/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;
import kd.drp.mdr.formplugin.template.BeForeF7Template;

public class CustomerAuthListPlugin
extends MdrListPlugin {
    private static final String TOOL_NEW = "new";
    private static final String TOOL_BATCH_EDIT = "batchedit";

    public void setFilter(SetFilterEvent e) {
        this.setFilterOwnerName("authowner.id");
        super.setFilter(e);
        if (!this.isLookup()) {
            this.createFilter(e);
        }
    }

    protected boolean isNeedCahceOwner() {
        return true;
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initAuthoriedOwnerFilterComboItem(e, "authowner.name", false);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "authowner.id": {
                List ownerIds = this.getAuthoriedOwnerIDs();
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)ownerIds));
                break;
            }
        }
    }

    private void createFilter(SetFilterEvent e) {
        List fs = e.getQFilters();
        Map fsMap = this.filter2Map(fs);
        String key = "authowner.id";
        ArrayList<Object> authowners = null;
        if (fsMap.containsKey(key)) {
            QFilter f = (QFilter)fsMap.get(key);
            Object value = f.getValue();
            if (value instanceof List) {
                authowners = (List)value;
            } else {
                authowners = new ArrayList<Object>();
                authowners.add(value);
            }
            fs.remove(f);
        } else {
            authowners = this.getAuthoriedOwnerIDs();
        }
        fs.add(this.createSaleOrder((List<Object>)authowners));
    }

    private QFilter createSaleOrder(List<Object> authowners) {
        Set ids = CustomerUtil.getAllAuthSubsIdsByIds(new ArrayList<Object>(authowners));
        ids.addAll(authowners);
        QFilter fs = new QFilter("authowner", "in", (Object)ids);
        return fs;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        super.beforeDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "new": {
                evt.setCancel(true);
                FormShowParameter param = new FormShowParameter();
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId("mdr_customer_authorize_e");
                if (this.getPageCache().get("ownerid4cache") != null) {
                    param.setCustomParam("ownerid4cache", (Object)this.getPageCache().get("ownerid4cache"));
                }
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
                this.getView().showForm(param);
                break;
            }
            case "batchedit": {
                evt.setCancel(true);
                this.showBatchEditPage();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        this.getListView().refresh();
    }

    private void showBatchEditPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_customer_authorize_b");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey(TOOL_BATCH_EDIT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        ListSelectedRowCollection rows = this.getListView().getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        parameter.setCustomParam("authorizeids", (Object)ids);
        this.getView().showForm(parameter);
    }
}

