/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class CustomerAuthorizeEditPugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    private static final String SAVE = "save";
    private static final String CHECKSAVE = "checksave";
    private static final String SAVEANDNEW = "saveandnew";
    private static final String CHECKSAVENEW = "checksavenew";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "checksave": 
            case "checksavenew": {
                Object customerId = this.getF7PKValue("customer");
                Object ownerId = this.getF7PKValue("authowner");
                if (this.getBooleanValue("isdefault") && CustomerUtil.queryCustomerByCustom((Object)customerId, (Object)ownerId).booleanValue()) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u8d27\u6e20\u9053\u5df2\u5b58\u5728\u9ed8\u8ba4\u8ba2\u8d27\u5173\u7cfb\uff0c\u662f\u5426\u5207\u6362\u672c\u8ba2\u8d27\u5173\u7cfb\u4e3a\u9ed8\u8ba4\u8ba2\u8d27\u5173\u7cfb\uff1f", (String)"CustomerAuthorizeEditPugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
                    break;
                }
                if (key.equals(CHECKSAVE)) {
                    this.getView().invokeOperation(SAVE);
                    break;
                }
                this.getView().invokeOperation(SAVEANDNEW);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"authowner", "customer", "customergroup"});
    }

    public void afterCreateNewData(EventObject e) {
        this.SetOwnerFromCache("authowner");
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(this.isAddNew()), new String[]{"authowner", "customer"});
        Object taxrateinfo = this.getModel().getValue("taxrateid");
        if (taxrateinfo == null) {
            this.setEnable(new String[]{"taxrate"});
        } else {
            this.setUnEnable(new String[]{"taxrate"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        CheckResult re = null;
        switch (key) {
            case "authowner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getAuthOwnerFilter());
                break;
            }
            case "customer": {
                re = this.checkCustomerBeforeSelect();
                if (!re.isSuccess()) {
                    this.getView().showMessage(re.getMsg());
                    evt.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getCustomerFilterFromCache());
                break;
            }
            case "customergroup": {
                DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_cust_standard_apply");
                DynamicObject standardObj = dobj.getDynamicObject("classstandardid");
                if (standardObj == null) break;
                Long groupStandardPK = Long.parseLong(standardObj.get("id").toString());
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCustomParam("groupStandard", (Object)groupStandardPK);
                QFilter standardFilter = new QFilter("classstandard", "=", (Object)groupStandardPK);
                formShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        switch (key) {
            case "authowner": {
                this.authOwnerChanged();
                break;
            }
            case "customer": {
                this.customerChanged();
                break;
            }
            case "taxrateid": {
                this.taxRateChanged(e.getChangeSet()[0].getNewValue());
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void taxRateChanged(Object newValue) {
        if (newValue == null) {
            this.setEnable(new String[]{"taxrate"});
        } else {
            DynamicObject taxrateinfo = (DynamicObject)newValue;
            this.getModel().setValue("taxrate", (Object)taxrateinfo.getBigDecimal("taxrate"));
            this.setUnEnable(new String[]{"taxrate"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "checksave": 
            case "checksavenew": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    this.setValue("isdefault", false);
                } else {
                    Object customerId = this.getF7PKValue("customer");
                    CustomerUtil.updateCustomerByCustom((Object)customerId);
                }
                if (key.equals(CHECKSAVE)) {
                    this.getView().invokeOperation(SAVE);
                    break;
                }
                this.getView().invokeOperation(SAVEANDNEW);
            }
        }
    }

    private void customerChanged() {
        this.setNumber();
    }

    private void setNumber() {
        String ownerNumber = "";
        String customerNumber = "";
        DynamicObject owner = this.getF7Value("authowner");
        String key = "number";
        if (owner != null) {
            ownerNumber = owner.getString(key);
        }
        DynamicObject customer = this.getF7Value("customer");
        if (owner != null) {
            customerNumber = customer.getString(key);
        }
        this.setValue(key, ownerNumber + "_" + customerNumber);
    }

    private void authOwnerChanged() {
        this.setValue("customer", null);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                this.afterSave(e);
                break;
            }
        }
        this.getPageCache().remove(this.getFilterCustomerCacheKey());
    }

    private void afterSave(AfterDoOperationEventArgs e) {
        OperationResult re = e.getOperationResult();
        if (re.isSuccess()) {
            // empty if block
        }
    }

    private CheckResult checkCustomerBeforeSelect() {
        if (this.getF7Value("authowner") == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"CustomerAuthorizeEditPugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private QFilter getAuthOwnerFilter() {
        String key = UserUtil.getUserID().toString();
        String fsStr = this.getPageCache().get(key);
        if (fsStr == null || "null".equalsIgnoreCase(fsStr)) {
            fsStr = "";
        }
        QFilter fs = null;
        if (StringUtils.isEmpty((CharSequence)fsStr.trim())) {
            fs = F7Utils.getEnableFilter();
            Set allIds = CustomerUtil.getAllAuthSubsIdsAndSelfByIds((Set)UserUtil.getAuthorizedOwnerIDs());
            fs.and("id", "in", (Object)allIds);
            this.getPageCache().put(key, fs.toSerializedString());
        } else {
            fs = QFilter.fromSerializedString((String)fsStr);
        }
        return fs;
    }

    private QFilter getCustomerFilter() {
        QFilter fs = F7Utils.getEnableFilter();
        Set<Object> ids = this.getNotAuthedCustomerIds();
        Object authOwnerId = this.getF7PKValue("authowner");
        if (!this.isAuthOwnerInnerCustomer()) {
            ids.removeAll(CustomerUtil.getAuthOwnerIDIgnoreVaild((Object)authOwnerId));
        }
        ids.removeAll(CustomerUtil.getAuthSubsIdsIgnoreVaild((Object)authOwnerId));
        ids.remove(authOwnerId);
        fs.and("id", "in", ids);
        return fs;
    }

    private Set<Object> getNotAuthedCustomerIds() {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("isinnerorg", "=", (Object)"0");
        return QueryUtil.querySingleCol((String)"mdr_customer", (String)"id", (QFilter[])fs.toArray());
    }

    private boolean isAuthOwnerInnerCustomer() {
        DynamicObject authOwner = this.getF7Value("authowner");
        if (authOwner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"CustomerAuthorizeEditPugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return authOwner.getBoolean("isinnerorg");
    }

    private String getFilterCustomerCacheKey() {
        Object authOwnerId = this.getF7PKValue("authowner");
        String key = new StringBuffer("filter").append(authOwnerId).toString();
        return key;
    }

    private QFilter getCustomerFilterFromCache() {
        String key = this.getFilterCustomerCacheKey();
        String fsStr = this.getPageCache().get(key);
        if (StringUtils.isEmpty((CharSequence)fsStr)) {
            QFilter fs = this.getCustomerFilter();
            this.getPageCache().put(key, fs.toSerializedString());
            return fs;
        }
        return QFilter.fromSerializedString((String)fsStr);
    }
}

