/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class CustomerAuthorizePlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    private static final String TOOL_BARAP = "toolbarap";
    private static final String TOOL_SAVEANDNEW = "tosaveandnew";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP});
        this.addF7Listener(this, new String[]{"authowner", "customer", "customergroup"});
    }

    public void afterCreateNewData(EventObject e) {
        this.SetOwnerFromCache("authowner");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "tosaveandnew": {
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().createNewEntryRow(ENTRYENTITY);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        CheckResult re = null;
        switch (key) {
            case "authowner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getAuthOwnerFilter());
                break;
            }
            case "customer": {
                re = this.checkCustomerBeforeSelect();
                if (!re.isSuccess()) {
                    this.getView().showMessage(re.getMsg());
                    evt.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getCustomerFilterFromCache());
                break;
            }
            case "customergroup": {
                DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_cust_standard_apply");
                DynamicObject standardObj = dobj.getDynamicObject("classstandardid");
                if (standardObj == null) break;
                Long groupStandardPK = Long.valueOf(standardObj.get("id").toString());
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCustomParam("groupStandard", (Object)groupStandardPK);
                QFilter standardFilter = new QFilter("classstandard", "=", (Object)groupStandardPK);
                formShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
        }
    }

    private QFilter getAuthOwnerFilter() {
        String key = UserUtil.getUserID().toString();
        String fsStr = this.getPageCache().get(key);
        if (fsStr == null || "null".equalsIgnoreCase(fsStr)) {
            fsStr = "";
        }
        QFilter fs = null;
        if (StringUtils.isEmpty((CharSequence)fsStr.trim())) {
            fs = F7Utils.getEnableFilter();
            Set allIds = CustomerUtil.getAllAuthSubsIdsAndSelfByIds((Set)UserUtil.getAuthorizedOwnerIDs());
            fs.and("id", "in", (Object)allIds);
            this.getPageCache().put(key, fs.toSerializedString());
        } else {
            fs = QFilter.fromSerializedString((String)fsStr);
        }
        return fs;
    }

    private CheckResult checkCustomerBeforeSelect() {
        if (this.getF7Value("authowner") == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"CustomerAuthorizePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private QFilter getCustomerFilterFromCache() {
        String key = this.getFilterCustomerCacheKey();
        String fsStr = this.getPageCache().get(key);
        if (StringUtils.isEmpty((CharSequence)fsStr)) {
            QFilter fs = this.getCustomerFilter();
            this.getPageCache().put(key, fs.toSerializedString());
            return fs;
        }
        return QFilter.fromSerializedString((String)fsStr);
    }

    private QFilter getCustomerFilter() {
        QFilter fs = F7Utils.getEnableFilter();
        Set<Object> ids = this.getNotAuthedCustomerIds();
        Object authOwnerId = this.getF7PKValue("authowner");
        if (this.isAuthOwnerInnerCustomer()) {
            ids.addAll(this.getOtherCanSelectByInnerCustomers(authOwnerId));
        }
        ids.remove(authOwnerId);
        fs.and("id", "in", ids);
        return fs;
    }

    private Set<Object> getNotAuthedCustomerIds() {
        QFilter fs = F7Utils.getEnableFilter();
        fs.and("isinnerorg", "=", (Object)"0");
        return QueryUtil.querySingleCol((String)"mdr_customer", (String)"id", (QFilter[])fs.toArray());
    }

    private String getFilterCustomerCacheKey() {
        Object authOwnerId = this.getF7PKValue("authowner");
        String key = new StringBuffer("filter").append(authOwnerId).toString();
        return key;
    }

    private boolean isAuthOwnerInnerCustomer() {
        DynamicObject authOwner = this.getF7Value("authowner");
        if (authOwner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"CustomerAuthorizePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return authOwner.getBoolean("isinnerorg");
    }

    private Set<Object> getOtherCanSelectByInnerCustomers(Object authOwnerId) {
        Set innerCustomerIds = CustomerUtil.getInnerCustomerIds();
        innerCustomerIds.remove(authOwnerId);
        Set ids = CustomerUtil.getAuthSubsIdsByIdsIgnoreVaild((Set)innerCustomerIds);
        ids.removeAll(CustomerUtil.getAuthSubsIdsIgnoreVaild((Object)authOwnerId));
        return ids;
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "customer": {
                DynamicObject standardObj;
                DynamicObject custObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (custObj == null) {
                    this.triggerChangeEvent = true;
                    this.setValue("customergroup", null, index);
                    break;
                }
                DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)custObj.getPkValue(), (String)"mdr_customer");
                DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_cust_standard_apply");
                if (dobj != null && (standardObj = dobj.getDynamicObject("classstandardid")) != null) {
                    Long customerStandardId = Long.parseLong(standardObj.get("id").toString());
                    if (!customer.getDynamicObjectCollection("custclassentity").isEmpty() && customerStandardId > 0L) {
                        for (DynamicObject customerClass : customer.getDynamicObjectCollection("custclassentity")) {
                            DynamicObject customerGroup;
                            if (customerStandardId.longValue() != customerClass.getDynamicObject("classstandardid").getLong("id") || (customerGroup = customerClass.getDynamicObject("customergroupid")) == null || customerGroup.getLong("id") <= 0L) continue;
                            this.setValue("customergroup", customerGroup.getLong("id"), index);
                        }
                    } else {
                        this.setValue("customergroup", null, index);
                    }
                }
                this.triggerChangeEvent = true;
                break;
            }
            case "taxrateid": {
                DynamicObject taxrateinfo = (DynamicObject)this.getModel().getValue("taxrateid");
                if (taxrateinfo != null) {
                    this.setValue("taxrate", taxrateinfo.getBigDecimal("taxrate"), index, true);
                    this.setUnEnable(index, new String[]{"taxrate"});
                    break;
                }
                this.setEnable(index, new String[]{"taxrate"});
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }
}

