/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class CustomerBatchEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String DO_OK = "dook";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = this.getOpKey(args)) {
            case "dook": {
                String editField = this.getStringValue("editfield");
                if (StringUtils.isEmpty((String)editField)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6279\u91cf\u4fee\u6539\u5c5e\u6027\uff01", (String)"CustomerBatchEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (!"currency".equals(editField) || this.getF7Value("currency") != null) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u7b97\u5e01\u522b\uff01", (String)"CustomerBatchEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        switch (key = evt.getOperateKey()) {
            case "dook": {
                this.batchEditCustomer();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"ordercustomer", "companycustomer"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDisVisible(new String[]{"customergroup", "grade", "invcontrolmode", "isnegativeinventory", "salecontrolmode", "currency", "companycustomer", "parentcustomer", "ordercustomer", "customertype", "billcontrolmode", "customerproperty", "customerfunctions"});
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        switch (key) {
            case "editfield": {
                this.editFieldChanged(e.getChangeSet()[0].getOldValue(), e.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "ordercustomer": {
                break;
            }
            case "companycustomer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)CustomerUtil.getAuthorisedCustomerFilter());
                break;
            }
        }
    }

    private void editFieldChanged(Object oldValue, Object newValue) {
        if (StringUtils.isNotEmpty((Object)newValue)) {
            this.setVisible(new String[]{String.valueOf(newValue)});
            if ("currency".equals(newValue)) {
                this.setMustInput("currency", true);
            }
        }
        if (StringUtils.isNotEmpty((Object)oldValue)) {
            this.setDisVisible(new String[]{String.valueOf(oldValue)});
            if ("currency".equals(oldValue)) {
                this.setMustInput("currency", false);
            }
        }
    }

    private void batchEditCustomer() {
        String editField = this.getStringValue("editfield");
        Object[] customerIds = this.getSelectedCustomerIds();
        String columnName = null;
        switch (editField) {
            case "customergroup": {
                columnName = "FCUSTOMERGROUPID";
                this.batchEditCustomer(columnName, this.getF7PKValue(editField), customerIds);
                break;
            }
            case "grade": {
                columnName = "FGRADEID";
                this.batchEditCustomer(columnName, this.getF7PKValue(editField), customerIds);
                break;
            }
            case "invcontrolmode": {
                columnName = "FINVCONTROLMODE";
                this.batchEditCustomerX(columnName, this.getValue(editField), customerIds);
                break;
            }
            case "isnegativeinventory": {
                columnName = "FISNEGATIVEINVENTORY";
                this.batchEditCustomerX(columnName, this.getValue(editField), customerIds);
                break;
            }
            case "salecontrolmode": {
                columnName = "FSALECONTROLMODE";
                this.batchEditCustomerX(columnName, this.getValue(editField), customerIds);
                break;
            }
            case "currency": {
                columnName = "FCURRENCYID";
                this.batchEditCustomerX(columnName, this.getF7PKValue(editField), customerIds);
                break;
            }
            case "companycustomer": {
                columnName = "FCOMPANYCUSTOMERID";
                this.batchEditCustomerX(columnName, this.getF7PKValue(editField), customerIds);
                break;
            }
            case "parentcustomer": {
                break;
            }
            case "ordercustomer": {
                break;
            }
            case "customertype": {
                break;
            }
            case "billcontrolmode": {
                columnName = "FBILLCONTROLMODE";
                this.batchEditCustomerX(columnName, this.getValue(editField), customerIds);
                break;
            }
            case "customerproperty": {
                break;
            }
            case "customerfunctions": {
                break;
            }
        }
    }

    private void batchEditCustomer(String columnName, Object updateValue, Object[] customerIds) {
        this.batchEdit("T_MDR_CUSTOMER", columnName, updateValue, customerIds);
    }

    private void batchEditCustomerX(String columnName, Object updateValue, Object[] customerIds) {
        this.batchEdit("T_MDR_CUSTOMER_X", columnName, updateValue, customerIds);
    }

    private void batchEdit(String tableName, String columnName, Object updateValue, Object[] customerIds) {
        if (customerIds != null && customerIds.length > 0) {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(tableName);
            sql.append(" SET ");
            sql.append(columnName);
            sql.append(" = ? WHERE FCUSTOMERID = ? ");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(customerIds.length);
            Object[] params = null;
            for (Object customerId : customerIds) {
                params = new Object[]{updateValue == null ? Long.valueOf(0L) : updateValue, customerId};
                paramsList.add(params);
            }
            DB.executeBatch((DBRoute)new DBRoute("mdr"), (String)sql.toString(), paramsList);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e20\u9053\u6279\u91cf\u4fee\u6539\u6210\u529f\uff01", (String)"CustomerBatchEditPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
    }

    private Object[] getSelectedCustomerIds() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        JSONArray ids = (JSONArray)fsp.getCustomParam("customerids");
        if (ids == null) {
            return new Object[0];
        }
        return ids.toArray();
    }
}

