/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.dbd.common.util.ItemClassStandardUtils;
import kd.drp.mdr.common.f7.F7Utils;

public class CustomerClassTreeListPlugin
extends StandardTreeListPlugin {
    private static Log logger = LogFactory.getLog(CustomerClassTreeListPlugin.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "1";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    public static final String PROP_ENABLE = "enable";
    public static final String SPLIT_LONG_NUMBER = "!";
    public static final String AP_BILL_LIST = "billlistap";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    private QFilter genRefreshFilter(String nodeId) {
        QFilter qFilter = null;
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        if (classStandardId == null) {
            classStandardId = this.getClassStandardId();
        } else if (StringUtils.isBlank((Object)classStandardId)) {
            return new QFilter("id", "in", new ArrayList());
        }
        String strclassStandardId = classStandardId.toString();
        this.getPageCache().put("classstandard", strclassStandardId);
        qFilter = new QFilter("classstandard", "=", (Object)Long.parseLong(strclassStandardId));
        if (ROOTNODEID.equals(nodeId)) {
            return qFilter;
        }
        List<String> groupIds = this.queryGroupsByGroupId("mdr_customer_group", classStandardId, nodeId);
        ArrayList<Long> longgroupIds = new ArrayList<Long>(1);
        if (groupIds != null && groupIds.size() > 0) {
            for (int i = 0; i < groupIds.size(); ++i) {
                longgroupIds.add(Long.parseLong(groupIds.get(i)));
            }
        }
        qFilter.and(new QFilter("id", "in", longgroupIds));
        return qFilter;
    }

    private Long getClassStandardId() {
        Long classStandardId = 836014120472951808L;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (param.getCustomParam("groupStandard") != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam("groupStandard").toString())) {
            classStandardId = Long.parseLong(param.getCustomParam("groupStandard").toString());
        }
        return classStandardId;
    }

    private List<String> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String strid = id.toString();
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)String.join((CharSequence)",", "longnumber", "isleaf"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(strid))});
        if (queryOne != null) {
            if (queryOne.getBoolean("isleaf")) {
                list.add(strid);
                return list;
            }
            String longnumber = queryOne.getString("longnumber");
            QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
            QFilter f2 = new QFilter("classstandard", "=", (Object)Long.parseLong(standardId.toString()));
            QFilter[] qFilters = new QFilter[]{f1, f2};
            ORM ormOV = ORM.create();
            try (DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), entity, "id", qFilters);){
                for (Row row : ds) {
                    if (row.getString("id") == null) continue;
                    list.add(row.getString("id"));
                }
            }
        }
        return list;
    }

    private List<DynamicObject> getComData() {
        QFilter[] qFilterArray;
        String createOrg = this.getPageCache().get("createOrg");
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String defGroupStandard = "";
        if (param.getCustomParam("groupStandard") != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam("groupStandard").toString())) {
            defGroupStandard = param.getCustomParam("groupStandard").toString();
        }
        QFilter enableFilter = F7Utils.getEnableFilter();
        QFilter authorizedFilter = null;
        if (StringUtils.isBlank((CharSequence)defGroupStandard)) {
            if (createOrg != null) {
                authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mdr_cust_classstandard", (Long)Long.parseLong(createOrg));
            }
        } else {
            authorizedFilter = new QFilter("id", "=", (Object)Long.parseLong(defGroupStandard));
        }
        if (authorizedFilter == null) {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = enableFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = enableFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = authorizedFilter;
        }
        QFilter[] qfilers = qFilterArray;
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_classstandard", (String)String.join((CharSequence)",", "id", "number", "name", "ispreset"), (QFilter[])qfilers);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(bizMap.values());
    }

    private void setComboEdit(List<DynamicObject> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<DynamicObject> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (orgModelList != null && orgModelList.size() > 0) {
            for (DynamicObject map : orgModelList) {
                String id = map.getString("id");
                String fName = map.getString("name");
                comboItems.put(id, new LocaleString(fName));
            }
            this.getModel().setValue(PROP_STANDARDLST, this.getDefaultStandardId(orgModelList));
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (NO_GROUP.equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        DynamicObject[] loads;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (value == null) {
            value = this.getClassStandardId();
        }
        QFilter qFilter = new QFilter("classstandard", "=", (Object)Long.parseLong(value.toString()));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId));
        QFilter qFilter3 = new QFilter(PROP_ENABLE, "=", (Object)String.valueOf(1));
        for (DynamicObject group : loads = BusinessDataServiceHelper.load((String)"mdr_customer_group", (String)String.join((CharSequence)",", "id", "number", "name", PROP_PARENT, "longnumber", "isleaf"), (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3})) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.get(PROP_PARENT).toString());
            treeNode.setText(group.getString("name"));
            treeNode.setLongNumber(group.getString("longnumber"));
            Object parentNode = group.get("isleaf");
            if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
                treeNode.addChildren(new ArrayList());
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public static List<String> getAllSuperiorLongnumber(String longnumber) {
        if (StringUtils.isBlank((CharSequence)longnumber) || longnumber.indexOf(".") == -1) {
            return new ArrayList<String>(0);
        }
        String superiorLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)".");
        ArrayList<String> superiorLongnumberSet = new ArrayList<String>(superiorLongnumber.length());
        superiorLongnumberSet.add(superiorLongnumber);
        while (superiorLongnumber.indexOf(SPLIT_LONG_NUMBER) > 0) {
            superiorLongnumber = StringUtils.substringBeforeLast((String)superiorLongnumber, (String)".");
            superiorLongnumberSet.add(superiorLongnumber);
        }
        return superiorLongnumberSet;
    }

    private Object getDefaultStandardId(List<DynamicObject> standards) {
        Object standardId = 836014120472951808L;
        if (standards == null) {
            standards = this.getComData();
        }
        if (standards != null && standards.size() > 0) {
            boolean isPreset = false;
            for (DynamicObject map : standards) {
                if (!map.getBoolean("ispreset")) continue;
                standardId = map.get("id");
                isPreset = true;
            }
            if (!isPreset) {
                standardId = standards.get(0).get("id");
            }
        }
        return standardId;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            List<DynamicObject> orgList = this.getComData();
            this.setComboEdit(orgList);
            this.getView().updateView(PROP_STANDARDLST);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

