/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.dbd.business.handle.CustomerHandler;
import kd.drp.dbd.formplugin.customer.CustomerEditPluginNew;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.CustomerTypeId;
import kd.drp.mdr.common.enums.customer.SaleControlMode;
import kd.drp.mdr.common.enums.customer.SystemPresetCustomerFuction;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.SysParamsUtil;

public class CustomerExtendEdit
extends CustomerEditPluginNew {
    private static final String SAVE = "save";
    private static final String SAVENEW = "saveandnew";
    private static final String SUBMIT = "submit";
    private static final String CHECK_SAVE = "checksave";
    private static final String CHECK_SAVENEW = "checksavenew";
    private static final String CHECK_SUBMIT = "checksubmit";
    private static final String KEY_STORE_PANELAP = "storepanelap";

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.reBuildCustomerClass(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.reBuildCustomerClass(true);
    }

    private void reBuildCustomerClass(boolean isCreateNew) {
        Object createOrg = this.getF7PKValue("createorg");
        if (createOrg != null) {
            Map customerClassStandardMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_classstandard", (QFilter[])new QFilter[]{F7Utils.getEnableFilter(), BaseDataServiceHelper.getBaseDataFilter((String)"mdr_cust_classstandard", (Long)Long.parseLong(createOrg.toString()))});
            HashSet customerClassStandardIds = new HashSet(customerClassStandardMap.keySet());
            DynamicObjectCollection customerClassEntries = this.getModel().getDataEntity().getDynamicObjectCollection("custclassentity");
            for (DynamicObject customerClass : customerClassEntries) {
                if (customerClass.getDynamicObject("classstandardid") == null) continue;
                customerClassStandardIds.remove(customerClass.getDynamicObject("classstandardid").get("id"));
            }
            Object customerGroupId = this.getView().getFormShowParameter().getCustomParam("customer_group_id");
            DynamicObject customerGroup = null;
            if (customerGroupId != null) {
                customerGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(customerGroupId.toString()), (String)"mdr_customer_group");
            }
            for (Object customerClassStandardId : customerClassStandardIds) {
                DynamicObject customerClassEntry = new DynamicObject(customerClassEntries.getDynamicObjectType());
                if (isCreateNew && customerGroup != null && customerClassStandardId.equals(customerGroup.getDynamicObject("classstandard").get("id"))) {
                    customerClassEntry.set("classstandardid", customerGroup.get("classstandard"));
                    customerClassEntry.set("customergroupid", (Object)customerGroup);
                } else {
                    customerClassEntry.set("classstandardid", customerClassStandardMap.get(customerClassStandardId));
                }
                customerClassEntries.add((Object)customerClassEntry);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handlerCustomerTypeRelationChange(true);
        this.handlerCustomerPropertyRelationChangedChange(true);
        this.handlerPartnerRelationChange(true);
        this.handlerIsStoreChange(true);
        this.handlerIsDeliveryOneCityChange(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"customertype", "ordercustomer", "receivecustomer", "balancecustomer", "paycustomer", "legalcustomer", "companycustomer", "parentcustomer", "classstandardid", "customergroupid", "customerfunctions", "partner", "bizgroup"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        this.triggerChangeEvent = true;
        switch (key) {
            case "bizgroup": {
                this.handlerizgGoupChange(false);
                break;
            }
            case "customertype": {
                this.handlerCustomerTypeRelationChange(false);
                break;
            }
            case "customerproperty": {
                this.handlerCustomerPropertyRelationChangedChange(false);
                break;
            }
            case "partner": {
                this.handlerPartnerRelationChange(false);
                break;
            }
            case "name": {
                this.handlerNameChange(false);
                break;
            }
            case "isstore": {
                this.handlerIsStoreChange(false);
                break;
            }
            case "isdeliveryonecity": {
                this.handlerIsDeliveryOneCityChange(false);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        switch (key) {
            case "ordercustomer": {
                qFilters.add(CustomerUtil.getOrderCustomerFilter((CustomerProperty)CustomerProperty.CustomerProperty((String)this.getStringValue("customerproperty"))));
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, qFilters);
                break;
            }
            case "receivecustomer": {
                qFilters.add(CustomerUtil.getAuthorisedCustomerFilter());
                qFilters.add(new QFilter("customerfunctions.fbasedataid.id", "=", (Object)Long.parseLong(SystemPresetCustomerFuction.STORAGE.toString())));
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, qFilters);
                break;
            }
            case "balancecustomer": 
            case "paycustomer": {
                qFilters.add(CustomerUtil.getAuthorisedCustomerFilter());
                qFilters.add(new QFilter("customerfunctions.fbasedataid.id", "=", (Object)Long.parseLong(SystemPresetCustomerFuction.BALANCE.toString())));
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, qFilters);
                break;
            }
            case "legalcustomer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)CustomerUtil.getAuthorisedCustomerFilter());
                break;
            }
            case "companycustomer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)CustomerUtil.getAuthorisedCustomerFilter());
                break;
            }
            case "parentcustomer": {
                Object customerId = this.getModel().getDataEntity().get("id");
                if (customerId == null || Long.parseLong(customerId.toString()) <= 0L) break;
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("id", "!=", customerId));
                break;
            }
            case "customergroupid": {
                Object classStandarObj = this.getModel().getValue("classstandardid", evt.getRow());
                if (classStandarObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u6807\u51c6\uff01", (String)"CustomerExtendEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Object standarId = ((DynamicObject)classStandarObj).get("id");
                listShowParameter.setCustomParam("groupStandard", standarId);
                listShowParameter.setMultiSelect(false);
                QFilter standardFilter = new QFilter("classstandard", "=", standarId);
                listShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
            case "customerfunctions": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)new QFilter("enable", "=", (Object)true));
                break;
            }
            case "bizgroup": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)F7Utils.getSaleOrgFitler());
                break;
            }
        }
    }

    private void handlerIsStoreChange(boolean isOnlySetControl) {
        boolean isStore = this.getBooleanValue("isstore");
        if (isStore) {
            this.setVisible(new String[]{KEY_STORE_PANELAP});
        } else {
            this.setDisVisible(new String[]{KEY_STORE_PANELAP});
        }
        if (!isOnlySetControl && !isStore) {
            this.setValue("isonlinestore", Boolean.FALSE);
            this.setValue("isdefaultstore", Boolean.FALSE);
            this.setValue("isfetchbyself", Boolean.FALSE);
            this.setValue("isdeliverybystore", Boolean.FALSE);
            this.setValue("isdeliveryonecity", Boolean.FALSE);
            this.setValue("deliverymile", BigDecimal.ZERO);
            this.setValue("beginstoreworktime", BigDecimal.valueOf(-1L));
            this.setValue("endstoreworktime", BigDecimal.valueOf(-1L));
        }
    }

    private void handlerIsDeliveryOneCityChange(boolean isOnlySetControl) {
        boolean isDeliveryOneCity = this.getBooleanValue("isdeliveryonecity");
        if (isDeliveryOneCity) {
            this.setEnable(new String[]{"deliverymile"});
        } else {
            this.setUnEnable(new String[]{"deliverymile"});
        }
        if (!isOnlySetControl && !isDeliveryOneCity) {
            this.setValue("deliverymile", BigDecimal.ZERO);
        }
    }

    private void handlerNameChange(boolean isOnlySetControl) {
        if (!isOnlySetControl && DynamicObjectUtils.isNewCreate((DynamicObject)this.getModel().getDataEntity())) {
            String name = this.getStringValue("name");
            if (StringUtils.isEmpty((String)name)) {
                this.setValueLinkByPartner(null, true);
            } else {
                DynamicObject partner = this.getF7Value("partner");
                if (partner == null) {
                    DynamicObjectCollection sameNamePartners = CustomerHandler.querySameNameParter2Customer((String)name, (boolean)this.getBooleanValue("isinnerorg"));
                    if (CollectionUtils.isEmpty((Collection)sameNamePartners)) {
                        this.setValueLinkByPartner(null, true);
                    } else if (sameNamePartners.size() == 1) {
                        DynamicObject sameNamePartner = (DynamicObject)sameNamePartners.get(0);
                        this.setValueLinkByPartner(sameNamePartner, true);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5546\u52a1\u4f19\u4f34\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u540c\u4e00\u4e2a\u4f01\u4e1a!", (String)"CustomerExtendEdit_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                        this.setValueLinkByPartner(null, true);
                    }
                }
            }
        }
    }

    private void setValueLinkByPartner(DynamicObject partner, boolean isSetPartner) {
        if (isSetPartner) {
            this.setValue("partner", partner == null ? null : partner.get("id"), false);
        }
        if (partner != null) {
            DynamicObject bdCustomer;
            Object company = partner.get("internal_company");
            if (company != null) {
                this.setValue("bizgroup", company, false);
            }
            if ((bdCustomer = QueryServiceHelper.queryOne((String)"bd_customer", (String)"id", (QFilter[])new QFilter("bizpartner", "=", partner.get("id")).toArray())) != null && bdCustomer.getLong("id") > 0L) {
                this.setValue("bdcustomer", bdCustomer.get("id"));
            }
        } else {
            this.setValue("bdcustomer", null);
        }
    }

    private void handlerPartnerRelationChange(boolean isOnlySetControl) {
        if (!isOnlySetControl && DynamicObjectUtils.isNewCreate((DynamicObject)this.getModel().getDataEntity())) {
            DynamicObject partner = this.getF7Value("partner");
            this.setValueLinkByPartner(partner, false);
        }
    }

    private void handlerCustomerPropertyRelationChangedChange(boolean isOnlySetControl) {
        CustomerProperty customerProperty = CustomerProperty.CustomerProperty((String)this.getStringValue("customerproperty"));
        boolean isConnectErpCloud = "A".equalsIgnoreCase(SysParamsUtil.getConnectERP());
        if (customerProperty == null) {
            this.setUnEnable(new String[]{"bdcustomer"});
            this.setMustInput("bdcustomer", false);
            this.setUnEnable(new String[]{"ordercustomer"});
            if (isConnectErpCloud) {
                this.setMustInput("ordercustomer", false);
            }
            if (!isOnlySetControl) {
                this.setValue("bdcustomer", null);
                this.setValue("ordercustomer", null);
            }
        } else {
            switch (customerProperty) {
                case DIRECT_CUSTOMER: {
                    this.setEnable(new String[]{"bdcustomer"});
                    this.setEnable(new String[]{"ordercustomer"});
                    if (isConnectErpCloud) {
                        this.setMustInput("bdcustomer", true);
                    }
                    if (isOnlySetControl) break;
                    this.setDefaultBillType();
                    break;
                }
                case INDIRECT_CUSTOMER: {
                    this.setUnEnable(new String[]{"bdcustomer"});
                    if (isConnectErpCloud) {
                        this.setMustInput("bdcustomer", false);
                    }
                    this.setEnable(new String[]{"ordercustomer"});
                    if (isOnlySetControl) break;
                    this.setValue("bdcustomer", null);
                    break;
                }
                case INNER_ORG: {
                    this.setUnEnable(new String[]{"bdcustomer"});
                    if (isConnectErpCloud) {
                        this.setMustInput("bdcustomer", false);
                    }
                    this.setUnEnable(new String[]{"ordercustomer"});
                    this.setMustInput("ordercustomer", false);
                    if (isOnlySetControl) break;
                    this.setValue("bdcustomer", null);
                    this.setValue("ordercustomer", null);
                    break;
                }
                case MIX_CUSTOMER: {
                    this.setEnable(new String[]{"bdcustomer"});
                    if (isConnectErpCloud) {
                        this.setMustInput("bdcustomer", true);
                    }
                    this.setEnable(new String[]{"ordercustomer"});
                    break;
                }
            }
        }
    }

    private void handlerizgGoupChange(boolean isOnlySetControl) {
        DynamicObject customer;
        DynamicObject bizGroup;
        CustomerProperty customerProperty = CustomerProperty.CustomerProperty((String)this.getStringValue("customerproperty"));
        if ((CustomerProperty.DIRECT_CUSTOMER == customerProperty || CustomerProperty.MIX_CUSTOMER == customerProperty) && (bizGroup = this.getF7Value("bizgroup")) != null && bizGroup.getLong("id") > 0L && (customer = CustomerUtil.getDefaultOrderCustomer((long)bizGroup.getLong("id"))) != null) {
            this.setValue("ordercustomer", customer.getLong("id"));
        }
    }

    private void handlerCustomerTypeRelationChange(boolean isOnlySetControl) {
        DynamicObject customertype = this.getF7Value("customertype");
        if (customertype == null) {
            this.setUnEnable(new String[]{"legalcustomer"});
            this.setEnable(new String[]{"customerproperty"});
            if (!isOnlySetControl) {
                this.setValue("legalcustomer", null);
                this.setValue("isinnerorg", false);
                this.setValue("isstore", false);
                this.setValue("customerfunctions", null);
                this.setValue("salecontrolmode", null);
                this.setValue("customerproperty", null);
            }
            return;
        }
        CustomerTypeId customerTypeId = CustomerTypeId.CustomerTypeId((String)customertype.getString("typeid"));
        boolean isstore = customertype.getBoolean("isstore");
        boolean isinsideorg = customertype.getBoolean("isinsideorg");
        if (!isOnlySetControl) {
            this.setValue("isinnerorg", isinsideorg);
            this.setValue("isstore", isstore);
        }
        if (customerTypeId != null) {
            switch (customerTypeId) {
                case FENXIAOSHANG: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setValue("salecontrolmode", SaleControlMode.BUGUANXIAOLIANG);
                    this.setValue("customerproperty", null);
                    break;
                }
                case FENXIAOMENDIAN: {
                    this.setEnable(new String[]{"legalcustomer"});
                    this.setEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])new SystemPresetCustomerFuction[]{SystemPresetCustomerFuction.PURCHASE, SystemPresetCustomerFuction.STORAGE}));
                    this.setValue("salecontrolmode", SaleControlMode.XIAOLIANGKAIDAN);
                    this.setValue("customerproperty", null);
                    break;
                }
                case FENXIAOSHANGJIANMENDIAN: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setValue("salecontrolmode", SaleControlMode.XIAOLIANGKAIDAN);
                    this.setValue("customerproperty", null);
                    break;
                }
                case ZHIYINGMENDIAN_DULIHESUAN: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setValue("salecontrolmode", SaleControlMode.POS_SHOUYIN);
                    this.setValue("customerproperty", CustomerProperty.DIRECT_CUSTOMER);
                    this.setDefaultBillType();
                    break;
                }
                case ZHIYINGMENDIAN_FEIDULIHESUAN: {
                    this.setEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setValue("salecontrolmode", SaleControlMode.POS_SHOUYIN);
                    this.setValue("customerproperty", CustomerProperty.DIRECT_CUSTOMER);
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setDefaultBillType();
                    break;
                }
                case JIAMENGMENDIAN_DULIHESUAN: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setValue("salecontrolmode", SaleControlMode.POS_SHOUYIN);
                    this.setValue("customerproperty", CustomerProperty.DIRECT_CUSTOMER);
                    this.setDefaultBillType();
                    break;
                }
                case JIAMENGMENDIAN_FEIDULIHESUAN: {
                    this.setEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setValue("customerfunctions", CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
                    this.setValue("salecontrolmode", SaleControlMode.POS_SHOUYIN);
                    this.setValue("customerproperty", CustomerProperty.DIRECT_CUSTOMER);
                    this.setDefaultBillType();
                    break;
                }
                case NEIBUZUZHI: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("salecontrolmode", SaleControlMode.BUGUANXIAOLIANG);
                    this.setValue("customerproperty", CustomerProperty.INNER_ORG);
                    if (!DynamicObjectUtils.isNewCreate((DynamicObject)this.getModel().getDataEntity())) break;
                    this.setValueLinkByPartner(null, true);
                    break;
                }
                case WANGDIAN: 
                case QITA: {
                    this.setUnEnable(new String[]{"legalcustomer"});
                    this.setUnEnable(new String[]{"customerproperty"});
                    if (isOnlySetControl) break;
                    this.setLegalCustomer2this();
                    this.setValue("salecontrolmode", SaleControlMode.BUGUANXIAOLIANG);
                    this.setValue("customerproperty", CustomerProperty.DIRECT_CUSTOMER);
                    this.setDefaultBillType();
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "checksave": 
            case "checksavenew": 
            case "checksubmit": {
                DynamicObject customer = this.getModel().getDataEntity();
                if (customer == null) break;
                DynamicObject parter = customer.getDynamicObject("partner");
                if (parter == null) {
                    DynamicObjectCollection queryPartners = CustomerHandler.querySameNameParter2Customer((String)customer.getString("name"), (boolean)customer.getBoolean("isinnerorg"));
                    if (queryPartners == null || queryPartners.isEmpty()) {
                        this.invokeOperation(key);
                        break;
                    }
                    if (queryPartners.size() == 1) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5546\u52a1\u4f19\u4f34\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u540c\u4e00\u4e2a\u4f01\u4e1a!", (String)"CustomerExtendEdit_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, confirmCallBacks, null, ((DynamicObject)queryPartners.get(0)).get("id").toString());
                        break;
                    }
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u540d\u79f0\u7684\u5546\u52a1\u4f19\u4f34\uff0c\u8bf7\u786e\u8ba4\u5b58\u5728\u76f8\u540c\u4f01\u4e1a!", (String)"CustomerExtendEdit_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, confirmCallBacks, null, "");
                    break;
                }
                this.invokeOperation(key);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        super.confirmCallBack(e);
        switch (key = e.getCallBackId()) {
            case "checksave": 
            case "checksavenew": 
            case "checksubmit": {
                if (StringUtils.isEmpty((String)e.getCustomVaule())) {
                    if (MessageBoxResult.Yes.equals((Object)e.getResult()) || !MessageBoxResult.No.equals((Object)e.getResult())) break;
                    this.setValue("iscomefromedit", true);
                    this.invokeOperation(key);
                    break;
                }
                long partnerId = Long.parseLong(e.getCustomVaule());
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.setValue("partner", partnerId, false);
                    this.setValue("iscomefromedit", true);
                    this.invokeOperation(key);
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)e.getResult())) break;
                this.setValue("iscomefromedit", true);
                this.invokeOperation(key);
                break;
            }
        }
    }

    private void invokeOperation(String key) {
        switch (key) {
            case "checksave": {
                this.getView().invokeOperation(SAVE);
                break;
            }
            case "checksavenew": {
                this.getView().invokeOperation(SAVENEW);
                break;
            }
            case "checksubmit": {
                this.getView().invokeOperation(SUBMIT);
                break;
            }
        }
    }

    private void setLegalCustomer2this() {
        long customerId = this.getModel().getDataEntity().getLong("id");
        if (customerId > 0L) {
            this.setValue("legalcustomer", customerId);
        } else {
            this.setValue("legalcustomer", null);
        }
    }

    private void setDefaultBillType() {
    }
}

