/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.dbd.servicehelper.DBDServiceHelper;
import kd.drp.mdr.common.enums.ControlStrategy;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.enums.customer.BillControlMode;
import kd.drp.mdr.common.enums.customer.BillTypeControl;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.InventoryControlMode;
import kd.drp.mdr.common.enums.customer.SaleControlMode;
import kd.drp.mdr.common.enums.customer.SystemPresetCustomerFuction;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.strategy.CtrlStrategyUtils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.template.BeForeF7Template;

public class CustomerListPlugin
extends AbstractTreeListPlugin {
    private static final String ADD_ADMIN = "addadmin";
    private static final String TO_UPDATE = "toupdate";
    private static final String BATCH_EDIT = "batchedit";
    private static final String IMPORT_FROM_CUSTOMER = "importfromcustomer";
    private static final String IMPORT_FROM_ORG = "importfromorg";
    public static final String CUSTOMPARAM_CUSTOMERGROUPID = "customer_group_id";
    private static final String USEORG_FILEDNAME = "useorg.id";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "bizgroup.number": {
                e.getQfilters().clear();
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)e, (QFilter)F7Utils.getSaleOrgFitler());
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String customfilterSer = this.getPageCache().get("customfilter");
        if (customfilterSer == null) {
            return;
        }
        List customfilter = (List)SerializationUtils.fromJsonString((String)customfilterSer, ArrayList.class);
        for (Map customFiter : customfilter) {
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0))) continue;
            List orgIds = (List)customFiter.get("Value");
            if (orgIds == null || orgIds.get(0) == null) break;
            this.clearCtrlCache(orgIds.get(0));
            break;
        }
    }

    private void clearCtrlCache(Object orgId) {
        if (orgId != null) {
            long useorgId = Long.parseLong(orgId.toString());
            String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            String entityID = this.getEntityNumber();
            String key = entityID + orgId;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, (Long)useorgId);
            BaseDataService baseDataService = new BaseDataService();
            baseDataService.clearBaseDataFilterCache(entityID, Long.valueOf(useorgId));
            ArrayList<Long> orgIDList = new ArrayList<Long>(1);
            orgIDList.add(useorgId);
            BaseDataServiceHelper.refreshBaseDataUseRange((String)entityID, orgIDList);
        }
    }

    private String getEntityNumber() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        return entity;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object currNodeId = this.getTreeModel().getCurrentNodeId();
        if (currNodeId != null && currNodeId.toString().compareTo(this.getTreeModel().getRoot().getId()) != 0) {
            e.getParameter().setCustomParam(CUSTOMPARAM_CUSTOMERGROUPID, currNodeId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String key = ((AbstractOperate)evt.getSource()).getOperateKey();
        String errorMessage = null;
        switch (key) {
            case "addadmin": {
                evt.setCancel(true);
                this.showAddAdminPage();
                break;
            }
            case "toupdate": {
                evt.setCancel(true);
                this.toUpdateCustomer();
                break;
            }
            case "batchedit": {
                evt.setCancel(true);
                this.showBatchEditPage();
                break;
            }
            case "importfromcustomer": {
                evt.setCancel(true);
                errorMessage = this.checkCtrlStrategyPermission();
                if (StringUtils.isNotEmpty((String)errorMessage)) {
                    this.getView().showTipNotification(errorMessage);
                    return;
                }
                this.showImportFromCustomerPage();
                break;
            }
            case "importfromorg": {
                evt.setCancel(true);
                errorMessage = this.checkCtrlStrategyPermission();
                if (StringUtils.isNotEmpty((String)errorMessage)) {
                    this.getView().showTipNotification(errorMessage);
                    return;
                }
                this.showImportFromOrgPage();
            }
        }
    }

    private String checkCtrlStrategyPermission() {
        List createOrgs;
        int checkPermission;
        String checkErrorMessage = null;
        String userId = RequestContext.get().getUserId();
        long useOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
        String entity = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((String)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if ((checkPermission = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)useOrgId, (String)appid, (String)entity, (String)"47156aff000000ac")) != 1) {
            checkErrorMessage = "\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c";
        }
        if ((createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appid)).isEmpty()) {
            checkErrorMessage = "\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa\u7ec4\u7ec7";
        } else {
            if (this.getPageCache().get("createOrg") == null) {
                checkErrorMessage = "\u8bf7\u9009\u62e9\u4f7f\u7528\u7ec4\u7ec7";
            }
            if (!createOrgs.contains(useOrgId) && createOrgs.size() > 0) {
                checkErrorMessage = "\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e";
            }
        }
        return checkErrorMessage;
    }

    private void showImportFromOrgPage() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)0, (boolean)true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_FROM_ORG));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)Enable.ENABLE.toString()));
        QFilter[] filters = new QFilter[]{new QFilter("customerproperty", "=", (Object)CustomerProperty.INNER_ORG.toString()), new QFilter("bizgroup.id", ">", (Object)0L)};
        Set existOrgIds = QueryUtil.querySingleCol((String)"mdr_customer", (String)"bizgroup.id", (QFilter[])filters);
        if (!existOrgIds.isEmpty()) {
            listFilterParameter.getQFilters().add(new QFilter("id", "not in", (Object)existOrgIds));
        }
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showImportFromCustomerPage() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_customer", (boolean)true, (int)0, (boolean)true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_FROM_CUSTOMER));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        Set existBdCustomerIds = QueryUtil.querySingleCol((String)"mdr_customer", (String)"bdcustomer.id", (QFilter[])new QFilter("bdcustomer.id", ">", (Object)0L).toArray());
        if (!existBdCustomerIds.isEmpty()) {
            listFilterParameter.getQFilters().add(new QFilter("id", "not in", (Object)existBdCustomerIds));
        }
        listFilterParameter.getQFilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)Long.parseLong(this.getPageCache().get("createOrg"))));
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)Enable.ENABLE.toString()));
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null || rows.size() == 0) {
            return;
        }
        List<Object> ids = rows.stream().map(r -> r.getPrimaryKeyValue()).collect(Collectors.toList());
        switch (key) {
            case "importfromcustomer": {
                this.importMdrCustomerFromBdCustomer(ids);
                break;
            }
            case "importfromorg": {
                this.importMdrCustomerFromOrg(ids);
                break;
            }
        }
    }

    private void importMdrCustomerFromBdCustomer(List<Object> bdCustomerIds) {
        DynamicObjectCollection bdCustomers = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty(bdCustomerIds)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", bdCustomerIds)};
            List<String> selectFields = this.buildSelectFields();
            bdCustomers = QueryServiceHelper.query((String)"bd_customer", (String)selectFields.stream().collect(Collectors.joining(",")), (QFilter[])filters);
            long createOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
            String ctrlStrategy = CtrlStrategyUtils.getDefaultCtrlStrategy((String)"mdr_customer", (long)createOrgId);
            DynamicObject orderCustomer = CustomerUtil.getDefaultOrderCustomer((long)createOrgId);
            List<DynamicObject> mdrCustomers = bdCustomers.stream().map(bdCustomer -> this.buildMdrCustomerDynObj((DynamicObject)bdCustomer, createOrgId, orderCustomer, ctrlStrategy)).collect(Collectors.toList());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"mdr_customer", (DynamicObject[])mdrCustomers.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            operationResult.setMessage(ResManager.loadKDString((String)"\u5173\u8054\u5ba2\u6237\u751f\u6210\u6e20\u9053\u4fe1\u606f\u6210\u529f", (String)"CustomerListPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            this.getView().showOperationResult(operationResult);
        }
    }

    protected DynamicObject buildMdrCustomerDynObj(DynamicObject bdCustomer, long createOrgId, DynamicObject orderCustomer, String ctrlStrategy) {
        DynamicObject result = this.createNewCustomer(createOrgId);
        result.set("number", bdCustomer.get("number"));
        result.set("name", bdCustomer.get("name"));
        DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"partner", (String)"bd_bizpartner", (Object)bdCustomer.get("bizpartner"), null);
        DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"currency", (String)"bd_currency", (Object)bdCustomer.get("settlementcyid"), (Object)1L);
        DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"customertype", (String)"mdr_customer_type", (Object)1L, null);
        result.set("customerproperty", (Object)CustomerProperty.DIRECT_CUSTOMER.toString());
        DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"bdcustomer", (String)"bd_customer", (Object)bdCustomer.get("id"), null);
        result.set("isinnerorg", (Object)false);
        DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"bizgroup", (String)"bos_org", (Object)createOrgId, null);
        if (orderCustomer != null) {
            DynamicObjectUtils.setF7Value((DynamicObject)result, (String)"ordercustomer", (String)"mdr_customer", (Object)orderCustomer.getLong("id"), null);
        }
        if (StringUtils.isNotEmpty((String)ctrlStrategy)) {
            result.set("ctrlstrategy", (Object)ctrlStrategy);
        } else {
            result.set("ctrlstrategy", (Object)ControlStrategy.SHARE_IN_GLOBAL.toString());
        }
        result.set("easnumber", bdCustomer.get("number"));
        return result;
    }

    protected List<String> buildSelectFields() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("id");
        result.add("name");
        result.add("number");
        result.add("bizpartner");
        result.add("settlementcyid");
        return result;
    }

    private void importMdrCustomerFromOrg(List<Object> orgIds) {
        DynamicObjectCollection orgs = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty(orgIds)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgIds)};
            ArrayList<String> selectFields = new ArrayList<String>();
            selectFields.add("id");
            selectFields.add("name");
            selectFields.add("number");
            orgs = QueryServiceHelper.query((String)"bos_org", (String)selectFields.stream().collect(Collectors.joining(",")), (QFilter[])filters);
            long createOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
            String ctrlStrategy = CtrlStrategyUtils.getDefaultCtrlStrategy((String)"mdr_customer", (long)createOrgId);
            List<DynamicObject> mdrCustomers = orgs.stream().map(org -> {
                DynamicObject mdrCustomer = this.createNewCustomer(createOrgId);
                mdrCustomer.set("number", org.get("number"));
                mdrCustomer.set("name", org.get("name"));
                DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"currency", (String)"bd_currency", (Object)1L, null);
                DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"customertype", (String)"mdr_customer_type", (Object)9L, null);
                mdrCustomer.set("customerproperty", (Object)CustomerProperty.INNER_ORG.toString());
                mdrCustomer.set("isinnerorg", (Object)true);
                DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"bizgroup", (String)"bos_org", (Object)org.get("id"), null);
                if (StringUtils.isNotEmpty((String)ctrlStrategy)) {
                    mdrCustomer.set("ctrlstrategy", (Object)ctrlStrategy);
                } else {
                    mdrCustomer.set("ctrlstrategy", (Object)ControlStrategy.SHARE_IN_GLOBAL.toString());
                }
                mdrCustomer.set("easnumber", org.get("number"));
                return mdrCustomer;
            }).collect(Collectors.toList());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"mdr_customer", (DynamicObject[])mdrCustomers.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            operationResult.setMessage(ResManager.loadKDString((String)"\u5173\u8054\u7ec4\u7ec7\u751f\u6210\u6e20\u9053\u4fe1\u606f\u6210\u529f", (String)"CustomerListPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            this.getView().showOperationResult(operationResult);
        }
    }

    private DynamicObject createNewCustomer(long createOrgId) {
        DynamicObject mdrCustomer = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer");
        DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"createorg", (String)"bos_org", (Object)createOrgId, null);
        DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"org", (String)"bos_org", (Object)createOrgId, null);
        mdrCustomer.set("isstore", (Object)false);
        DynamicObjectUtils.setMultiF7Value((DynamicObject)mdrCustomer, (String)"customerfunctions", (String)"mdr_customer_function", (Object[])CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
        mdrCustomer.set("ordercontroltype", (Object)BillTypeControl.OPTIONAL.toString());
        mdrCustomer.set("returncontroltype", (Object)BillTypeControl.OPTIONAL.toString());
        mdrCustomer.set("salecontrolmode", (Object)SaleControlMode.BUGUANXIAOLIANG.toString());
        mdrCustomer.set("billcontrolmode", (Object)BillControlMode.I_BILL_I_ORDER.toString());
        mdrCustomer.set("invcontrolmode", (Object)InventoryControlMode.ENTRY_IN_SALE_MODE.toString());
        mdrCustomer.set("enable", (Object)Enable.ENABLE.toString());
        mdrCustomer.set("status", (Object)Status.SAVED.toString());
        DynamicObjectUtils.setF7Value((DynamicObject)mdrCustomer, (String)"creator", (String)"bos_user", (Object)UserUtil.getUserID(), null);
        mdrCustomer.set("createtime", (Object)new Date());
        return mdrCustomer;
    }

    private void toUpdateCustomer() {
        QFilter fs = new QFilter("partner", "=", (Object)0L);
        boolean exists = QueryServiceHelper.exists((String)"mdr_customer", (QFilter[])fs.toArray());
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u662f\u5347\u7ea7\u540e\u72b6\u6001\uff0c\u65e0\u9700\u518d\u5347\u7ea7", (String)"CustomerListPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("dbd_customer_update");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.getOpenStyle().setTargetKey(TO_UPDATE);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
            this.getView().showForm(fsp);
        }
        DBDServiceHelper.customerUpgrade();
    }

    private void showAddAdminPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("dbd_customer_admin_add");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(ADD_ADMIN);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        parameter.setCustomParam("customerids", (Object)ids);
        this.getView().showForm(parameter);
    }

    private void showBatchEditPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mdr_customer_batchedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey(BATCH_EDIT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        parameter.setCustomParam("customerids", (Object)ids);
        this.getView().showForm(parameter);
    }
}

