/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.dbd.common.util.ItemClassStandardUtils;
import kd.drp.mdr.common.f7.F7Utils;

public class CustomerTreeListPlugin
extends StandardTreeListPlugin {
    private static Log logger = LogFactory.getLog(CustomerTreeListPlugin.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "0";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    private static final String PARAM_INIT_GROUP_ID = "initGROUPId";
    private static final String USEORG_FILEDNAME = "useorg.id";
    public static final String SPLIT_LONG_NUMBER = "!";
    public static final String AP_BILL_LIST = "billlistap";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    private QFilter genRefreshFilter(String nodeId) {
        if (ROOTNODEID.equals(nodeId)) {
            return null;
        }
        QFilter qFilter = null;
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        if (!NO_GROUP.equals(nodeId)) {
            qFilter = new QFilter("custclassentity.classstandardid", "=", (Object)Long.parseLong(classStandardId.toString()));
            List<String> groupIds = this.queryGroupsByGroupId("mdr_customer_group", classStandardId, nodeId);
            ArrayList<Long> longresult = new ArrayList<Long>(1);
            if (groupIds != null && groupIds.size() > 0) {
                for (int i = 0; i < groupIds.size(); ++i) {
                    longresult.add(Long.parseLong(groupIds.get(i)));
                }
            }
            qFilter.and(new QFilter("custclassentity.customergroupid", "in", longresult));
        } else {
            HashSet<Long> customerIds = new HashSet<Long>();
            qFilter = new QFilter("customergroupid", "=", (Object)0);
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"mdr_customer_class", (String)"customerid", (QFilter[])qFilter.toArray());
            for (DynamicObject itemDynObj : itemDynObjColl) {
                customerIds.add(Long.parseLong(itemDynObj.getString("customerid")));
            }
            if (customerIds.size() > 0) {
                qFilter = new QFilter("customerid", "in", customerIds);
                qFilter.and(new QFilter("customergroupid", "!=", (Object)0));
                itemDynObjColl = QueryServiceHelper.query((String)"mdr_customer_class", (String)"customerid", (QFilter[])qFilter.toArray());
                for (DynamicObject itemDynObj : itemDynObjColl) {
                    customerIds.remove(Long.parseLong(itemDynObj.getString("customerid")));
                }
            }
            qFilter = new QFilter("custclassentity.classstandardid", "is null", (Object)"");
            if (customerIds.size() > 0) {
                qFilter.or(new QFilter("id", "in", customerIds));
            }
        }
        return qFilter;
    }

    private List<String> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String strid = id.toString();
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)String.join((CharSequence)",", "longnumber", "isleaf"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(strid))});
        if (queryOne.getBoolean("isleaf")) {
            list.add(strid);
            return list;
        }
        String longnumber = queryOne.getString("longnumber");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
        QFilter f2 = new QFilter("classstandard", "=", (Object)Long.parseLong(standardId.toString()));
        QFilter[] qFilters = new QFilter[]{f1, f2};
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), entity, "id", qFilters);){
            for (Row row : ds) {
                if (row.getString("id") == null) continue;
                list.add(row.getString("id"));
            }
        }
        return list;
    }

    private List<DynamicObject> getComData() {
        QFilter[] qFilterArray;
        String createOrg = this.getPageCache().get("createOrg");
        QFilter enableFilter = F7Utils.getEnableFilter();
        QFilter authorizedFilter = null;
        if (createOrg != null) {
            authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mdr_cust_classstandard", (Long)Long.parseLong(createOrg));
        }
        if (authorizedFilter == null) {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = enableFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = enableFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = authorizedFilter;
        }
        QFilter[] qfilers = qFilterArray;
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_cust_classstandard", (String)String.join((CharSequence)",", "id", "number", "name", "ispreset"), (QFilter[])qfilers);
        if (bizMap == null || bizMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        return new ArrayList<DynamicObject>(bizMap.values());
    }

    private void setComboEdit(List<DynamicObject> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<DynamicObject> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (orgModelList != null && orgModelList.size() > 0) {
            for (DynamicObject map : orgModelList) {
                String id = map.getString("id");
                String fName = map.getString("name");
                comboItems.put(id, new LocaleString(fName));
            }
            this.getModel().setValue(PROP_STANDARDLST, this.getDefaultStandardId(orgModelList));
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if (NO_GROUP.equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (NO_GROUP.equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        if (nodeId.equals(this.getTreeModel().getRoot().getId())) {
            TreeNode noOrgNode = new TreeNode(nodeId, NO_GROUP, this.getNodeNameUnknown(), false);
            treeNodes.add(noOrgNode);
        }
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        DynamicObject[] loads;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (value == null) {
            value = 836014120472951808L;
        }
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = NO_GROUP;
        }
        for (DynamicObject group : loads = BusinessDataServiceHelper.load((String)"mdr_customer_group", (String)String.join((CharSequence)",", "id", "number", "name", PROP_PARENT, "longnumber", "isleaf"), (QFilter[])new QFilter[]{new QFilter("classstandard", "=", (Object)Long.parseLong(value.toString())), new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId))})) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.get(PROP_PARENT).toString());
            treeNode.setText(group.getString("name"));
            treeNode.setLongNumber(group.getString("longnumber"));
            Object parentNode = group.get("isleaf");
            if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
                treeNode.addChildren(new ArrayList());
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
        this.focusInitGroupTreeNode();
    }

    private void focusInitGroupTreeNode() {
        String initGroupId = this.getPageCache().get(PARAM_INIT_GROUP_ID);
        if (StringUtils.isBlank((CharSequence)initGroupId)) {
            return;
        }
        String rootId = this.getTreeModel().getRoot().getId();
        if (initGroupId.equals(rootId)) {
            return;
        }
        this.getPageCache().remove(PARAM_INIT_GROUP_ID);
        DynamicObject strucObj = QueryServiceHelper.queryOne((String)"mdr_customer_group", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)initGroupId)});
        if (strucObj == null) {
            return;
        }
        String longnumber = strucObj.getString("longnumber");
        List longnumberList = ItemClassStandardUtils.getAllSuperiorLongnumber((String)longnumber);
        if (longnumberList == null || longnumberList.isEmpty()) {
            return;
        }
        DynamicObjectCollection struCol = QueryServiceHelper.query((String)"mdr_customer_group", (String)String.join((CharSequence)",", PROP_PARENT, "id"), (QFilter[])new QFilter[]{new QFilter("longnumber", "in", (Object)longnumberList)}, (String)"longnumber");
        if (struCol == null || struCol.isEmpty()) {
            return;
        }
        TreeView treeView = this.treeListView.getTreeView();
        String nodeId = "";
        String parentId = "";
        for (DynamicObject groupObj : struCol) {
            nodeId = groupObj.getString("id");
            if (nodeId.equals(rootId)) continue;
            parentId = groupObj.getString(PROP_PARENT);
            treeView.queryTreeNodeChildren(parentId, nodeId);
            treeView.expand(nodeId);
        }
        treeView.treeNodeClick(parentId, initGroupId);
    }

    public static List<String> getAllSuperiorLongnumber(String longnumber) {
        if (StringUtils.isBlank((CharSequence)longnumber) || longnumber.indexOf(".") == -1) {
            return new ArrayList<String>(0);
        }
        String superiorLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)".");
        ArrayList<String> superiorLongnumberSet = new ArrayList<String>(superiorLongnumber.length());
        superiorLongnumberSet.add(superiorLongnumber);
        while (superiorLongnumber.indexOf(SPLIT_LONG_NUMBER) > 0) {
            superiorLongnumber = StringUtils.substringBeforeLast((String)superiorLongnumber, (String)".");
            superiorLongnumberSet.add(superiorLongnumber);
        }
        return superiorLongnumberSet;
    }

    private Object getDefaultStandardId(List<DynamicObject> standards) {
        Object standardId = 836014120472951808L;
        if (standards == null) {
            standards = this.getComData();
        }
        if (standards != null && standards.size() > 0) {
            boolean isPreset = false;
            for (DynamicObject map : standards) {
                if (!map.getBoolean("ispreset")) continue;
                standardId = map.get("id");
                isPreset = true;
            }
            if (!isPreset) {
                standardId = standards.get(0).get("id");
            }
        }
        return standardId;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            List<DynamicObject> orgList = this.getComData();
            this.setComboEdit(orgList);
            this.getView().updateView(PROP_STANDARDLST);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String orgId = null;
        for (Map customFiter : customFiterList) {
            String createOrg;
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get("createOrg"))) {
                return;
            }
            this.getPageCache().put("createOrg", orgId);
            List<DynamicObject> orgList = this.getComData();
            this.setComboEdit(orgList);
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
            break;
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }

    private String getNodeNameUnknown() {
        return ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"CustomerTreeListPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
    }
}

