/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.customer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.Bizpartner;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class CustomerUpdatePlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(CustomerUpdatePlugin.class);
    private static final String UPDATE_INNER = "updateInnerCustomer";
    private static final String OP_UPDATE_DATA = "updatedata";
    private static final String OP_RESET = "reset";
    private static final String CONFIRM_TO_UPDATE = "toUpdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"partner"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData4Update();
    }

    private void loadData4Update() {
        IDataModel model = this.getModel();
        model.deleteEntryData("datas");
        QFilter fs = new QFilter("partner", "=", (Object)0L);
        QFilter innerFilter = new QFilter("isinnerorg", "=", (Object)"1");
        List customerInfos = QueryUtil.queryColumnsList((String)"mdr_customer", (String[])new String[]{"id", "name"}, (QFilter[])new QFilter[]{fs, innerFilter});
        if (customerInfos.isEmpty()) {
            innerFilter = new QFilter("isinnerorg", "=", (Object)"0");
            customerInfos = QueryUtil.queryColumnsList((String)"mdr_customer", (String[])new String[]{"id", "name"}, (QFilter[])new QFilter[]{fs, innerFilter});
            this.getPageCache().put(UPDATE_INNER, "0");
        } else {
            this.getPageCache().put(UPDATE_INNER, "1");
        }
        if (customerInfos.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6e20\u9053\u9700\u8981\u66f4\u65b0\uff0c\u53ef\u5237\u65b0\u6e20\u9053\u5217\u8868", (String)"CustomerUpdatePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object[]> fieldMap = this.autoAddPartner(customerInfos);
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry<String, Object[]> entry : fieldMap.entrySet()) {
            vs.addField(entry.getKey(), entry.getValue());
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.batchCreateNewEntryRow("datas", vs);
        model.endInit();
        this.getView().updateView("datas");
    }

    private Map<String, Object[]> autoAddPartner(List<Map<String, Object>> customerInfos) {
        int size = customerInfos.size();
        HashMap<Object, Map<String, Object>> customerNameMaps = new HashMap<Object, Map<String, Object>>(customerInfos.size());
        for (Map<String, Object> customer : customerInfos) {
            customerNameMaps.put(customer.get("name"), customer);
        }
        Set names = customerNameMaps.keySet();
        QFilter fs = new QFilter("name", "in", names);
        boolean isInnerOrg = this.isinnerOrg();
        Set<Object> ids = this.getExsistIdFromDb(isInnerOrg);
        fs.and("id", "not in", ids);
        fs.and(new QFilter("internal_company", isInnerOrg ? ">" : "=", (Object)0L));
        List infos = QueryUtil.queryColumnsList((String)"bd_bizpartner", (String[])new String[]{"name", "id"}, (QFilter[])fs.toArray());
        Object nameKey = null;
        for (Map partner : infos) {
            nameKey = partner.get("name");
            ((Map)customerNameMaps.get(nameKey)).put("partner", partner.get("id"));
        }
        HashMap<String, Object[]> feildMaps = new HashMap<String, Object[]>();
        Object[] customers = new Object[size];
        feildMaps.put("customer", customers);
        Object[] partners = new Object[size];
        feildMaps.put("partner", partners);
        for (int i = 0; i < size; ++i) {
            customers[i] = customerInfos.get(i).get("id");
            partners[i] = customerInfos.get(i).get("partner");
        }
        return feildMaps;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "updatedata": {
                this.toUpdateData();
                break;
            }
            case "reset": {
                this.reSetTb();
                break;
            }
        }
    }

    private void reSetTb() {
        this.loadData4Update();
    }

    private void toUpdateData() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u540e\uff0c\u4e0d\u53ef\u56de\u6eda\uff0c\u8bf7\u786e\u8ba4\u65e0\u8bef\u540e\uff0c\u70b9\u51fb\u3010\u786e\u8ba4\u3011\uff0c\u7ee7\u7eed\u5347\u7ea7\uff0c\u5347\u7ea7\u540e\uff0c\u5217\u8868\u5c06\u88ab\u91cd\u65b0\u52a0\u8f7d", (String)"CustomerUpdatePlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_TO_UPDATE, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        switch (key = e.getCallBackId()) {
            case "toUpdate": {
                this.conFirmToUpdateData(e);
                break;
            }
        }
    }

    private void conFirmToUpdateData(MessageBoxClosedEvent e) {
        MessageBoxResult result = e.getResult();
        if (result.compareTo((Enum)MessageBoxResult.Yes) == 0) {
            ArrayList<DynamicObject> withoutPartners = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> withPartners = new ArrayList<DynamicObject>();
            CheckResult cr = this.checkRows(withoutPartners, withPartners);
            if (!cr.isSuccess()) {
                this.getView().showTipNotification(cr.getMsg());
                return;
            }
            this.update(withoutPartners, withPartners);
            CustomerTreeCache.refreshCache();
        }
    }

    private void update(List<DynamicObject> withoutPartners, List<DynamicObject> withPartners) {
        if (!withoutPartners.isEmpty()) {
            HashMap<String, DynamicObject> nameMaps = new HashMap<String, DynamicObject>(withoutPartners.size());
            for (DynamicObject customer : withoutPartners) {
                nameMaps.put(customer.getString("name"), customer);
            }
            Set names = nameMaps.keySet();
            QFilter fs = new QFilter("name", "in", names);
            List infos = QueryUtil.queryColumnsList((String)"bd_bizpartner", (String[])new String[]{"name", "id"}, (QFilter[])fs.toArray());
            DynamicObject customerInfo = null;
            for (Map info : infos) {
                customerInfo = (DynamicObject)nameMaps.remove(info.get("name"));
                customerInfo.set("partner", info.get("id"));
                withPartners.add(customerInfo);
            }
            Collection<DynamicObject> withoutPartnerColl = nameMaps.values();
            List<Bizpartner> bps = this.prase2Bizpartners(withoutPartnerColl);
            StringBuilder sb = new StringBuilder();
            bps = this.createBizPartner(sb, bps);
            for (Bizpartner bp : bps) {
                customerInfo = (DynamicObject)nameMaps.remove(bp.getName());
                customerInfo.set("partner", (Object)bp.getId());
                withPartners.add(customerInfo);
            }
        }
        this.loadThenSave(withPartners);
        this.reSetTb();
    }

    private void loadThenSave(List<DynamicObject> customers) {
        DynamicObject[] customerInfos;
        HashMap<Object, DynamicObject> idMap = new HashMap<Object, DynamicObject>(customers.size());
        for (DynamicObject customer : customers) {
            idMap.put(customer.get("id"), customer);
        }
        Set ids = idMap.keySet();
        QFilter fs = new QFilter("id", "in", ids);
        String selectCols = F7Utils.getSelectCols((String[])new String[]{"id", "partner"});
        for (DynamicObject customerInfo : customerInfos = BusinessDataServiceHelper.load((String)"mdr_customer", (String)selectCols, (QFilter[])fs.toArray())) {
            customerInfo.set("partner", ((DynamicObject)idMap.get(customerInfo.get("id"))).get("partner"));
        }
        SaveServiceHelper.save((DynamicObject[])customerInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Bizpartner> createBizPartner(StringBuilder errorInfo, List<Bizpartner> bdBizpartners) {
        try (TXHandle newTx = null;){
            boolean success = true;
            newTx = TX.requiresNew();
            ArrayList<Bizpartner> bps = new ArrayList<Bizpartner>(bdBizpartners.size());
            StringBuilder error = null;
            for (Bizpartner bizpartner : bdBizpartners) {
                try {
                    error = new StringBuilder();
                    success = PermissionServiceHelper.createBizpartner((Bizpartner)bizpartner, (StringBuilder)error);
                    if (!success) continue;
                    bps.add(bizpartner);
                }
                catch (Exception e) {
                    LOG.error(ResManager.loadKDString((String)"CustomerUpdatePlugin.createBizPartner \u5931\u8d25\uff1a", (String)"CustomerUpdatePlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]) + this.getBizpartner(bizpartner).append(ResManager.loadKDString((String)"\u539f\u56e0\uff1a", (String)"CustomerUpdatePlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0])).append((CharSequence)error));
                }
            }
            ArrayList<Bizpartner> arrayList = bps;
            return arrayList;
        }
    }

    private StringBuilder getBizpartner(Bizpartner bp) {
        StringBuilder sb = new StringBuilder();
        return sb.append("Bizpartner:").append("name=").append(bp.getName()).append("number=").append(bp.getNumber()).append("typr=").append(bp.getType()).append("enable=").append(bp.getEnable()).append("status=").append(bp.getStatus());
    }

    private List<Bizpartner> prase2Bizpartners(Collection<DynamicObject> datas) {
        ArrayList<Bizpartner> bps = new ArrayList<Bizpartner>(datas.size());
        for (DynamicObject data : datas) {
            Bizpartner bp = new Bizpartner();
            bp.setName(data.getString("name"));
            bp.setNumber(data.getString("number"));
            bp.setType("1");
            boolean isInnerOrg = data.getBoolean("isinnerorg");
            if (isInnerOrg) {
                bp.setInternal_company_id(Long.valueOf(data.getDynamicObject("bizgroup").getLong("id")));
            }
            bp.setStatus("C");
            bp.setEnable("1");
            bp.setPartnerrole("3");
            bps.add(bp);
        }
        return bps;
    }

    private CheckResult checkRows(List<DynamicObject> withoutPartners, List<DynamicObject> withPartners) {
        EntryGrid eg = (EntryGrid)this.getControl("datas");
        int[] indexs = eg.getSelectRows();
        boolean isInnerOrg = this.isinnerOrg();
        DynamicObject rowInfo = null;
        DynamicObject customer = null;
        DynamicObject partner = null;
        for (int index : indexs) {
            rowInfo = this.getRowInfo("datas", index);
            partner = rowInfo.getDynamicObject("partner");
            if (isInnerOrg && partner == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\uff1a\u6e20\u9053\u65f6\u5185\u90e8\u6e20\u9053\u65f6\uff0c\u5546\u52a1\u4f19\u4f34\u4e0d\u80fd\u4e3a\u7a7a", (String)"CustomerUpdatePlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]), (Object[])new Object[]{index + 1});
            }
            customer = rowInfo.getDynamicObject("customer");
            if (partner != null) {
                customer.set("partner", partner.get("id"));
                withPartners.add(customer);
                continue;
            }
            withoutPartners.add(customer);
        }
        return CheckResult.returnTrue();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        int index = evt.getRow();
        switch (key) {
            case "partner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)this.getPartnerFilter(index));
                break;
            }
        }
    }

    private QFilter getPartnerFilter(int index) {
        boolean isInnerOrg = this.isinnerOrg();
        QFilter fs = new QFilter("internal_company", isInnerOrg ? ">" : "=", (Object)0L);
        Set<Object> ids = this.getPageExsistId(index);
        ids.addAll(this.getExsistIdFromDb(isInnerOrg));
        fs.and("id", "not in", ids);
        return fs;
    }

    protected boolean isinnerOrg() {
        String flag = this.getPageCache().get(UPDATE_INNER);
        boolean isInnerOrg = true;
        if ("1".equals(flag)) {
            isInnerOrg = true;
        } else if ("0".equals(flag)) {
            isInnerOrg = false;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u91cd\u65b0\u64cd\u4f5c", (String)"CustomerUpdatePlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return isInnerOrg;
    }

    private Set<Object> getExsistIdFromDb(boolean isInnerOrg) {
        QFilter fs = new QFilter("isinnerorg", "=", (Object)(isInnerOrg ? "1" : "0"));
        fs.and("partner", ">", (Object)0L);
        return QueryUtil.querySingleCol((String)"mdr_customer", (String)"partner", (QFilter[])fs.toArray());
    }

    private Set<Object> getPageExsistId(int index) {
        HashSet<Object> ids = new HashSet<Object>();
        int indexs = this.getModel().getEntryRowCount("datas");
        DynamicObject partner = null;
        for (int i = 0; i < indexs; ++i) {
            if (index == i || (partner = this.getRowInfo("datas", i).getDynamicObject("partner")) == null) continue;
            ids.add(partner.get("id"));
        }
        return ids;
    }
}

