/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.distributionrules;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.drp.dbd.common.util.DeflaterUtils;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.F7Utils;

class Common {
    static String[] fieldKeys = new String[]{"salebranch", "itemclass", "goods", "province", "city", "county", "branch", "stock", "mode"};
    static final String OP_SAVE = "save";
    static final String OP_REFRESH = "refresh";
    static final String KEY_SUCCESS = "Success";
    static final String KEY_ACTION_MODIFY = "ModifyRule";
    static final String KEY_ACTION_ADD = "AddRules";
    static final String KEY_UPDATERULES = "updateRules";

    Common() {
    }

    static void beforeF7Select(BeforeF7SelectEvent e, IFormView view) {
        int rowIndex = e.getRow();
        String fieldKey = e.getProperty().getName();
        QFilter filter = null;
        switch (fieldKey) {
            case "salebranch": 
            case "branch": {
                DynamicObject saleOrg = (DynamicObject)view.getModel().getValue("saleorg", rowIndex);
                filter = new QFilter("bizgroup.Id", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrg));
                break;
            }
            case "itemclass": {
                DynamicObject saleOrg = (DynamicObject)view.getModel().getValue("saleorg", rowIndex);
                List<Long> lstStandardId = Common.getGoodsClassStandardIds(saleOrg);
                filter = new QFilter("standard.Id", "in", lstStandardId);
                break;
            }
            case "province": {
                DynamicObject country = (DynamicObject)view.getModel().getValue("country", rowIndex);
                filter = Common.getCountryFilter(country);
                break;
            }
            case "city": {
                DynamicObject province = (DynamicObject)view.getModel().getValue("province", rowIndex);
                filter = Common.getAdminDivisionFilter(province);
                break;
            }
            case "county": {
                DynamicObject city = (DynamicObject)view.getModel().getValue("city", rowIndex);
                filter = Common.getAdminDivisionFilter(city);
                break;
            }
            case "stock": {
                DynamicObject branch = (DynamicObject)view.getModel().getValue("salebranch", rowIndex);
                long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
                filter = Common.getStockFilter(branchId);
                break;
            }
            case "mode": {
                DynamicObject saleBranch = (DynamicObject)view.getModel().getValue("salebranch", rowIndex);
                if (saleBranch == null) {
                    filter = new QFilter("id", "in", (Object)new Long[]{926596971228197888L, 926600838443594752L});
                    break;
                }
                filter = new QFilter("id", "in", (Object)new Long[]{926596489101228032L, 926596971228197888L, 926600838443594752L});
                break;
            }
            case "goods": {
                filter = new QFilter("operationmodel", "=", (Object)"1");
                break;
            }
        }
        F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, filter);
    }

    static void propertyChanged(PropertyChangedArgs e, IFormView view) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        int rowIndex = changeData[0].getRowIndex();
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"salebranch")) {
            DynamicObject saleBranch = (DynamicObject)changeData[0].getNewValue();
            if (saleBranch == null) {
                view.getModel().setValue("mode", (Object)926596971228197888L, rowIndex);
                view.getModel().setValue("stock", null, rowIndex);
            } else {
                view.getModel().setValue("mode", (Object)926596489101228032L, rowIndex);
                Common.setDefaultDeliveryStock(view, DynamicObjectUtils.getPkValue((DynamicObject)saleBranch), rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"mode")) {
            DynamicObject mode = (DynamicObject)changeData[0].getNewValue();
            long modeId = DynamicObjectUtils.getPkValue((DynamicObject)mode);
            if (modeId == 926596489101228032L) {
                DynamicObject saleBranch = (DynamicObject)view.getModel().getValue("salebranch", rowIndex);
                long saleBranchId = DynamicObjectUtils.getPkValue((DynamicObject)saleBranch);
                view.getModel().setValue("branch", (Object)saleBranchId, rowIndex);
                Common.setDefaultDeliveryStock(view, saleBranchId, rowIndex);
                view.getModel().setValue("inventoryorg", null, rowIndex);
            } else {
                view.getModel().setValue("branch", null, rowIndex);
                view.getModel().setValue("stock", null, rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"inventoryorg")) {
            view.getModel().setValue("erpstock", null, rowIndex);
        }
    }

    static String getCombinationStr(DynamicObject dyObj) {
        String combination = DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"saleorg") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"salebranch") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"itemclass") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"goods") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"country") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"province") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"city") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"county") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"mode") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"branch") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"stock") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"inventoryorg") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)dyObj, (String)"erpstock") + "_" + DynamicObjectUtils.getInt((DynamicObject)dyObj, (String)"priority");
        return DeflaterUtils.deflaterStr((String)combination);
    }

    static void clientCallBack(ClientCallBackEvent e) {
        if (StringUtils.equals((CharSequence)e.getName(), (CharSequence)KEY_UPDATERULES)) {
            IAppCache cache = AppCache.get((String)"dbd");
            String rulesCache = (String)cache.get("dbd_distributionrules", String.class);
            if (StringUtils.isNotBlank((CharSequence)rulesCache)) {
                cache.remove("dbd_distributionrules");
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"dbd_distributionrules");
            QFilter filter = F7Utils.getEnableStatus();
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            Object[] rules = BusinessDataServiceHelper.load((String)"dbd_distributionrules", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
            String strRule = DynamicObjectSerializeUtil.serialize((Object[])rules, (DynamicObjectType)type);
            cache.put("dbd_distributionrules", (Object)strRule);
        }
    }

    private static QFilter getCountryFilter(DynamicObject country) {
        long countryId = DynamicObjectUtils.getPkValue((DynamicObject)country);
        return new QFilter("country.Id", "=", (Object)countryId);
    }

    private static QFilter getAdminDivisionFilter(DynamicObject parentDivision) {
        long parentDivisionId = DynamicObjectUtils.getPkValue((DynamicObject)parentDivision);
        return new QFilter("parent.Id", "=", (Object)parentDivisionId);
    }

    private static QFilter getStockFilter(long branchId) {
        QFilter filter = new QFilter("ownerchannelid.Id", "=", (Object)branchId);
        filter.and("warehousetype", "=", (Object)"1");
        return filter;
    }

    private static List<Long> getGoodsClassStandardIds(DynamicObject saleOrg) {
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrg);
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("org.Id", "=", (Object)saleOrgId);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bd_goodsclassstandard", (String)"id", (QFilter[])filter.toArray());
        ArrayList<Long> lstStandardId = new ArrayList<Long>();
        if (data != null && data.size() > 0) {
            data.forEach(p -> lstStandardId.add(p.getLong("id")));
        } else {
            lstStandardId.add(0L);
        }
        return lstStandardId;
    }

    private static void setDefaultDeliveryStock(IFormView view, long branchId, int index) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and(Common.getStockFilter(branchId));
        filter.and("isdelivery", "=", (Object)Boolean.TRUE);
        DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"ocic_warehouse", (String)"id", (QFilter[])filter.toArray());
        view.getModel().setItemValueByID("stock", (Object)DynamicObjectUtils.getPkValue((DynamicObject)stock), index);
    }
}

