/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.inventory;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.log4j.Logger;

public class ItemStoreEditPlugin
extends MdrFormPlugin
implements IBillWebApiPlugin {
    private static final Logger log = Logger.getLogger(ItemStoreEditPlugin.class);

    public void convertPk(ConvertPkEvent e) {
        super.convertPk(e);
        Map m = e.getDataObject();
        String itemeasnumber = m.get("itemeasnumber") == null ? null : m.get("itemeasnumber").toString();
        String customereasnumber = m.get("customereasnumber") == null ? null : m.get("customereasnumber").toString();
        String measureunitnumber = m.get("measureunitnumber") == null ? null : m.get("measureunitnumber").toString();
        String assistattrnumber = m.get("assistattrnumber") == null ? null : m.get("assistattrnumber").toString();
        String warehousenumber = m.get("warehousenumber") == null ? null : m.get("warehousenumber").toString();
        QFilter filter = new QFilter("easnum", "=", (Object)itemeasnumber);
        DynamicObject item = ItemUtil.getInfoByQFilter((QFilter)filter, (String)"id");
        if (item == null) {
            log.error((Object)String.format("\u4e0d\u5b58\u5728eas\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u5546\u54c1", itemeasnumber));
            m.clear();
            return;
        }
        filter = new QFilter("number", "=", (Object)measureunitnumber);
        DynamicObject measureunit = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (measureunit == null) {
            log.error((Object)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u8ba1\u91cf\u5355\u4f4d", measureunitnumber));
            m.clear();
            return;
        }
        Object assistattrId = 0L;
        if (assistattrnumber != null) {
            filter = new QFilter("easnumber", "=", (Object)assistattrnumber);
            filter.and("item", "=", item.get("id"));
            DynamicObject assistattr = QueryServiceHelper.queryOne((String)"mdr_item_attrvalue", (String)"id,number", (QFilter[])new QFilter[]{filter});
            if (assistattr == null) {
                log.error((Object)String.format("\u5546\u54c1\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u8f85\u52a9\u5c5e\u6027", assistattrnumber));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728eas\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u5546\u54c1\u8f85\u52a9\u5c5e\u6027\u503c", (String)"ItemStoreEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), assistattrnumber));
            }
            assistattrId = assistattr.get("id");
        } else if (ItemAttrUtil.hasAssistAttr((Object)item.get("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5f00\u542f\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ItemStoreEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        filter = new QFilter("easnumber", "=", (Object)customereasnumber);
        DynamicObject customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (customer == null) {
            log.error((Object)String.format("\u4e0d\u5b58\u5728eas\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u6e20\u9053", measureunitnumber));
            m.clear();
            return;
        }
        DynamicObject warehouse = null;
        if (warehousenumber != null && !warehousenumber.isEmpty() && (warehouse = QueryServiceHelper.queryOne((String)"mdr_warehouse", (String)"id,number", (QFilter[])new QFilter[]{filter = new QFilter("number", "=", (Object)warehousenumber)})) == null) {
            log.error((Object)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a\u3010%s\u3011\u7684\u53d1\u8d27\u5730\u70b9", measureunitnumber));
            m.clear();
            return;
        }
        DynamicObject store = ItemStoreUtil.queryItemStore((Object)customer.getString("id"), (Object)item.getString("id"), (Object)measureunit.getString("id"), (Object)assistattrId, warehouse == null ? null : warehouse.getString("id"));
        m.put("id", store.get("id"));
        if (m.get("isinit") == null) {
            m.clear();
            return;
        }
        if (!((Boolean)m.get("isinit")).booleanValue()) {
            m.put("qty", store.getBigDecimal("qty").add(new BigDecimal(m.get("qty").toString())));
        }
    }
}

