/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.inventory;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class ItemStoreListPlugin
extends MdrListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterlist = e.getQFilters();
        QFilter filter = new QFilter("customer.id", "in", (Object)UserUtil.getOwnerIDs());
        filterlist.add(filter);
        e.setQFilters(filterlist);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (int i = 0; i < rows.size(); ++i) {
                    DynamicObject row = (DynamicObject)rows.get(i);
                    row.set("usableqty", (Object)row.getBigDecimal("qty").subtract(row.getBigDecimal("orderqty")));
                }
                return rows;
            }
        });
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, "customer.name");
        this.setWareHouseFilterComboItem(e, "warehouse.name");
    }
}

