/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.inventory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class WarehouseListPlugin
extends MdrListPlugin {
    private static final String WAREHOUSE_RELATION = "warehouse_relation";
    private static final String WAREHOUSE_RULE = "warehouse_rule";
    private static final String ADD_RELATION = "add_relation";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "warehouse_relation": {
                this.showWarehouseRelation();
                break;
            }
            case "add_relation": {
                this.addWarehouseRelation();
                break;
            }
            case "warehouse_rule": {
                this.addWarehouseRule();
            }
        }
    }

    private void showWarehouseRelation() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("mdr_warehouse_relation");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void addWarehouseRelation() {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("mdr_warehouse_relation");
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void addWarehouseRule() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bos_list");
        parameter.setBillFormId("mdr_warehouse_rule");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        this.initOwnerFilterComboItem(e, "owner.name");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!this.isLookup()) {
            List fs = e.getQFilters();
            HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>(fs.size());
            for (QFilter f : fs) {
                fsMap.put(f.getProperty(), f);
            }
            if (!fsMap.containsKey("owner.id")) {
                fs.add(this.createFilter(UserUtil.getOwnerIDs()));
                this.getPageCache().put(this.getView().getPageId() + "ownerId", "");
            } else {
                QFilter filter = (QFilter)fsMap.get("owner.id");
                this.getPageCache().put(this.getView().getPageId() + "ownerId", filter.getValue().toString());
                fs.add(this.createFilter(filter.getValue()));
                fs.remove(fsMap.get("owner.id"));
            }
        }
    }

    private QFilter createFilter(Object owner) {
        Collection ownerIds = new HashSet<Object>();
        if (owner instanceof Collection) {
            ownerIds = (Collection)owner;
        } else {
            ownerIds.add(owner);
        }
        QFilter filter = null;
        filter = ownerIds.size() > 0 && !owner.toString().equalsIgnoreCase("EMPTY") ? new QFilter("owner", "in", ownerIds) : new QFilter("owner", "is null", (Object)"");
        return filter;
    }
}

