/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileFormPosition;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.formplugin.formhandler.UnitFormHandler;
import kd.drp.mdr.mobile.MobileControlUtils;

public class ItemAddMobilePlugin
extends MdrFormMobPlugin
implements ListRowClickListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener {
    public static final String ADDITEM = "additem";
    public static final String BILLLLISTAP = "billlistap";
    public static final String CLOSE = "close";
    public static final String SEARCH = "search";
    private List<Map<String, Object>> itemlist = new ArrayList<Map<String, Object>>();
    private String searchText = "";

    private String getCacheKey() {
        return "mdr_itemlist_" + this.getView().getPageId();
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent arg0) {
                arg0.addCustomQFilter(ItemAddMobilePlugin.this.getItemFilter());
                arg0.setOrderBy("serialnumber desc,selltime desc");
            }
        });
    }

    protected QFilter getItemFilter() {
        QFilter filter = ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getParameter("ownerid"), (Object)this.getParameter("customerid"), (IPageCache)this.getPageCache());
        filter.and(new QFilter("isonsell", "=", (Object)"1"));
        if (!StringUtils.isEmpty((String)this.searchText)) {
            filter.and(QMatches.ftlike((String[])new String[]{this.searchText}, (String[])new String[]{"number,name"}));
        }
        return filter;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ADDITEM, CLOSE});
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObject row;
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                LinkedList<Object> itemIds = new LinkedList<Object>();
                for (int i = 0; i < rows.size(); ++i) {
                    row = (DynamicObject)rows.get(i);
                    itemIds.add(((DynamicObject)rows.get(i)).get("id"));
                }
                UnitFormHandler unitFormHandler = ItemAddMobilePlugin.this.getUnitFormHandler();
                unitFormHandler.batchLoad(itemIds);
                for (int i = 0; i < rows.size(); ++i) {
                    row = (DynamicObject)rows.get(i);
                    Object unitPK = unitFormHandler.getBaseUnitId(row.get("id"));
                    Object attrid = ItemAttrUtil.getDefaultAttrId((Object)row.get("id"));
                    BigDecimal itemprice = PriceUtil.getItemPrice((Object)ItemAddMobilePlugin.this.getParameter("ownerid"), (Object)ItemAddMobilePlugin.this.getParameter("customerid"), (Object)row.get("id"), (Object)unitPK, (Object)attrid, (BigDecimal)BigDecimal.ONE);
                    row.set("easnum", (Object)itemprice.stripTrailingZeros().toPlainString());
                }
                return rows;
            }
        });
    }

    public void click(MobileSearchTextChangeEvent e) {
        String context = e.getText();
        this.reLoadItem(context);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "additem": {
                BillList itemList = (BillList)this.getControl(BILLLLISTAP);
                ListSelectedRow iteminfo = itemList.getCurrentSelectedRowInfo();
                Object itempk = iteminfo.getPrimaryKeyValue();
                this.addItem(itempk);
                break;
            }
            case "close": {
                this.getView().returnDataToParent(this.getItemlist());
                CacheUtil.remove((String)this.getCacheKey());
                this.getView().close();
                break;
            }
        }
    }

    private void addItem(Object itempk) {
        Object ownerId = this.getParameter("ownerid");
        Object customerId = this.getParameter("customerid");
        if (ownerId == null || customerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u53ca\u4f9b\u8d27\u6e20\u9053", (String)"ItemAddMobilePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ownerid", ownerId);
        params.put("customerid", customerId);
        params.put("itemid", itempk);
        params.put("warehouseid", this.getParameter("warehouseid"));
        parameter.setCustomParams(params);
        parameter.setPosition(MobileFormPosition.Bottom);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("mdr_mobchooseitemattr");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDITEM));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void addItem(Map<String, Object> param) {
        this.itemlist = this.getItemlist();
        this.itemlist.add(param);
        this.setItemlist(this.itemlist);
        CacheUtil.put((String)this.getCacheKey(), this.itemlist);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f", (String)"ItemAddMobilePlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
    }

    public void setItemlist(List<Map<String, Object>> itemlist) {
        CacheUtil.put((String)this.getCacheKey(), itemlist);
    }

    private void reLoadItem(Object context) {
        this.searchText = context.toString();
        BillList billList = (BillList)this.getControl(BILLLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getItemFilter()});
    }

    public List<Map<String, Object>> getItemlist() {
        if (CacheUtil.get((String)this.getCacheKey(), ArrayList.class) != null) {
            this.itemlist = new ArrayList<Map<String, Object>>((Collection)CacheUtil.get((String)this.getCacheKey(), ArrayList.class));
        }
        if (this.itemlist == null || this.itemlist.isEmpty()) {
            this.itemlist = new ArrayList<Map<String, Object>>();
        }
        return this.itemlist;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "additem": {
                Map param = (Map)e.getReturnData();
                if (param == null) {
                    return;
                }
                this.addItem(param);
                break;
            }
        }
    }
}

