/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.message.json.JsonHelper;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class ItemAttrChooseMobilePlugin
extends MdrFormMobPlugin
implements BeforeF7SelectListener {
    private static final String ITEM = "item";
    private static final String ITEMNAME = "itemname";
    private static final String ITEMPIC = "itempic";
    private static final String UNIT = "unit";
    private static final String UNITNAME = "unitname";
    private static final String PRICE = "price";
    private static final String PRICENAME = "pricename";
    private static final String QTY = "qty";
    private static final String STORE = "store";
    private static final String HASSTORE = "hasstore";
    private static final String ITEMATTRVALUE = "itemattrvalue";
    private static final String REDUCE = "reduce";
    private static final String ADD = "add";
    private static final String SPLIT = "&";
    private static final String CACHE_KEY = "checked";
    private static final String ITEM_ATTRVALUELIST = "itemattrvaluelist";
    private static final String UNENABLE_LIST = "unablelist";
    private static final String SUBMIT_BTN = "submit";
    private static final String LABEL = "label";
    private static final String ASSISTQTY = "assistqty";
    private static final String ASSISTUNIT = "assistunit";
    private static final String ASSISTUNITNAME = "assistunitname";
    private static final String SALEQTY = "saleqty";
    private static final String SALEUNIT = "saleunit";
    private static final String SALEUNITNAME = "saleunitname";
    private static final int ITEMATTRVALUESIGN = 100;
    protected static Log log = LogFactory.getLog(ItemAttrChooseMobilePlugin.class);
    private static final String PAGECACHE_ASSISTATTR_COUNT = "assist_attr_count";

    public void afterCreateNewData(EventObject e) {
        String operate;
        this.setItemInfo();
        this.addUnitAp();
        DynamicObject unit = (DynamicObject)this.getModel().getValue(UNIT);
        if (unit != null) {
            this.setUnit("unitbtn&" + unit.getPkValue(), null);
        }
        this.addAssistattrAp();
        int count = Integer.parseInt(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT));
        if (count != 0) {
            this.setEnableAndUnEnable("init", null);
            this.setAssistAttr();
        }
        if (unit == null) {
            this.setLabelTitle(HASSTORE, "");
            return;
        }
        this.setItemStore();
        String string = operate = this.getParamValue("operate") != null ? this.getParamValue("operate").toString() : "";
        if ("edit".equals(operate)) {
            BigDecimal qty = new BigDecimal(this.getParamValue(QTY).toString());
            BigDecimal store = (BigDecimal)this.getModel().getValue(STORE);
            if (this.isAllowOver() && store.compareTo(qty) < 0) {
                qty = store.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : store;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u5df2\u4e3a\u60a8\u66f4\u65b0\u6570\u91cf\uff01", (String)"ItemAttrChooseMobilePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(QTY, (Object)qty);
        }
        this.handleQty();
        this.setPrice();
    }

    private void setItemInfo() {
        DynamicObject unit;
        Long itemid = this.getItemIdFromParams();
        this.getModel().setValue(ITEM, (Object)itemid);
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM);
        Image userphoto = (Image)this.getControl(ITEMPIC);
        String url = UrlService.getImageFullUrl((String)"") + item.getString("thumbnail");
        userphoto.setUrl(url);
        Object unitid = null;
        String operate = this.getParamValue("operate") != null ? this.getParamValue("operate").toString() : "";
        unitid = this.getUnitFormHandler().getSaleUnitId((Object)itemid);
        this.getModel().setValue(SALEUNIT, unitid);
        DynamicObject saletunit = (DynamicObject)this.getModel().getValue(SALEUNIT);
        this.setLabelTitle(SALEUNITNAME, saletunit.getString("name"));
        this.setLabelTitle(UNITNAME, "/" + saletunit.getString("name"));
        this.setLabelTitle(ITEMNAME, item.getString("name"));
        if ("edit".equals(operate)) {
            unitid = this.getUnitIdFromParams();
            Object priceValue = this.getParamValue(PRICE);
            if (priceValue instanceof Integer) {
                priceValue = new BigDecimal((Integer)priceValue);
            }
            this.getModel().setValue(PRICE, priceValue);
            this.setLabelTitle(PRICENAME, "\uffe5" + ((BigDecimal)priceValue).stripTrailingZeros().toPlainString());
        } else if (itemid != null) {
            this.setLabelTitle(PRICENAME, "\uffe50");
        }
        if (unitid != null) {
            this.getModel().setValue(UNIT, unitid);
        }
        if ((unit = (DynamicObject)this.getModel().getValue(UNIT)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u9519\u8bef\uff0c\u6ca1\u6709\u8ba1\u91cf\u5355\u4f4d\uff01", (String)"ItemAttrChooseMobilePlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        Object assistunitid = this.getUnitFormHandler().getAssistUnitId((Object)itemid);
        if (assistunitid != null) {
            this.getModel().setValue(ASSISTUNIT, assistunitid);
        }
    }

    private void setAssistAttr() {
        String operate;
        String string = operate = this.getParamValue("operate") != null ? this.getParamValue("operate").toString() : "";
        if ("edit".equals(operate)) {
            Object assistattrid = this.getParamValue("assistattrid");
            if (assistattrid == null) {
                return;
            }
            DynamicObjectCollection attrValues = ItemAttrUtil.getAttrValuesById((Object)assistattrid);
            for (DynamicObject attrValue : attrValues) {
                List unEnableList = JsonHelper.parseJsonArray2List((String)this.getPageCache().get(UNENABLE_LIST));
                if (unEnableList.contains("addbtn&" + attrValue.get("attrentity.attrvalue"))) continue;
                Button button = (Button)this.getControl("addbtn&" + attrValue.getString("attrentity.attrvalue"));
                button.click();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD, REDUCE, SUBMIT_BTN});
        this.addF7Listener(this, new String[]{UNIT});
    }

    public void click(EventObject evt) {
        Long newUnitId;
        Object oldUnitId;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (ADD.equals(key)) {
            this.add(QTY);
        } else if (REDUCE.equals(key)) {
            this.reduce(QTY);
        } else if (SUBMIT_BTN.equals(key)) {
            this.returnDataAndClose();
        } else if (key.startsWith("addbtn")) {
            String oldUnitId2 = this.getPageCache().get("checked&" + this.getPageCache().get(key));
            if (oldUnitId2 != null) {
                Long newUnitId2 = Long.parseLong(key.split(SPLIT)[1]);
                if (!oldUnitId2.equals(((Object)newUnitId2).toString())) {
                    String index = this.getPageCache().get(key);
                    this.clearAndSetChecked(index, key);
                    this.clearQty();
                    this.setPrice();
                }
            } else {
                String index = this.getPageCache().get(key);
                this.clearAndSetChecked(index, key);
                this.clearQty();
                this.setPrice();
            }
        } else if (key.startsWith("unitbtn") && !(oldUnitId = ((DynamicObject)this.getModel().getValue(UNIT)).getPkValue()).equals(newUnitId = Long.valueOf(Long.parseLong(key.split(SPLIT)[1])))) {
            this.setUnit("unitbtn&" + newUnitId, "unitbtn&" + oldUnitId);
            BigDecimal newQty = this.changeQty(newUnitId, oldUnitId);
            this.getModel().setValue(QTY, (Object)newQty);
        }
    }

    private void setUnit(String unit, String oldUnit) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(unit);
        list.add(dataMap);
        if (oldUnit != null) {
            HashMap<String, String> oldDataMap = new HashMap<String, String>();
            list.add(oldUnit);
            list.add(oldDataMap);
            oldDataMap.put("bc", "#ffffff");
            oldDataMap.put("fc", "#333333");
        }
        dataMap.put("bc", "#F4984E");
        dataMap.put("fc", "#ffffff");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
        this.getModel().setValue(UNIT, (Object)unit.split(SPLIT)[1]);
        this.updateRate(unit.split(SPLIT)[1]);
    }

    private void setEnableAndUnEnable(String operate, String key) {
        int count = Integer.parseInt(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT));
        List<Object> attrList = this.getAttrList(key);
        DynamicObject unit = (DynamicObject)this.getModel().getValue(UNIT);
        Object unitid = null;
        if (unit != null) {
            unitid = unit.get("id");
        }
        if ("click".equals(operate) || "init".equals(operate)) {
            this.setEnableAndUnEnable(attrList, unitid, key, count, operate);
        } else if ("cancel".equals(operate)) {
            this.modelClick();
        }
    }

    private void modelClick() {
        int count = Integer.parseInt(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT));
        this.setEnableAndUnEnable("init", null);
        List<Object> checkedList = this.getCheckedList(count);
        DynamicObject unit = (DynamicObject)this.getModel().getValue(UNIT);
        for (Object key : checkedList) {
            List<Object> attrList = this.getAttrList("addbtn&" + key.toString());
            this.setEnableAndUnEnable(attrList, unit.get("id"), "addbtn&" + key, count, "click");
        }
    }

    private void setItemStore() {
        int count = Integer.parseInt(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT));
        DynamicObject unit = (DynamicObject)this.getModel().getValue(UNIT);
        if (count != 0) {
            this.setItemStore(this.getAttrList(count), unit.get("id"));
        } else {
            this.setItemStore(null, unit.get("id"));
        }
    }

    private void setItemStore(List<Object> attrList, Object unit) {
        DynamicObjectCollection sum = ItemStoreUtil.queryItemStoreInfoSum((Object)this.getParamValue("ownerid"), (Object)this.getParamValue("itemid"), (Object)unit, attrList, (Object)this.getParamValue("warehouseid"), (boolean)true);
        DynamicObject info = CustomerUtil.getAuthBizInfo((Object)this.getParamValue("ownerid"), (Object)this.getParamValue("customerid"));
        String parentinvtype = info.getString("parentinvtype");
        BigDecimal sumUsableQty = ZERO;
        if (sum != null && !sum.isEmpty()) {
            sumUsableQty = ((DynamicObject)sum.get(0)).getBigDecimal("usableqty");
        }
        this.getModel().setValue(STORE, (Object)sumUsableQty);
        String hasStore = ResManager.loadKDString((String)"\u65e0\u8d27", (String)"ItemAttrChooseMobilePlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
        if (sumUsableQty.compareTo(ZERO) > 0) {
            hasStore = "1".equals(parentinvtype) ? ResManager.loadKDString((String)"\u6709\u8d27", (String)"ItemAttrChooseMobilePlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]) : new StringBuffer(ResManager.loadKDString((String)"\u6709\u8d27\uff08\u5e93\u5b58", (String)"ItemAttrChooseMobilePlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0])).append(sumUsableQty.stripTrailingZeros().toPlainString()).append("\uff09").toString();
        }
        if ("0".equals(parentinvtype)) {
            hasStore = "";
        }
        this.setLabelTitle(HASSTORE, hasStore);
    }

    private boolean isAllowOver() {
        return CustomerParamsUtil.isAllowOver((Object)this.getParamValue("ownerid")).equals("1");
    }

    private void setEnableAndUnEnable(List<Object> attrList, Object unit, String key, int count, String operate) {
        List<Object> checkedList;
        List<Object> nowlineList = null;
        ArrayList<Object> attrListHasStore = new ArrayList<Object>(QueryUtil.querySingleCol((String)"mdr_item_attrvalue", (String)"attrentity.attrvalue", (QFilter[])new QFilter("id", "in", attrList).toArray()));
        List<Object> itemAttrValueList = this.getItemAttrValueList();
        if (key != null) {
            nowlineList = this.getNowLineList(key.split(SPLIT)[1]);
        }
        if (nowlineList != null && !nowlineList.isEmpty()) {
            attrListHasStore.removeAll(nowlineList);
            itemAttrValueList.removeAll(nowlineList);
        }
        if ((checkedList = this.getCheckedList(count)) != null && !checkedList.isEmpty()) {
            attrListHasStore.removeAll(checkedList);
            itemAttrValueList.removeAll(checkedList);
        }
        this.addPrefix(attrListHasStore, "addbtn&");
        this.addPrefix(itemAttrValueList, "addbtn&");
        itemAttrValueList.removeAll(attrListHasStore);
        this.setEnableAndUnEnable(itemAttrValueList, attrListHasStore, operate);
        if ("init".equals(operate)) {
            this.setEnable(attrListHasStore.toArray(new String[attrListHasStore.size()]));
        }
        this.setUnEnable(itemAttrValueList.toArray(new String[itemAttrValueList.size()]));
        this.getPageCache().put(UNENABLE_LIST, JsonHelper.encodeObject2Json(itemAttrValueList));
    }

    private List<Object> getNowLineList(String key) {
        DynamicObjectCollection collect = ItemAttrUtil.getAttrIdByAttrValueId((Object)Long.parseLong(key));
        if (collect != null && !((DynamicObject)collect.get(0)).getString("group").equals("0")) {
            Object group = ((DynamicObject)collect.get(0)).get("group");
            DynamicObjectCollection attrvalues = ItemAttrUtil.getAttrValuesByItemId((Object)this.getParamValue("itemid"), (Object)group);
            List valueList = CommonUtils.collection2List((String)"attrentity.attrvalue", (List)attrvalues);
            return valueList;
        }
        return null;
    }

    private void setEnableAndUnEnable(List<Object> unAllowList, List<Object> allowList, String operate) {
        HashMap<String, String> unAllowdataMap = new HashMap<String, String>();
        unAllowdataMap.put("bc", "#E5E5E5");
        unAllowdataMap.put("fc", "#333");
        HashMap<String, String> allowdataMap = new HashMap<String, String>(allowList.size());
        allowdataMap.put("bc", "#fff");
        allowdataMap.put("fc", "#333");
        ArrayList<Object> list = new ArrayList<Object>(unAllowList.size());
        for (Object key : unAllowList) {
            list.add(key);
            list.add(unAllowdataMap);
        }
        if ("init".equals(operate)) {
            for (Object key : allowList) {
                list.add(key);
                list.add(allowdataMap);
            }
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private void addPrefix(List<Object> list, String str) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, str + list.get(i));
        }
    }

    private List<Object> getItemAttrValueList() {
        String itemattrValueList = this.getPageCache().get(ITEM_ATTRVALUELIST);
        if (itemattrValueList == null) {
            DynamicObjectCollection attrvalues = ItemAttrUtil.getAttrValuesByItemId((Object)this.getParamValue("itemid"), null);
            List valueList = CommonUtils.collection2List((String)"attrentity.attrvalue", (List)attrvalues);
            this.getPageCache().put(ITEM_ATTRVALUELIST, JsonHelper.encodeObject2Json((Object)valueList));
            return valueList;
        }
        return JsonHelper.parseJsonArray2List((String)itemattrValueList);
    }

    private List<Object> getAttrList(String key) {
        ArrayList<Object> attrList = new ArrayList<Object>();
        Object itemid = this.getParamValue("itemid");
        DynamicObject[] attrInfos = ItemAttrUtil.getAttrInfos((Object)itemid);
        if (key == null) {
            return CommonUtils.collection2List((String)"id", (DynamicObject[])attrInfos);
        }
        Long id = Long.valueOf(key.split(SPLIT)[1]);
        for (DynamicObject attrInfo : attrInfos) {
            DynamicObjectCollection entry = attrInfo.getDynamicObjectCollection("attrentity");
            List list = CommonUtils.collection2List((String)"attrvalue.id", (List)entry);
            if (!list.contains(id)) continue;
            attrList.add(attrInfo.get("id"));
        }
        return attrList;
    }

    private List<Object> getAttrList(int count) {
        List<Object> checkedList = this.getCheckedList(count);
        ArrayList<Object> attrList = new ArrayList<Object>();
        Object itemid = this.getParamValue("itemid");
        DynamicObject[] attrInfos = ItemAttrUtil.getAttrInfos((Object)itemid);
        if (checkedList == null || checkedList.isEmpty()) {
            return CommonUtils.collection2List((String)"id", (DynamicObject[])attrInfos);
        }
        for (DynamicObject attrInfo : attrInfos) {
            DynamicObjectCollection entry = attrInfo.getDynamicObjectCollection("attrentity");
            List list = CommonUtils.collection2List((String)"attrvalue.id", (List)entry);
            if (!list.containsAll(checkedList)) continue;
            attrList.add(attrInfo.get("id"));
        }
        return attrList;
    }

    private List<Object> getCheckedList(int count) {
        ArrayList<Object> checkedList = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            String checked = this.getPageCache().get("checked&" + (100 + i));
            if (checked == null || checked.isEmpty()) continue;
            checkedList.add(Long.parseLong(checked));
        }
        return checkedList;
    }

    private void returnDataAndClose() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject unit = (DynamicObject)this.getModel().getValue(UNIT);
        if (unit == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\uff01", (String)"ItemAttrChooseMobilePlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal qty = (BigDecimal)this.getModel().getValue(QTY);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u4e3a0\uff01", (String)"ItemAttrChooseMobilePlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Object itemattrvalue = this.getModel().getValue(ITEMATTRVALUE);
        if (!"0".equals(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT)) && (itemattrvalue == null || itemattrvalue.toString().isEmpty())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f85\u52a9\u5c5e\u6027\uff01", (String)"ItemAttrChooseMobilePlugin_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject assistunit = (DynamicObject)this.getModel().getValue(ASSISTUNIT);
        param.put(ASSISTUNIT, assistunit);
        param.put(ITEM, (DynamicObject)this.getModel().getValue(ITEM));
        if (assistunit != null) {
            param.put("assistunitid", assistunit.get("id"));
            param.put(ASSISTUNITNAME, assistunit.get("name").toString());
            param.put(ASSISTQTY, new BigDecimal(this.getPageCache().get(ASSISTQTY)));
        }
        DynamicObject saleUnit = (DynamicObject)this.getModel().getValue(SALEUNIT);
        param.put("unitid", saleUnit.getPkValue());
        param.put(UNITNAME, saleUnit.get("name").toString());
        param.put("assistattrid", this.getF7PKValue(ITEMATTRVALUE));
        BigDecimal price = (BigDecimal)this.getModel().getValue(PRICE);
        param.put(PRICE, price);
        BigDecimal newQty = this.changeQty(saleUnit.getPkValue(), unit.getPkValue());
        param.put(QTY, newQty);
        param.put("amount", newQty.multiply(price));
        this.getView().returnDataToParent((Object)param);
        this.getView().close();
    }

    private void clearAndSetChecked(String index, String key) {
        String oldchecked = this.getPageCache().get("checked&" + index);
        if (oldchecked != null && !oldchecked.isEmpty()) {
            this.clear(index, "addbtn&" + oldchecked);
            this.setEnableAndUnEnable("cancel", null);
        }
        if (!key.split(SPLIT)[1].equals(oldchecked)) {
            this.setChecked(index, key);
            this.setEnableAndUnEnable("click", key);
        }
        this.setItemStore();
    }

    private void setChecked(String index, String key) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        list.add(dataMap);
        dataMap.put("bc", "#F4984E");
        dataMap.put("fc", "#ffffff");
        this.getPageCache().put("checked&" + index, key.split(SPLIT)[1]);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private void clear(String index, String oldkey) {
        HashMap<String, String> olddataMap = new HashMap<String, String>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(oldkey);
        list.add(olddataMap);
        olddataMap.put("bc", "#fff");
        olddataMap.put("fc", "#333");
        this.getPageCache().put("checked&" + index, "");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private void add(String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname);
        this.getModel().setValue(qtyname, (Object)qty.add(ONE));
    }

    private void reduce(String qtyname) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyname);
        this.getModel().setValue(qtyname, (Object)qty.subtract(ONE));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        String key = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "qty": {
                if (((BigDecimal)value).compareTo(ZERO) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (String)"ItemAttrChooseMobilePlugin_8", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(QTY, oldValue);
                    return;
                }
                this.handleQty();
                this.setPrice();
                break;
            }
            case "store": {
                this.setPrice();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void handleQty() {
        DynamicObject saleunit = (DynamicObject)this.getModel().getValue(SALEUNIT);
        BigDecimal saleRate = this.getToSaleRate();
        int salePrisicion = saleunit.getInt("precision");
        BigDecimal qty = (BigDecimal)this.getModel().getValue(QTY);
        BigDecimal saleqty = qty.multiply(saleRate).setScale(salePrisicion, RoundingMode.HALF_UP);
        this.getPageCache().put(SALEQTY, saleqty.toPlainString());
        this.setLabelTitle(SALEQTY, saleqty.toPlainString());
        DynamicObject assistunit = (DynamicObject)this.getModel().getValue(ASSISTUNIT);
        if (assistunit != null) {
            BigDecimal rate = this.getToAssistRate();
            int assistPrisicion = assistunit.getInt("precision");
            BigDecimal assistqty = qty.multiply(rate).setScale(assistPrisicion, RoundingMode.HALF_UP);
            this.getPageCache().put(ASSISTQTY, assistqty.toPlainString());
        }
    }

    private BigDecimal getToAssistRate() {
        return new BigDecimal(this.getPageCache().get("assistfactor"));
    }

    private BigDecimal getToSaleRate() {
        return new BigDecimal(this.getPageCache().get("salefactor"));
    }

    private void updateRate(String unitid) {
        DynamicObject saleunit;
        DynamicObject assistunit = (DynamicObject)this.getModel().getValue(ASSISTUNIT);
        Long unitId = Long.valueOf(unitid);
        if (assistunit != null) {
            BigDecimal rate = ItemUtil.queryConversionFactor((Object)this.getItemIdFromParams(), (Object)unitId, (Object)assistunit.getPkValue());
            this.getPageCache().put("assistfactor", rate.stripTrailingZeros().toPlainString());
        }
        if ((saleunit = (DynamicObject)this.getModel().getValue(SALEUNIT)) != null) {
            BigDecimal saleRate = ItemUtil.queryConversionFactor((Object)this.getItemIdFromParams(), (Object)unitId, (Object)saleunit.getPkValue());
            this.getPageCache().put("salefactor", saleRate.stripTrailingZeros().toPlainString());
        }
    }

    private void setPrice() {
        int count = Integer.parseInt(this.getPageCache().get(PAGECACHE_ASSISTATTR_COUNT));
        Object attrvalues = this.matchAttrValues(count);
        if (attrvalues == null) {
            if (count != 0) {
                this.getModel().setValue(ITEMATTRVALUE, null);
            }
            attrvalues = 0L;
        } else {
            this.getModel().setValue(ITEMATTRVALUE, attrvalues);
        }
        DynamicObject unit = (DynamicObject)this.getModel().getValue(SALEUNIT);
        if (unit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u9519\u8bef\uff0c\u6ca1\u6709\u8ba1\u91cf\u5355\u4f4d\uff01", (String)"ItemAttrChooseMobilePlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        BigDecimal qty = new BigDecimal(this.getPageCache().get(SALEQTY));
        BigDecimal price = PriceUtil.getItemPrice((Object)this.getParamValue("ownerid"), (Object)this.getParamValue("customerid"), (Object)this.getParamValue("itemid"), (Object)unit.get("id"), (Object)attrvalues, (BigDecimal)qty);
        this.getModel().setValue(PRICE, (Object)price);
        this.setLabelTitle(PRICENAME, "\uffe5" + price.stripTrailingZeros().toPlainString());
    }

    private Object matchAttrValues(int count) {
        DynamicObject[] attrInfos;
        ArrayList<Long> checkedList = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            String checked = this.getPageCache().get("checked&" + (100 + i));
            if (checked == null || checked.isEmpty()) {
                return null;
            }
            checkedList.add(Long.parseLong(checked));
        }
        Object itemid = this.getParamValue("itemid");
        for (DynamicObject attrInfo : attrInfos = ItemAttrUtil.getAttrInfos((Object)itemid)) {
            DynamicObjectCollection entry = attrInfo.getDynamicObjectCollection("attrentity");
            List list = CommonUtils.collection2List((String)"attrvalue.id", (List)entry);
            if (!list.containsAll(checkedList)) continue;
            return attrInfo.get("id");
        }
        return null;
    }

    private void clearQty() {
        this.getModel().setValue(QTY, (Object)BigDecimal.ZERO);
        this.handleQty();
    }

    private BigDecimal changeQty(Object newUnitId, Object oldUnitId) {
        BigDecimal newQty = BigDecimal.ZERO;
        DynamicObject saleunit = (DynamicObject)this.getModel().getValue(SALEUNIT);
        if (saleunit != null) {
            BigDecimal rate = this.getToSaleRate();
            rate = ItemUtil.queryConversionFactor((Object)this.getItemIdFromParams(), (Object)oldUnitId, (Object)newUnitId);
            int assistPrisicion = saleunit.getInt("precision");
            BigDecimal oldQty = (BigDecimal)this.getModel().getValue(QTY);
            newQty = oldQty.multiply(rate).setScale(assistPrisicion, RoundingMode.HALF_UP);
        }
        return newQty;
    }

    protected void addUnitAp() {
        Object itemid = this.getParamValue("itemid");
        DynamicObjectCollection unitInfo = this.getUnits(itemid);
        this.addFlexAp(0, unitInfo, "unitpanel", UNIT, ResManager.loadKDString((String)"\u9009\u62e9\u5355\u4f4d", (String)"ItemAttrChooseMobilePlugin_9", (String)"drp-dbd-formplugin", (Object[])new Object[0]), "id", "name", "unitbtn");
    }

    protected DynamicObjectCollection getUnits(Object itemid) {
        ArrayList<Object> unitIds = new ArrayList<Object>();
        Object baseUnitId = this.getUnitFormHandler().getBaseUnitId(itemid);
        Object saleUnitId = this.getUnitFormHandler().getSaleUnitId(itemid);
        Object assistUnitId = this.getUnitFormHandler().getAssistUnitId(itemid);
        unitIds.add(baseUnitId);
        if (saleUnitId != null) {
            unitIds.add(saleUnitId);
        }
        if (assistUnitId != null) {
            unitIds.add(assistUnitId);
        }
        return ItemUtil.loadUnitInfo(unitIds, (String)"id,name");
    }

    protected void addAssistattrAp() {
        Object itemid = this.getParamValue("itemid");
        DynamicObjectCollection attrList = this.getAssistAttr(itemid);
        if (attrList == null || attrList.isEmpty() || ((DynamicObject)attrList.get(0)).getString("attrentry.attr").equals("0") || ((DynamicObject)attrList.get(0)).getString("attrentry.attr.name") == null) {
            this.setDisVisible(new String[]{"panels"});
            this.getPageCache().put(PAGECACHE_ASSISTATTR_COUNT, "0");
        } else {
            this.setVisible(new String[]{"panels"});
            this.getPageCache().put(PAGECACHE_ASSISTATTR_COUNT, String.valueOf(attrList.size()));
            for (int i = 0; i < attrList.size(); ++i) {
                DynamicObjectCollection attrValues = ItemAttrUtil.getAttrValuesByItemId((Object)itemid, (Object)((DynamicObject)attrList.get(i)).getLong("attrentry.attr"));
                this.addFlexAp(100 + i, attrValues, "panels", ((DynamicObject)attrList.get(i)).getString("attrentry.attr"), ((DynamicObject)attrList.get(i)).getString("attrentry.attr.name"), "attrentity.attrvalue", "attrentity.attrvalue.name", "addbtn");
            }
        }
    }

    protected DynamicObjectCollection getAssistAttr(Object itemid) {
        return ItemAttrUtil.getAttrInfoByItemId((Object)itemid);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("addbtn") || key.startsWith("unitbtn")) {
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "unit": {
                e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                List unitIds = this.getUnitFormHandler().getUnitIdList((Object)this.getItemIdFromParams());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)unitIds));
            }
        }
    }

    private long getItemIdFromParams() {
        return Long.parseLong(this.getParameter("itemid").toString());
    }

    private long getUnitIdFromParams() {
        return Long.parseLong(this.getParameter("unitid").toString());
    }

    private Object getParamValue(Object value) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map customParams = fsp.getCustomParams();
        return customParams.get(value);
    }

    private void setLabelTitle(String name, String title) {
        ((Label)this.getControl(name)).setText(title);
    }

    private void addFlexAp(int index, DynamicObjectCollection childValues, String controlName, String titleLabelKey, String titleName, String childKey, String childName, String buttonKey) {
        String mainPanelKey = "panel&" + index;
        FlexPanelAp flexAp = this.buildPanel(mainPanelKey, "column");
        flexAp.getStyle().getMargin().setTop("17px");
        flexAp.getStyle().getMargin().setBottom("17.5px");
        String titleKeyPre = titleLabelKey + SPLIT + index;
        LabelAp title = this.buildLabel(titleKeyPre, titleName);
        flexAp.getItems().add(title);
        String childPanelKey = "childpanel&" + index;
        FlexPanelAp childflexAp = this.buildPanel(childPanelKey, "row");
        for (DynamicObject childValue : childValues) {
            String key = buttonKey + SPLIT + childValue.getString(childKey);
            String name = childValue.getString(childName);
            ButtonAp button = this.buildButton(key, name);
            childflexAp.getItems().add(button);
            this.getPageCache().put(key, String.valueOf(index));
        }
        flexAp.getItems().add(childflexAp);
        Container c = (Container)this.getView().getControl(controlName);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexAp.createControl());
        c.insertControls(-1, list);
    }

    private FlexPanelAp buildPanel(String panelKey, String direction) {
        FlexPanelAp childflexAp = new FlexPanelAp();
        childflexAp.setKey(panelKey);
        childflexAp.setDirection(direction);
        childflexAp.setAlignItems("center");
        childflexAp.setGrow(1);
        childflexAp.setJustifyContent("flex-start");
        childflexAp.setAlignItems("left");
        childflexAp.setShrink(1);
        childflexAp.setWidth(new LocaleString("100%"));
        childflexAp.setOverflow("hidden");
        Style childFlexstyle = new Style();
        Margin childMargin = new Margin();
        childFlexstyle.setMargin(childMargin);
        childflexAp.setStyle(childFlexstyle);
        return childflexAp;
    }

    private LabelAp buildLabel(String labelKey, String labelName) {
        LabelAp title = new LabelAp();
        title.setKey(labelKey);
        title.setName(new LocaleString(labelName));
        title.setFontSize(14);
        title.setForeColor("#333333");
        title.setTextAlign("left");
        Style labelstyle = new Style();
        Padding padding = new Padding();
        padding.setLeft("8px");
        labelstyle.setPadding(padding);
        title.setStyle(labelstyle);
        return title;
    }

    private ButtonAp buildButton(String buttonKey, String buttonName) {
        ButtonAp button = new ButtonAp();
        button.setKey(buttonKey);
        button.setName(new LocaleString(buttonName));
        button.setWidth(new LocaleString("80px"));
        button.setFontSize(11);
        button.setTextAlign("center");
        button.setForeColor("#666666");
        button.setRadius("100px");
        button.setHeight(new LocaleString("28px"));
        Style buttonstyle = new Style();
        Margin buttonmargin = new Margin();
        buttonmargin.setLeft("12px");
        buttonmargin.setTop("8px");
        buttonstyle.setMargin(buttonmargin);
        Padding buttonpadding = new Padding();
        buttonpadding.setLeft("12px");
        buttonpadding.setRight("12px");
        button.setStyle(buttonstyle);
        return button;
    }
}

