/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class ItemCombinationChooseMobPlugin
extends MdrFormMobPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String AMOUNT = "amount";
    private static final String ITEMINFO = "iteminfo";
    private static final String QTY = "qty";
    public static final String ADD = "add";
    public static final String REDUCE = "reduce";
    public static final String ADDTOSHOPPINGCART = "addtoshoppingcart";
    private String temp = "";
    private Map<String, Object> checkedMap = new HashMap<String, Object>();

    public void afterCreateNewData(EventObject e) {
        this.initItemCombList();
    }

    public void initialize() {
        this.temp = "mdr_itemlist_" + this.getView().getPageId();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ADD, REDUCE, ADDTOSHOPPINGCART});
    }

    private void initItemCombList() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        String fiedls = "name,totalamount,itemdetail.item,itemdetail.qty,itemdetail.unit";
        QFilter f = new QFilter("status", "=", (Object)"C");
        DynamicObject[] itemCombs = BusinessDataServiceHelper.load((String)"dpm_item_combination", (String)fiedls, (QFilter[])f.toArray());
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, itemCombs.length);
        for (int i = 0; i < itemCombs.length; ++i) {
            DynamicObjectCollection itemdetails = itemCombs[i].getDynamicObjectCollection("itemdetail");
            StringBuilder iteminfo = new StringBuilder();
            if (itemdetails != null) {
                this.getModel().setValue(SIZE, (Object)String.format(ResManager.loadKDString((String)"\uff08\u5171%s\u6b3e\uff09", (String)"ItemCombinationChooseMobPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), itemdetails.size()), i);
                for (DynamicObject itemdetail : itemdetails) {
                    DynamicObject item = itemdetail.getDynamicObject("item");
                    DynamicObject unit = itemdetail.getDynamicObject("unit");
                    BigDecimal qty = itemdetail.getBigDecimal(QTY);
                    if (item == null || qty == null || unit == null) continue;
                    iteminfo.append(item.getString(NAME)).append("\uff0c").append(qty.stripTrailingZeros().toPlainString()).append(unit.getString(NAME)).append(";\n");
                }
            }
            if (iteminfo.length() > 0) {
                this.getModel().setValue(ITEMINFO, (Object)iteminfo, i);
            }
            this.getModel().setValue(NAME, itemCombs[i].get(NAME), i);
            this.getModel().setValue(AMOUNT, (Object)("\uffe5" + itemCombs[i].getBigDecimal("totalamount").stripTrailingZeros().toPlainString()), i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        switch (key) {
            case "add": {
                this.add(index, QTY);
                break;
            }
            case "reduce": {
                this.reduce(index, QTY);
                break;
            }
            case "addtoshoppingcart": {
                this.getView().returnDataToParent(this.getCheckedMap());
                CacheUtil.remove((String)this.temp);
                this.getView().close();
            }
        }
    }

    private void add(int index, String qtyname) {
        int qty = (Integer)this.getModel().getValue(qtyname, index);
        this.getModel().setValue(qtyname, (Object)(qty + 1), index);
    }

    private void reduce(int index, String qtyname) {
        int qty = (Integer)this.getModel().getValue(qtyname, index);
        this.getModel().setValue(qtyname, (Object)(qty - 1), index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        Object oldValue = data.getOldValue();
        int index = this.getRowIndex(e);
        switch (propertyName = e.getProperty().getName()) {
            case "qty": {
                int qty = (Integer)this.getModel().getValue(QTY, index);
                if (qty < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0", (String)"ItemCombinationChooseMobPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(QTY, oldValue, index);
                }
                this.updateCheckedList(index);
                break;
            }
        }
    }

    private void updateCheckedList(int index) {
        DynamicObject row = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
        int qty = (Integer)this.getModel().getValue(QTY);
        this.checkedMap = this.getCheckedMap();
        this.checkedMap.put("combid", row.getPkValue());
        this.checkedMap.put(QTY, qty);
        this.setCheckedMap(this.checkedMap);
    }

    public Map<String, Object> getCheckedMap() {
        this.checkedMap = (Map)CacheUtil.get((String)this.temp, Map.class);
        if (this.checkedMap == null || this.checkedMap.isEmpty()) {
            this.checkedMap = new HashMap<String, Object>();
        }
        return this.checkedMap;
    }

    public void setCheckedMap(Map<String, Object> checkedMap) {
        CacheUtil.put((String)this.temp, checkedMap);
    }
}

