/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class ItemCombinationEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String OWNER = "owner";
    public static final String ITEM = "item";
    public static final String PRICEMODE = "pricemode";
    public static final String UNIT = "unit";
    public static final String ATTR = "attr";
    public static final String QTY = "qty";
    public static final String TOTALAMOUNT = "totalamount";
    public static final String PRICE = "price";
    public static final String AMOUNT = "amount";
    public static final String PROPORTION = "proportion";
    public static final String ITEMDETAIL = "itemdetail";
    public static final String ISSUBGROUP = "issubgroup";
    public static final String SUBGROUP = "subgroup";
    public static final String ISDEFAULT = "isdefault";
    public static final String INFOPANEL = "advconap";
    public static final String BAR_RESORT = "resort";
    public static final String BAR_AUDIT = "bar_audit";
    public static final String BAR_UNAUDIT = "bar_unaudit";
    public static final String BAR_UPITEM = "bar_upitem";
    public static final String BAR_DOWNITEM = "bar_downitem";
    public static final String UPITEM = "upitem";
    public static final String DOWNITEM = "downitem";
    public static final int FETCHING_PRICING = 0;
    public static final int FREE_PRICING = 1;
    public static final int PROPORTIONAL_PRICING = 2;
    protected volatile boolean triggerChangeEvent = false;
    private int batch = 0;
    private int loop = 5;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isFromImport()) {
            IPageCache pageCache;
            String ownerId;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
                this.getModel().setValue(OWNER, (Object)ownerId);
                return;
            }
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshEnable();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isonsell = dataEntity.getBoolean("isonsell");
        IFormView view = this.getView();
        this.setVisiable();
        if (isonsell) {
            view.setEnable(Boolean.valueOf(false), new String[]{BAR_UPITEM});
            view.setEnable(Boolean.valueOf(true), new String[]{BAR_DOWNITEM});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{BAR_UPITEM});
            view.setEnable(Boolean.valueOf(false), new String[]{BAR_DOWNITEM});
        }
        if (((Boolean)dataEntity.get(ISSUBGROUP)).booleanValue()) {
            this.setVisible(new String[]{SUBGROUP});
            this.setVisible(new String[]{ISDEFAULT});
            this.setMustInput(SUBGROUP, true);
            if (this.getModel().getDataEntity().getString("status").equals("A")) {
                this.setVisible(new String[]{BAR_RESORT});
            }
            this.sortEntryEntity();
            this.setColor();
        } else {
            this.setDisVisible(new String[]{SUBGROUP});
            this.setDisVisible(new String[]{ISDEFAULT});
            this.setDisVisible(new String[]{BAR_RESORT});
            this.setMustInput(SUBGROUP, false);
        }
        this.attrLock();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.triggerChangeEvent && !key.equals(ITEM)) {
            return;
        }
        this.triggerChangeEvent = true;
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "pricemode": {
                this.changePriceMode();
                break;
            }
            case "owner": {
                this.changeOwner();
                break;
            }
            case "item": {
                this.changeSubItem(index);
                break;
            }
            case "proportion": {
                this.changeSubProportion(e);
                break;
            }
            case "qty": {
                this.changeSubQty(e);
                break;
            }
            case "price": {
                this.changeSubPrice(e);
                break;
            }
            case "amount": {
                this.changeSubAmount(e);
                break;
            }
            case "totalamount": {
                this.changeTotalAmount();
                break;
            }
            case "issubgroup": {
                this.changeIsSubGroup(e);
                break;
            }
            case "isdefault": {
                this.changeIsDefault(e);
                break;
            }
            case "subgroup": {
                this.changeSubGroup(e);
            }
        }
        this.attrLock();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{OWNER, ITEM, UNIT, ATTR});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getOwnerIdsQFilter((String)"id"));
                break;
            }
            case "item": {
                Object ownerid = this.getOwnerF7PKValue();
                QFilter filter = null;
                if (ownerid == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053\uff01", (String)"ItemCombinationEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    filter = new QFilter("id", "=", (Object)0L);
                } else {
                    filter = ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerid, (IPageCache)this.getPageCache());
                    filter.and(new QFilter("isonsell", "=", (Object)"1"));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
            case "unit": {
                DynamicObject item4unit = (DynamicObject)this.getModel().getValue(ITEM, index);
                if (item4unit == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8be5\u884c\u5546\u54c1", (String)"ItemCombinationEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)this.getUnitFormHandler().getUnitIdList(item4unit.getPkValue())));
                break;
            }
            case "attr": {
                DynamicObject item4attr = (DynamicObject)this.getModel().getValue(ITEM, index);
                if (item4attr == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ItemCombinationEditPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)item4attr.getPkValue()));
            }
        }
    }

    private void changePriceMode() {
        IDataModel model = this.getModel();
        this.refreshEnable();
        DynamicObjectCollection entry = model.getDataEntity(true).getDynamicObjectCollection(ITEMDETAIL);
        model.setValue(TOTALAMOUNT, (Object)BigDecimal.ZERO);
        for (int i = 0; i < entry.size(); ++i) {
            this.setValue(PRICE, BigDecimal.ZERO, i);
            this.setValue(AMOUNT, BigDecimal.ZERO, i);
            this.setValue(PROPORTION, BigDecimal.ZERO, i);
        }
    }

    private void refreshEnable() {
        int type = Integer.parseInt(this.getModel().getValue(PRICEMODE).toString());
        IFormView view = this.getView();
        switch (type) {
            case 0: {
                view.setEnable(Boolean.valueOf(false), new String[]{TOTALAMOUNT});
                view.setEnable(Boolean.valueOf(false), -1, new String[]{PRICE, AMOUNT, PROPORTION});
                break;
            }
            case 1: {
                view.setEnable(Boolean.valueOf(false), new String[]{TOTALAMOUNT});
                view.setEnable(Boolean.valueOf(false), -1, new String[]{PROPORTION});
                view.setEnable(Boolean.valueOf(true), -1, new String[]{PRICE, AMOUNT});
                break;
            }
            case 2: {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{TOTALAMOUNT});
                view.setEnable(Boolean.valueOf(true), -1, new String[]{PROPORTION});
                view.setEnable(Boolean.valueOf(false), -1, new String[]{PRICE, AMOUNT});
            }
        }
    }

    private void changeOwner() {
        this.getModel().deleteEntryData(ITEMDETAIL);
        this.getModel().createNewEntryRow(ITEMDETAIL);
        this.getModel().setValue(TOTALAMOUNT, (Object)BigDecimal.ZERO);
    }

    private void changeItem(int index) {
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM, index);
        if (item != null) {
            Object itemId = item.getPkValue();
            this.getModel().setValue(UNIT, this.getUnitFormHandler().getSaleUnitId(itemId), index);
            boolean hasattr = item.getBoolean("hasattr");
            if (hasattr) {
                this.setEnable(index, new String[]{ATTR});
                this.getModel().setValue(ATTR, ItemAttrUtil.getDefaultAttrId((Object)itemId), index);
            } else {
                this.getModel().setValue(ATTR, null, index);
                this.setUnEnable(index, new String[]{ATTR});
            }
        } else {
            this.getModel().setValue(UNIT, null, index);
            this.getModel().setValue(ATTR, null, index);
        }
    }

    private void changeSubItem(int index) {
        if (((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
            int i;
            int count = this.getModel().getEntryRowCount(ITEMDETAIL);
            for (i = index + 1; i < count && this.getModel().getValue(SUBGROUP, index) != null && this.getModel().getValue(SUBGROUP, index).toString().length() > 0 && this.batch > 0; ++i) {
                if (this.batch <= 0) continue;
                this.getModel().setValue(SUBGROUP, this.getValue(SUBGROUP, index), i);
                this.decrementCount();
            }
            if (index == 0 || index > 0 && this.getModel().getValue(SUBGROUP, index) != this.getModel().getValue(SUBGROUP, index - 1)) {
                for (i = this.getModel().getEntryRowCount(ITEMDETAIL) - 1; i >= 0; --i) {
                    if (i == index || this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0 || Integer.parseInt(this.getModel().getValue(SUBGROUP, i).toString()) != Integer.parseInt(this.getModel().getValue(SUBGROUP, index).toString())) continue;
                    this.getModel().setValue(QTY, this.getModel().getValue(QTY, i), index);
                    this.getModel().setValue(PRICE, this.getModel().getValue(PRICE, i), index);
                    this.getModel().setValue(AMOUNT, this.getModel().getValue(AMOUNT, i), index);
                    this.getModel().setValue(PROPORTION, this.getModel().getValue(PROPORTION, i), index);
                    break;
                }
            } else {
                for (i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                    if (i == index || this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0 || Integer.parseInt(this.getModel().getValue(SUBGROUP, i).toString()) != Integer.parseInt(this.getModel().getValue(SUBGROUP, index).toString())) continue;
                    this.getModel().setValue(QTY, this.getModel().getValue(QTY, i), index);
                    this.getModel().setValue(PRICE, this.getModel().getValue(PRICE, i), index);
                    this.getModel().setValue(AMOUNT, this.getModel().getValue(AMOUNT, i), index);
                    this.getModel().setValue(PROPORTION, this.getModel().getValue(PROPORTION, i), index);
                    break;
                }
            }
        }
        this.changeItem(index);
    }

    private void changeSubProportion(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        if (((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
            BigDecimal oldvalue4pro = (BigDecimal)e.getChangeSet()[0].getOldValue();
            if (this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0) {
                this.subProjectCheck(index, oldvalue4pro, key);
            } else {
                this.changeProportion(index);
                this.autoUpdate(index);
            }
        } else {
            this.changeProportion(index);
        }
    }

    private void changeProportion(int index) {
        IDataModel model = this.getModel();
        BigDecimal totalamount = (BigDecimal)model.getValue(TOTALAMOUNT);
        BigDecimal proportion = (BigDecimal)model.getValue(PROPORTION, index);
        BigDecimal amount = totalamount.multiply(proportion).divide(new BigDecimal(100));
        BigDecimal qty = (BigDecimal)model.getValue(QTY, index);
        this.getModel().setValue(AMOUNT, (Object)amount, index);
        this.getModel().setValue(PRICE, (Object)amount.divide(qty, this.getCurrencyPricePrecision(), RoundingMode.HALF_UP), index);
    }

    private void changeSubPrice(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        BigDecimal oldvalue4price = (BigDecimal)e.getChangeSet()[0].getOldValue();
        BigDecimal bigDecimal = oldvalue4price = oldvalue4price == null ? BigDecimal.ZERO : oldvalue4price;
        if (((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
            if (this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0) {
                this.subProjectCheck(index, oldvalue4price, key);
            } else {
                this.changePrice(oldvalue4price, index);
                this.autoUpdate(index);
            }
        } else {
            this.changePrice(oldvalue4price, index);
        }
    }

    private void changePrice(BigDecimal beforevalue, int index) {
        IDataModel model = this.getModel();
        BigDecimal totalamount = (BigDecimal)model.getValue(TOTALAMOUNT);
        BigDecimal qty = (BigDecimal)model.getValue(QTY, index);
        BigDecimal price = (BigDecimal)model.getValue(PRICE, index);
        BigDecimal nowamount = price.multiply(qty).setScale(this.getCurrencyAmountPrecision(), RoundingMode.HALF_UP);
        BigDecimal beforeamount = beforevalue.multiply(qty);
        model.setValue(AMOUNT, (Object)nowamount, index);
        this.getModel().setValue(TOTALAMOUNT, (Object)totalamount.subtract(beforeamount).add(nowamount));
        this.getView().updateView();
    }

    private void changeSubAmount(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        BigDecimal oldvalue4amount = (BigDecimal)e.getChangeSet()[0].getOldValue();
        BigDecimal bigDecimal = oldvalue4amount = oldvalue4amount == null ? BigDecimal.ZERO : oldvalue4amount;
        if (((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
            if (this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0) {
                this.subProjectCheck(index, oldvalue4amount, key);
            } else {
                this.changeAmount(oldvalue4amount, index);
                this.autoUpdate(index);
            }
        } else {
            this.changeAmount(oldvalue4amount, index);
        }
    }

    private void changeAmount(BigDecimal beforevalue, int index) {
        IDataModel model = this.getModel();
        BigDecimal totalamount = (BigDecimal)model.getValue(TOTALAMOUNT);
        BigDecimal amount = (BigDecimal)model.getValue(AMOUNT, index);
        model.setValue(TOTALAMOUNT, (Object)totalamount.add(amount).subtract(beforevalue));
        BigDecimal qty = (BigDecimal)model.getValue(QTY, index);
        model.setValue(PRICE, (Object)amount.divide(qty, this.getCurrencyPricePrecision(), RoundingMode.HALF_UP), index);
    }

    private void changeTotalAmount() {
        BigDecimal totalamount = (BigDecimal)this.getModel().getValue(TOTALAMOUNT);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ITEMDETAIL);
        for (DynamicObject entry : entrys) {
            BigDecimal proportion = entry.getBigDecimal(PROPORTION);
            BigDecimal qty = entry.getBigDecimal(QTY);
            BigDecimal amount = totalamount.multiply(proportion).divide(new BigDecimal(100));
            entry.set(AMOUNT, (Object)amount);
            entry.set(PRICE, (Object)amount.divide(qty, this.getCurrencyPricePrecision(), RoundingMode.HALF_UP));
        }
        this.getView().updateView(ITEMDETAIL);
    }

    private void changeIsSubGroup(PropertyChangedArgs e) {
        boolean btn = (Boolean)e.getChangeSet()[0].getNewValue();
        if (btn) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SUBGROUP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ISDEFAULT});
            String status = this.getModel().getDataEntity().getString("status");
            if ("A".equals(status)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_RESORT});
            }
            this.setMustInput(SUBGROUP, true);
            for (int i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                this.setValue(SUBGROUP, "-1", i);
                this.setValue(SUBGROUP, null, i);
            }
        } else {
            for (int i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                this.getModel().setValue(SUBGROUP, (Object)0, i);
                this.getModel().setValue(ISDEFAULT, (Object)false, i);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_RESORT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBGROUP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ISDEFAULT});
            this.setMustInput(SUBGROUP, false);
        }
    }

    private void changeIsDefault(PropertyChangedArgs e) {
        boolean oldvalue4isdefault;
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        boolean bl = oldvalue4isdefault = e.getChangeSet()[0].getOldValue() != null;
        if (this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0) {
            this.subProjectCheck(index, oldvalue4isdefault, key);
        } else {
            boolean isdef = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isdef) {
                int counts = this.getModel().getEntryRowCount(ITEMDETAIL);
                int subnum = (Integer)this.getModel().getValue(SUBGROUP, index);
                for (int i = 0; i < counts; ++i) {
                    if (this.getModel().getValue(SUBGROUP, index).toString().length() <= 0 || this.getModel().getValue(SUBGROUP, i) == null || (Integer)this.getModel().getValue(SUBGROUP, i) != subnum || i == index || !((Boolean)this.getModel().getValue(ISDEFAULT, i)).booleanValue()) continue;
                    this.getModel().setValue(ISDEFAULT, (Object)false, i);
                }
            }
        }
    }

    private void changeSubGroup(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue().toString().length() <= 0) {
            this.getModel().setValue(ISDEFAULT, (Object)false, index);
            this.getModel().setValue(QTY, (Object)1, index);
            this.getModel().setValue(PRICE, (Object)0, index);
            this.getModel().setValue(AMOUNT, (Object)0, index);
            this.getModel().setValue(PROPORTION, (Object)0, index);
        } else if (e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue().toString().length() > 0) {
            int i;
            boolean def;
            int newvalue = (Integer)e.getChangeSet()[0].getNewValue();
            BigDecimal changeAmount = (BigDecimal)this.getModel().getValue(AMOUNT, index);
            Boolean isNewGroup = true;
            Boolean oldGroupSurvive = false;
            for (int i2 = 0; i2 < this.getModel().getEntryRowCount(ITEMDETAIL); ++i2) {
                if (i2 == index || this.getModel().getValue(SUBGROUP, i2) == null || this.getModel().getValue(SUBGROUP, i2).toString().length() <= 0 || (Integer)this.getModel().getValue(SUBGROUP, i2) != newvalue) continue;
                isNewGroup = Boolean.FALSE;
                this.getModel().setValue(QTY, this.getModel().getValue(QTY, i2), index);
                this.getModel().setValue(PRICE, this.getModel().getValue(PRICE, i2), index);
                this.getModel().setValue(AMOUNT, this.getModel().getValue(AMOUNT, i2), index);
                this.getModel().setValue(PROPORTION, this.getModel().getValue(PROPORTION, i2), index);
                break;
            }
            if (def = ((Boolean)this.getModel().getValue(ISDEFAULT, index)).booleanValue()) {
                for (i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                    if (i == index || this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || (Integer)this.getModel().getValue(SUBGROUP, i) != newvalue || !((Boolean)this.getModel().getValue(ISDEFAULT, i)).booleanValue()) continue;
                    this.getModel().setValue(ISDEFAULT, (Object)false, index);
                    break;
                }
            }
            if (String.valueOf(e.getChangeSet()[0].getOldValue()).compareTo("null") == 0 || e.getChangeSet()[0].getOldValue().toString().length() <= 0) {
                if (isNewGroup.booleanValue()) {
                    this.getModel().setValue(TOTALAMOUNT, (Object)((BigDecimal)this.getModel().getValue(TOTALAMOUNT)).add(changeAmount));
                }
            } else {
                for (i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                    if (i == index || this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || ((Integer)this.getModel().getValue(SUBGROUP, i)).intValue() != ((Integer)e.getChangeSet()[0].getOldValue()).intValue()) continue;
                    oldGroupSurvive = Boolean.TRUE;
                    break;
                }
                if (!isNewGroup.booleanValue() && !oldGroupSurvive.booleanValue()) {
                    this.getModel().setValue(TOTALAMOUNT, (Object)((BigDecimal)this.getModel().getValue(TOTALAMOUNT)).subtract(changeAmount));
                } else if (isNewGroup.booleanValue() && oldGroupSurvive.booleanValue()) {
                    this.getModel().setValue(TOTALAMOUNT, (Object)((BigDecimal)this.getModel().getValue(TOTALAMOUNT)).add(changeAmount));
                }
            }
        }
    }

    private void changeSubQty(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        int type = Integer.parseInt(this.getModel().getValue(PRICEMODE).toString());
        BigDecimal oldvalue4qty = (BigDecimal)e.getChangeSet()[0].getOldValue();
        BigDecimal bigDecimal = oldvalue4qty = oldvalue4qty == null ? BigDecimal.ZERO : oldvalue4qty;
        if (((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
            if (this.getModel().getValue(SUBGROUP, index) == null || this.getModel().getValue(SUBGROUP, index).toString().length() <= 0) {
                this.subProjectCheck(index, oldvalue4qty, key);
            } else {
                int minprecision = this.queryMinPrecision(index);
                BigDecimal value = ((BigDecimal)e.getChangeSet()[0].getNewValue()).setScale(minprecision, 1);
                if (value.compareTo(ZERO) == 0) {
                    value = BigDecimal.valueOf(1L, minprecision);
                }
                this.setValue(QTY, value, index);
                this.changeQty(oldvalue4qty, type, index);
                this.autoUpdate(index);
            }
        } else {
            this.changeQty(oldvalue4qty, type, index);
        }
    }

    private void changeQty(BigDecimal beforevalue, int type, int index) {
        IDataModel model = this.getModel();
        BigDecimal qty = (BigDecimal)model.getValue(QTY, index);
        BigDecimal amount = (BigDecimal)model.getValue(AMOUNT, index);
        if (1 == type) {
            BigDecimal price = (BigDecimal)model.getValue(PRICE, index);
            BigDecimal amountdiff = qty.subtract(beforevalue).multiply(price);
            model.setValue(AMOUNT, (Object)amount.add(amountdiff), index);
            BigDecimal totalamount = (BigDecimal)model.getValue(TOTALAMOUNT);
            model.setValue(TOTALAMOUNT, (Object)totalamount.add(amountdiff));
        }
        if (2 == type) {
            model.setValue(PRICE, (Object)amount.divide(qty, this.getCurrencyPricePrecision(), RoundingMode.HALF_UP), index);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int index = e.getInsertRow();
        if (index != -1) {
            this.incrementCount();
        }
        int type = Integer.parseInt(this.getModel().getValue(PRICEMODE).toString());
        switch (type) {
            case 0: {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{PROPORTION, PRICE, AMOUNT});
                break;
            }
            case 1: {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{PRICE, AMOUNT});
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{PROPORTION});
                break;
            }
            case 2: {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{PROPORTION});
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{PRICE, AMOUNT});
            }
        }
    }

    private int getCurrencyPricePrecision() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        return currency.getInt("priceprecision");
    }

    private int getCurrencyAmountPrecision() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        return currency.getInt("amtprecision");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.setVisiable();
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        IFormView view = this.getView();
        switch (key) {
            case "audit": 
            case "unaudit": 
            case "downitem": {
                if (!e.getOperationResult().isSuccess()) break;
                view.setEnable(Boolean.valueOf(true), new String[]{BAR_UPITEM});
                view.setEnable(Boolean.valueOf(false), new String[]{BAR_DOWNITEM});
                break;
            }
            case "upitem": {
                view.setEnable(Boolean.valueOf(false), new String[]{BAR_UPITEM});
                view.setEnable(Boolean.valueOf(true), new String[]{BAR_DOWNITEM});
                break;
            }
            case "resort": {
                this.sortEntryEntity();
                this.setColor();
            }
        }
    }

    private void setVisiable() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        IFormView view = this.getView();
        String status = dataEntity.getString("status");
        if ("A".equals(status)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"newentry"});
            view.setVisible(Boolean.valueOf(true), new String[]{"deleteentry"});
            if (dataEntity.getBoolean(ISSUBGROUP)) {
                view.setVisible(Boolean.valueOf(true), new String[]{BAR_RESORT});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"newentry"});
            view.setVisible(Boolean.valueOf(false), new String[]{"deleteentry"});
            view.setVisible(Boolean.valueOf(false), new String[]{BAR_RESORT});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                DynamicObjectCollection itemdetail;
                this.attrLock();
                this.sortEntryEntity();
                this.setColor();
                if (key.equals("submit") && ((Boolean)this.getModel().getValue(ISSUBGROUP)).booleanValue()) {
                    for (int i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
                        if (this.getModel().getValue(SUBGROUP, i) != null && this.getModel().getValue(SUBGROUP, i).toString().length() > 0) continue;
                        this.triggerChangeEvent = false;
                        this.subProjectCheck(i, null, SUBGROUP);
                        e.setCancel(true);
                    }
                }
                if ((itemdetail = this.getModel().getEntryEntity(ITEMDETAIL)) == null) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d\u81f3\u5c11\u5305\u542b\u4e00\u884c\u5546\u54c1\u4fe1\u606f\u3002", (String)"ItemInfoEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set itemdetailSet = itemdetail.stream().filter(p -> p.getLong("item_id") > 0L).collect(Collectors.toSet());
                if (itemdetailSet == null || itemdetailSet.size() == 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d\u81f3\u5c11\u5305\u542b\u4e00\u884c\u5546\u54c1\u4fe1\u606f\u3002", (String)"ItemInfoEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                Set filterRow = itemdetail.stream().filter(p -> p.getLong("unit_id") > 0L && p.getLong(QTY) > 0L).collect(Collectors.toSet());
                if (filterRow == null || filterRow.size() < itemdetailSet.size()) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d\u5546\u54c1\u3001\u8ba1\u91cf\u5355\u4f4d\u3001\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemInfoEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                HashSet<Integer> set = new HashSet<Integer>();
                for (int i = 0; i < itemdetail.size(); ++i) {
                    if (((DynamicObject)itemdetail.get(i)).get(ITEM) == null || !((DynamicObject)((DynamicObject)itemdetail.get(i)).get(ITEM)).getBoolean("hasattr") || ((DynamicObject)itemdetail.get(i)).get(ATTR) != null) continue;
                    set.add(i + 1);
                }
                if (set == null || set.size() <= 0) break;
                StringBuilder numSet = new StringBuilder();
                numSet.append(" ");
                for (Integer it : set) {
                    numSet.append(it).append(",");
                }
                numSet.deleteCharAt(numSet.length() - 1).append(" ");
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7684\u5546\u54c1\u7684\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItemCombinationEditPlugin_8", (String)"drp-dbd-formplugin", (Object[])new Object[0]), numSet));
            }
        }
    }

    private void subProjectCheck(int row, Object value, String key) {
        this.getModel().setValue(key, value, row);
        String errMessage = ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5b50\u4ef6\u7ec4\u201d\u3002", (String)"ItemCombinationEditPlugin_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(String.format(errMessage, new Object[0]));
    }

    private void attrLock() {
        for (int i = 0; i < this.getModel().getEntryRowCount(ITEMDETAIL); ++i) {
            DynamicObject itemInfo = (DynamicObject)this.getModel().getValue(ITEM, i);
            if (itemInfo == null || itemInfo.getBoolean("hasattr")) continue;
            this.setUnEnable(i, new String[]{ATTR});
        }
    }

    private int queryMinPrecision(int index) {
        int min = 102;
        int count = this.getModel().getEntryRowCount(ITEMDETAIL);
        int subgroup = (Integer)this.getModel().getValue(SUBGROUP, index);
        for (int i = 0; i < count; ++i) {
            if (this.getModel().getValue(UNIT, i) == null) continue;
            int precision = (Integer)((DynamicObject)this.getModel().getValue(UNIT, i)).get("precision");
            if (this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || (Integer)this.getModel().getValue(SUBGROUP, i) != subgroup || min <= precision) continue;
            min = precision;
        }
        return min;
    }

    private void autoUpdate(int row) {
        int group = (Integer)this.getModel().getValue(SUBGROUP, row);
        int count = this.getModel().getEntryRowCount(ITEMDETAIL);
        for (int i = 0; i < count; ++i) {
            if (i == row || this.getModel().getValue(SUBGROUP, i) == null || this.getModel().getValue(SUBGROUP, i).toString().length() <= 0 || (Integer)this.getModel().getValue(SUBGROUP, i) != group) continue;
            this.getModel().setValue(QTY, this.getModel().getValue(QTY, row), i);
            this.getModel().setValue(PRICE, this.getModel().getValue(PRICE, row), i);
            this.getModel().setValue(AMOUNT, this.getModel().getValue(AMOUNT, row), i);
            this.getModel().setValue(PROPORTION, this.getModel().getValue(PROPORTION, row), i);
        }
    }

    private void sortEntryEntity() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection(ITEMDETAIL);
        entryentitys.sort(Comparator.comparing(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)SUBGROUP)));
        this.getView().updateView(ITEMDETAIL);
    }

    private void setColor() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection(ITEMDETAIL);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int flag = 1;
        String preColor = "white";
        for (int i = 0; i < entryentitys.size(); ++i) {
            if (i > 0 && ((DynamicObject)entryentitys.get(i)).get(SUBGROUP) != ((DynamicObject)entryentitys.get(i - 1)).get(SUBGROUP)) {
                if ((flag = -flag) < 0) {
                    ClientActions.createRowStyleBuilder().setRows(new int[]{i}).setBackColor("#e5e5e5").buildStyle().build().invokeControlMethod(proxy, ITEMDETAIL);
                    preColor = "#e5e5e5";
                    continue;
                }
                ClientActions.createRowStyleBuilder().setRows(new int[]{i}).setBackColor("white").buildStyle().build().invokeControlMethod(proxy, ITEMDETAIL);
                preColor = "white";
                continue;
            }
            ClientActions.createRowStyleBuilder().setRows(new int[]{i}).setBackColor(preColor).buildStyle().build().invokeControlMethod(proxy, ITEMDETAIL);
        }
    }

    public synchronized void incrementCount() {
        ++this.batch;
    }

    public synchronized void decrementCount() {
        --this.batch;
    }

    public synchronized void blankchange() {
        --this.loop;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (this.loop > 0) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(ITEM);
            if (basedataEdit.getModel().getValue(ITEM) == null) {
                basedataEdit.setItemByNumber(null);
            }
            this.blankchange();
        }
    }
}

