/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.formplugin.MdrTreeListPlugin;

public class ItemF7List4OrderPlugin
extends MdrTreeListPlugin {
    protected static final String COMBINATION_BILLLISTAP = "combinationbilllistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"promotionvectorap", "promotionlable", "collectionlable", "collectionvectorap", "combinationlable", "combinationvectorap", "buttonap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showBillstap(false);
        String fStr = (String)this.getView().getFormShowParameter().getCustomParam("combfilter");
        if (fStr == null) {
            return;
        }
        QFilter f = QFilter.fromSerializedString((String)fStr);
        this.setListFilter(COMBINATION_BILLLISTAP, f);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "combinationlable": 
            case "combinationvectorap": {
                this.getPageCache().put("listType", "combination");
                this.billstapInit();
                this.clearSelection();
                break;
            }
            case "promotionvectorap": 
            case "promotionlable": {
                this.getPageCache().put("listType", "promotion");
                this.billstapInit();
                this.clearSelection();
                break;
            }
            case "collectionlable": 
            case "collectionvectorap": {
                this.getPageCache().put("listType", "collection");
                this.billstapInit();
                this.clearSelection();
                break;
            }
            case "buttonap": {
                this.returnData();
                break;
            }
        }
    }

    protected final void clearSelection() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList = (BillList)this.getControl(COMBINATION_BILLLISTAP);
        billList.clearSelection();
    }

    private void billstapInit() {
        String listType = this.getPageCache().get("listType");
        if (listType == null) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            return;
        }
        switch (listType) {
            case "combination": {
                this.getTreeListView().focusRootNode();
                this.showBillstap(true);
                break;
            }
            case "promotion": {
                this.getTreeListView().focusRootNode();
                QFilter f = new QFilter("ispromotional", "in", (Object)"1");
                this.setListFilter("billlistap", f);
                this.showBillstap(false);
                break;
            }
            case "collection": {
                this.getTreeListView().focusRootNode();
                QFilter f = new QFilter("id", "in", (Object)ItemUtil.getCollectionItems());
                this.setListFilter("billlistap", f);
                this.showBillstap(false);
                break;
            }
            case "classtreeNode": {
                this.showBillstap(false);
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                billList.clearSelection();
                break;
            }
        }
    }

    private void returnData() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        boolean iscombination = "1".equals(this.getPageCache().get("iscombination"));
        data.put("iscombination", iscombination);
        if (!iscombination) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            data.put("data", (Boolean)selectedRows);
        } else {
            BillList billList = (BillList)this.getControl(COMBINATION_BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            data.put("data", (Boolean)selectedRows);
        }
        this.getView().setReturnData(data);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getPageCache().put("listType", "classtreeNode");
        this.showBillstap(false);
        super.treeNodeClick(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        Object formatValue = e.getFormatValue();
        Object source = e.getSource();
        if (source instanceof ListOperationColumnDesc) {
            Set<Object> collectionItems = this.getCollectionCache();
            DynamicObject rowData = e.getRowData();
            boolean isCollection = collectionItems.contains(rowData.getPkValue().toString());
            List items = (List)formatValue;
            for (OperationColItem item : items) {
                if (item.getOperationKey().equals("addcollection") && isCollection) {
                    item.setVisible(false);
                }
                if (!item.getOperationKey().equals("deletecollection") || isCollection) continue;
                item.setVisible(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "deletecollection": 
            case "addcollection": {
                this.refreshCollectionCache();
                this.billstapInit();
                break;
            }
        }
    }

    private void refreshCollectionCache() {
        Set collectionItems = ItemUtil.getCollectionItems();
        this.getPageCache().put("collectionItems", SerializationUtils.toJsonString((Object)collectionItems));
    }

    private Set<Object> getCollectionCache() {
        String collectionItemsStr = this.getPageCache().get("collectionItems");
        Set collectionItems = null;
        if (collectionItemsStr == null) {
            collectionItems = ItemUtil.getCollectionItems();
            this.getPageCache().put("collectionItems", SerializationUtils.toJsonString((Object)collectionItems));
        } else {
            collectionItems = (Set)SerializationUtils.fromJsonString((String)collectionItemsStr, Set.class);
        }
        return collectionItems;
    }

    private void showBillstap(boolean iscombination) {
        this.getPageCache().put("iscombination", iscombination ? "1" : "0");
        this.getPageCache().put("iscollection", "0");
        if (iscombination) {
            this.setVisible(new String[]{COMBINATION_BILLLISTAP});
            this.setDisVisible(new String[]{"billlistap"});
        } else {
            this.setVisible(new String[]{"billlistap"});
            this.setDisVisible(new String[]{COMBINATION_BILLLISTAP});
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        QFilter f = QFilter.match((String)searchText, (String[])new String[]{"name,number"});
        this.setListFilter("billlistap", f);
        String fStr = (String)this.getView().getFormShowParameter().getCustomParam("combfilter");
        if (fStr == null) {
            return;
        }
        QFilter combf = QFilter.fromSerializedString((String)fStr);
        this.setListFilter(COMBINATION_BILLLISTAP, combf.and(f));
    }

    private void setListFilter(String billlistid, QFilter f) {
        BillList billList = (BillList)this.getControl(billlistid);
        billList.setFilter(f);
        billList.refresh();
    }
}

