/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Html;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CodeRuleUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class ItemInfoEditPlugin
extends MdrBasePlugin
implements IBillWebApiPlugin,
BeforeF7SelectListener {
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String OWNER = "owner";
    public static final String ASSISTUNIT = "assistunit";
    public static final String HASATTR = "hasattr";
    public static final String MAXATTR = "maxattr";
    public static final String ATTRINIT = "attrinit";
    public static final String NEW_ATTRENTRY = "newattrentry";
    public static final String MOVE_ATTRENTRY_UP = "moveattrentryup";
    public static final String MOVE_ATTRENTRY_DOWN = "moveattrentrydown";
    public static final String DELET_ATTRENTRY = "deleteattrentry";
    public static final String NEW_ATTRVALUEENTRY = "newattrvalueentry";
    public static final String DELETE_ATTRVALUEENTRY = "deleteattrvalueentry";
    public static final String ATTRPANELAP = "attrpanelap";
    public static final String ATTRENTRY = "attrentry";
    public static final String ATTR = "attr";
    public static final String ATTRVALUEENTRY = "attrvalueentry";
    public static final String ATTRVALUE = "attrvalue";
    public static final String ATTRNAME = "attrname";
    public static final String ATTRNUMBER = "attrnumber";
    public static final String PRE_ATTR = "attrvalue";
    public static final String OP_UPITEM = "upitem";
    public static final String OP_DOWNITEM = "downitem";
    public static final String ISONSELL = "isonsell";
    public static final String SELLTIME = "selltime";
    public static final String NEWSELLTIME = "newselltime";
    public static final String ITEM_MODEL = "itemmodel";
    public static final String SALE_UNIT = "saleunit";
    public static final String BASE_UNIT = "baseunit";
    public static final String MODELNUM = "modelnum";
    public static final String GROSSWEIGHT = "grossweight";
    public static final String NETWEIGHT = "netweight";
    public static final String LENGTH = "length";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String VOLUME = "volume";
    public static final String VOLUMUNIT = "volumnunit";
    public static final String WEIGHTUNIT = "weightunit";
    public static final String LENGTHUNIT = "lengthunit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{OWNER, ASSISTUNIT, SALE_UNIT, "material"});
        int maxAttr = this.getMaxattr();
        for (int i = 1; i <= maxAttr; ++i) {
            String attrKey = "attrvalue" + i;
            this.addF7Listener(this, new String[]{attrKey});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isFromImport()) {
            this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
            this.SetOwnerFromCache(null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String description = (String)this.getModel().getValue("description_tag");
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"htmlap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"richtexteditorap"});
            Html htmlap = (Html)this.getControl("htmlap");
            htmlap.setConent(description);
        } else {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            if (StringUtils.isEmpty((String)richTextEditor.getText()) && StringUtils.isNotEmpty((String)description)) {
                richTextEditor.setText(description);
            }
        }
        this.attrEntryInit();
        if (!((Boolean)this.getValue(HASATTR)).booleanValue()) {
            this.setDisVisible(new String[]{ATTRPANELAP});
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject material;
        super.afterLoadData(e);
        if (((Boolean)this.getValue(HASATTR)).booleanValue()) {
            this.loadAttrInfo();
            this.getModel().setDataChanged(false);
        }
        if (this.isRefrenced()) {
            this.lockAttrAp();
        }
        this.setValue(BASE_UNIT, (material = QueryServiceHelper.queryOne((String)"bd_material", (String)"id,baseunit,modelnum", (QFilter[])new QFilter("id", "=", this.getF7PKValue("material")).toArray())) == null ? null : material.get(BASE_UNIT));
        this.getModel().setDataChanged(false);
    }

    private void loadAttrInfo() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("item", "=", pkValue);
        DynamicObjectCollection attrs = QueryServiceHelper.query((String)"mdr_item_attrvalue", (String)"id,name,easnumber,number,attrseq,attrentity.seq,attrentity.attrvalue", (QFilter[])qFilter.toArray(), (String)"attrseq,attrentity.seq");
        ArrayList<Map<String, Object>> attrEntryList = new ArrayList<Map<String, Object>>();
        boolean isRefrenced = this.isRefrenced();
        for (DynamicObject attr : attrs) {
            ArrayList<Object> list;
            Object attrId = attr.get("id");
            int size = attrEntryList.size();
            Map<String, Object> attrEntryMap = null;
            if (size > 0) {
                attrEntryMap = (Map)attrEntryList.get(size - 1);
            }
            if (attrEntryMap == null || !attrId.equals(attrEntryMap.get("id"))) {
                attrEntryMap = new HashMap();
                attrEntryMap.put("id", attrId);
                attrEntryMap.put(NAME, attr.get(NAME));
                attrEntryMap.put(NUMBER, attr.get(NUMBER));
                attrEntryMap.put("easnumber", attr.get("easnumber"));
                attrEntryList.add(attrEntryMap);
            }
            if ((list = (ArrayList<Object>)attrEntryMap.get("list")) == null) {
                list = new ArrayList<Object>();
            }
            list.add(attr.get("attrentity.attrvalue"));
            attrEntryMap.put("list", list);
        }
        int size = attrEntryList.size();
        this.getModel().deleteEntryData(ATTRVALUEENTRY);
        if (size > 0) {
            this.getModel().batchCreateNewEntryRow(ATTRVALUEENTRY, size);
            for (int i = 0; i < size; ++i) {
                Map attrEntry = (Map)attrEntryList.get(i);
                this.setValue("attrvalue", attrEntry.get("id"), i);
                this.setValue(ATTRNAME, attrEntry.get(NAME), i);
                this.setValue(ATTRNUMBER, attrEntry.get(NUMBER), i);
                this.setValue("easnumber", attrEntry.get("easnumber"), i);
                List list = (List)attrEntry.get("list");
                if (list == null) continue;
                for (int j = 0; j < list.size(); ++j) {
                    this.setValue("attrvalue" + (j + 1), list.get(j), i);
                    if (!isRefrenced) continue;
                    this.setUnEnable(i, new String[]{"attrvalue" + (j + 1)});
                }
            }
        }
    }

    private void lockAttrAp() {
        this.setDisVisible(new String[]{"attrentryop", NEW_ATTRENTRY, MOVE_ATTRENTRY_UP, MOVE_ATTRENTRY_DOWN, DELET_ATTRENTRY, ATTRINIT});
        this.setUnEnable(new String[]{HASATTR, "attrentryop", ATTRENTRY});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = this.getOpKey(e)) {
            case "save": 
            case "upitem": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                this.getModel().setValue("description_tag", (Object)text);
                break;
            }
            case "newattrentry": {
                if (this.isRefrenced()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u8f85\u52a9\u5c5e\u6027\uff0c\u53ea\u80fd\u65b0\u589e\u8f85\u52a9\u5c5e\u6027\u503c\uff01", (String)"ItemInfoEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
                int maxAttr = this.getMaxattr();
                if (attrs == null || attrs.size() <= maxAttr) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01\u5982\u9700\u8d85\u8fc7\u6700\u5927\u6570\u76ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"ItemInfoEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), maxAttr));
                e.setCancel(true);
                break;
            }
            case "moveattrentryup": 
            case "moveattrentrydown": 
            case "deleteattrentry": {
                if (!this.isRefrenced()) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u8f85\u52a9\u5c5e\u6027\uff0c\u53ea\u80fd\u65b0\u589e\u8f85\u52a9\u5c5e\u6027\u503c\uff01", (String)"ItemInfoEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            }
            case "deleteattrvalueentry": {
                int[] selectRows;
                if (!this.isRefrenced()) break;
                EntryGrid attrEntry = (EntryGrid)this.getControl(ATTRVALUEENTRY);
                for (int i : selectRows = attrEntry.getSelectRows()) {
                    Object attrValue = this.getValue("attrvalue", i);
                    if (attrValue == null) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5546\u54c1\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u5df2\u6709\u8f85\u52a9\u5c5e\u6027\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"ItemInfoEditPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "newattrvalueentry": {
                this.attrCheck();
                break;
            }
            case "attrinit": {
                this.attrCheck();
                this.attrInit();
                break;
            }
        }
    }

    private void attrCheck() {
        DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
        if (attrs == null || attrs.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8f85\u52a9\u5c5e\u6027\u518d\u6dfb\u52a0\u8f85\u52a9\u5c5e\u6027\u503c\uff01", (String)"ItemInfoEditPlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < attrs.size(); ++i) {
            DynamicObject attrObj = ((DynamicObject)attrs.get(i)).getDynamicObject(ATTR);
            if (attrObj != null) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6dfb\u52a0\u8f85\u52a9\u5c5e\u6027\u518d\u6dfb\u52a0\u8f85\u52a9\u5c5e\u6027\u503c\uff01", (String)"ItemInfoEditPlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]), i + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void attrInit() {
        ArrayList<Object> allAttrList = new ArrayList<Object>();
        DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
        ArrayList attrValueList = new ArrayList();
        if (attrs != null) {
            ArrayList<Object> attrIds = new ArrayList<Object>();
            for (DynamicObject attr : attrs) {
                DynamicObject data = attr.getDynamicObject(ATTR);
                attrIds.add(data.get("id"));
            }
            QFilter qFilter = new QFilter("group", "in", attrIds);
            DynamicObjectCollection attrValues = QueryServiceHelper.query((String)"mdr_assist_value", (String)"id,name,group", (QFilter[])qFilter.toArray(), (String)"group");
            for (Object e : attrIds) {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (DynamicObject attrValue : attrValues) {
                    if (!e.equals(attrValue.get("group"))) continue;
                    list.add(attrValue);
                }
                attrValueList.add(list);
            }
            for (List list : attrValueList) {
                int size = allAttrList.size();
                if (size == 0) {
                    if (list.size() == 0) {
                        ArrayList attrDyList = new ArrayList();
                        attrDyList.add(null);
                        allAttrList.add(attrDyList);
                        continue;
                    }
                    for (DynamicObject attrDy : list) {
                        ArrayList<DynamicObject> attrDyList = new ArrayList<DynamicObject>();
                        attrDyList.add(attrDy);
                        allAttrList.add(attrDyList);
                    }
                    continue;
                }
                ArrayList<Object> newAllAttrList = new ArrayList<Object>();
                for (int i = 0; i < size; ++i) {
                    if (list.size() == 0) {
                        ArrayList attrList = new ArrayList((Collection)allAttrList.get(i));
                        attrList.add(null);
                        newAllAttrList.add(attrList);
                        continue;
                    }
                    for (DynamicObject attrDy : list) {
                        ArrayList<DynamicObject> attrList = new ArrayList<DynamicObject>((Collection)allAttrList.get(i));
                        attrList.add(attrDy);
                        newAllAttrList.add(attrList);
                    }
                }
                allAttrList = newAllAttrList;
            }
            int size = allAttrList.size();
            if (size > 0) {
                void var8_13;
                this.getModel().deleteEntryData(ATTRVALUEENTRY);
                this.getModel().batchCreateNewEntryRow(ATTRVALUEENTRY, size);
                boolean bl = false;
                while (var8_13 < size) {
                    List attrList = (List)allAttrList.get((int)var8_13);
                    for (int j = 1; j <= attrList.size(); ++j) {
                        Object attrId = null;
                        DynamicObject attr = (DynamicObject)attrList.get(j - 1);
                        if (attr != null) {
                            attrId = ((DynamicObject)attrList.get(j - 1)).get("id");
                        }
                        this.setValue("attrvalue" + j, attrId, (int)var8_13);
                    }
                    ++var8_13;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "material": {
                DynamicObject material = this.getF7Value("material");
                this.setValue(NAME, material == null ? null : material.get(NAME));
                boolean isCodeRuleExist = CodeRuleUtil.isExist((String)"mdr_item_info");
                if (!isCodeRuleExist) {
                    this.setValue(NUMBER, material == null ? null : material.get(NUMBER));
                }
                this.setValue(MODELNUM, material == null ? null : material.get(MODELNUM));
                this.setValue(SALE_UNIT, material == null ? null : material.get(BASE_UNIT));
                this.setValue(BASE_UNIT, material == null ? null : material.get(BASE_UNIT));
                this.setValue(ASSISTUNIT, null);
                this.setValue(GROSSWEIGHT, material == null ? null : material.get(GROSSWEIGHT));
                this.setValue(NETWEIGHT, material == null ? null : material.get(NETWEIGHT));
                this.setValue(LENGTH, material == null ? null : material.get(LENGTH));
                this.setValue(WIDTH, material == null ? null : material.get(WIDTH));
                this.setValue(HEIGHT, material == null ? null : material.get(HEIGHT));
                this.setValue(VOLUME, material == null ? null : material.get(VOLUME));
                this.setValue(VOLUMUNIT, material == null ? null : material.get("volumnunit.id"));
                this.setValue(WEIGHTUNIT, material == null ? null : material.get("weightunit.id"));
                this.setValue(LENGTHUNIT, material == null ? null : material.get("lengthunit.id"));
                break;
            }
            case "hasattr": {
                if (((Boolean)this.getValue(HASATTR)).booleanValue()) {
                    this.setVisible(new String[]{ATTRPANELAP});
                    break;
                }
                this.setDisVisible(new String[]{ATTRPANELAP});
                break;
            }
            case "attr": {
                Object newValue = changeSet[0].getNewValue();
                if (newValue != null) {
                    int rowIndex = changeSet[0].getRowIndex();
                    DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
                    int maxAttr = this.getMaxattr();
                    int attrsSize = 0;
                    if (attrs != null) {
                        attrsSize = attrs.size();
                    }
                    if (maxAttr < attrsSize) {
                        this.setValue(ATTR, null, rowIndex);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01\u5982\u9700\u8d85\u8fc7\u6700\u5927\u6570\u76ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"ItemInfoEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), maxAttr));
                        return;
                    }
                    for (int i = 0; i < attrsSize; ++i) {
                        DynamicObject attrObj;
                        if (i == rowIndex || (attrObj = ((DynamicObject)attrs.get(i)).getDynamicObject(ATTR)) != newValue) continue;
                        this.setValue(ATTR, null, rowIndex);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5546\u54c1\u7ec4\u5408\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u76f8\u540c\uff0c\u4e0d\u80fd\u4e0e\u7b2c%s\u884c\u8f85\u52a9\u5c5e\u6027\u76f8\u540c\uff01", (String)"ItemInfoEditPlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]), i + 1));
                    }
                }
                this.getModel().deleteEntryData(ATTRVALUEENTRY);
                this.attrEntryInit();
                break;
            }
            case "itemmodel": {
                int index = this.getRowIndex(e);
                DynamicObject itemModel = (DynamicObject)this.getValue(ITEM_MODEL, index);
                this.setValue("modelkey", itemModel.get(NAME), index);
                break;
            }
        }
        if (key.startsWith("attrvalue")) {
            for (ChangeData changeData : changeSet) {
                int rowIndex = changeData.getRowIndex();
                DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
                int attrsSize = 0;
                if (attrs != null) {
                    attrsSize = attrs.size();
                }
                StringBuilder nameBuffer = new StringBuilder();
                for (int i = 1; i <= attrsSize; ++i) {
                    DynamicObject value = (DynamicObject)this.getValue("attrvalue" + i, rowIndex);
                    if (value == null) continue;
                    if (i != 1 && nameBuffer.length() > 0) {
                        nameBuffer.append('+');
                    }
                    nameBuffer.append(value.get(NAME));
                }
                this.setValue(ATTRNAME, nameBuffer.toString(), rowIndex);
                String number = (String)this.getValue(ATTRNUMBER, rowIndex);
                if (!StringUtils.isEmpty((String)number)) continue;
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue");
                number = CodeRuleServiceHelper.getNumber((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
                if (StringUtils.isEmpty((String)number)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u8f85\u52a9\u5c5e\u6027\u7f16\u7801\u89c4\u5219\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\uff01", (String)"ItemInfoEditPlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                }
                this.setValue(ATTRNUMBER, number, rowIndex);
            }
        }
    }

    private void attrEntryInit() {
        int i;
        DynamicObjectCollection attrs = this.getModel().getEntryEntity(ATTRENTRY);
        int maxAttr = this.getMaxattr();
        if (attrs != null) {
            int attrsSize = attrs.size();
            if (maxAttr < attrsSize) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01\u5982\u9700\u8d85\u8fc7\u6700\u5927\u6570\u76ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff01", (String)"ItemInfoEditPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), maxAttr));
                return;
            }
            for (i = 1; i <= attrsSize; ++i) {
                DynamicObject itemAttr = (DynamicObject)attrs.get(i - 1);
                String attrKey = "attrvalue" + i;
                DynamicObject attr = itemAttr.getDynamicObject(ATTR);
                if (attr == null) continue;
                EntryGrid itemmodelentry = (EntryGrid)this.getControl(ATTRVALUEENTRY);
                itemmodelentry.setColumnProperty(attrKey, "header", (Object)new LocaleString(attr.getString(NAME)));
                this.setVisible(new String[]{attrKey});
                QFilter qFilter = new QFilter("group", "=", attr.get("id"));
                this.setF7Filter(attrKey, qFilter);
            }
        }
        while (i <= maxAttr) {
            String attrKey = "attrvalue" + i;
            this.setDisVisible(new String[]{attrKey});
            ++i;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getOwnerIdsQFilter((String)"id"));
                break;
            }
            case "assistunit": 
            case "saleunit": {
                Object materialId = this.getF7PKValue("material");
                if (materialId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\uff01", (String)"ItemInfoEditPlugin_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                Set units = ItemUtil.queryMaterialAllUnit((Object)materialId);
                QFilter idQFilter = WebUtil.getIdQFilter((Collection)units);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)idQFilter);
            }
        }
        if (key.startsWith("attrvalue")) {
            this.setNoTreeF7(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "upitem": 
            case "downitem": {
                this.getView().updateView(ISONSELL);
                this.getView().updateView(SELLTIME);
                this.getView().updateView(NEWSELLTIME);
                break;
            }
            case "newattrentry": 
            case "moveattrentryup": 
            case "moveattrentrydown": 
            case "deleteattrentry": {
                this.getModel().deleteEntryData(ATTRVALUEENTRY);
                break;
            }
            case "newattrvalueentry": {
                this.attrEntryInit();
                break;
            }
            case "save": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    private int getMaxattr() {
        int maxAttr = SysParamsUtil.getMaxattr();
        return maxAttr;
    }

    private boolean isRefrenced() {
        if (this.isNewCreate()) {
            return false;
        }
        String isRefrencedStr = this.getPageCache().get("isRefrenced");
        boolean isRefrenced = true;
        if (isRefrencedStr == null) {
            isRefrenced = BaseDataRefrenceHelper.isRefrenced((String)"mdr_item_info", (Object)this.getId());
            if (isRefrenced) {
                List allRefs = BaseDataRefrenceHelper.getAllRefs((String)"mdr_item_info", (Object)this.getId());
                for (BaseDataRefenceKey bdr : allRefs) {
                    String refEntityKey = bdr.getRefEntityKey();
                    if ("mdr_item_attrvalue".equals(refEntityKey)) {
                        isRefrenced = false;
                        continue;
                    }
                    isRefrenced = true;
                    break;
                }
            }
            this.getPageCache().put("isRefrenced", String.valueOf(isRefrenced));
        } else {
            isRefrenced = Boolean.parseBoolean(isRefrencedStr);
        }
        return isRefrenced;
    }
}

