/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;
import kd.drp.mdr.mobile.model.FormModel;
import kd.drp.mdr.servicehelper.PromotionServiceHelper;

public class ItemInfoMobilePlugin
extends MdrFormMobPlugin
implements ListRowClickListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener,
TabSelectListener {
    public static final String ADDTOSHOPPINGCART = "addtoshoppingcart";
    public static final String BILLLLISTAP = "billlistap";
    public static final String SEARCH = "search";
    private static final String ITEMCLASS_TAB = "tabap";
    private static final String FIRST_TAB_PAGE_ID = "all";
    public static final String BUT_SHOPPING_CAR = "butshoppingcar";
    public static final String CUSTOMERKEY = "customerkey";
    public static final String PROMOTIONKEY = "promotionkey";

    public void initialize() {
        super.initialize();
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        itemlist.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ADDTOSHOPPINGCART, BUT_SHOPPING_CAR});
        MobileSearch serach = (MobileSearch)this.getView().getControl(SEARCH);
        serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        itemlist.addListRowClickListener((ListRowClickListener)this);
        Tab tab = (Tab)this.getControl(ITEMCLASS_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initShoppingcartInfo();
        this.reLoadItem("", false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initItemClass();
    }

    private void initItemClass() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("level", "=", (Object)1));
        qFilters.add(new QFilter("standard.id", "=", (Object)1));
        DynamicObject[] itemClasses = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)String.join((CharSequence)",", "id", "name", "number"), (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<Map> tab_items = new ArrayList<Map>(16);
        TabPageAp firstTabPageAp = new TabPageAp();
        firstTabPageAp.setKey(FIRST_TAB_PAGE_ID);
        firstTabPageAp.setName(new LocaleString("\u5168\u90e8"));
        Map firstTabPageMap = firstTabPageAp.createControl();
        firstTabPageMap.put(FIRST_TAB_PAGE_ID, firstTabPageAp);
        tab_items.add(firstTabPageMap);
        for (DynamicObject itemClass : itemClasses) {
            TabPageAp tabPageAp = new TabPageAp();
            String tabPageId = itemClass.getString("id");
            tabPageAp.setKey(tabPageId);
            tabPageAp.setId(tabPageId);
            String name = itemClass.getLocaleString("name").getLocaleValue();
            if (name == null || name.trim().length() == 0) {
                name = itemClass.getString("name");
            }
            tabPageAp.setName(new LocaleString(name));
            Map tabPageMap = tabPageAp.createControl();
            tabPageMap.put(tabPageId, tabPageAp);
            tab_items.add(tabPageMap);
        }
        Tab tabAp = (Tab)this.getControl(ITEMCLASS_TAB);
        tabAp.addControls(tab_items);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty() || rows.size() == 0) {
                    return rows;
                }
                Object ownerid = ItemInfoMobilePlugin.this.getParameter("ownerid");
                Object customerid = ItemInfoMobilePlugin.this.getParameter("customerid");
                Set promotioninfos = null;
                if (SysParamsUtil.isUsePromotion() && ownerid != null && customerid != null) {
                    String key = String.format("%s_%s", ownerid, customerid);
                    String customerkey = ItemInfoMobilePlugin.this.getPageCache().get(ItemInfoMobilePlugin.CUSTOMERKEY);
                    if (customerkey == null || key.compareTo(customerkey) != 0) {
                        PromotionServiceHelper.removePromotionContextFromCache((String)ItemInfoMobilePlugin.this.getPageCache().get(ItemInfoMobilePlugin.PROMOTIONKEY));
                        String cachekey = UUID.randomUUID().toString().replace("-", "");
                        ItemInfoMobilePlugin.this.getPageCache().put(ItemInfoMobilePlugin.PROMOTIONKEY, cachekey);
                        String sourformkey = "0".equals(ItemInfoMobilePlugin.this.getParameter("ispurchasing")) ? "C" : "D";
                        promotioninfos = PromotionServiceHelper.matchAndExecutePromotion((String)cachekey, (Object)ownerid, (Object)customerid, (boolean)true, (String[])new String[]{sourformkey});
                        ItemInfoMobilePlugin.this.getPageCache().put(ItemInfoMobilePlugin.CUSTOMERKEY, key);
                    } else {
                        promotioninfos = PromotionServiceHelper.getUsablePromotionResult((String)ItemInfoMobilePlugin.this.getPageCache().get(ItemInfoMobilePlugin.PROMOTIONKEY));
                    }
                }
                DynamicObject authBizInfo = CustomerUtil.getAuthBizInfo((Object)ownerid, (Object)customerid);
                String parentinvtype = authBizInfo.getString("parentinvtype");
                String hasStore = "";
                int size = rows.size();
                HashSet<Object> itemIds = new HashSet<Object>(size);
                for (DynamicObject item : rows) {
                    itemIds.add(item.get("id"));
                }
                Map attrids = ItemAttrUtil.getDefaultAttrId(itemIds);
                HashMap<String, DynamicObject> itemstores = new HashMap<String, DynamicObject>();
                if (!"0".equals(parentinvtype)) {
                    DynamicObjectCollection store = ItemStoreUtil.queryItemsStoreInfoSum((Object)ownerid, itemIds, (Object)ItemInfoMobilePlugin.this.getParameter("warehouseid"), (boolean)true);
                    for (DynamicObject dyObject : store) {
                        itemstores.put(String.format("%s_%s", dyObject.getString("item"), dyObject.getString("measureunit")), dyObject);
                    }
                }
                PriceUtil.setRowsPrice((DynamicObjectCollection)rows, (Object)ownerid, (Object)customerid, (BigDecimal)BigDecimal.ONE);
                for (int i = 0; i < size; ++i) {
                    DynamicObject row = (DynamicObject)rows.get(i);
                    Object itempk = row.get("id");
                    Object unitId = row.getDynamicObject("saleunit").get("id");
                    Object attrId = attrids.get(itempk);
                    row.set("promotioninfo", (Object)ItemInfoMobilePlugin.this.getPromotionDetatils(new DetailItemInfo(itempk, unitId, (Object)0L), promotioninfos));
                    if ("0".equals(parentinvtype)) {
                        hasStore = "";
                    } else {
                        BigDecimal usableQty;
                        hasStore = ResManager.loadKDString((String)"\u65e0\u8d27", (String)"ItemInfoMobilePlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
                        DynamicObject itemstore = (DynamicObject)itemstores.get(String.format("%s_%s", itempk, unitId));
                        if (itemstore != null && (usableQty = itemstore.getBigDecimal("usableqty")).compareTo(MdrFormMobPlugin.ZERO) > 0) {
                            hasStore = "1".equals(parentinvtype) ? ResManager.loadKDString((String)"\u6709\u8d27", (String)"ItemInfoMobilePlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]) : new StringBuffer(ResManager.loadKDString((String)"\u6709\u8d27\uff08\u5e93\u5b58", (String)"ItemInfoMobilePlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0])).append(usableQty.stripTrailingZeros().toPlainString()).append("\uff09").toString();
                        }
                    }
                    row.set("storeinfo", (Object)hasStore);
                }
                return rows;
            }
        });
    }

    private String getPromotionDetatils(DetailItemInfo iteminfo, Set<UsablePromotionResult> promotioninfos) {
        if (promotioninfos == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set itemranges = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        int i = 0;
        block0: for (UsablePromotionResult usablePromotionResult : promotioninfos) {
            itemranges = usablePromotionResult.getItemRanges();
            if (itemranges == null) continue;
            for (DetailItemInfo detailItemInfo : itemranges) {
                if (detailItemInfo.getItemid().toString().compareTo(iteminfo.getItemid().toString()) != 0) continue;
                if (i > 2) {
                    stringBuilder.append("...");
                    continue block0;
                }
                stringBuilder.append(String.format("%s\uff1a", usablePromotionResult.getName()));
                stringBuilder.append(String.format("%s-%s\uff0c", simpleDateFormat.format(usablePromotionResult.getstarttime()), simpleDateFormat.format(usablePromotionResult.getendtime())));
                if (usablePromotionResult.getLeftLimitqty() != null && usablePromotionResult.getLeftLimitqty().compareTo(BigDecimal.ZERO) > 0) {
                    stringBuilder.append(String.format("\u5269\u4f59\u6570\u91cf\uff1a%s\n", usablePromotionResult.getLeftLimitqty()));
                }
                ++i;
                continue block0;
            }
        }
        return stringBuilder.toString();
    }

    public void beforeClosed(BeforeClosedEvent arg0) {
        super.beforeClosed(arg0);
        PromotionServiceHelper.removePromotionContextFromCache((String)this.getPageCache().get(PROMOTIONKEY));
    }

    public void click(MobileSearchTextChangeEvent e) {
        String context = e.getText();
        this.reLoadItem(context, true);
    }

    private void reLoadItem(Object context, boolean isrefresh) {
        Tab tabAp;
        String tabKey;
        QFilter saleControlFilter = ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getParameter("ownerid"), (Object)this.getParameter("customerid"), (IPageCache)this.getPageCache());
        saleControlFilter.and("nonsingle", "=", (Object)"0");
        saleControlFilter.and("status", "=", (Object)"C");
        saleControlFilter.and("enable", "=", (Object)"1");
        if (!StringUtils.isEmpty((Object)context)) {
            QFilter filter = QMatches.ftlike((String[])new String[]{context.toString()}, (String[])new String[]{"number,name,searchkey"});
            saleControlFilter.and(filter);
        }
        if ((tabKey = (tabAp = (Tab)this.getControl(ITEMCLASS_TAB)).getCurrentTab()) != null && !FIRST_TAB_PAGE_ID.equals(tabKey)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(tabKey))};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)String.join((CharSequence)",", "longnumber"), (QFilter[])qFilters);
            String longnumber = dynamicObject.getString("longnumber");
            saleControlFilter.and("itemclassentity.goodsclasssid.longnumber", "like", (Object)(longnumber + "%"));
            saleControlFilter.and("itemclassentity.classstandardid", "=", (Object)1);
        }
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        itemlist.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                e.setOrderBy("serialnumber desc,selltime desc");
            }
        });
        itemlist.addListRowClickListener((ListRowClickListener)this);
        itemlist.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        MobileControlUtils.BillListRefresh((BillList)itemlist, (boolean)isrefresh, (QFilter[])new QFilter[]{saleControlFilter});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "addtoshoppingcart": {
                BillList itemList = (BillList)this.getControl(BILLLLISTAP);
                ListSelectedRow iteminfo = itemList.getCurrentSelectedRowInfo();
                Object itempk = iteminfo.getPrimaryKeyValue();
                this.addToShoppingCart(itempk);
                break;
            }
            case "butshoppingcar": {
                this.getView().close();
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow listSelectedRow = evt.getCurrentListSelectedRow();
        Object itempk = listSelectedRow.getPrimaryKeyValue();
        this.addToShoppingCart(itempk);
    }

    private void addToShoppingCart(Object itempk) {
        Object ownerId = this.getParameter("ownerid");
        Object customerId = this.getParameter("customerid");
        if (ownerId == null || customerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\u53ca\u4f9b\u8d27\u6e20\u9053", (String)"ItemInfoMobilePlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        FormModel model = new FormModel("mdr_mobchooseitemattr", ResManager.loadKDString((String)"\u9009\u62e9\u5546\u54c1\u5c5e\u6027", (String)"ItemInfoMobilePlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]), "15", true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ownerid", ownerId);
        params.put("customerid", customerId);
        params.put("itemid", itempk);
        params.put("warehouseid", this.getParameter("warehouseid"));
        model.addCustomParam(params);
        model.showPage((AbstractFormPlugin)this);
    }

    public String titleName() {
        String ownername = "";
        String customername = "";
        Object ownerid = this.getParameter("ownerid");
        Object customerid = this.getParameter("customerid");
        if (ownerid != null && customerid != null) {
            DynamicObject ownerInfo = BusinessDataServiceHelper.loadSingle((Object)ownerid, (String)"mdr_customer");
            DynamicObject customerInfo = BusinessDataServiceHelper.loadSingle((Object)customerid, (String)"mdr_customer");
            if (ownerInfo != null && customerInfo != null) {
                ownername = ownerInfo.getString("name");
                if (ownername.length() > 15) {
                    ownername = ownername.replace(ownername.substring(15, ownername.length()), "...");
                }
                if ((customername = customerInfo.getString("name")).length() > 15) {
                    customername = customername.replace(customername.substring(15, customername.length()), "...");
                }
            }
        }
        return ownername + "-" + customername;
    }

    public void initShoppingcartInfo() {
        Object ownerid;
        BigDecimal sumitemall = ZERO;
        Object customerId = this.getParameter("customerid");
        DynamicObject[] cartItemInfos = this.getShoppingCartList(customerId, ownerid = this.getParameter("ownerid"));
        if (cartItemInfos.length > 0) {
            for (DynamicObject cartItemInfo : cartItemInfos) {
                sumitemall = sumitemall.add(cartItemInfo.getBigDecimal("qty"));
            }
        }
        ((Label)this.getControl("titlename")).setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6b3e  \u603b\u6570%s", (String)"ItemInfoMobilePlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]), cartItemInfos.length, sumitemall.stripTrailingZeros().toPlainString()));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "mdr_mobchooseitemattr": {
                Map param = (Map)e.getReturnData();
                if (param == null) {
                    return;
                }
                this.addToShoppingCart(param);
                break;
            }
        }
    }

    private void addToShoppingCart(Map<String, Object> param) {
        boolean isMergeCartSameItem = SysParamsUtil.isMergeCartSameItem();
        boolean isAddToShoppingCart = false;
        if (isMergeCartSameItem) {
            QFilter filter = new QFilter("item", "=", param.get("itemid"));
            filter.and("owner", "=", param.get("customerid"));
            filter.and("customer", "=", param.get("ownerid"));
            filter.and("user", "=", UserUtil.getUserID());
            filter.and("unit", "=", param.get("unitid"));
            filter.and("assistattr", "=", param.get("assistattrid") == null ? Integer.valueOf(0) : param.get("assistattrid"));
            filter.and("assistunit", "=", param.get("assistunitid") == null ? Integer.valueOf(0) : param.get("assistunitid"));
            if ("0".equals(this.getParameter("ispurchasing"))) {
                filter.and("ispurchasing", "=", (Object)Character.valueOf('0'));
            } else {
                filter.and("ispurchasing", "=", (Object)Character.valueOf('1'));
            }
            DynamicObject[] cartItems = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"id,item,owner,customer,unit,assistattr,assistunit,price,assistqty,qty,createdate", (QFilter[])filter.toArray());
            if (cartItems != null && cartItems.length > 0) {
                DynamicObject cartItem = cartItems[0];
                isAddToShoppingCart = true;
                BigDecimal qty = cartItem.getBigDecimal("qty");
                BigDecimal assistqty = cartItem.getBigDecimal("assistqty");
                if (param.get("assistqty") != null) {
                    cartItem.set("assistqty", (Object)assistqty.add((BigDecimal)param.get("assistqty")));
                }
                cartItem.set("qty", (Object)qty.add((BigDecimal)param.get("qty")));
                cartItem.set("createdate", (Object)new Date());
                SaveServiceHelper.save((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem});
            }
        }
        if (!isAddToShoppingCart) {
            DynamicObject cartItem = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
            cartItem.set("owner", param.get("customerid"));
            cartItem.set("item", param.get("itemid"));
            cartItem.set("unit", param.get("unitid"));
            cartItem.set("assistattr", param.get("assistattrid"));
            cartItem.set("assistunit", param.get("assistunitid"));
            cartItem.set("assistqty", param.get("assistqty"));
            cartItem.set("price", param.get("price"));
            cartItem.set("qty", param.get("qty"));
            cartItem.set("createdate", (Object)new Date());
            cartItem.set("customer", param.get("ownerid"));
            cartItem.set("user", UserUtil.getUserID());
            if ("0".equals(this.getParameter("ispurchasing"))) {
                cartItem.set("ispurchasing", (Object)0);
            } else {
                cartItem.set("ispurchasing", (Object)1);
            }
            SaveServiceHelper.save((IDataEntityType)cartItem.getDataEntityType(), (Object[])new Object[]{cartItem});
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f", (String)"ItemInfoMobilePlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        this.initShoppingcartInfo();
    }

    private DynamicObject[] getShoppingCartList(Object customerId, Object ownerid) {
        QFilter qfilter = new QFilter("customer", "=", ownerid);
        qfilter.and("owner", "=", customerId);
        qfilter.and("user.id", "=", UserUtil.getUserID());
        if ("0".equals(this.getParameter("ispurchasing"))) {
            qfilter.and("ispurchasing", "=", (Object)Character.valueOf('0'));
        } else {
            qfilter.and("ispurchasing", "=", (Object)Character.valueOf('1'));
        }
        QFilter[] filters = new QFilter[]{qfilter};
        DynamicObject[] cartItemInfos = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"id,item.id,unit,qty,customer.id,ispurchasing", (QFilter[])filters);
        return cartItemInfos;
    }

    public void tabSelected(TabSelectEvent arg0) {
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH);
        String searchText = search.getText();
        this.reLoadItem(searchText, true);
    }
}

