/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class NewItemInfoDetailsPlugin
extends MdrFormPlugin {
    private static String[] pictures = new String[]{"picture1", "picture2", "picture3", "picture4", "picture5"};
    private static String[] images = new String[]{"image1", "image2", "image3", "image4", "image5"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(images);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Image bigpic = (Image)this.getControl("bigpic");
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String url = this.getPageCache().get(key);
        bigpic.setUrl(url);
    }

    private void initModelEntry(DynamicObject item) {
        DynamicObjectCollection itemmodelentrys = item.getDynamicObjectCollection("itemmodelentry");
        if (itemmodelentrys == null) {
            this.setDisVisible(new String[]{"itemmodelentrys"});
        } else {
            for (DynamicObject itemmodelentry : itemmodelentrys) {
                int i = this.getModel().createNewEntryRow("itemmodelentry");
                this.setValue("modelkey", itemmodelentry.get("modelkey"), i);
                this.setValue("modelvalue", itemmodelentry.get("modelvalue"), i);
            }
        }
    }

    private DynamicObject getItem() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object itemId = parameter.getCustomParam("itemId");
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info");
        return item;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject item = this.getItem();
        this.initItemInfo(item);
        this.initModelEntry(item);
    }

    private void initEvaluate(DynamicObject item) {
        DynamicObjectCollection itemEvaluateCollection = this.getItemEvaluate(item.get("id"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject itemEvaluate : itemEvaluateCollection) {
            DynamicObject newEntry = dynamicObjectCollection.addNew();
            newEntry.set("name", itemEvaluate.get("creator.name"));
            newEntry.set("imageap", itemEvaluate.get("creator.headsculpture"));
            newEntry.set("content", itemEvaluate.get("evaluatecontent"));
            newEntry.set("createtime", itemEvaluate.get("createtime"));
            newEntry.set("replytxt", itemEvaluate.get("modifier"));
            newEntry.set("replytime", itemEvaluate.get("modifytime"));
            int score = itemEvaluate.getInt("evaluategrade");
            for (int i = 1; i <= 5; ++i) {
                if (score > i) {
                    newEntry.set("star1" + String.valueOf(i), (Object)"\u2605");
                    continue;
                }
                newEntry.set("star1" + String.valueOf(i), (Object)"\u2606");
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().equals("name")) {
            Button button = new Button();
            button.setKey("name");
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }

    private void creatAssistattr(DynamicObject item) {
        FlexPanelAp flex = this.createFlex("assistattr");
        DynamicObjectCollection attrentry = item.getDynamicObjectCollection("attrentry");
        for (int i = 0; i < attrentry.size(); ++i) {
            FlexPanelAp flexPanelAp = this.createFlex("assistattr" + String.valueOf(i));
            String name = ((DynamicObject)attrentry.get(i)).getDynamicObject("attr").getString("name");
            Object id = ((DynamicObject)attrentry.get(i)).getDynamicObject("attr").get("id");
            LabelAp label = new LabelAp();
            label.setId("assistattr" + name);
            label.setKey("assistattr" + name);
            label.setName(new LocaleString(name + ":"));
            Style style2 = new Style();
            Margin margin2 = new Margin();
            margin2.setRight("40px");
            style2.setMargin(margin2);
            label.setStyle(style2);
            flexPanelAp.getItems().add(label);
            DynamicObject[] nameDyns = BusinessDataServiceHelper.load((String)"mdr_assist_value", (String)"name", (QFilter[])new QFilter("group", "=", id).toArray());
            for (int j = 0; j < nameDyns.length; ++j) {
                ButtonAp buttonvalue = new ButtonAp();
                buttonvalue.setKey("assistattr" + nameDyns[j].getString("name"));
                buttonvalue.setId("assistattr" + nameDyns[j].getString("name"));
                buttonvalue.setName(new LocaleString(nameDyns[j].getString("name")));
                buttonvalue.setWidth(new LocaleString("80px"));
                buttonvalue.setHeight(new LocaleString("20px"));
                buttonvalue.setRadius("0px");
                buttonvalue.setForeColor("#cccccc");
                Style style = new Style();
                Margin margin = new Margin();
                margin.setLeft("10px");
                style.setMargin(margin);
                buttonvalue.setStyle(style);
                flexPanelAp.getItems().add(buttonvalue);
            }
            flex.getItems().add(flexPanelAp);
        }
        Container container = (Container)this.getView().getControl("assistattrflex");
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flex.createControl());
        container.addControls(list);
    }

    private FlexPanelAp createFlex(String key) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(key);
        flex.setWidth(new LocaleString("100%"));
        flex.setDirection("row");
        flex.setAlignItems("left");
        flex.setGrow(1);
        flex.setShrink(1);
        flex.setJustifyContent("flex-start");
        flex.setAlignItems("center");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("10px");
        margin.setBottom("20px");
        style.setMargin(margin);
        flex.setStyle(style);
        return flex;
    }

    private DynamicObjectCollection getItemEvaluate(Object itemPk) {
        String selectFields = "creator.name,creator.headsculpture,createtime,replytxt,modifier,modifytime,evaluatecontent,evaluategrade,picture1,picture2,picture3,picture4,picture5";
        QFilter f = new QFilter("item", "=", itemPk).and("billstatus", "=", (Object)"C").and("evaluatetype", "=", (Object)"0");
        return QueryServiceHelper.query((String)"mdr_item_evaluate", (String)selectFields, (QFilter[])f.toArray());
    }

    private void initItemInfo(DynamicObject item) {
        DynamicObjectCollection itemBrands;
        if (item == null) {
            return;
        }
        String ownerName = "";
        if (item.getDynamicObject("owner") != null) {
            ownerName = item.getDynamicObject("owner").getString("name");
        }
        ((Label)this.getControl("owner")).setText(ownerName);
        ((Label)this.getControl("iteminfo")).setText(item.getString("name") + " " + item.getString("number"));
        ((Label)this.getControl("shorttitle")).setText(item.getString("shorttitle"));
        DynamicObject itemClass = (DynamicObject)item.get("itemclass");
        if (itemClass != null) {
            ((Label)this.getControl("itemclass")).setText(itemClass.getString("name"));
        }
        if ((itemBrands = (DynamicObjectCollection)item.get("itembrands")) != null && itemBrands.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < itemBrands.size(); ++i) {
                DynamicObject o = (DynamicObject)((DynamicObject)itemBrands.get(i)).get("fbasedataid");
                if (o == null) continue;
                if (i > 0) {
                    sb.append("   ");
                }
                sb.append(o.get("name"));
            }
            ((Label)this.getControl("itembrand")).setText(sb.toString());
        }
        BigDecimal bd = BigDecimal.valueOf(0.0);
        if (item.get("referenceprice") != null) {
            bd = item.getBigDecimal("referenceprice");
        }
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        ((Label)this.getControl("price")).setText("\uffe5" + bd.toString());
        ((Html)this.getControl("description")).setConent(item.getString("description_tag"));
        Image bigpic = (Image)this.getControl("bigpic");
        int i = 0;
        boolean hasBigpic = false;
        for (String picture : pictures) {
            picture = item.getString(picture);
            String fileServerUrl = UrlService.getImageFullUrl((String)picture);
            if (!StringUtils.isNotEmpty((String)picture)) continue;
            String imageKey = images[i++];
            Image image = (Image)this.getControl(imageKey);
            this.getPageCache().put(imageKey, fileServerUrl);
            image.setUrl(fileServerUrl);
            if (hasBigpic) continue;
            bigpic.setUrl(fileServerUrl);
            hasBigpic = true;
        }
        while (i < images.length) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{images[i++]});
        }
    }

    private Map<String, Object> getCmpEvaluate(Object itemPk) {
        QFilter f = new QFilter("billstatus", "=", (Object)"C").and("item", "=", itemPk);
        String selectedFileds = "billno,evaluategrade,item.name,id";
        BigDecimal score = new BigDecimal("0");
        DynamicObject[] itemInfoList = BusinessDataServiceHelper.load((String)"mdr_item_evaluate", (String)selectedFileds, (QFilter[])f.toArray());
        ArrayList list = new ArrayList();
        for (DynamicObject subItem : itemInfoList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)subItem.get("id"), (String)"mdr_item_evaluate", (String)"evaluatelabels");
            DynamicObjectCollection colList = dynamicObject.getDynamicObjectCollection("evaluatelabels");
            if (colList != null && colList.size() > 0) {
                for (DynamicObject col : colList) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("name", col.get("fbasedataid.name.zh_CN"));
                    map.put("id", col.get("fbasedataid.id"));
                    list.add(map);
                }
            }
            score = new BigDecimal(subItem.getString("evaluategrade")).add(score);
        }
        BigDecimal avg = BigDecimal.ZERO;
        if (itemInfoList != null && itemInfoList.length > 0) {
            avg = score.divide(BigDecimal.valueOf(itemInfoList.length), 0, 4);
        }
        Map<Object, Long> labelMap = list.stream().collect(Collectors.groupingBy(p -> p.get("id") + "," + p.get("name"), Collectors.counting()));
        ArrayList labelList = new ArrayList(labelMap.size());
        for (Map.Entry entry : labelMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            Object key = entry.getKey();
            String[] arr = key.toString().split(",");
            map.put("id", arr[0]);
            map.put("name", arr[1]);
            map.put("count", (String)entry.getValue());
            labelList.add(map);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("labelList", labelList);
        resultMap.put("avg", avg);
        return resultMap;
    }

    private void createLabel(DynamicObject item) {
        FlexPanelAp labelFlex = this.createFlex("label");
        Map<String, Object> labelMap = this.getCmpEvaluate(item.get("id"));
        List labelList = (List)labelMap.get("labelList");
        for (int i = 0; i < labelList.size(); ++i) {
            ButtonAp buttonAp = new ButtonAp();
            buttonAp.setKey(((Map)labelList.get(i)).get("id").toString());
            buttonAp.setId(((Map)labelList.get(i)).get("id").toString());
            buttonAp.setName(new LocaleString(((Map)labelList.get(i)).get("name").toString() + "(" + ((Map)labelList.get(i)).get("count").toString() + ")"));
            buttonAp.setWidth(new LocaleString("120px"));
            buttonAp.setHeight(new LocaleString("25px"));
            buttonAp.setRadius("0px");
            buttonAp.setForeColor("#cccccc");
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("10px");
            style.setMargin(margin);
            buttonAp.setStyle(style);
            labelFlex.getItems().add(buttonAp);
        }
        Container container = (Container)this.getView().getControl("evaluatelabel");
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(labelFlex.createControl());
        container.addControls(list);
    }
}

