/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.item;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class SubItemSelectEditPlugin
extends MdrBasePlugin
implements RowClickEventListener {
    public static final String BTN_CONFIRM = "btconfirm";
    public static final String ISSELECT = "isselect";
    public static final String QTY = "qty";
    public static final String PRESENTBAGTYPE = "presentbagtype";
    public static final String SUBPROJECT = "subproject";
    public static final String ESUBPROJECT = "esubproject";
    public static final String SUBENTRYENTITY = "subentryentity";
    public static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String strkey = this.getStringInShowParam();
        if (strkey == null || strkey.isEmpty()) {
            return;
        }
        HashSet<Object> combIds = new HashSet<Object>();
        DynamicObjectCollection itemEntry = this.getView().getParentView().getModel().getEntryEntity("itementry");
        for (int i = 0; i < itemEntry.size(); ++i) {
            DynamicObject entry;
            DynamicObject combitem;
            if (!strkey.contains(String.format("%s,", i)) || (combitem = (entry = (DynamicObject)itemEntry.get(i)).getDynamicObject("combitem")) == null || !combitem.getBoolean("issubgroup")) continue;
            combIds.add(combitem.getPkValue());
        }
        DynamicObject[] combinations = BusinessDataServiceHelper.load((Object[])combIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"dpm_item_combination"));
        if (combinations == null || combinations.length == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("combination", new Object[0]);
        vs.addField(SUBPROJECT, new Object[0]);
        vs.addField("sumqty", new Object[0]);
        vs.addField("hunit", new Object[0]);
        Object combid = null;
        int subgroup = 0;
        int oldsubgroup = -1;
        for (DynamicObject combination : combinations) {
            oldsubgroup = -1;
            combid = combination.getPkValue();
            DynamicObjectCollection itemdetails = combination.getDynamicObjectCollection("itemdetail");
            itemdetails.sort(Comparator.comparing(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"subgroup")));
            for (DynamicObject itemdetail : itemdetails) {
                subgroup = itemdetail.getInt("subgroup");
                if (oldsubgroup != -1 && oldsubgroup == subgroup) continue;
                oldsubgroup = subgroup;
                vs.addRow(new Object[]{combid, subgroup, itemdetail.getBigDecimal(QTY), itemdetail.getDynamicObject("unit").getPkValue()});
            }
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
        this.addSubEntryEntity(combinations);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{BTN_CONFIRM});
        EntryGrid ce = (EntryGrid)this.getControl(ENTRYENTITY);
        ce.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject e) {
        String btnname;
        super.click(e);
        Button btn = (Button)e.getSource();
        switch (btnname = btn.getKey()) {
            case "btconfirm": {
                this.btnConfirmClick();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        super.propertyChanged(e, key);
        int index = this.getRowIndex(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "qty": {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                this.presentQtyChange(index, this.getBigDecimalValue(newValue).subtract(this.getBigDecimalValue(oldValue)));
                break;
            }
        }
    }

    private BigDecimal getBigDecimalValue(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return BigDecimal.ZERO;
    }

    private String getStringInShowParam() {
        return (String)this.getView().getFormShowParameter().getCustomParam("indexs");
    }

    private void btnConfirmClick() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        if (this.beforeConfirmCheckEntry(entryentitys)) {
            DynamicObjectCollection subentryentitys = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            HashMap<Long, BigDecimal> sourceentryids = new HashMap<Long, BigDecimal>(entryentitys.size());
            BigDecimal qty = BigDecimal.ZERO;
            for (DynamicObject subentryentity : subentryentitys) {
                qty = subentryentity.getBigDecimal(QTY);
                if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                sourceentryids.put(subentryentity.getLong("fromentryid"), qty);
            }
            this.getView().returnDataToParent(sourceentryids);
            this.getView().close();
        }
    }

    private boolean beforeConfirmCheckEntry(DynamicObjectCollection entryentitys) {
        if (entryentitys == null || entryentitys.size() == 0) {
            return false;
        }
        int seq = 0;
        StringBuilder errorinfo = new StringBuilder();
        StringBuilder qtyerrorseq = new StringBuilder();
        for (DynamicObject entryentity : entryentitys) {
            seq = entryentity.getInt("seq");
            if (entryentity.getBigDecimal("sumqty").compareTo(entryentity.getBigDecimal("subitemsumqty")) == 0) continue;
            qtyerrorseq.append(seq);
            qtyerrorseq.append(',');
        }
        int length = qtyerrorseq.length();
        if (length > 0) {
            qtyerrorseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u5b50\u4ef6\u7ec4\u201d\u5df2\u586b\u5b50\u4ef6\u603b\u6570\u201c\u9700\u8981\u7b49\u4e8e\u201d\u603b\u6570\u91cf\u201c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", qtyerrorseq));
        }
        if (errorinfo.length() > 0) {
            this.getView().showErrorNotification(errorinfo.toString());
            return false;
        }
        return true;
    }

    private void sortSubEntryEntity() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection subentryentitys = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
        int fromindex = 0;
        int size = subentryentitys.size();
        int[] rowIndexs = new int[size];
        int i = 0;
        for (int j = 0; j < size; ++j) {
            DynamicObject subentryentity = (DynamicObject)subentryentitys.get(j);
            fromindex = subentryentity.getInt("fromindex");
            if (fromindex != 0 && fromindex % 2 != 0) continue;
            rowIndexs[i] = j;
            ++i;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ClientActions.createRowStyleBuilder().setRows(rowIndexs).setBackColor("#e5e5e5").buildStyle().build().invokeControlMethod(proxy, SUBENTRYENTITY);
    }

    private void addSubEntryEntity(DynamicObject[] combinations) {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, Integer> fromindexs = new HashMap<String, Integer>(entryentitys.size());
        for (DynamicObject entryentity : entryentitys) {
            fromindexs.put(String.format("%s_%s", entryentity.getDynamicObject("combination").getPkValue(), entryentity.get(SUBPROJECT)), entryentity.getInt("seq") - 1);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("ecombination", new Object[0]);
        vs.addField(ESUBPROJECT, new Object[0]);
        vs.addField("item", new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("attr", new Object[0]);
        vs.addField("fromindex", new Object[0]);
        vs.addField("fromentryid", new Object[0]);
        Object itemid = null;
        Object unitid = null;
        Object attrid = null;
        Object combid = null;
        Object subgroup = null;
        String key = "";
        for (DynamicObject combination : combinations) {
            combid = combination.getPkValue();
            DynamicObjectCollection itemdetails = combination.getDynamicObjectCollection("itemdetail");
            itemdetails.sort(Comparator.comparing(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"subgroup")));
            for (DynamicObject itemdetail : itemdetails) {
                subgroup = itemdetail.get("subgroup");
                key = String.format("%s_%s", combid, subgroup);
                dynamicObject = itemdetail.getDynamicObject("item");
                itemid = dynamicObject.getPkValue();
                dynamicObject = itemdetail.getDynamicObject("unit");
                unitid = dynamicObject == null ? Integer.valueOf(0) : dynamicObject.getPkValue();
                dynamicObject = itemdetail.getDynamicObject("attr");
                attrid = dynamicObject == null ? Integer.valueOf(0) : dynamicObject.getPkValue();
                vs.addRow(new Object[]{combid, subgroup, itemid, unitid, attrid, fromindexs.get(key), itemdetail.getPkValue()});
            }
        }
        model.batchCreateNewEntryRow(SUBENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(SUBENTRYENTITY);
        this.sortSubEntryEntity();
    }

    private void presentQtyChange(int index, BigDecimal presentqty) {
        int findex = (Integer)this.getValue("fromindex", index);
        BigDecimal sumpresentqty = this.getBigDecimalValue(this.getValue("subitemsumqty", findex));
        this.setValue("subitemsumqty", sumpresentqty.add(presentqty), findex);
    }
}

