/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itembarcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.f7.F7Utils;

public class ItemBarCodeDefEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "coderuleid", "itemtypeid");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadDefaultData();
    }

    private void loadDefaultData() {
        QFilter qFilter = new QFilter("conditionentry.property", "=", (Object)"0TJ=767Q13+S");
        qFilter.and("bizobjectid", "=", (Object)"mdr_item_barcode");
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bos_coderule", (String)"id,conditionentry.id,conditionentry.propertyvalue.value value", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)data)) {
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData("entryentity");
            dataModel.batchCreateNewEntryRow("entryentity", data.size());
            for (int i = 0; i < data.size(); ++i) {
                dataModel.setValue("coderuleid", ((DynamicObject)data.get(i)).get("id"), i);
                dataModel.setValue("itemtypeid", ((DynamicObject)data.get(i)).get("value"), i);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "coderuleid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getCoderuleIdFilter());
                break;
            }
            case "itemtypeid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemTypeIdFilter());
            }
        }
    }

    private List<QFilter> getCoderuleIdFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        QFilter filter = new QFilter("bos_coderule.bizobjectid", "=", (Object)"mdr_item_barcode");
        filter.and("enable", "=", (Object)Enable.ENABLE.toString());
        fs.add(filter);
        return fs;
    }

    private List<QFilter> getItemTypeIdFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        ArrayList barcodeids = !CollectionUtils.isEmpty((Collection)entrys) ? entrys.stream().filter(m -> m.get("itemtypeid") != null).map(m -> m.getDynamicObject("itemtypeid").getPkValue()).collect(Collectors.toList()) : new ArrayList();
        QFilter filter = new QFilter("id", "not in", barcodeids);
        fs.add(filter);
        return fs;
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }
}

