/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itembarcode;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.dbd.common.enums.StatusEnum;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;

public class ItemBarCodeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SAVE = "save";
    private static final String BATCHNEWBARCODE = "batchnewbarcode";
    private static final String CUORG = "createOrg";
    private static Log logger = LogFactory.getLog(ItemBarCodeEditPlugin.class);
    private static final String[] cols = new String[]{"memberprice", "retailprice", "barcode", "currency", "unit", "item", "auxpty", "materiel", "createorg"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "item", "unit");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String cuOrgId = (String)this.getView().getFormShowParameter().getCustomParam(CUORG);
        if (!StringUtils.isEmpty((String)cuOrgId)) {
            this.getPageCache().put(CUORG, cuOrgId);
        } else {
            this.getView().showErrorNotification("\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
        }
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("barcodeids");
        if (ids != null) {
            this.initDefaultData(ids.toArray());
        }
    }

    private void initDefaultData(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"mdr_item_barcode", (String)"id,barcode,item,unit,createorg,currency,retailprice,memberprice,materiel,auxpty", (QFilter[])qFilter.toArray());
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        dataModel.batchCreateNewEntryRow("entryentity", ids.length);
        for (int i = 0; i < ids.length; ++i) {
            dataModel.setValue("barcodeid", ((DynamicObject)data.get(i)).get("id"), i);
            dataModel.setValue("createorg", ((DynamicObject)data.get(i)).get("createorg"), i);
            dataModel.setValue("barcode", ((DynamicObject)data.get(i)).get("barcode"), i);
            dataModel.setValue("currency", ((DynamicObject)data.get(i)).get("currency"), i);
            dataModel.setValue("item", ((DynamicObject)data.get(i)).get("item"), i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"item"});
            dataModel.setValue("materiel", ((DynamicObject)data.get(i)).get("materiel"), i);
            dataModel.setValue("auxpty", ((DynamicObject)data.get(i)).get("auxpty"), i);
            dataModel.setValue("unit", ((DynamicObject)data.get(i)).get("unit"), i);
            dataModel.setValue("retailprice", ((DynamicObject)data.get(i)).get("retailprice"), i);
            dataModel.setValue("memberprice", ((DynamicObject)data.get(i)).get("memberprice"), i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showErrorNotification("\u8bf7\u5148\u8f93\u5165\u5206\u5f55\u6570\u636e");
            return;
        }
        switch (key = evt.getItemKey()) {
            case "save": {
                boolean success = this.toSaveRows();
                if (!success) break;
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                this.getView().close();
                break;
            }
            case "batchnewbarcode": {
                this.batchNewBarcode();
                break;
            }
        }
    }

    protected void batchNewBarcode() {
        DynamicObjectCollection entryInfos = this.getModel().getEntryEntity("entryentity");
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        if (!CollectionUtils.isEmpty((Collection)entryInfos)) {
            try {
                Map<String, List<DynamicObject>> collect = entryInfos.stream().filter(m -> m.get("item") != null).filter(m -> m.getDynamicObject("item").getDynamicObject("itemtypeid") != null).filter(m -> StringUtils.isEmpty((String)m.getString("barcode"))).collect(Collectors.groupingBy(m -> DynamicObjectUtils.getPkValue((DynamicObject)m.getDynamicObject("item"), (String)"itemtypeid") + "_" + DynamicObjectUtils.getPkValue((DynamicObject)m.getDynamicObject("item"), (String)"createorg")));
                if (collect.isEmpty()) {
                    result.setMessage("\u81ea\u52a8\u751f\u6210\u6761\u5f62\u7801\u5931\u8d25,\u9009\u62e9\u7684\u5546\u54c1\u5206\u5f55\u4e3a\u7a7a");
                } else {
                    this.getModel().beginInit();
                    for (Map.Entry<String, List<DynamicObject>> groupByentry : collect.entrySet()) {
                        String[] key = groupByentry.getKey().split("_");
                        List<DynamicObject> entrys = groupByentry.getValue();
                        result.setBillCount(result.getBillCount() + entrys.size());
                        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_barcode");
                        obj.set("itemtype", (Object)key[0]);
                        obj.set("createorg", (Object)key[1]);
                        String[] barcodes = CodeRuleServiceHelper.getBatchNumber((String)"mdr_item_barcode", (DynamicObject)obj, (String)key[1], (int)entrys.size());
                        if (barcodes != null && barcodes.length > 0) {
                            for (int i = 0; i < barcodes.length; ++i) {
                                int seq = entrys.get(i).getInt("seq");
                                Object itemId = entrys.get(i).getDynamicObject("item").getPkValue();
                                this.getModel().setValue("barcode", (Object)barcodes[i], seq - 1);
                                result.addSuccessPkId(itemId);
                            }
                            continue;
                        }
                        for (DynamicObject entry : entrys) {
                            int seq = entry.getInt("seq");
                            Object itemId = entry.getDynamicObject("item").getPkValue();
                            String itemNumber = entry.getDynamicObject("item").getString("number");
                            result.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("number", itemId, seq, seq, "500", "\u81ea\u52a8\u751f\u6210\u6761\u7801\u5931\u8d25", String.format("\u81ea\u52a8\u751f\u6210\u6761\u7801\u5931\u8d25,\u8bf7\u68c0\u67e5\u5546\u54c1%s\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u5173\u8054\u7684\u6761\u7801\u89c4\u5219", itemNumber), ErrorLevel.FatalError));
                        }
                    }
                    this.getModel().endInit();
                    this.getView().updateView("entryentity");
                }
                if (result.getSuccessPkIds().size() == result.getBillCount() && result.getBillCount() > 0) {
                    this.getView().showSuccessNotification("\u81ea\u52a8\u751f\u6210\u6761\u5f62\u7801\u6210\u529f");
                } else {
                    this.getView().showOperationResult(result, "\u81ea\u52a8\u751f\u6210\u6761\u5f62\u7801\u5931\u8d25");
                }
            }
            catch (Exception e) {
                logger.error("\u81ea\u52a8\u751f\u6210\u6761\u5f62\u7801\u5931\u8d25" + e.getMessage());
                result.setMessage(e.getMessage());
                this.getView().showOperationResult(result, "\u81ea\u52a8\u751f\u6210\u6761\u5f62\u7801\u5931\u8d25");
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        if ("entryentity".equals(prop.getName())) {
            OperationResult result;
            int[] indexs = e.getRowIndexs();
            ArrayList<Object> delIds = new ArrayList<Object>();
            for (int i : indexs) {
                DynamicObject col = this.getModel().getEntryRowEntity("entryentity", i);
                Object id = ItemBarCodeEditPlugin.getPkId(col, "barcodeid");
                if (id == null || id.equals(0L)) continue;
                delIds.add(id);
            }
            if (!CollectionUtils.isEmpty(delIds) && !(result = OperationServiceHelper.executeOperate((String)"delete", (String)"mdr_item_barcode", (Object[])delIds.toArray())).isSuccess()) {
                e.setCancel(true);
                this.getView().showOperationResult(result);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "item": {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.setCustomParam("isFromPos", (Object)"1");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "unit": {
                this.addUnitFilter(e, e.getRow());
                break;
            }
        }
    }

    private boolean toSaveRows() {
        Map<DynamicObject, Integer> datas = this.checkAndGetRows();
        boolean success = true;
        if (datas.size() > 0) {
            OperateOption op = OperateOption.create();
            OperationResult result = OperationServiceHelper.executeOperate((String)SAVE, (String)"mdr_item_barcode", (DynamicObject[])datas.keySet().toArray(new DynamicObject[datas.size()]), (OperateOption)op);
            if (!result.isSuccess()) {
                this.getView().showOperationResult(result);
                success = false;
            }
            if (!CollectionUtils.isEmpty((Collection)result.getSuccessPkIds())) {
                Map maps = BusinessDataServiceHelper.loadFromCache((Object[])result.getSuccessPkIds().toArray(), (String)"mdr_item_barcode");
                for (Map.Entry entry : maps.entrySet()) {
                    DynamicObject data = (DynamicObject)entry.getValue();
                    Object id = entry.getKey();
                    List keydata = datas.keySet().stream().filter(m -> m.get("barcode").equals(data.get("barcode")) && m.getInt("item.id") == data.getInt("item.id") && m.getInt("unit.id") == data.getInt("unit.id")).collect(Collectors.toList());
                    Integer integer = datas.get(keydata.get(0));
                    this.getModel().setValue("barcodeid", id, integer.intValue());
                    this.getView().setEnable(Boolean.valueOf(false), integer.intValue(), new String[]{"item"});
                }
            }
        } else {
            success = false;
        }
        return success;
    }

    private Map<DynamicObject, Integer> checkAndGetRows() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        StringBuilder msg = new StringBuilder();
        DynamicObject item = null;
        HashMap<DynamicObject, Integer> datas = new HashMap<DynamicObject, Integer>();
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            item = row.getDynamicObject("item");
            if (item == null) {
                msg.append(String.format("\u7b2c%s\u884c,\u5546\u54c1\u7f3a\u5c11\u5fc5\u5f55\u9879\uff1b", row.get("seq")));
                continue;
            }
            if (row.getDynamicObject("unit") == null) {
                msg.append(String.format("\u7b2c%s\u884c,\u8ba1\u91cf\u5355\u4f4d\u7f3a\u5c11\u5fc5\u5f55\u9879\uff1b", row.get("seq")));
                continue;
            }
            if (StringUtils.isEmpty((String)row.getString("barcode"))) {
                msg.append(String.format("\u7b2c%s\u884c,\u6761\u5f62\u7801\u7f3a\u5c11\u5fc5\u5f55\u9879\uff1b", row.get("seq")));
                continue;
            }
            if (row.getBigDecimal("memberprice").compareTo(BigDecimal.ZERO) < 0) {
                msg.append(String.format("\u7b2c%s\u884c,\u4f1a\u5458\u4ef7\u8981\u6c42\u5927\u4e8e0\uff1b", row.get("seq")));
                continue;
            }
            if (row.getBigDecimal("retailprice").compareTo(BigDecimal.ZERO) < 0) {
                msg.append(String.format("\u7b2c%s\u884c,\u96f6\u552e\u4ef7\u8981\u6c42\u5927\u4e8e0\uff1b", row.get("seq")));
                continue;
            }
            DynamicObject object = this.createItemBarCode(row);
            datas.put(object, i);
        }
        String showMsg = msg.toString();
        if (!StringUtils.isEmpty((String)showMsg)) {
            throw new KDBizException(showMsg);
        }
        return datas;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "item": {
                Object itemId;
                int index = e.getChangeSet()[0].getRowIndex();
                IDataModel model = this.getModel();
                DynamicObject item = this.getModel().getEntryRowEntity("entryentity", index).getDynamicObject("item");
                Object object = itemId = item != null ? item.getPkValue() : null;
                if (itemId == null) {
                    this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01");
                    return;
                }
                model.setValue("currency", ItemBarCodeEditPlugin.getPkId(item, "currency"), index);
                model.setValue("unit", ItemBarCodeEditPlugin.getPkId(item, "retailunit"), index);
                model.setValue("retailprice", item.get("retailprice"), index);
                model.setValue("memberprice", item.get("memberprice"), index);
                break;
            }
        }
    }

    protected DynamicObject createItemBarCode(DynamicObject row) {
        DynamicObject data = null;
        DynamicObject barcode = row.getDynamicObject("barcodeid");
        if (barcode != null && barcode.getPkValue() != null) {
            data = BusinessDataServiceHelper.loadSingle((Object)barcode.getPkValue(), (String)"mdr_item_barcode");
            data.set("modifier", ItemBarCodeEditPlugin.getUserID());
            data.set("modifytime", (Object)this.getNow());
        } else {
            data = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_barcode");
            data.set("createtime", (Object)this.getNow());
            data.set("creator", ItemBarCodeEditPlugin.getUserID());
        }
        data.set("status", (Object)StatusEnum.AUDIT.getValue());
        for (String col : cols) {
            data.set(col, row.get(col));
        }
        return data;
    }

    protected void addUnitFilter(BeforeF7SelectEvent e, int rowIndex) {
        long retailUnitId;
        DynamicObject item = this.getModel().getEntryRowEntity("entryentity", rowIndex).getDynamicObject("item");
        if (item == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01");
            e.setCancel(true);
            return;
        }
        long materialId = item.getDynamicObject("material").getLong("id");
        long l = retailUnitId = item.getDynamicObject("retailunit") == null ? 0L : item.getDynamicObject("retailunit").getLong("id");
        if (retailUnitId != 0L) {
            QFilter f = new QFilter("id", "in", (Object)QueryUtil.getAssistMUListResult((Long)materialId, (Long)retailUnitId, (String)"2"));
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)f);
        }
    }

    private List<QFilter> getItemFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        String curOrgId = this.getPageCache().get(CUORG);
        QFilter dataIdFilter = null;
        dataIdFilter = StringUtils.isEmpty((String)curOrgId) ? new QFilter("1", "=", (Object)"-1") : BaseDataServiceHelper.getBaseDataIdInFilter((String)"mdr_item_info", (Long)Long.parseLong(curOrgId));
        fs.add(dataIdFilter);
        return fs;
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public static Object getPkId(DynamicObject data, String name) {
        Object idobject = data.get(name);
        if (idobject == null) {
            return null;
        }
        return idobject.getClass().equals(DynamicObject.class) ? ((DynamicObject)idobject).getPkValue() : idobject;
    }

    public static Object getUserID() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public Date getNow() {
        return new Date();
    }
}

