/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itembarcode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.drp.dbd.common.util.ItemClassStandardUtils;
import kd.drp.dbd.common.util.PermUtils;

public class ItemBarCodeTreeListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ItemBarCodeTreeListPlugin.class);
    private static final String BTN_NEW = "tblnew";
    private static final String BTN_EDIT = "tbledit";
    private static final String BTN_DEL = "tbldel";
    private static final String LIST_ITEM = "tblitem";
    private static final String NEED_SELECTEDNODE_MSG = "\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6761\u5f62\u7801";
    private static final String CUORG_FILEDNAME = "useorg.id";
    private static final String CREATEORG = "createOrg";
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "0";
    private static final String PROP_ID = "id";
    private static final String PROP_LONGNUMBER = "longnumber";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String orgId = this.getPageCache().get(CREATEORG);
        if (key.equals(BTN_NEW) || key.equals(BTN_EDIT) || key.equals(BTN_DEL) || key.equals(LIST_ITEM)) {
            evt.setCancel(true);
            switch (key) {
                case "tblnew": 
                case "tbledit": {
                    this.openBill(key);
                    break;
                }
                case "tbldel": {
                    this.delBarcode(key);
                    break;
                }
                case "tblitem": {
                    boolean hasPerm = PermUtils.checkUserPermItemId((String)orgId, (String)"dbd", (String)"dbd_itemsale_publish", (String)"47156aff000000ac");
                    if (!hasPerm) {
                        this.getView().showErrorNotification("\u4f60\u6ca1\u6709\u5355\u636e\u7684\u65b0\u589e\u6743\u9650");
                        return;
                    }
                    if (this.getSelectIds().length == 0) {
                        this.getView().showErrorNotification(NEED_SELECTEDNODE_MSG);
                        return;
                    }
                    Object[] checkedId = this.getSelectIds();
                    boolean IsInSide = this.checkItemBelong(checkedId);
                    if (!IsInSide) break;
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("dbd_itemsale_publish");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    String cuOrgId = this.getPageCache().get(CREATEORG);
                    showParameter.setCustomParam("createorg", (Object)cuOrgId);
                    showParameter.setCustomParam("barcodeids", Arrays.asList(checkedId));
                    showParameter.setBillStatus(BillOperationStatus.ADDNEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
            }
        }
    }

    private boolean checkItemBelong(Object[] checkedId) {
        QFilter filters = new QFilter(PROP_ID, "in", (Object)checkedId);
        filters.and("item.goodsbelong", "!=", (Object)Character.valueOf('0'));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"mdr_item_barcode", (String)"id,barcode,item.name,item.number", (QFilter[])filters.toArray());
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return true;
        }
        OperationResult result = new OperationResult();
        result.setShowMessage(true);
        result.setBillCount(checkedId.length);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.Error, dynamicObject.getPkValue());
            String message = String.format("\u6761\u5f62\u7801%s\u5305\u542b\u7684\u5546\u54c1%s,\u4e0d\u662f\u5185\u90e8\u5546\u54c1,\u4e0d\u80fd\u53d1\u5e03", dynamicObject.getString("barcode"), dynamicObject.getString("item.name"));
            errorInfo.setMessage(message);
            result.addErrorInfo(errorInfo);
        }
        this.getView().showOperationResult(result);
        return false;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String orgId = null;
        for (Map customFiter : customFiterList) {
            String cuOrg;
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !CUORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(cuOrg = this.getPageCache().get(CREATEORG))) {
                return;
            }
            filterValues.put("fastfilter", new ArrayList());
            this.getPageCache().remove(CREATEORG);
            this.getPageCache().put(CREATEORG, orgId);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List<Object> filters = this.barcodeFilter();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String useorg = "";
        if (listShowParameter.isLookUp()) {
            long useOrgId = listShowParameter.getUseOrgId();
            if (useOrgId != 0L) {
                useorg = String.valueOf(useOrgId);
                QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"mdr_item_info", (Long)Long.valueOf(useorg));
                QFilter qFilter = new QFilter("item.id", "in", filter.getValue());
                filters.add(qFilter);
            }
        } else {
            List idfilters = filters.stream().filter(m -> PROP_ID.equals(m.getProperty())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idfilters)) {
                filters = filters.stream().filter(m -> !PROP_ID.equals(m.getProperty())).collect(Collectors.toList());
                filters.add(new QFilter("item.id", "in", ((QFilter)idfilters.get(0)).getValue()));
            }
            if (!StringUtils.isEmpty((CharSequence)(useorg = this.getPageCache().get(CREATEORG)))) {
                filters = filters.stream().filter(m -> !CUORG_FILEDNAME.equals(m.getProperty())).collect(Collectors.toList());
                QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"mdr_item_info", (Long)Long.valueOf(useorg));
                if (filter != null) {
                    QFilter qFilter = new QFilter("item.id", "in", filter.getValue());
                    filters.add(qFilter);
                } else {
                    filters.add(QFilter.isNull((String)PROP_ID));
                }
            } else {
                QFilter filter = QFilter.isNull((String)PROP_ID);
                filters.add(filter);
            }
        }
        e.setQFilters(filters);
        super.setFilter(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        LocaleString orgPropertyName = new LocaleString("\u4e1a\u52a1\u7ec4\u7ec7");
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            String entityType = "mdr_item_info";
            CommonFilterColumn orgColumn = new CommonFilterColumn();
            orgColumn.setCaption(orgPropertyName);
            orgColumn.setFieldName(CUORG_FILEDNAME);
            orgColumn.setMustInput(true);
            orgColumn.setEntityField(false);
            if (!filterColumnList.contains(orgColumn)) {
                ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
                DynamicObjectCollection col = ItemBarCodeTreeListPlugin.getAllCuOrg(entityType, this.getView());
                String defaultOrg = "";
                if (!CollectionUtils.isEmpty((Collection)col)) {
                    defaultOrg = String.valueOf(((DynamicObject)col.get(0)).get(PROP_ID));
                    for (Object org : col) {
                        if (org == null) continue;
                        ComboItem item = new ComboItem();
                        item.setCaption(new LocaleString(org.getString("name")));
                        item.setValue(String.valueOf(org.get(PROP_ID)));
                        combos.add(item);
                    }
                }
                orgColumn.setComboItems(combos);
                orgColumn.setType("enum");
                String createOrg = this.getPageCache().get(CREATEORG);
                if (StringUtils.isEmpty((CharSequence)createOrg)) {
                    Object org;
                    org = String.valueOf(RequestContext.get().getOrgId());
                    long count = col.stream().filter(arg_0 -> ItemBarCodeTreeListPlugin.lambda$filterContainerInit$3((String)org, arg_0)).count();
                    createOrg = count == 0L ? defaultOrg : org;
                    this.getPageCache().put(CREATEORG, createOrg);
                }
                orgColumn.setDefaultValue(createOrg);
                filterColumnList.add(0, orgColumn);
            }
        }
    }

    protected void delBarcode(String key) {
        ListSelectedRowCollection rows = this.getSelectRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showErrorNotification(NEED_SELECTEDNODE_MSG);
            return;
        }
        List ids = rows.stream().map(M -> M.getPrimaryKeyValue()).collect(Collectors.toList());
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"mdr_item_barcode", (Object[])ids.toArray());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f");
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showOperationResult(result);
        }
    }

    public void openBill(String key) {
        String permId;
        String cuOrg = this.getPageCache().get(CREATEORG);
        boolean hasPerm = PermUtils.checkUserPermItemId((String)cuOrg, (String)"dbd", (String)"mdr_item_barcode", (String)(permId = BTN_NEW.equals(key) ? "47156aff000000ac" : "4715a0df000000ac"));
        if (!hasPerm) {
            this.getView().showErrorNotification("\u4f60\u6ca1\u6709\u7684\u64cd\u4f5c\u6743\u9650");
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mdr_itembarcode_edit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam(CREATEORG, (Object)cuOrg);
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_EDIT)) {
            Object[] pkIds = this.getSelectIds();
            if (pkIds.length == 0) {
                this.getView().showErrorNotification(NEED_SELECTEDNODE_MSG);
                return;
            }
            showParameter.setCustomParam("barcodeids", (Object)pkIds);
        }
        this.getView().showForm(showParameter);
    }

    protected Object[] getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        ids = ids == null ? new Object[]{} : ids;
        return ids;
    }

    protected ListSelectedRowCollection getSelectRows() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null) {
            selectedRows = new ListSelectedRowCollection();
        }
        return selectedRows;
    }

    public static DynamicObjectCollection getAllCuOrg(String entityType, IFormView iview) {
        QFilter extendOrgQFilter;
        String orgFuncPro;
        HasPermOrgResult result;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"mdr_item_info");
        String appNumber = iview.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"mdr_item_info", (String)"47150e89000000ac")) == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)"mdr_item_info");
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)true);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>(10);
        long view = 16L;
        if (null != ctrlview) {
            view = ctrlview.getLong(PROP_ID);
        }
        QFilter f2 = new QFilter("view.id", "=", (Object)view);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)true);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new DynamicObjectCollection();
        }
        DynamicObject[] var17 = viewOrgs;
        int var18 = viewOrgs.length;
        for (int var19 = 0; var19 < var18; ++var19) {
            DynamicObject viewOrg = var17[var19];
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter(PROP_ID, "in", viewOrgIds);
        filterList.add(idsFilter);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
        filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters, (String)PROP_ID);
        return col;
    }

    protected List<QFilter> barcodeFilter() {
        ITreeListView treeListView = ((IListView)this.getView()).getTreeListView();
        String nodeId = treeListView.getTreeView().getTreeState().getFocusNodeId();
        QFilter filter = this.genRefreshFilter(nodeId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (filter != null) {
            qFilters.add(filter);
        }
        return qFilters;
    }

    protected QFilter genRefreshFilter(String nodeId) {
        if (ROOTNODEID.equals(nodeId) || nodeId == null) {
            return null;
        }
        QFilter qFilter = null;
        Object classStandardId = this.getModel().getValue(PROP_STANDARDLST);
        if (nodeId != null && !NO_GROUP.equals(nodeId)) {
            qFilter = new QFilter("item.itemclassentity.classstandardid", "=", (Object)Long.parseLong(classStandardId.toString()));
            List<String> groupIds = this.queryGroupsByGroupId("mdr_item_class", classStandardId, Long.valueOf(nodeId));
            if (groupIds == null) {
                qFilter.and(new QFilter("item.itemclassentity.goodsclasssid", "is null", (Object)""));
            } else {
                ArrayList<Long> longgroupIds = new ArrayList<Long>(groupIds.size());
                for (int i = 0; i < groupIds.size(); ++i) {
                    longgroupIds.add(Long.parseLong(groupIds.get(i)));
                }
                qFilter.and(new QFilter("item.itemclassentity.goodsclasssid", "in", longgroupIds));
            }
        } else {
            HashSet<Long> itemIdSets = new HashSet<Long>();
            qFilter = new QFilter("goodsclasssid", "=", (Object)0);
            DynamicObjectCollection itemDynObjColl = QueryServiceHelper.query((String)"mdr_itemclassentry", (String)PROP_ID, (QFilter[])qFilter.toArray());
            for (DynamicObject itemDynObj : itemDynObjColl) {
                itemIdSets.add(Long.parseLong(itemDynObj.getString(PROP_ID)));
            }
            if (itemIdSets.size() > 0) {
                qFilter = new QFilter(PROP_ID, "in", itemIdSets);
                qFilter.and(new QFilter("goodsclasssid", "!=", (Object)0));
                itemDynObjColl = QueryServiceHelper.query((String)"mdr_itemclassentry", (String)PROP_ID, (QFilter[])qFilter.toArray());
                for (DynamicObject itemDynObj : itemDynObjColl) {
                    itemIdSets.remove(Long.parseLong(itemDynObj.getString(PROP_ID)));
                }
            }
            qFilter = new QFilter("item.itemclassentity.classstandardid", "is null", (Object)"");
            if (itemIdSets.size() > 0) {
                qFilter.or(new QFilter(PROP_ID, "in", itemIdSets));
            }
        }
        return qFilter;
    }

    protected List<String> queryGroupsByGroupId(String entity, Object standardId, Object id) {
        if (id == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String strid = id.toString();
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)entity, (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)Long.parseLong(strid))});
        if (queryOne.getBoolean("isleaf")) {
            list.add(strid);
            return list;
        }
        String longnumber = queryOne.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.parseLong(standardId.toString()));
        QFilter[] qFilters = new QFilter[]{f1, f2};
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), entity, PROP_ID, qFilters);){
            for (Row row : ds) {
                if (row.getString(PROP_ID) == null) continue;
                list.add(row.getString(PROP_ID));
            }
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$filterContainerInit$3(String org, DynamicObject m) {
        return m.getString(PROP_ID).equals(org);
    }
}

