/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemlabel;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.formplugin.itemlabel.ItemLabelTreeListPlugin;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemLabelEditPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ItemLabelTreeListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, new String[]{"item", "materiel"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key = arg0.getProperty().getName();
        int rowIndex = arg0.getRow();
        switch (key) {
            case "auxpty": {
                this.addAssistAttrFilter(arg0, rowIndex);
                break;
            }
            case "item": {
                QFilter qFilter = QFilter.isNotNull((String)"entryentity.id");
                DynamicObjectCollection entryIds = QueryServiceHelper.query((String)"dbd_item_label", (String)"entryentity.id", (QFilter[])qFilter.toArray());
                List existids = entryIds.stream().map(m -> m.get("entryentity.id")).collect(Collectors.toList());
                QFilter dataIdFilter = new QFilter("id", "not in", existids);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.setCustomParam("isFromPos", (Object)"1");
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)dataIdFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = this.getRowIndex(e);
        if ("item".equals(key)) {
            DynamicObject item = (DynamicObject)this.getValue("item", rowIndex);
            if (item != null) {
                Object materielId = ItemUtil.getMaterialId((Object)item.getPkValue());
                if (materielId != null) {
                    this.setValue("materiel", materielId, rowIndex);
                }
            } else {
                this.setValue("materiel", null, rowIndex);
            }
        }
    }

    protected void addAssistAttrFilter(BeforeF7SelectEvent e, int rowIndex) {
        Object itemId = this.getEntryF7PKValue("entryentity", "item", rowIndex);
        if (itemId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01", (String)"ItemLabelEditPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)itemId));
    }
}

