/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemlabel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.drp.dbd.common.enums.EnableStatusEnum;
import kd.drp.mdr.common.constants.OP;
import kd.drp.mdr.common.util.DynamicObjectUtils;

public class ItemLabelTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(ItemLabelTreeListPlugin.class);
    public static final String BILLLISTID = "billlistap";
    private static final String USEORG_FILEDNAME = "useorg.id";
    private static final String CREATEORG_FILEDNAME = "createOrg";
    private static final String ENABLE_FILEDNAME = "enable";
    private static final String LIST_NEW = "tblnew";
    private static final String LIST_EDIT = "tbledit";
    private static final String LIST_DEL = "tbldel";
    private static final String LIST_REFRESH = "tblrefresh";
    private static final String LIST_ENABLE = "tblenable";
    private static final String LIST_DISABLE = "tbldisable";
    private static final String CALLBACKID_DELET_LABEL = "deletelabelcallback";

    private String getNeedSelectedNodeMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6807\u7b7e\u8282\u70b9", (String)"ItemLabelTreeListPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            e.setChildNodes(this.queryItemLabel());
        } else {
            e.setChildNodes(new ArrayList());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals(LIST_NEW) || key.equals(LIST_EDIT) || key.equals(LIST_DEL) || key.equals(LIST_ENABLE) || key.equals(LIST_DISABLE) || key.equals(LIST_REFRESH)) {
            evt.setCancel(true);
            switch (key) {
                case "tblnew": 
                case "tbledit": {
                    String permId = LIST_NEW.equals(key) ? "47156aff000000ac" : "4715a0df000000ac";
                    boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"dbd_item_label", (String)permId);
                    if (!hasPerm) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5355\u636e\u7684\u64cd\u4f5c\u6743\u9650", (String)"ItemLabelTreeListPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.OpenBill(key);
                    break;
                }
                case "tbldel": {
                    this.delLable(key);
                    break;
                }
                case "tblenable": 
                case "tbldisable": {
                    if (this.HasSelectedNode()) {
                        String key_enable = key.equals(LIST_ENABLE) ? ENABLE_FILEDNAME : "disable";
                        String labelId = this.getTreeModel().getCurrentNodeId().toString();
                        this.updateLabel(key_enable, labelId);
                        break;
                    }
                    this.getView().showErrorNotification(this.getNeedSelectedNodeMsg());
                    break;
                }
                case "tblrefresh": {
                    this.refreshTreeNode();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void OpenBill(String key) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("dbd_item_label");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String createOrg = this.getPageCache().get(CREATEORG_FILEDNAME);
        showParameter.setCustomParam("useorgId", (Object)createOrg);
        if (StringUtils.equals((CharSequence)key, (CharSequence)LIST_EDIT)) {
            Object pkId = this.getTreeModel().getCurrentNodeId();
            if (pkId == null || this.isRootNode(pkId.toString())) {
                this.getView().showErrorNotification(this.getNeedSelectedNodeMsg());
                return;
            }
            if (!this.validatelabelCreateOrg(pkId)) return;
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkId);
        } else {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        }
        showParameter.getCustomParams().put("useorgId", this.getPageCache().get(CREATEORG_FILEDNAME));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean validatelabelCreateOrg(Object pkId) {
        String createOrg = this.getPageCache().get(CREATEORG_FILEDNAME);
        if (!StringUtils.isEmpty((CharSequence)createOrg)) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"dbd_item_label", (String)"createorg");
            Object cuOrg = DynamicObjectUtils.getDynamicObjectID((DynamicObject)loadSingle, (String)"createorg");
            if (!createOrg.equals(cuOrg.toString())) {
                this.getView().showErrorNotification("\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u8be5\u57fa\u7840\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7,\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e");
                return false;
            }
            return true;
        }
        this.getView().showErrorNotification("\u8be5\u57fa\u7840\u8d44\u6599\u6ca1\u6709\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7,\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e");
        return false;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String labelId = e.getNodeId().toString();
        List filters = e.getFilters();
        QFilter filter = QFilter.isNotNull((String)"entryentity.id");
        if (!this.isRootNode(labelId)) {
            filter.and("id", "=", (Object)Long.parseLong(labelId));
        }
        e.addQFilter(filter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters = qFilters.stream().filter(m -> !"id".equals(m.getProperty()) || !"in".equals(m.getCP())).collect(Collectors.toList());
        e.setQFilters(qFilters);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            Object orgId = null;
            List fieldNames = (List)currentCommonFilter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0) {
                return;
            }
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (!USEORG_FILEDNAME.equals(fieldNames.get(i).toString())) continue;
                this.refreshTreeNode();
            }
        }
        if (customFiterList != null) {
            for (Map customFiter : customFiterList) {
                String enableCache;
                List enables;
                List fieldNames = (List)customFiter.get("FieldName");
                if (fieldNames == null || fieldNames.size() == 0 || !ENABLE_FILEDNAME.equals(fieldNames.get(0)) || (enables = (List)customFiter.get("Value")) == null || enables.size() == 0) continue;
                String enable = String.valueOf(enables.get(0));
                if (enable.equals(enableCache = this.getPageCache().get(ENABLE_FILEDNAME))) {
                    return;
                }
                this.getPageCache().put(ENABLE_FILEDNAME, enable);
                this.refreshTreeNode();
            }
        }
    }

    private void refreshTreeNode() {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeNode root = this.getTreeModel().createRootNode();
        this.treeListView.getTreeView().deleteAllNodes();
        treeView.addNode(root);
        treeView.queryTreeNodeChildren(root.getParentid(), root.getId());
    }

    protected List<TreeNode> queryItemLabel() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String cuOrg = this.getPageCache().get(CREATEORG_FILEDNAME);
        QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"dbd_item_label", (Long)Long.valueOf(cuOrg));
        qFilters.add(filter);
        List enableValue = ((IListView)this.getView()).getControlFilters().getFilter(ENABLE_FILEDNAME);
        if (!CollectionUtils.isEmpty((Collection)enableValue) && kd.drp.mdr.common.StringUtils.isNotEmpty(enableValue.get(0))) {
            QFilter qFilter = new QFilter(ENABLE_FILEDNAME, "=", enableValue.get(0));
            qFilters.add(qFilter);
        }
        DynamicObject[] itemLabels = BusinessDataServiceHelper.load((String)"dbd_item_label", (String)"id,name,number,enable", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        ArrayList<TreeNode> datas = new ArrayList<TreeNode>(itemLabels.length);
        TreeNode root = this.getTreeModel().getRoot();
        for (DynamicObject dynamicObject : itemLabels) {
            String enableStateText = dynamicObject.getString(ENABLE_FILEDNAME).equals(EnableStatusEnum.ENABLE.getValue()) ? ResManager.loadKDString((String)"\u53ef\u7528", (String)"ItemLabelTreeListPlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"ItemLabelTreeListPlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
            String text = dynamicObject.getString("name") + "(" + enableStateText + ")";
            TreeNode node = new TreeNode(root.getId(), dynamicObject.getPkValue().toString(), text);
            datas.add(node);
        }
        return datas;
    }

    private void delLable(String key) {
        ITreeModel treeModel = this.getTreeModel();
        Object currNodeId = treeModel.getCurrentNodeId();
        if (currNodeId == null || this.isRootNode(currNodeId.toString())) {
            this.getView().showErrorNotification(this.getNeedSelectedNodeMsg());
            return;
        }
        if (this.validatelabelCreateOrg(currNodeId)) {
            String msg = treeModel.getRoot().getTreeNode(currNodeId.toString(), 1).getText();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACKID_DELET_LABEL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u88ab\u9009\u4e2d\u7684\u5546\u54c1\u6807\u7b7e:", (String)"ItemLabelTreeListPlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]) + msg, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)CALLBACKID_DELET_LABEL, (CharSequence)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            Object labelId = this.getTreeModel().getCurrentNodeId();
            BillList billList = (BillList)this.getControl(BILLLISTID);
            ListSelectedRowCollection currentListAllRowCollection = billList.getCurrentListAllRowCollection();
            if (currentListAllRowCollection.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6807\u7b7e\u4e0b\u5b58\u5728\u5173\u8054\u7684\u5546\u54c1\uff0c\u4e0d\u5bb9\u8bb8\u5220\u9664", (String)"ItemLabelTreeListPlugin_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            } else {
                this.updateLabel("delete", labelId.toString());
            }
        }
    }

    private void updateLabel(String key, String labelId) {
        if (this.validatelabelCreateOrg(labelId)) {
            OperationResult result = OperationServiceHelper.executeOperate((String)key, (String)"dbd_item_label", (Object[])new Object[]{labelId});
            if (result != null && result.isSuccess()) {
                ITreeModel treeModel = this.getTreeModel();
                String rootNodeId = treeModel.getRoot().getId();
                treeModel.setCurrentNodeId((Object)rootNodeId);
                this.getView().showSuccessNotification(OP.getName((String)key) + ResManager.loadKDString((String)"\u6210\u529f", (String)"ItemLabelTreeListPlugin_8", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                this.getTreeListView().refreshTreeView();
            } else {
                this.getView().showOperationResult(result);
            }
        }
    }

    public boolean HasSelectedNode() {
        return !this.isRootNode(this.getTreeModel().getCurrentNodeId().toString());
    }

    public boolean isRootNode(String nodeId) {
        return this.getTreeModel().getRoot().getId().equals(nodeId);
    }
}

