/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.business.handle.SpuHandler;
import kd.drp.dbd.common.util.BarcodeUtil;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class ItemPriceChangeEdit
extends MdrBillPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"barcode", "customerid", "item"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONArray jids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        if (jids != null && jids.size() > 0) {
            this.initdefaultdata(jids.toArray());
        }
    }

    private void initdefaultdata(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)ORMUtil.appendFieldsToStr((String[])new String[]{"barcode", "createorg", "currency", "customer"}), (QFilter[])qFilter.toArray());
        IDataModel dataModel = this.getModel();
        if (ids.length == 1) {
            this.setValue("currency", ((DynamicObject)datas.get(0)).get("currency"), false);
            dataModel.batchCreateNewEntryRow("customer_entry", ids.length);
            this.setValue("customerid", ((DynamicObject)datas.get(0)).get("customer"), 0, false);
        }
        dataModel.batchCreateNewEntryRow("item_entry", ids.length);
        for (int i = 0; i < datas.size(); ++i) {
            dataModel.setValue("barcode", ((DynamicObject)datas.get(i)).get("barcode"), i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("barcode".equals(propertyName)) {
            ChangeData[] datas = e.getChangeSet();
            for (int i = 0; i < datas.length; ++i) {
                int index = datas[i].getRowIndex();
                Object object = datas[i].getNewValue();
                if (object != null) {
                    DynamicObject barcodeDy = (DynamicObject)object;
                    this.changeBarcode(barcodeDy, index);
                    continue;
                }
                this.getModel().setValue("item", null, index);
            }
        }
    }

    private void changeBarcode(Object barcodeOb, int index) {
        IDataModel dataModel = this.getModel();
        if (barcodeOb != null) {
            DynamicObject barcodeDy = (DynamicObject)barcodeOb;
            long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)barcodeDy, (String)"auxpty");
            List spuList = SpuHandler.matchSpuByItem((Object)barcodeDy.getDynamicObject("item").getPkValue(), (Object)auxptyId, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"name", "number"}));
            if (CollectionUtils.isEmpty((Collection)spuList) || spuList.size() == 1) {
                long spuId = CollectionUtils.isEmpty((Collection)spuList) ? 0L : (Long)((DynamicObject)spuList.get(0)).getPkValue();
                dataModel.setValue("spuid", (Object)spuId, index);
                dataModel.setValue("item", barcodeDy.get("item"), index);
                dataModel.setValue("materiel", barcodeDy.get("materiel"), index);
                dataModel.setValue("unit", barcodeDy.get("unit"), index);
                dataModel.setValue("auxpty", barcodeDy.get("auxpty"), index);
                dataModel.setValue("memberprice", barcodeDy.get("memberprice"), index);
                dataModel.setValue("retailprice", barcodeDy.get("retailprice"), index);
            } else {
                dataModel.batchInsertEntryRow("entryentity_item", index, spuList.size());
                for (int i = 0; i < spuList.size(); ++i) {
                }
            }
        } else {
            dataModel.setValue("item", null, index);
            dataModel.setValue("spuid", null, index);
            dataModel.setValue("materiel", null, index);
            dataModel.setValue("unit", null, index);
            dataModel.setValue("auxpty", null, index);
            dataModel.setValue("memberprice", (Object)0, index);
            dataModel.setValue("retailprice", (Object)0, index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key;
        switch (key = arg0.getProperty().getName()) {
            case "barcode": {
                QFilter qFilter = this.barcodeFilter();
                if (qFilter == null) break;
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)qFilter);
                break;
            }
            case "customerid": {
                QFilter Filter = new QFilter("isstore", "=", (Object)Enable.ENABLE);
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)Filter);
                break;
            }
        }
    }

    protected QFilter barcodeFilter() {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7");
            return null;
        }
        QFilter qFilter = BarcodeUtil.queryInsideBarcodeF7((String)orgId.toString());
        List barcodeids = this.getEntryF7PKValue("item_entry", "barcode");
        if (!CollectionUtils.isEmpty((Collection)barcodeids)) {
            qFilter.and("id", "not in", (Object)barcodeids);
        }
        return qFilter;
    }
}

