/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.orm.query.QFilter;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.ItemSaleContentUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class ItemPriceChangeTplEdit
extends MdrBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"unit", "customerid", "customergroupid"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object createOrgId = this.getView().getFormShowParameter().getCustomParam("createorg");
        if (!StringUtils.isEmpty((Object)createOrgId)) {
            this.setValue("createorg", createOrgId, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "createorg": {
                this.getModel().deleteEntryData("customer_entry");
                this.getModel().deleteEntryData("item_entry");
                break;
            }
            case "currency": {
                this.getModel().deleteEntryData("item_entry");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key;
        switch (key = arg0.getProperty().getName()) {
            case "customerid": {
                QFilter qFilters = this.addCustomerIdFilter(arg0);
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)qFilters);
                break;
            }
            case "customergroupid": {
                QFilter qFilters1 = this.addCustomerGroupFilter(arg0);
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)qFilters1);
                break;
            }
            case "unit": {
                this.addUnitFilter(arg0, arg0.getRow());
                break;
            }
        }
    }

    protected void addUnitFilter(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject item = this.getModel().getEntryRowEntity("item_entry", rowIndex).getDynamicObject("item");
        if (item == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01");
            e.setCancel(true);
            return;
        }
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material");
        long retailUnitId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"retailunit");
        if (retailUnitId != 0L && materialId != 0L) {
            QFilter f = new QFilter("id", "in", (Object)QueryUtil.getAssistMUListResult((Long)materialId, (Long)retailUnitId, (String)"2"));
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)f);
        }
    }

    protected QFilter addCustomerGroupFilter(BeforeF7SelectEvent var1) {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7", (String)"ItemSaleContentPublishEdit_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        Object currencyId = this.getF7PKValue("currency");
        if (currencyId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"ItemSaleContentPublishEdit_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        List excludeIds = this.getEntryF7PKValue("entryentity_customer", "customergroupid");
        QFilter filter = new QFilter("id", "not in", (Object)excludeIds);
        return filter;
    }

    protected QFilter addCustomerIdFilter(BeforeF7SelectEvent var1) {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7", (String)"ItemPriceChangeEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        Object currencyId = this.getF7PKValue("currency");
        if (currencyId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"ItemPriceChangeEdit_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        QFilter Filter = new QFilter("currency", "=", currencyId);
        List excludeIds = this.getEntryF7PKValue("customer_entry", "customerid");
        QFilter filter = new QFilter("id", "not in", (Object)excludeIds);
        filter.and("currency", "=", currencyId);
        Filter.and(filter);
        return Filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = this.getOpKey(afterDoOperationEventArgs);
        if ("audit".equals(key) && this.getOperationResult(afterDoOperationEventArgs)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            OperateOption option = ((EntityOperate)afterDoOperationEventArgs.getSource()).getOption();
            String resultStr = option.getVariableValue("itemsale_content_result");
            OperationResult operationResult = ItemSaleContentUtils.jsonStr2OperationResult((String)resultStr);
            this.getView().showOperationResult(operationResult, "\u8c03\u6574\u5546\u54c1\u76ee\u5f55");
        }
    }
}

