/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.dbd.business.handle.SpuHandler;
import kd.drp.dbd.common.util.BarcodeUtil;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class ItemSaleContentPublishEdit
extends MdrBillPlugin
implements BeforeF7SelectListener {
    public static final String SAVE = "save";
    public static final String CLOSE = "close";
    private static Log logger = LogFactory.getLog(ItemSaleContentPublishEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"barcode", "customerid"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("barcodeids");
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            this.initDefaultEntry(ids.toArray());
        } else {
            this.setEnable(new String[]{"createorg"});
        }
    }

    private void initDefaultEntry(Object[] ids) {
        DynamicObject[] data = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mdr_item_barcode"));
        if (ids.length == 1) {
            this.setValue("currency", data[0].get("currency"), false);
        }
        IDataModel dataModel = this.getModel();
        dataModel.batchCreateNewEntryRow("entryentity_item", ids.length);
        for (int i = 0; i < ids.length; ++i) {
            dataModel.setValue("barcode", data[i].get("id"), i);
            this.changeBarcode(data[i], i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent var1) {
        String key;
        switch (key = var1.getProperty().getName()) {
            case "customerid": {
                QFilter Filter = new QFilter("isstore", "=", (Object)Enable.ENABLE);
                F7Utils.addF7Filter((BeforeF7SelectEvent)var1, (QFilter)Filter);
                break;
            }
            case "barcode": {
                QFilter qFilter1 = this.addBarcodeFilter(var1);
                F7Utils.addF7Filter((BeforeF7SelectEvent)var1, (QFilter)qFilter1);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "barcode": {
                ChangeData[] datas = e.getChangeSet();
                for (int i = 0; i < datas.length; ++i) {
                    int index = datas[i].getRowIndex();
                    Object object = datas[i].getNewValue();
                    this.changeBarcode(object, index);
                }
                break;
            }
        }
    }

    private void changeBarcode(Object barcodeOb, int index) {
        IDataModel dataModel = this.getModel();
        if (barcodeOb != null) {
            DynamicObject barcodeDy = (DynamicObject)barcodeOb;
            long auxptyId = DynamicObjectUtils.getPkValue((DynamicObject)barcodeDy, (String)"auxpty");
            List spuList = SpuHandler.matchSpuByItem((Object)barcodeDy.getDynamicObject("item").getPkValue(), (Object)auxptyId, (String)ORMUtil.appendFieldsToStr((String[])new String[]{"name", "number"}));
            if (CollectionUtils.isEmpty((Collection)spuList) || spuList.size() == 1) {
                long spuId = CollectionUtils.isEmpty((Collection)spuList) ? 0L : (Long)((DynamicObject)spuList.get(0)).getPkValue();
                dataModel.setValue("spuid", (Object)spuId, index);
                dataModel.setValue("item", barcodeDy.get("item"), index);
                dataModel.setValue("materiel", barcodeDy.get("materiel"), index);
                dataModel.setValue("unit", barcodeDy.get("unit"), index);
                dataModel.setValue("auxpty", barcodeDy.get("auxpty"), index);
                dataModel.setValue("memberprice", barcodeDy.get("memberprice"), index);
                dataModel.setValue("retailprice", barcodeDy.get("retailprice"), index);
            } else {
                dataModel.batchInsertEntryRow("entryentity_item", index, spuList.size());
                for (int i = 0; i < spuList.size(); ++i) {
                }
            }
        } else {
            dataModel.setValue("item", null, index);
            dataModel.setValue("spuid", null, index);
            dataModel.setValue("materiel", null, index);
            dataModel.setValue("unit", null, index);
            dataModel.setValue("auxpty", null, index);
            dataModel.setValue("memberprice", (Object)0, index);
            dataModel.setValue("retailprice", (Object)0, index);
        }
    }

    protected QFilter addBarcodeFilter(BeforeF7SelectEvent var1) {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7");
            return null;
        }
        QFilter qFilter = BarcodeUtil.queryInsideBarcodeF7((String)orgId.toString());
        List barcodeids = this.getEntryF7PKValue("item_entry", "barcode");
        if (!CollectionUtils.isEmpty((Collection)barcodeids)) {
            qFilter.and("id", "not in", (Object)barcodeids);
        }
        return qFilter;
    }
}

