/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.orm.query.QFilter;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.ItemSaleContentUtils;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class ItemSaleContentPublishTplEdit
extends MdrBillPlugin
implements BeforeF7SelectListener {
    public static final String SAVE = "save";
    public static final String CLOSE = "close";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"customerid", "customergroupid", "unit"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object createOrgId = this.getView().getFormShowParameter().getCustomParam("createorg");
        if (!StringUtils.isEmpty((Object)createOrgId)) {
            this.setValue("createorg", createOrgId, false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent var1) {
        String key;
        switch (key = var1.getProperty().getName()) {
            case "customerid": {
                QFilter qFilters = this.addCustomerFilter(var1);
                F7Utils.addF7Filter((BeforeF7SelectEvent)var1, (QFilter)qFilters);
                break;
            }
            case "customergroupid": {
                QFilter qFilters1 = this.addCustomerGroupFilter(var1);
                F7Utils.addF7Filter((BeforeF7SelectEvent)var1, (QFilter)qFilters1);
                break;
            }
            case "unit": {
                this.addUnitFilter(var1, var1.getRow());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "createorg": {
                this.getModel().deleteEntryData("entryentity_customer");
                this.getModel().deleteEntryData("entryentity_item");
                break;
            }
            case "currency": {
                this.getModel().deleteEntryData("entryentity_customer");
                break;
            }
        }
    }

    protected QFilter addCustomerFilter(BeforeF7SelectEvent var1) {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7", (String)"ItemSaleContentPublishEdit_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        Object currencyId = this.getF7PKValue("currency");
        if (currencyId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"ItemSaleContentPublishEdit_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        List excludeIds = this.getEntryF7PKValue("entryentity_customer", "customerid");
        QFilter filter = new QFilter("id", "not in", (Object)excludeIds);
        filter.and("currency", "=", currencyId);
        return filter;
    }

    protected QFilter addCustomerGroupFilter(BeforeF7SelectEvent var1) {
        Object orgId = this.getF7PKValue("createorg");
        if (orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7", (String)"ItemSaleContentPublishEdit_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        Object currencyId = this.getF7PKValue("currency");
        if (currencyId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b", (String)"ItemSaleContentPublishEdit_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            var1.setCancel(true);
            return null;
        }
        List excludeIds = this.getEntryF7PKValue("entryentity_customer", "customergroupid");
        QFilter filter = new QFilter("id", "not in", (Object)excludeIds);
        return filter;
    }

    protected void addUnitFilter(BeforeF7SelectEvent e, int rowIndex) {
        DynamicObject item = this.getModel().getEntryRowEntity("entryentity_item", rowIndex).getDynamicObject("item");
        if (item == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01");
            e.setCancel(true);
            return;
        }
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"material");
        long retailUnitId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"retailunit");
        if (retailUnitId != 0L && materialId != 0L) {
            QFilter f = new QFilter("id", "in", (Object)QueryUtil.getAssistMUListResult((Long)materialId, (Long)retailUnitId, (String)"2"));
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)f);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = this.getOpKey(afterDoOperationEventArgs);
        if ("audit".equals(key) && this.getOperationResult(afterDoOperationEventArgs)) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            OperateOption option = ((EntityOperate)afterDoOperationEventArgs.getSource()).getOption();
            String resultStr = option.getVariableValue("itemsale_content_result");
            OperationResult operationResult = ItemSaleContentUtils.jsonStr2OperationResult((String)resultStr);
            this.getView().showOperationResult(operationResult, "\u53d1\u5e03\u5546\u54c1\u76ee\u5f55");
        }
    }
}

