/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemSaleContentStatePlugin
extends MdrFormPlugin {
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_RETAILSTATE = "retailstate";
    private static Log logger = LogFactory.getLog(ItemSaleContentStatePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object billFormId = this.getView().getFormShowParameter().getCustomParam("billFormId");
        MulComboProp prop = (MulComboProp)MetadataServiceHelper.getDataEntityType((String)billFormId.toString()).getFields().get(KEY_RETAILSTATE);
        List comboItems = prop.getComboItems();
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(KEY_RETAILSTATE);
        this.setComboValue(mulComboEdit, comboItems);
    }

    private void setComboValue(MulComboEdit comboEdit, List<ValueMapItem> comboItems) {
        ArrayList<ComboItem> comboItemlist = new ArrayList<ComboItem>(16);
        for (ValueMapItem entry : comboItems) {
            ComboItem item = new ComboItem(entry.getName(), entry.getValue());
            comboItemlist.add(item);
        }
        comboEdit.setComboItems(comboItemlist);
        comboEdit.selectedStore(comboItemlist);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_OK)) {
            JSONArray jids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
            if (jids != null && !jids.isEmpty()) {
                DynamicObject[] dataEntities;
                Object value = this.getModel().getValue(KEY_RETAILSTATE);
                Object billFormId = this.getView().getFormShowParameter().getCustomParam("billFormId");
                Object[] ids = jids.toArray();
                QFilter qFilter = new QFilter("id", "in", (Object)ids);
                for (DynamicObject dynamicObject : dataEntities = BusinessDataServiceHelper.load((String)billFormId.toString(), (String)KEY_RETAILSTATE, (QFilter[])qFilter.toArray())) {
                    dynamicObject.set(KEY_RETAILSTATE, value);
                }
                try {
                    SaveServiceHelper.save((DynamicObject[])dataEntities);
                    this.getView().returnDataToParent(null);
                    this.getView().close();
                }
                catch (Exception e) {
                    this.getView().showErrorNotification("\u8bbe\u7f6e\u5931\u8d25");
                    logger.error((Throwable)e);
                }
            }
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_CANCEL)) {
            this.getView().returnDataToParent(null);
            this.getView().close();
        }
    }
}

