/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.itemsalecontent;

import java.util.Collection;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.dbd.common.util.PermUtils;
import kd.drp.mdr.formplugin.MdrListPlugin;

public class ItemSaleContentTplList
extends MdrListPlugin {
    private static final String OP_PUBLISH = "publish";
    private static final String OP_CHANGE = "change";
    private static final String OP_RETAILSTATE = "retailstatechange";
    private static Log logger = LogFactory.getLog(ItemSaleContentTplList.class);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        if (this.getOperationResult(e) && (key = e.getOperateKey()).equals(OP_RETAILSTATE)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            Object[] selectIds = this.getListView().getSelectedRows().getPrimaryKeyValues();
            showParameter.setCustomParam("ids", (Object)selectIds);
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String entity = listShowParameter.getBillFormId();
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_RETAILSTATE));
            showParameter.setFormId("dbd_contentstate_setting");
            showParameter.setCustomParam("billFormId", (Object)entity);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String orgId;
        super.beforeDoOperation(evt);
        FormOperate op = (FormOperate)evt.getSource();
        String key = op.getOperateKey();
        IListView listView = (IListView)this.getView();
        ControlFilters co = listView.getControlFilters();
        List filterValue = co.getFilter("createorg.id");
        String string = orgId = !CollectionUtils.isEmpty((Collection)filterValue) ? filterValue.get(0).toString() : "";
        if (key.equals(OP_PUBLISH) || key.equals(OP_CHANGE)) {
            evt.setCancel(true);
            String entityNum = this.getEntityNumber(key);
            String appId = MetadataServiceHelper.getDataEntityType((String)entityNum).getAppId();
            boolean hasPerm = PermUtils.checkUserPermItemId((String)orgId, (String)appId, (String)entityNum, (String)"47156aff000000ac");
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u8be5\u5355\u636e\u7684\u65b0\u589e\u6743\u9650", (String)"ItemSaleContentList_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setFormId(entityNum);
            showParameter.setCustomParam("createorg", (Object)orgId);
            Object[] selectIds = this.getListView().getSelectedRows().getPrimaryKeyValues();
            if (selectIds != null && selectIds.length > 0) {
                showParameter.setCustomParam("ids", (Object)selectIds);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)OP_RETAILSTATE)) {
            this.getListView().refresh();
        }
    }

    private String getEntityNumber(String key) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        String entityNum = "";
        switch (key) {
            case "publish": {
                entityNum = entity.equals("dbd_itemsale_content") ? "dbd_itemsale_publish" : "olmm_itemsale_publish";
                break;
            }
            case "change": {
                entityNum = entity.equals("dbd_itemsale_content") ? "dbd_item_pricechange" : "olmm_item_pricechange";
            }
        }
        return entityNum;
    }
}

