/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.marketactivity;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.helper.CurrencyHelper;
import kd.drp.dbd.business.helper.MarketActivityHelper;
import kd.drp.dbd.enums.ControlMethodEnum;
import kd.drp.dbd.utils.DynamicObjectUtil;

public class MarketActivityEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketTypeEdit = (BasedataEdit)this.getView().getControl("tickettypeid");
        ticketTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        if (e.getChangeSet().length <= 0) {
            return;
        }
        IDataModel dataModel = this.getView().getModel();
        switch (propertyName = e.getProperty().getName()) {
            case "orgrange": {
                DynamicObjectCollection customerGroups = (DynamicObjectCollection)dataModel.getValue("customergroup");
                if (customerGroups != null && customerGroups.size() > 0) {
                    this.setViewValue("customergroup");
                }
                DynamicObjectCollection orgRanges = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                MarketActivityHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)orgRanges, (boolean)true);
                this.expand();
                break;
            }
            case "customergroup": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)dataModel.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.setViewValue("orgrange");
                }
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                MarketActivityHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)customerGroup, (boolean)false);
                this.expand();
                break;
            }
            case "isvalidityctl": {
                this.setStartTimeEndTime(dataModel);
                break;
            }
            case "controlmethod": {
                String controlMethod = String.valueOf(e.getChangeSet()[0].getNewValue());
                if (ControlMethodEnum.ISAPPLYBRANCH.getControlMethod().equals(controlMethod)) break;
                dataModel.deleteEntryData("treeentryentity");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "tickettypeid": {
                if (dataModel.getEntryEntity("mktatictentry").size() <= 0) break;
                showParameter.getListFilterParameter().setQFilters(this.buildTicketTypeFilters(dataModel));
                break;
            }
        }
    }

    private List<QFilter> buildTicketTypeFilters(IDataModel dataModel) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter ticketTypeFilter = null;
        DynamicObjectCollection ticketTypeEntryColl = dataModel.getEntryEntity("mktatictentry");
        ArrayList<Long> selectedTicketTypeIds = null;
        if (ticketTypeEntryColl.size() > 0) {
            selectedTicketTypeIds = new ArrayList<Long>(ticketTypeEntryColl.size());
            for (DynamicObject ticketTypeEntry : ticketTypeEntryColl) {
                if (this.getBaseDataLongPkId(ticketTypeEntry, "tickettypeid") <= 0L) continue;
                selectedTicketTypeIds.add(this.getBaseDataLongPkId(ticketTypeEntry, "tickettypeid"));
            }
        }
        if (!CollectionUtils.isEmpty(selectedTicketTypeIds)) {
            ticketTypeFilter = new QFilter("id", "not in", selectedTicketTypeIds);
        }
        qFilters.add(ticketTypeFilter);
        return qFilters;
    }

    protected long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }

    private void setStartTimeEndTime(IDataModel dataModel) {
        boolean isValidityCtl = dataModel.getDataEntity().getBoolean("isvalidityctl");
        FieldEdit startTimeEdit = (FieldEdit)this.getView().getControl("starttime");
        FieldEdit endTimeEdit = (FieldEdit)this.getView().getControl("endtime");
        if (isValidityCtl) {
            this.setEnable("starttime");
            this.setEnable("endtime");
            dataModel.setValue("starttime", (Object)TimeServiceHelper.now());
            this.setMustInput(startTimeEdit);
            this.setMustInput(endTimeEdit);
        } else {
            dataModel.setValue("starttime", null);
            dataModel.setValue("endtime", null);
            this.setDisable("starttime");
            this.setDisable("endtime");
            this.setDisMustInput(startTimeEdit);
            this.setDisMustInput(endTimeEdit);
        }
        this.getView().updateView("starttime");
        this.getView().updateView("endtime");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDefaultOrg();
        this.initDefaultLocalCurrency();
        this.initEnable();
    }

    private void initEnable() {
        this.setDisable("starttime");
        this.setDisable("endtime");
    }

    private void initDefaultOrg() {
        this.getView().getModel().setValue("bizorgid", (Object)RequestContext.get().getOrgId());
        this.getView().updateView("bizorgid");
    }

    private void initDefaultLocalCurrency() {
        long bizOrgId = RequestContext.get().getOrgId();
        if (bizOrgId <= 0L) {
            return;
        }
        DynamicObject currencyDyn = CurrencyHelper.getCurrency((Long)bizOrgId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)currencyDyn);
        if (currencyId > 0L) {
            this.getView().getModel().setItemValueByID("localcurrencyid", (Object)currencyId, 0);
        } else {
            this.getView().getModel().setValue("localcurrencyid", null);
        }
        this.getView().updateView("localcurrencyid");
    }

    private void setDisMustInput(FieldEdit fieldEdit) {
        fieldEdit.setMustInput(false);
    }

    private void setMustInput(FieldEdit fieldEdit) {
        fieldEdit.setMustInput(true);
    }

    private void setDisable(String fieldKey) {
        this.getView().setEnable(Boolean.FALSE, new String[]{fieldKey});
    }

    private void setEnable(String fieldKey) {
        this.getView().setEnable(Boolean.TRUE, new String[]{fieldKey});
    }

    private void setViewValue(String propertyName) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(propertyName, null);
        this.getView().updateView(propertyName);
        this.getView().getModel().endInit();
    }

    private void expand() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }
}

