/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.mdritem;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.dbd.common.enums.EnableStatusEnum;
import kd.drp.dbd.common.enums.GoodsBelongEnum;
import kd.drp.dbd.common.enums.GoodsTypeEnum;
import kd.drp.dbd.common.enums.StatusEnum;
import kd.drp.dbd.common.util.F7Utils;
import kd.drp.dbd.servicehelper.DBDServiceHelper;
import kd.drp.mdr.common.CommonUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.template.BeForeF7Template;

public class MdrItemInfoList
extends AbstractTreeListPlugin {
    private static final String CUORG_FILEDNAME = "createorg.id";
    private static final String SALECHANNEL_FILEDNAME = "owner.id";
    private static final String IMPORT_FROM_MATERIAL = "importfrommaterial";
    public static final String OP_SAVE = "save";
    public static final String ISINNERORG = "isinnerorg";
    public static final String COMBINATION_CHILD = "combinationchild";
    public static final String ITEMMULCUSTOMERUPGRADE = "itemmulcustomerupgrade";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        String key;
        switch (key = e.getFieldName()) {
            case "owner.id": {
                e.getQfilters().clear();
                BeForeF7Template.fastAddListF7Filter((BeforeFilterF7SelectEvent)e, (QFilter)UserUtil.getOwnerIdsQFilter((String)"id"));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (!param.isLookUp()) {
            List filters = e.getQFilters();
            filters = filters.stream().filter(m -> !SALECHANNEL_FILEDNAME.equals(m.getProperty())).collect(Collectors.toList());
            String channelId = this.getPageCache().get(SALECHANNEL_FILEDNAME);
            if (StringUtils.isNotEmpty((String)channelId)) {
                QFilter qFilter = new QFilter("mulowner.fbasedataid", "=", (Object)Long.parseLong(channelId));
                filters.add(qFilter);
            } else {
                DynamicObjectCollection channelColl = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])UserUtil.getOwnerIdsQFilter((String)"id").toArray());
                QFilter qFilter = null;
                if (!CommonUtils.isNull((Object)channelColl)) {
                    Set channelIdSet = channelColl.stream().map(dynObj -> dynObj.getLong("id")).collect(Collectors.toSet());
                    channelIdSet.add(0L);
                    qFilter = new QFilter("mulowner.fbasedataid", "in", (Object)channelIdSet.toArray());
                } else {
                    qFilter = new QFilter("mulowner.fbasedataid", "=", null);
                }
                filters.add(qFilter);
            }
            e.setQFilters(filters);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        LocaleString orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053", (String)"MdrItemInfoList_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            CommonFilterColumn channelColumn = new CommonFilterColumn();
            channelColumn.setCaption(orgPropertyName);
            channelColumn.setFieldName(SALECHANNEL_FILEDNAME);
            channelColumn.setMustInput(true);
            channelColumn.setEntityField(false);
            if (!filterColumnList.contains(channelColumn)) {
                String createOrg = this.getPageCache().get(CUORG_FILEDNAME);
                if (StringUtils.isEmpty((String)createOrg)) {
                    ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
                    DynamicObject[] customerDynObjs = BusinessDataServiceHelper.load((String)"mdr_customer", (String)String.join((CharSequence)",", "name"), (QFilter[])UserUtil.getOwnerIdsQFilter((String)"id").toArray());
                    if (!CommonUtils.isNull((Object)customerDynObjs)) {
                        ComboItem item = new ComboItem();
                        item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"MdrItemInfoList_1", (String)"drp-dbd-formplugin", (Object[])new Object[0])));
                        item.setValue("");
                        combos.add(item);
                        for (DynamicObject custDynObj : customerDynObjs) {
                            item = new ComboItem();
                            item.setCaption(new LocaleString(custDynObj.getString("name")));
                            item.setValue(String.valueOf(custDynObj.get("id")));
                            combos.add(item);
                        }
                        channelColumn.setComboItems(combos);
                        channelColumn.setType("enum");
                        String channelId = customerDynObjs[0].getPkValue().toString();
                        if (this.getPageCache().get(SALECHANNEL_FILEDNAME) != null) {
                            channelId = this.getPageCache().get(SALECHANNEL_FILEDNAME);
                        }
                        this.getPageCache().put(SALECHANNEL_FILEDNAME, channelId);
                        channelColumn.setDefaultValue(channelId);
                    }
                }
                filterColumnList.add(1, channelColumn);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String channelId = null;
        for (Map customFiter : customFiterList) {
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0) continue;
            switch (fieldNames.get(0).toString()) {
                case "owner.id": {
                    List orgIds = (List)customFiter.get("Value");
                    if (orgIds == null || orgIds.size() == 0) break;
                    channelId = String.valueOf(orgIds.get(0));
                    this.getPageCache().put(SALECHANNEL_FILEDNAME, channelId);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        if (StringUtils.isEmpty((String)this.getPageCache().get("createOrg"))) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        long useOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (IMPORT_FROM_MATERIAL.equalsIgnoreCase(op.getOperateKey())) {
            int checkPermission;
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
            String appNumber = this.getView().getFormShowParameter().getAppId();
            String appid = null;
            if (!StringUtils.isBlank((String)appNumber)) {
                try {
                    appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
                }
                catch (Exception ex) {
                    appid = met.getAppId();
                }
            }
            if ((checkPermission = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)useOrgId, (String)appid, (String)entity, (String)"47156aff000000ac")) != 1) {
                e.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c", (String)"MdrItemInfoList_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return;
            }
            List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appid);
            if (createOrgs.isEmpty()) {
                e.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa", (String)"MdrItemInfoList_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            } else {
                if (this.getPageCache().get("createOrg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f7f\u7528\u7ec4\u7ec7", (String)"MdrItemInfoList_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    e.cancel = true;
                    return;
                }
                if (!createOrgs.contains(useOrgId) && createOrgs.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e", (String)"MdrItemInfoList_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    e.cancel = true;
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "importfrommaterial": {
                String channelId = this.getPageCache().get(SALECHANNEL_FILEDNAME);
                if (StringUtils.isEmpty((String)channelId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u6e20\u9053\u3002", (String)"MdrItemInfoList_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter qFilter = new QFilter("id", "in", (Object)Long.parseLong(channelId));
                DynamicObjectCollection channelObjColl = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{qFilter, F7Utils.getEnableStatus(), F7Utils.getCommonStatusFilter()});
                if (CommonUtils.isNull((Object)channelObjColl)) {
                    this.getView().showMessage("\u9500\u552e\u6e20\u9053\u975e\u53ef\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u3002");
                    return;
                }
                this.showImportFromMaterialPage();
                break;
            }
            case "itemmulcustomerupgrade": {
                DBDServiceHelper.itemMulCustomerUpgrade();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
        if (rows == null || rows.size() == 0) {
            return;
        }
        List<Object> ids = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (key) {
            case "importfrommaterial": {
                this.importItemFromMaterial(ids);
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refresh();
                break;
            }
        }
    }

    private void showImportFromMaterialPage() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_material", (boolean)true, (int)0, (boolean)true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_FROM_MATERIAL));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        Set existBdMaterialIds = QueryUtil.querySingleCol((String)"mdr_item_info", (String)"material.id", (QFilter[])new QFilter("material.id", ">", (Object)0L).toArray());
        if (!existBdMaterialIds.isEmpty()) {
            listFilterParameter.getQFilters().add(new QFilter("id", "not in", (Object)existBdMaterialIds));
        }
        listFilterParameter.getQFilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)Long.parseLong(this.getPageCache().get("createOrg"))));
        listFilterParameter.getQFilters().add(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void importItemFromMaterial(List<Object> materialIds) {
        if (!CollectionUtils.isEmpty(materialIds)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", materialIds)};
            List<String> selectFields = this.buildSelectFields();
            DynamicObjectCollection materialDynObjColl = QueryServiceHelper.query((String)"bd_material", (String)selectFields.stream().collect(Collectors.joining(",")), (QFilter[])filters);
            long createOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
            String ctrlStrgy = this.queryControlStrategy(createOrgId);
            DynamicObjectCollection materialStockObjs = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", "masterid", "inventoryunit"), (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialIds)});
            Map<Object, List<DynamicObject>> materialStockObjMap = materialStockObjs.stream().collect(Collectors.groupingBy(materialStockObj -> materialStockObj.get("masterid")));
            String defalutCtrlStrgy = ctrlStrgy;
            Date createDate = TimeServiceHelper.now();
            Object creatorId = UserUtil.getUserID();
            String channelId = this.getPageCache().get(SALECHANNEL_FILEDNAME);
            DynamicObject customerDynObj = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)String.join((CharSequence)",", ISINNERORG), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(channelId))});
            String goodsBelong = customerDynObj == null || customerDynObj.getBoolean(ISINNERORG) ? GoodsBelongEnum.INNER.getValue() : GoodsBelongEnum.OUTER.getValue();
            List<DynamicObject> itemDynObjList = materialDynObjColl.stream().map(material -> this.buildItemDynObj((DynamicObject)material, createOrgId, creatorId, createDate, defalutCtrlStrgy, channelId, materialStockObjMap, goodsBelong)).collect(Collectors.toList());
            this.setMulOwner(itemDynObjList, channelId);
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"mdr_item_info", (DynamicObject[])itemDynObjList.toArray(new DynamicObject[itemDynObjList.size()]), (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u7269\u6599\u751f\u6210\u5546\u54c1\u4fe1\u606f\u6210\u529f", (String)"MdrItemInfoList_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    protected void setMulOwner(List<DynamicObject> itemDynObjList, String channelId) {
        if (!CommonUtils.isNull(itemDynObjList)) {
            BusinessDataServiceHelper.loadRefence((Object[])itemDynObjList.toArray(), (IDataEntityType)itemDynObjList.get(0).getDataEntityType());
            for (DynamicObject itemDynObj : itemDynObjList) {
                MainEntityType mainType = (MainEntityType)itemDynObj.getDataEntityType();
                MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty("mulowner");
                DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
                DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)itemDynObj);
                DynamicObject row = new DynamicObject(subEntityType);
                row.set("fbasedataid", (Object)channelId);
                rows.add((Object)row);
                itemDynObj.set("mulowner", (Object)rows);
            }
        }
    }

    protected DynamicObject buildItemDynObj(DynamicObject material, Object createOrgId, Object creatorId, Date createDate, String defalutCtrlStrgy, String channelId, Map<Object, List<DynamicObject>> materialStockObjMap, String goodsBelong) {
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_info");
        result.set("createorg_id", createOrgId);
        result.set("org_id", createOrgId);
        result.set("ctrlstrategy", (Object)defalutCtrlStrgy);
        result.set("owner_id", (Object)channelId);
        result.set("material_id", material.get("id"));
        result.set("number", material.get("number"));
        result.set("name", material.get("name"));
        result.set("modelnum", material.get("modelnum"));
        result.set("saleunit_id", material.get("baseunit"));
        result.set("baseunit_id", material.get("baseunit"));
        result.set("hasattr", material.get("isuseauxpty"));
        result.set("easnum", material.get("number"));
        DynamicObject materialStockObj = null;
        if (materialStockObjMap.containsKey(material.get("id"))) {
            materialStockObj = materialStockObjMap.get(material.get("id")).get(0);
        }
        result.set("assistunit_id", material.get("auxptyunit"));
        result.set("conversionfor", (Object)this.getItemUnitconvertdir(material.getString("unitconvertdir")));
        result.set("enablelot", material.get("enablelot"));
        result.set("enableserial", material.get("enableserial"));
        result.set("serialunit_id", material.get("serialmu"));
        result.set("onlyoutandinrequest", material.get("isoutputrequest"));
        result.set("orderunit_id", material.get("baseunit"));
        result.set("retailunit_id", material.get("baseunit"));
        result.set("stockunit_id", materialStockObj == null ? material.get("baseunit") : materialStockObj.get("inventoryunit"));
        result.set("status", (Object)StatusEnum.DRAFT.getValue());
        result.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        result.set("isonsell", (Object)EnableStatusEnum.ENABLE.getValue());
        result.set("nonsingle", (Object)"0");
        result.set("goodsbelong", (Object)goodsBelong);
        result.set("creator_id", creatorId);
        result.set("createtime", (Object)createDate);
        result.set("itemtypeid_id", (Object)GoodsTypeEnum.NORMALGOODS.getValue());
        result.set("weightunit_id", material == null ? Integer.valueOf(0) : material.get("weightunit"));
        result.set("grossweight", material == null ? null : material.get("grossweight"));
        result.set("netweight", material == null ? null : material.get("netweight"));
        result.set("lengthunit_id", material == null ? Integer.valueOf(0) : material.get("lengthunit"));
        result.set("length", material == null ? null : material.get("length"));
        result.set("width", material == null ? null : material.get("width"));
        result.set("height", material == null ? null : material.get("height"));
        result.set("volumnunit_id", material == null ? Integer.valueOf(0) : material.get("volumnunit"));
        result.set("volume", material == null ? null : material.get("volume"));
        return result;
    }

    private String queryControlStrategy(long createOrgId) {
        String[] ctrlStrgys;
        String result = "";
        String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"mdr_item_info", (String)String.valueOf(createOrgId));
        if (ctrlStrgy != null && ctrlStrgy.length() > 0 && (ctrlStrgys = ctrlStrgy.split(",")).length > 1) {
            for (String ctr : ctrlStrgys) {
                if (!StringUtils.isNotEmpty((String)ctr)) continue;
                result = ctr;
                break;
            }
        }
        return result;
    }

    protected List<String> buildSelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>(21);
        selectFields.add("id");
        selectFields.add("name");
        selectFields.add("number");
        selectFields.add("modelnum");
        selectFields.add("baseunit");
        selectFields.add("isuseauxpty");
        selectFields.add("enablelot");
        selectFields.add("enableserial");
        selectFields.add("serialmu");
        selectFields.add("isoutputrequest");
        selectFields.add("unitconvertdir");
        selectFields.add("auxptyunit");
        selectFields.add("weightunit");
        selectFields.add("grossweight");
        selectFields.add("netweight");
        selectFields.add("lengthunit");
        selectFields.add("length");
        selectFields.add("width");
        selectFields.add("height");
        selectFields.add("volumnunit");
        selectFields.add("volume");
        return selectFields;
    }

    private String getItemUnitconvertdir(String materialUnitconvertdir) {
        String itemlUnitconvertdir = "A";
        switch (materialUnitconvertdir) {
            case "A": {
                itemlUnitconvertdir = "B";
                break;
            }
            case "B": {
                itemlUnitconvertdir = "C";
                break;
            }
            case "C": {
                itemlUnitconvertdir = "A";
                break;
            }
            case "D": {
                itemlUnitconvertdir = "D";
                break;
            }
        }
        return itemlUnitconvertdir;
    }
}

