/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.formplugin.member.MemberFFormPlugin;

public class Common {
    private static Log Logger = LogFactory.getLog(MemberFFormPlugin.class);

    static List<LabelAp> parseLabelDataToLabelAp(DynamicObjectCollection labelDatas, int parseCount) {
        ArrayList<LabelAp> labelAps = new ArrayList<LabelAp>();
        for (int i = 0; i < labelDatas.size() && (parseCount == 0 || i < parseCount); ++i) {
            DynamicObject labelData = ((DynamicObject)labelDatas.get(i)).getDynamicObject(1);
            QFilter[] labelGroupFilters = new QFilter[]{new QFilter("id", "=", (Object)"")};
            String labelId = labelData.getString("id");
            String labelName = labelData.getLocaleString("name").getLocaleValue();
            long labelGroupId = labelData.getDynamicObject("group").getLong("id");
            labelGroupFilters[0].__setValue((Object)labelGroupId);
            DynamicObject dbGroupColor = QueryServiceHelper.queryOne((String)"dbd_member_labelgroup", (String)"color", (QFilter[])labelGroupFilters);
            if (dbGroupColor == null) {
                Logger.info(String.format("\u67e5\u8be2\u6807\u7b7e{%s}\u989c\u8272\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5220\u9664", labelData.toString()));
                continue;
            }
            String labelColor = dbGroupColor.getString("color");
            labelAps.add(Common.createDynamicLabel(labelId, labelName, labelColor));
        }
        return labelAps;
    }

    static void updateVipLabelMetadata(IFormView view, String strContainer, String parentContainer, List<LabelAp> labelAps) {
        FlexPanelAp labelContainer = Common.createDynamicFlexPanel(strContainer);
        if (labelAps.size() > 0) {
            labelContainer.getItems().addAll(labelAps);
        }
        HashMap<String, String> labelContainerMeta = new HashMap<String, String>(2);
        labelContainerMeta.put("id", parentContainer);
        labelContainerMeta.put("items", (String)labelContainer.createControl().get("items"));
        view.updateControlMetadata(parentContainer, labelContainerMeta);
    }

    private static LabelAp createDynamicLabel(String labelId, String labelName, String labelColor) {
        LabelAp labelAp = new LabelAp();
        labelAp.setId(labelId);
        labelAp.setKey(labelId);
        labelAp.setName(new LocaleString(labelName));
        Style labelStyle = new Style();
        labelStyle.setMargin(new Margin(){
            {
                this.setLeft("10px");
                this.setBottom("5px");
            }
        });
        if (StringUtils.isBlank((CharSequence)labelColor) || StringUtils.equalsIgnoreCase((CharSequence)labelColor, (CharSequence)"#FFFFFF") || StringUtils.equalsIgnoreCase((CharSequence)labelColor, (CharSequence)"#FFF")) {
            labelStyle.setPadding(new Padding(){
                {
                    this.setLeft("12px");
                    this.setRight("12px");
                    this.setTop("1px");
                    this.setBottom("1px");
                }
            });
            labelStyle.setBorder(new Border(){
                {
                    this.setTop("1px solid #333333");
                    this.setRight("1px solid #333333");
                    this.setBottom("1px solid #333333");
                    this.setLeft("1px solid #333333");
                }
            });
            labelAp.setForeColor("#333333");
        } else {
            labelStyle.setPadding(new Padding(){
                {
                    this.setLeft("12px");
                    this.setRight("12px");
                    this.setTop("1px");
                    this.setBottom("3px");
                }
            });
            labelAp.setForeColor("#FFFFFF");
            labelAp.setBackColor(labelColor);
        }
        labelAp.setStyle(labelStyle);
        labelAp.setRadius("10px");
        labelAp.setFontSize(12);
        return labelAp;
    }

    private static FlexPanelAp createDynamicFlexPanel(String containerKey) {
        FlexPanelAp labelContainer = new FlexPanelAp();
        labelContainer.setKey(containerKey);
        return labelContainer;
    }
}

