/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.member;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.drp.dbd.common.enums.EnableStatusEnum;
import kd.drp.dbd.common.util.OwnerUtils;
import kd.drp.dbd.formplugin.member.Common;

public class MemberFFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final int COUNT_DEFAULTSHOWLABEL = 10;
    private static boolean isSuccess = false;

    public void registerListener(EventObject eventArgs) {
        this.addClickListeners(new String[]{"label_addlabel", "button_addlabel", "label_editlabel", "button_editlabel", "label_seemore", "button_seemore", "vector_seemore", "label_unseemore", "button_unseemore", "vector_unseemore"});
        MulBasedataEdit vipLabelEdit = (MulBasedataEdit)this.getControl("labelid");
        vipLabelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("branchid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        super.registerListener(eventArgs);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject createOrg;
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchId();
        }
        if ((createOrg = (DynamicObject)this.getView().getModel().getValue("createorg")) == null) {
            long orgId = RequestContext.get().getOrgId();
            this.getView().getModel().setItemValueByID("createorg", (Object)orgId);
            this.getView().getModel().setItemValueByID("org", (Object)orgId);
        }
    }

    public void click(EventObject eventArgs) {
        Control eventSource = (Control)eventArgs.getSource();
        switch (eventSource.getKey()) {
            case "label_addlabel": 
            case "button_addlabel": 
            case "button_editlabel": 
            case "label_editlabel": {
                this.callLabelF7List();
                break;
            }
            case "button_seemore": 
            case "vector_seemore": 
            case "label_seemore": {
                DynamicObjectCollection labelDatas = this.getModel().getDataEntity().getDynamicObjectCollection("labelid");
                if (labelDatas == null) break;
                List<LabelAp> labelAps = Common.parseLabelDataToLabelAp(labelDatas, 0);
                Common.updateVipLabelMetadata(this.getView(), "labelcontainer", "flexpanel_labelcontainer", labelAps);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"button_unseemore"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_seemore"});
                break;
            }
            case "button_unseemore": 
            case "vector_unseemore": 
            case "label_unseemore": {
                DynamicObjectCollection labelDatas = this.getModel().getDataEntity().getDynamicObjectCollection("labelid");
                if (labelDatas == null) break;
                List<LabelAp> labelAps = Common.parseLabelDataToLabelAp(labelDatas, 10);
                Common.updateVipLabelMetadata(this.getView(), "labelcontainer", "flexpanel_labelcontainer", labelAps);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_unseemore"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"button_seemore"});
                break;
            }
            default: {
                this.getView().showTipNotification("\u6682\u672a\u5904\u7406\u8be5\u70b9\u51fb\u4e8b\u4ef6");
            }
        }
        super.click(eventArgs);
    }

    public void afterBindData(EventObject eventArgs) {
        DynamicObjectCollection labelDatas = this.getModel().getDataEntity().getDynamicObjectCollection("labelid");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelsplitlabelbutton", "button_unseemore"});
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_addlabel"});
            if (labelDatas.size() <= 10) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_seemore", "labelsplitlabelbutton"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelsplitlabelbutton"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_editlabel", "button_seemore"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"button_addlabel"});
        }
        ArrayList<LabelAp> labelAps = null;
        if (labelDatas != null && labelDatas.size() > 0) {
            labelAps = Common.parseLabelDataToLabelAp(labelDatas, 10);
        } else {
            labelAps = new ArrayList<LabelAp>();
            labelAps.add(this.createEmptyTipLabel());
        }
        Common.updateVipLabelMetadata(this.getView(), "labelcontainer", "flexpanel_labelcontainer", labelAps);
    }

    public void propertyChanged(PropertyChangedArgs eventArgs) {
        switch (eventArgs.getProperty().getName()) {
            case "labelid": {
                DynamicObjectCollection newValueCollection = (DynamicObjectCollection)eventArgs.getChangeSet()[0].getNewValue();
                List<LabelAp> labelAps = Common.parseLabelDataToLabelAp(newValueCollection, 0);
                Common.updateVipLabelMetadata(this.getView(), "labelcontainer", "flexpanel_labelcontainer", labelAps);
                if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) break;
                if (newValueCollection.size() > 10) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_seemore"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"button_unseemore", "labelsplitlabelbutton"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"button_seemore", "button_unseemore", "labelsplitlabelbutton"});
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if ("labelid".equals(e.getProperty().getName())) {
            QFilter enableFilter = new QFilter("1", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            listShowParameter.getListFilterParameter().setFilter(enableFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"save") || StringUtils.equals((CharSequence)opKey, (CharSequence)"submit")) {
            OperationResult result = e.getOperationResult();
            isSuccess = result != null && result.isSuccess();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (isSuccess) {
            this.getView().returnDataToParent((Object)"Success");
        }
    }

    private void callLabelF7List() {
        MulBasedataEdit vipLabelCtrl = (MulBasedataEdit)this.getView().getControl("labelid");
        vipLabelCtrl.click();
    }

    private LabelAp createEmptyTipLabel() {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label_emptytips");
        labelAp.setName(new LocaleString("\u6682\u65e0\u4fe1\u606f\u6807\u7b7e\uff0c\u8bf7\u6dfb\u52a0\u6807\u7b7e\u54e6\uff5e"));
        Style labelStyle = new Style();
        labelStyle.setMargin(new Margin(){
            {
                this.setLeft("10px");
            }
        });
        labelAp.setStyle(labelStyle);
        labelAp.setForeColor("#999999");
        return labelAp;
    }

    private void initDefaultBranchId() {
        this.getView().getModel().setValue("branchid", (Object)OwnerUtils.getDefaultOwnerId((boolean)true));
    }
}

