/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.mobile;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;
import kd.drp.mdr.mobile.MobileControlUtils;

public class CustomerGroup
extends MdrFormMobPlugin
implements RowClickEventListener,
MobileSearchTextChangeListener,
ListRowClickListener {
    public static final String ENTRY_CUSTOMER_GROUP = "customergroupentry";
    public static final String FLEX_CUSTOMER_GROUP_SELECT = "gradeselectresult";
    public static final String CUSTOMER_GROUP = "customergroup";
    public static final String SELECTED_CUSTOMER_GROUP = "selectedcustomergroup";
    public static final String SEARCH_CUSTOMER_GOURP = "mobilesearchap";
    public static final String ENTRY_RESULTLIST = "resultlist";
    public static final String FLEX_SEARCH_RESULT = "searchresultflex";

    public void registerListener(EventObject e) {
        for (String customerGroupEntryName : this.getAllGradeEntryName(ENTRY_CUSTOMER_GROUP)) {
            CardEntry cardEntry = (CardEntry)this.getControl(customerGroupEntryName);
            cardEntry.addRowClickListener((RowClickEventListener)this);
        }
        MobileSearch search = (MobileSearch)this.getControl(SEARCH_CUSTOMER_GOURP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList itemlist = (BillList)this.getControl(ENTRY_RESULTLIST);
        itemlist.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        QFilter filter = new QFilter("parent", "=", (Object)0L);
        filter.and("classstandard", "=", this.getParameter("groupStandard"));
        this.setDisVisible(new String[]{FLEX_SEARCH_RESULT});
        this.fillCustomerGroup(filter, 1);
    }

    protected void returnDataToParent(Object customerGroup) {
        this.getView().returnDataToParent(customerGroup);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith(ENTRY_CUSTOMER_GROUP)) {
            int index = evt.getRow();
            int grade = this.getColumnGrade(key, ENTRY_CUSTOMER_GROUP);
            DynamicObject customerGroup = (DynamicObject)this.getValue(CUSTOMER_GROUP + grade, index);
            Object customerGroupId = customerGroup.getPkValue();
            QFilter fitler = new QFilter("parent", "in", customerGroupId);
            fitler.and("classstandard", "=", this.getParameter("groupStandard"));
            int fillColumn = this.fillCustomerGroup(fitler, grade + 1);
            if (fillColumn == 0) {
                this.returnDataToParent(customerGroupId);
            }
            this.setRowSelected(index, (CardEntry)control);
        }
    }

    protected void setRowSelected(int row, CardEntry customerGroupCardEntry) {
        int size = this.getModel().getEntryEntity(customerGroupCardEntry.getEntryKey()).size();
        int grade = this.getColumnGrade(customerGroupCardEntry.getKey(), ENTRY_CUSTOMER_GROUP);
        for (int i = 0; i < size; ++i) {
            if (i == row) {
                customerGroupCardEntry.setChildVisible(false, i, new String[]{CUSTOMER_GROUP + grade});
                customerGroupCardEntry.setChildVisible(true, i, new String[]{SELECTED_CUSTOMER_GROUP + grade});
                continue;
            }
            customerGroupCardEntry.setChildVisible(true, i, new String[]{CUSTOMER_GROUP + grade});
            customerGroupCardEntry.setChildVisible(false, i, new String[]{SELECTED_CUSTOMER_GROUP + grade});
        }
    }

    private int fillCustomerGroup(QFilter filter, int grade) {
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"mdr_customer_group", (String)"id,name", (QFilter[])filter.toArray(), (String)"number asc");
        if (groups.size() == 0) {
            this.setDisVisible(new String[]{ENTRY_CUSTOMER_GROUP + grade});
            return 0;
        }
        List<String> entriesName = this.getAllGradeEntryName(ENTRY_CUSTOMER_GROUP);
        for (String entryName : entriesName) {
            int currentGrade = this.getColumnGrade(entryName, ENTRY_CUSTOMER_GROUP);
            if (currentGrade > grade) {
                this.getModel().deleteEntryData(entryName);
                this.setDisVisible(new String[]{entryName});
                continue;
            }
            this.setVisible(new String[]{entryName});
        }
        if (grade > entriesName.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301%s\u7ea7\u6e20\u9053\u5206\u7ec4", (String)"CustomerGroup_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]), entriesName.size()));
        }
        this.getModel().deleteEntryData(ENTRY_CUSTOMER_GROUP + grade);
        this.getModel().batchCreateNewEntryRow(ENTRY_CUSTOMER_GROUP + grade, groups.size());
        DynamicObject group = null;
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_CUSTOMER_GROUP + grade);
        for (int i = 0; i < groups.size(); ++i) {
            group = (DynamicObject)groups.get(i);
            this.setValue(CUSTOMER_GROUP + grade, group.getLong("id"), i);
            this.setValue(SELECTED_CUSTOMER_GROUP + grade, group.getLong("id"), i);
            cardEntry.setChildVisible(false, i, new String[]{SELECTED_CUSTOMER_GROUP + grade});
        }
        return groups.size();
    }

    private List<String> getAllGradeEntryName(String entryName) {
        LinkedList<String> customerGroupEntryNames = new LinkedList<String>();
        int index = 1;
        while (this.getControl(entryName + index) != null) {
            customerGroupEntryNames.add(entryName + index);
            ++index;
        }
        return customerGroupEntryNames;
    }

    private int getColumnGrade(String entryName, String entryNamePrefix) {
        String[] nameSplit = entryName.split(entryNamePrefix);
        if (nameSplit.length < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u4e0d\u5b58\u5728\u7b49\u7ea7", (String)"CustomerGroup_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        int currentGrade = Integer.parseInt(nameSplit[1]);
        return currentGrade;
    }

    public void click(MobileSearchTextChangeEvent e) {
        MobileSearch search = (MobileSearch)e.getSource();
        String key = search.getKey();
        String context = e.getText();
        switch (key) {
            case "mobilesearchap": {
                if (context == null || context.trim().equals("")) {
                    this.setDisVisible(new String[]{FLEX_SEARCH_RESULT});
                    this.setVisible(new String[]{FLEX_CUSTOMER_GROUP_SELECT});
                    break;
                }
                this.setVisible(new String[]{FLEX_SEARCH_RESULT});
                this.setDisVisible(new String[]{FLEX_CUSTOMER_GROUP_SELECT});
                QFilter filter = QMatches.match((String[])new String[]{context}, (String[])new String[]{"name"});
                BillList entryResult = (BillList)this.getControl(ENTRY_RESULTLIST);
                MobileControlUtils.BillListRefresh((BillList)entryResult, (QFilter[])new QFilter[]{filter});
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        String key;
        Control list = (Control)evt.getSource();
        switch (key = list.getKey()) {
            case "resultlist": {
                ListSelectedRow row = evt.getCurrentListSelectedRow();
                Object rowPkValue = row.getPrimaryKeyValue();
                QFilter filter = new QFilter("parent", "in", rowPkValue);
                boolean isExist = QueryServiceHelper.exists((String)"mdr_customer_group", (QFilter[])filter.toArray());
                if (isExist) {
                    MobileControlUtils.BillListRefresh((BillList)((BillList)this.getControl(ENTRY_RESULTLIST)), (QFilter[])new QFilter[]{filter});
                    break;
                }
                this.returnDataToParent(rowPkValue);
            }
        }
    }
}

