/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.orderquantity;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WarehouseRuleUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class OrderQuantityPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String TOOL_BARAP = "toolbarap";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String TOOL_SAVE = "save";
    private static final String TOOL_RESET = "reset";
    private static final String RULE_LIST = "rulelist";
    private static final String OWNER = "owner";
    private static final String REGION = "region";
    private static final String WAREHOUSE = "warehouse";
    private static final String CUSTOMERGROUP = "customergroup";
    private static final String CUSTOMER = "customer";
    private static final String ITEMCLASS = "itemclass";
    private static final String ITEM = "item";
    private static final String UNIT = "unit";
    private static final String QTY = "qty";
    private static final String MINQTY = "minqty";
    private static final String ENABLE = "enable";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(OWNER, UserUtil.getDefaultOwnerID());
        this.SetOwnerFromCache(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARAP, ADVCONTOOLBARAP});
        this.addF7Listener(this, new String[]{OWNER, REGION, WAREHOUSE, CUSTOMERGROUP, CUSTOMER, ITEMCLASS, ITEM, UNIT, "assistattr"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        Object ownerid = this.getOwnerF7PKValue();
        int rowIndex = e.getRow();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                break;
            }
            case "region": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getRegionFilter(ownerid));
                break;
            }
            case "warehouse": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getWareHouseFilter(ownerid));
                break;
            }
            case "customergroup": {
                DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)2L, (String)"mdr_cust_standard_apply");
                DynamicObject standardObj = dobj.getDynamicObject("classstandardid");
                Long groupStandardPK = Long.valueOf(standardObj.get("id").toString());
                formShowParameter.setCustomParam("groupStandard", (Object)groupStandardPK);
                QFilter standardFilter = new QFilter("classstandard", "=", (Object)groupStandardPK);
                formShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter(ownerid));
                break;
            }
            case "itemclass": {
                DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)5L, (String)"mdr_classstandardapply");
                long standardId = itemClassStandard.getLong("classstandardid_id");
                formShowParameter.setCustomParam("groupStandard", (Object)standardId);
                QFilter itemStandardFilter = new QFilter("standard", "=", (Object)standardId);
                formShowParameter.getListFilterParameter().getQFilters().add(itemStandardFilter);
                break;
            }
            case "item": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter(ownerid));
                break;
            }
            case "unit": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getUnitFilter(rowIndex));
                break;
            }
            case "assistattr": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getAssistAttrFilter(rowIndex));
            }
        }
    }

    private QFilter getOwnerFilter() {
        return UserUtil.getAuthorizedCommonUserOwnersFilter();
    }

    private QFilter getRegionFilter(Object ownerid) {
        return new QFilter(OWNER, "=", ownerid);
    }

    private QFilter getWareHouseFilter(Object ownerid) {
        List warehouseid = WarehouseRuleUtil.queryWarehouse((Object)ownerid);
        return new QFilter("id", "in", (Object)warehouseid);
    }

    private QFilter getCustomerFilter(Object ownerid) {
        Set customerids = CustomerUtil.getAuthSubsIds((Object)ownerid);
        return new QFilter("id", "in", (Object)customerids);
    }

    private QFilter getItemClassFilter(Object ownerid) {
        return new QFilter("1", "=", (Object)"1");
    }

    private List<QFilter> getItemFilter(Object ownerid) {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)ownerid, (IPageCache)this.getPageCache()));
        return fs;
    }

    private QFilter getUnitFilter(int rowindex) {
        List unitIds = this.getUnitFormHandler().getUnitIdList(this.getEntryF7PKValue(RULE_LIST, ITEM, rowindex));
        return new QFilter("id", "in", (Object)unitIds);
    }

    private QFilter getAssistAttrFilter(int rowindex) {
        Object itemId = this.getEntryF7PKValue(RULE_LIST, ITEM, rowindex);
        QFilter f = ItemAttrUtil.getAttrFilter((Object)itemId);
        return f;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "reset": {
                this.getModel().deleteEntryData(RULE_LIST);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        Object oldvalue = e.getChangeSet()[0].getOldValue();
        int i = this.getModel().getEntryCurrentRowIndex(RULE_LIST);
        if (OWNER.equalsIgnoreCase(key)) {
            if (this.getF7PKValue(OWNER) == null) {
                this.getModel().setValue(OWNER, oldvalue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrderQuantityPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryData(RULE_LIST);
            this.getModel().createNewEntryRow(RULE_LIST);
        }
        if (value != null) {
            switch (key) {
                case "region": {
                    this.setValue(CUSTOMERGROUP, null, i);
                    this.setValue(CUSTOMER, null, i);
                    this.setValue(ITEM, null, i);
                    this.setValue(UNIT, null, i);
                    break;
                }
                case "customergroup": {
                    this.setValue(REGION, null, i);
                    this.setValue(CUSTOMER, null, i);
                    this.setValue(ITEM, null, i);
                    this.setValue(UNIT, null, i);
                    break;
                }
                case "customer": {
                    this.setValue(REGION, null, i);
                    this.setValue(CUSTOMERGROUP, null, i);
                    this.setValue(ITEM, null, i);
                    this.setValue(UNIT, null, i);
                    break;
                }
                case "itemclass": {
                    this.setValue(ITEM, null, i);
                    this.setValue(UNIT, null, i);
                    break;
                }
                case "item": {
                    this.itemChanged(e);
                    break;
                }
                case "assistattr": {
                    this.setValue(ITEMCLASS, null, i);
                    break;
                }
            }
        } else if (ITEM.equalsIgnoreCase(key)) {
            this.setValue(UNIT, null, i);
            this.setValue("assistattr", null, i);
        }
    }

    private void itemChanged(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        DynamicObject row = this.getRowInfo(RULE_LIST, index);
        DynamicObject item = row.getDynamicObject(ITEM);
        if (item == null) {
            this.setValue(UNIT, null, index);
            this.setValue("assistattr", null, index);
            this.setUnEnable(index, new String[]{UNIT, "assistattr"});
        } else {
            this.setValue(ITEMCLASS, null, index);
            if (item.getBoolean("iscombination")) {
                this.setValue(UNIT, null, index);
                this.setValue("assistattr", null, index);
                this.setUnEnable(index, new String[]{UNIT, "assistattr"});
            } else {
                QFilter fs = new QFilter("id", "=", item.getPkValue());
                boolean hasattr = false;
                DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
                if (iteminfo != null) {
                    Object unit = iteminfo.get("saleunit");
                    if (unit != null) {
                        this.setValue(UNIT, unit, index);
                    }
                    hasattr = iteminfo.getBoolean("hasattr");
                }
                this.setEnable(index, new String[]{UNIT});
                if (hasattr) {
                    this.setValue("assistattr", ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()), index);
                    this.setEnable(index, new String[]{"assistattr"});
                } else {
                    this.setValue("assistattr", null, index);
                    this.setUnEnable(index, new String[]{"assistattr"});
                }
            }
        }
    }

    private void save() {
        int rows = this.getModel().getEntryRowCount(RULE_LIST);
        if (rows == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8981\u4fdd\u5b58\u7684\u89c4\u5219\u3002", (String)"OrderQuantityPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (TXHandle h = TX.required();){
            try {
                DynamicObject obj = null;
                for (int row = 0; row < rows; ++row) {
                    obj = null;
                    obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_orderquantity");
                    obj.set(REGION, this.getModel().getValue(REGION, row));
                    obj.set(WAREHOUSE, this.getModel().getValue(WAREHOUSE, row));
                    obj.set(CUSTOMERGROUP, this.getModel().getValue(CUSTOMERGROUP, row));
                    obj.set(CUSTOMER, this.getModel().getValue(CUSTOMER, row));
                    obj.set(ITEMCLASS, this.getModel().getValue(ITEMCLASS, row));
                    obj.set(ITEM, this.getModel().getValue(ITEM, row));
                    obj.set(UNIT, this.getModel().getValue(UNIT, row));
                    obj.set("assistattr", this.getModel().getValue("assistattr", row));
                    obj.set(ENABLE, this.getModel().getValue(ENABLE, row));
                    obj.set(QTY, this.getModel().getValue(QTY, row));
                    obj.set(MINQTY, this.getModel().getValue(MINQTY, row));
                    obj.set(OWNER, (Object)this.getF7Value(OWNER));
                    OperationUtil.addDefaultInfo((DynamicObject)obj);
                    OperationResult result = OperationServiceHelper.executeOperate((String)TOOL_SAVE, (String)obj.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    List validResultList = result.getValidateResult().getValidateErrors();
                    for (ValidateResult validation : validResultList) {
                        Iterator iter = validation.getAllErrorInfo().iterator();
                        while (iter.hasNext()) {
                            OperateErrorInfo info = (OperateErrorInfo)iter.next();
                            sb.append(info.getMessage());
                            if (sb.charAt(sb.length() - 1) == '\u3002') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (iter.hasNext()) {
                                sb.append(",");
                                continue;
                            }
                            sb.append("\u3002");
                        }
                    }
                }
                if (sb.length() > 0) {
                    String errorInfo = sb.toString();
                    throw new KDBizException(errorInfo);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw new KDBizException(e.getLocalizedMessage());
            }
        }
        this.getView().close();
    }
}

