/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.params;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class CustomerParamsEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter params = (BaseShowParameter)e.getSource();
        Object id = this.getPkId();
        params.setPkId(id);
    }

    private Object getPkId() {
        DynamicObject one = this.getParams(UserUtil.getDefaultOwnerID());
        if (one == null) {
            return null;
        }
        return one.get("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.ownerChange();
                break;
            }
        }
    }

    private void ownerChange() {
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            return;
        }
        DynamicObject params = this.getParams(ownerId);
        if (params == null) {
            params = this.createDefault(ownerId);
        }
        this.reLoadPage(params.get("id"));
    }

    private DynamicObject createDefault(Object ownerId) {
        DynamicObject newParam = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_params");
        Map params = CustomerParamsUtil.getParamsDefaultVal();
        for (Map.Entry param : params.entrySet()) {
            newParam.set((String)param.getKey(), param.getValue());
        }
        newParam.set("owner", ownerId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newParam});
        return newParam;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner"});
    }

    private DynamicObject getParams(Object ownerId) {
        QFilter fs = new QFilter("owner", "=", ownerId);
        return QueryServiceHelper.queryOne((String)"mdr_customer_params", (String)"id", (QFilter[])fs.toArray());
    }

    public void afterCreateNewData(EventObject e) {
        this.initDefaultVal();
    }

    private void initDefaultVal() {
        List ownerIds = UserUtil.getOwnerIDs();
        if (ownerIds.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u6240\u5c5e\u6e20\u9053\uff0c\u65e0\u6cd5\u4e0b\u5355\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"CustomerParamsEditPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ownerIds.size() == 1) {
            this.setUnEnable(new String[]{"owner"});
        }
        this.setOwnerF7Value(ownerIds.get(0));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
                break;
            }
        }
    }
}

