/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.pay;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.business.handle.SetBranchRangeHelper;
import kd.drp.dbd.business.payhelper.PayTradeHelper;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.PayResult;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dbd.common.util.F7Utils;
import kd.drp.dbd.common.util.OwnerUtils;
import kd.drp.dbd.enums.PaymentModeEnum;

public class PayConfigEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getView().getModel();
        String fieldName = e.getProperty().getName();
        if (e.getChangeSet().length <= 0) {
            return;
        }
        switch (fieldName) {
            case "channel": {
                DynamicObject payInfo;
                long channelId;
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                long l = channelId = newValue == null ? 0L : newValue.getLong("Id");
                if (channelId == 0L) {
                    return;
                }
                int row = e.getChangeSet()[0].getRowIndex();
                DynamicObject data = this.getModel().getDataEntity(true);
                DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
                DynamicObject entryItem = (DynamicObject)entryEntity.get(row);
                DynamicObjectCollection subEntry = entryItem.getDynamicObjectCollection("subentryentity");
                if (!CollectionUtils.isEmpty((Collection)subEntry)) {
                    subEntry.clear();
                }
                if (Boolean.TRUE.equals((payInfo = BusinessDataServiceHelper.loadSingle((Object)channelId, (String)"dbd_paymode")).getBoolean("isconfigparam"))) {
                    DynamicObject[] payParamSets = this.getPayParamSets(channelId);
                    if (payParamSets == null || payParamSets.length <= 0) {
                        this.getView().showTipNotification("\u8be5\u7ed3\u7b97\u65b9\u5f0f\u672a\u914d\u7f6e\u76f8\u5173\u652f\u4ed8\u53c2\u6570\uff0c\u8bf7\u524d\u5f80\u652f\u4ed8\u53c2\u6570\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\uff01");
                        this.getView().getModel().beginInit();
                        this.getView().getModel().setItemValueByID("channel", (Object)0L, row);
                        this.getView().updateView("channel", row);
                        this.getView().getModel().endInit();
                        this.getView().updateView("entryentity");
                        return;
                    }
                    for (DynamicObject payParamSet : payParamSets) {
                        DynamicObjectCollection payParamSetEntry = payParamSet.getDynamicObjectCollection("entryentity");
                        if (CollectionUtils.isEmpty((Collection)payParamSetEntry)) continue;
                        for (DynamicObject item : payParamSetEntry) {
                            DynamicObject subEntryItem = subEntry.addNew();
                            DynamicObject payparam = DynamicObjectUtils.getDynamicObject((DynamicObject)item, (String)"payparam");
                            subEntryItem.set("param", (Object)payparam);
                            subEntryItem.set("paramkey", (Object)DynamicObjectUtils.getString((DynamicObject)payparam, (String)"number"));
                            subEntryItem.set("ismustinput", (Object)DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"ismustinput"));
                        }
                    }
                }
                entryItem.set("subentryentity", (Object)subEntry);
                this.getView().updateView("entryentity");
                this.getView().updateView("subentryentity");
                break;
            }
            case "attachment": {
                DynamicObjectCollection newValueList = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                String replaceAttchUrl = "";
                if (newValueList != null && newValueList.size() > 0) {
                    DynamicObject attachment = ((DynamicObject)newValueList.get(0)).getDynamicObject("fbasedataid");
                    DynamicObject attachmentInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)attachment.getPkValue(), (String)"bd_attachment");
                    replaceAttchUrl = attachmentInfo.getString("url");
                }
                this.getView().getModel().setValue("paramvalue", (Object)replaceAttchUrl, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "orgrange": {
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)model.getValue("channelgroup");
                if (customerGroup != null && customerGroup.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("channelgroup", null);
                    this.getView().updateView("channelgroup");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection range = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)model, (DynamicObjectCollection)range, (boolean)true, (String)"treeentryentity", (String)"org", (String)"branch");
                this.expand();
                break;
            }
            case "channelgroup": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)model.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection group = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)model, (DynamicObjectCollection)group, (boolean)false, (String)"treeentryentity", (String)"org", (String)"branch");
                this.expand();
                break;
            }
        }
    }

    private void expand() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        if ("bar_test".equalsIgnoreCase(e.getItemKey())) {
            PayResult payResult;
            TradeStatus paystatus;
            long payChannelId;
            int index = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryData = this.getView().getModel().getEntryRowEntity("entryentity", index);
            if (entryData == null) {
                return;
            }
            DynamicObjectCollection subEntryData = entryData.getDynamicObjectCollection("subentryentity");
            if (subEntryData == null || subEntryData.size() <= 0) {
                return;
            }
            HashMap map = new HashMap(subEntryData.size());
            subEntryData.forEach(p -> map.put(p.getString("paramkey"), p.getString("paramvalue")));
            DynamicObject payChannel = entryData.getDynamicObject("channel");
            long l = payChannelId = payChannel == null ? 0L : payChannel.getLong("Id");
            if (PaymentModeEnum.getKey((String)"wechatpay") != payChannelId && PaymentModeEnum.getKey((String)"alipay") != payChannelId) {
                this.getView().showErrorNotification("\u652f\u4ed8\u5931\u8d25");
                return;
            }
            String payCode = entryData.getString("paycode");
            Date operaTime = TimeServiceHelper.now();
            long currentSalerId = Long.parseLong(RequestContext.get().getUserId());
            long branchId = OwnerUtils.getDefaultOwnerId((boolean)true);
            CheckOutCounterInfo payDate = new CheckOutCounterInfo();
            payDate.setBillNo("2020666888");
            payDate.setOperatorId(currentSalerId);
            payDate.setOperaTime(operaTime);
            payDate.setStoreId(branchId);
            payDate.setSubject("\u6d4b\u8bd5\u652f\u4ed8");
            if (PaymentModeEnum.getKey((String)"wechatpay") == payChannelId) {
                payDate.setBody("\u6d4b\u8bd5\u652f\u4ed8");
                payDate.setSpbillCreateIp("127.0.0.1");
            }
            if (TradeStatus.SUCCESS == (paystatus = (payResult = PayTradeHelper.getPayData((CheckOutCounterInfo)payDate, (long)payChannelId, (String)payCode, (BigDecimal)new BigDecimal("0.01"))).getTradeStatus())) {
                this.getView().showMessage("\u652f\u4ed8\u6210\u529f");
            } else {
                this.getView().showErrorNotification("\u652f\u4ed8\u5931\u8d25");
            }
        }
    }

    private DynamicObject[] getPayParamSets(long channelId) {
        QFilter filter = F7Utils.getCommonStatusFilter().and("paychannel.Id", "=", (Object)channelId);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"dbd_payparamset");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.load((String)"dbd_payparamset", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
    }
}

