/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.region;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class RegionAllocationPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_ADD_USER = "adduser";
    private static final String BTN_ADD_CUSTOMER = "addcustomer";
    private static final String BTN_REMOVE_USER = "removeuser";
    private static final String BTN_REMOVE_CUSTOMER = "removecustomer";
    private static final String TB_UN_USER = "un_user_tb";
    private static final String TB_USER = "user_tb";
    private static final String TB_CUSTOMER = "customer_tb";
    private static final String TB_UN_CUSTOMER = "un_customer_tb";
    private static final String UN_CUSTOMER = "un_customer";
    private static final String UN_USER = "un_user";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_ADD_USER, BTN_ADD_CUSTOMER, BTN_REMOVE_USER, BTN_REMOVE_CUSTOMER});
        this.addF7Listener(this, new String[]{"region", "owner"});
    }

    public void afterCreateNewData(EventObject e) {
        String key = "hasInit";
        if (this.getPageCache().get(key) == null) {
            this.initRegion();
            this.initTBs();
            this.getPageCache().put(key, "true");
        }
    }

    private void initTBs() {
        if (this.getRegionF7Value() == null || this.getOwnerF7Value() == null) {
            return;
        }
        this.clearTB(new String[]{TB_CUSTOMER, TB_UN_CUSTOMER, TB_USER, TB_UN_USER});
        this.initUserTBs();
        this.initCustomerTB();
    }

    private void initCustomerTB() {
        Object regionId = this.getRegionF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        Set cutomerIds = CustomerUtil.queryCustomerByRegion((Object)ownerId, (Object)regionId);
        this.loadTB(cutomerIds, TB_CUSTOMER, "customer");
        Set unCustomerIds = CustomerUtil.queryCustomerByRegion((Object)ownerId, (Object)0L);
        this.loadTB(unCustomerIds, TB_UN_CUSTOMER, UN_CUSTOMER);
    }

    private void initUserTBs() {
        Object regionId = this.getRegionF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("enable", "=", (Object)"1");
        Set allUsers = QueryUtil.querySingleCol((String)"dbd_drp_user", (String)"sysuser", (QFilter[])fs.toArray());
        QFilter relationFs = new QFilter("owner", "=", ownerId);
        relationFs.and("region", "=", regionId);
        Set users = QueryUtil.querySingleCol((String)"mdr_region_user_relation", (String)"user", (QFilter[])relationFs.toArray());
        this.loadTB(users, TB_USER, "user");
        allUsers.removeAll(users);
        this.loadTB(allUsers, TB_UN_USER, UN_USER);
    }

    private void loadTB(Set<Object> users, String tbName, String colName) {
        if (users.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(colName, new Object[0]);
        for (Object id : users) {
            vs.addRow(new Object[]{id});
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.batchCreateNewEntryRow(tbName, vs);
        this.getModel().endInit();
        this.getView().updateView(tbName);
    }

    private void initRegion() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object regionID = fsp.getCustomParam("regionID");
        if (regionID != null) {
            this.loadRegionInfo(regionID);
        } else {
            this.loadDefaultOwner();
        }
    }

    private void loadDefaultOwner() {
        List ownerIds = UserUtil.getOwnerIDs();
        if (ownerIds.size() == 0) {
            return;
        }
        if (ownerIds.size() == 1) {
            this.setUnEnable(new String[]{"owner"});
        }
        this.setOwnerF7Value(ownerIds.get(0));
    }

    private void loadRegionInfo(Object regionID) {
        QFilter fs = QueryUtil.getIdFilter((Object)regionID);
        DynamicObject info = QueryServiceHelper.queryOne((String)"mdr_region", (String)"owner", (QFilter[])fs.toArray());
        this.setRegionF7Value(regionID);
        this.setOwnerF7Value(info.get("owner"));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "adduser": {
                this.addUser();
                break;
            }
            case "addcustomer": {
                this.addCustomer();
                break;
            }
            case "removeuser": {
                this.removeUser();
                break;
            }
            case "removecustomer": {
                this.removeCustomer();
            }
        }
    }

    private void removeCustomer() {
        EntryGrid entrys = (EntryGrid)this.getControl(TB_CUSTOMER);
        int[] rows = entrys.getSelectRows();
        int len = rows.length;
        if (len == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6e20\u9053\uff01", (String)"RegionAllocationPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        Set<Object> ids = this.getRowF7Ids(TB_CUSTOMER, rows, "customer");
        this.updateCustomerInfos(ids, true);
        this.getModel().deleteEntryRows(TB_CUSTOMER, rows);
        this.loadTB(ids, TB_UN_CUSTOMER, UN_CUSTOMER);
    }

    private void removeUser() {
        EntryGrid entrys = (EntryGrid)this.getControl(TB_USER);
        int[] rows = entrys.getSelectRows();
        int len = rows.length;
        if (len == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7528\u6237\uff01", (String)"RegionAllocationPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        Set<Object> ids = this.getRowF7Ids(TB_USER, rows, "user");
        Object regionId = this.getRegionF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter fs = new QFilter("owner", "=", ownerId);
        fs.and("region", "=", regionId);
        fs.and("user", "in", ids);
        DeleteServiceHelper.delete((String)"mdr_region_user_relation", (QFilter[])fs.toArray());
        this.getModel().deleteEntryRows(TB_USER, rows);
        this.loadTB(ids, TB_UN_USER, UN_USER);
    }

    private void addCustomer() {
        EntryGrid entrys = (EntryGrid)this.getControl(TB_UN_CUSTOMER);
        int[] rows = entrys.getSelectRows();
        int len = rows.length;
        if (len == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6e20\u9053\uff01", (String)"RegionAllocationPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        Set<Object> ids = this.getRowF7Ids(TB_UN_CUSTOMER, rows, UN_CUSTOMER);
        this.updateCustomerInfos(ids, false);
        this.getModel().deleteEntryRows(TB_UN_CUSTOMER, rows);
        this.loadTB(ids, TB_CUSTOMER, "customer");
    }

    private void updateCustomerInfos(Set<Object> ids, boolean isNullRegion) {
        DynamicObject[] infos;
        Object regionId = isNullRegion ? Long.valueOf(0L) : this.getRegionF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        QFilter fs = new QFilter("authowner", "=", ownerId);
        fs = fs.and("customer", "in", ids);
        for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"mdr_customer_authorize", (String)"id,region", (QFilter[])fs.toArray())) {
            info.set("region", regionId);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
    }

    private void addUser() {
        EntryGrid entrys = (EntryGrid)this.getControl(TB_UN_USER);
        int[] rows = entrys.getSelectRows();
        int len = rows.length;
        if (len == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7528\u6237\uff01", (String)"RegionAllocationPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        Set<Object> ids = this.getRowF7Ids(TB_UN_USER, rows, UN_USER);
        DynamicObject[] relations = this.createRegionUserRelation(ids);
        SaveServiceHelper.save((DynamicObject[])relations);
        this.getModel().deleteEntryRows(TB_UN_USER, rows);
        this.loadTB(ids, TB_USER, "user");
    }

    private Set<Object> getRowF7Ids(String TBName, int[] indexs, String f7Name) {
        int len = indexs.length;
        HashSet<Object> ids = new HashSet<Object>(len);
        for (int i = 0; i < len; ++i) {
            ids.add(this.getEntryF7PKValue(TBName, f7Name, indexs[i]));
        }
        return ids;
    }

    private DynamicObject[] createRegionUserRelation(Set<Object> userIds) {
        Object regionId = this.getRegionF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        DynamicObject[] ralations = new DynamicObject[userIds.size()];
        int i = 0;
        for (Object id : userIds) {
            ralations[i] = BusinessDataServiceHelper.newDynamicObject((String)"mdr_region_user_relation");
            ralations[i].set("region", regionId);
            ralations[i].set("owner", ownerId);
            ralations[i].set("user", id);
            ++i;
        }
        return ralations;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        switch (key = e.getProperty().getName()) {
            case "region": {
                this.regionChange();
                break;
            }
            case "owner": {
                this.ownerChange();
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void ownerChange() {
        this.setRegionF7Value(null);
        this.clearTB(new String[]{TB_CUSTOMER, TB_UN_CUSTOMER, TB_USER, TB_UN_USER});
    }

    private void regionChange() {
        this.initTBs();
    }

    private QFilter getRegionFitler() {
        return new QFilter("owner", "=", this.getOwnerF7PKValue());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "region": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getRegionFitler());
                break;
            }
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCommonOwnerFitler());
            }
        }
    }
}

