/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrTreeListPlugin;

public class RegionListPlugin
extends MdrTreeListPlugin {
    public static final String MDR_REGION_ALLOCATION = "mdr_region_allocation";
    public static final String BTN_ALLOCATION = "allocation";
    private volatile boolean isReSeted = false;
    private List<Object> ownerIds;

    public void initialize() {
        if (!this.isLookup() && !this.isReSeted) {
            this.setTreeInitFilter();
        }
    }

    private List<Object> getOwnerIDs() {
        if (this.ownerIds == null) {
            this.ownerIds = UserUtil.getOwnerIDs();
        }
        return this.ownerIds;
    }

    private List<ComboItem> getOwnerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        if (this.isLookup()) {
            return;
        }
        this.initOwnerFilterComboItem(e, "owner.name");
    }

    private void initOwnerFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey) {
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getOwnerComboItem();
            if (comboItems.size() > 0) {
                col.setDefaultValue(UserUtil.getDefaultOwnerID().toString());
            }
            col.setComboItems(comboItems);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "allocation": {
                    this.toAllocationPage();
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (!this.isLookup()) {
            this.setListFilter(e);
        }
    }

    private void setListFilter(SetFilterEvent e) {
        List fs = e.getQFilters();
        HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>(fs.size());
        for (QFilter f : fs) {
            fsMap.put(f.getProperty(), f);
        }
        if (!fsMap.containsKey("owner.id")) {
            fs.add(this.createFilter());
        }
    }

    private void setTreeInitFilter() {
        TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
        List treeFilter = treeListModel.getTreeFilter();
        List<Object> ids = this.getOwnerIDs();
        if (ids.size() == 0) {
            treeFilter.add(new QFilter("owner.id", "=", (Object)0L));
        } else {
            treeFilter.add(new QFilter("owner.id", "=", ids.get(0)));
        }
    }

    private QFilter createFilter() {
        return new QFilter("owner.id", "in", this.getOwnerIDs());
    }

    private void toAllocationPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        int size = ids.length;
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"RegionListPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        if (size > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01", (String)"RegionListPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(MDR_REGION_ALLOCATION);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(BTN_ALLOCATION);
        parameter.setCustomParam("regionID", ids[0]);
        this.getView().showForm(parameter);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        this.getTreeListView().focusRootNode();
        if (this.isLookup()) {
            return;
        }
        List fs = e.getSearchClickEvent().getFilterParameter().getQFilters();
        this.reSetTree(fs);
    }

    private void reSetTree(List<QFilter> fs) {
        QFilter treeFilter = null;
        for (QFilter f : fs) {
            if (!"owner.id".equals(f.getProperty())) continue;
            treeFilter = f;
            break;
        }
        ITreeListView treeView = this.getTreeListView();
        TreeListModel treeModel = (TreeListModel)treeView.getTreeModel();
        List treeFilters = treeModel.getTreeFilter();
        if (treeFilter == null) {
            treeFilter = this.getOwnerFilter();
        }
        ArrayList<QFilter> newFilter = new ArrayList<QFilter>();
        newFilter.add(treeFilter);
        for (QFilter f : treeFilters) {
            if ("owner.id".equals(f.getProperty())) continue;
            newFilter.add(f);
        }
        treeModel.setTreeFilter(newFilter);
        this.isReSeted = true;
        treeView.refreshTreeView();
    }

    private QFilter getOwnerFilter() {
        return new QFilter("owner.id", "in", this.getOwnerIDs());
    }
}

