/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.salecontrol;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.KV;
import kd.drp.mdr.common.util.CustomerAdminUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class SaleControlRuleAddPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String TB_RULE = "tbrule";
    private static final String TO_SAVE = "tosave";
    private static final String CAN_SALE = "cansale";
    private static final String[] EFFECTIVE_STRING = new String[]{"region", "item", "itemclass"};
    private static final String[] COPY_ROW_VALS = new String[]{"region", "item", "itemclass", "cansale"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner", "customer", "customergroup", "region", "item", "itemclass"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String otKey;
        FormOperate formOperate = (FormOperate)evt.getSource();
        switch (otKey = formOperate.getOperateKey()) {
            case "tosave": {
                this.checkAndSave(evt);
                break;
            }
        }
    }

    private void checkAndSave(BeforeDoOperationEventArgs e) {
        Object cusObj = this.getCustomerF7PKValue();
        DynamicObject groupObj = this.getF7Value("customergroup");
        if (cusObj == null && groupObj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u4e0e\u8ba2\u8d27\u6e20\u9053\u5206\u7c7b\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\uff01", (String)"SaleControlRuleAddPlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowCount = this.getModel().getEntryRowCount(TB_RULE);
        if (rowCount <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6709\u4e00\u6761\u89c4\u5219\u624d\u80fd\u4fdd\u5b58\uff01", (String)"SaleControlRuleAddPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        HashSet<String> idSet = new HashSet<String>(16);
        DynamicObject rowInfo = null;
        String ids = null;
        for (int i = 0; i < rowCount; ++i) {
            rowInfo = this.getRowInfo(TB_RULE, i);
            ids = this.getEffectiveString(rowInfo);
            if (ids == null) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6e20\u9053\u4fe1\u606f\u548c\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SaleControlRuleAddPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]), i + 1));
                e.setCancel(true);
                return;
            }
            if (idSet.add(ids)) continue;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u89c4\u5219\u91cd\u590d\uff0c\u8bf7\u5220\u9664\uff01", (String)"SaleControlRuleAddPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]), i + 1));
            e.setCancel(true);
            return;
        }
    }

    private String getEffectiveString(DynamicObject rowInfo) {
        StringBuilder sb = new StringBuilder();
        DynamicObject val = null;
        int count = 0;
        int len = EFFECTIVE_STRING.length;
        for (int i = 0; i < len; ++i) {
            val = rowInfo.getDynamicObject(EFFECTIVE_STRING[i]);
            if (val != null) {
                sb.append(val.get("id"));
                ++count;
                continue;
            }
            sb.append("-");
        }
        if (count != 1) {
            return null;
        }
        return sb.toString();
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache;
        String ownerId;
        this.initDefaultVal();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (ownerId = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get(parentView.getPageId() + "ownerId")) != null && !ownerId.toString().trim().equals("")) {
            this.setOwnerF7Value(ownerId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        int index = this.getRowIndex(e);
        switch (key) {
            case "owner": {
                this.ownerChanged();
                break;
            }
            case "customer": {
                this.customerChanged();
                break;
            }
            case "customergroup": {
                this.customergroupChanged();
                break;
            }
            case "region": {
                this.regionChanged(index);
                break;
            }
            case "item": {
                this.itemChanged(index);
                break;
            }
            case "itemclass": {
                this.itemClassChanged(index);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void itemClassChanged(int index) {
        this.setValue("item", null, index);
    }

    private void itemChanged(int index) {
        this.setValue("itemclass", null, index);
    }

    private void regionChanged(int index) {
        this.setValue("customergroup", null, index);
        this.setValue("customer", null, index);
    }

    private void customergroupChanged() {
        this.setValue("customer", null);
        this.getModel().deleteEntryData(TB_RULE);
        this.getModel().createNewEntryRow(TB_RULE);
    }

    private void customerChanged() {
        this.setValue("customergroup", null);
        this.getModel().deleteEntryData(TB_RULE);
        this.getModel().createNewEntryRow(TB_RULE);
    }

    private void ownerChanged() {
        this.reSetControl();
        this.setValue("customer", null);
        this.setValue("customergroup", null);
        this.getModel().deleteEntryData(TB_RULE);
        this.getModel().createNewEntryRow(TB_RULE);
    }

    private void reSetControl() {
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            return;
        }
        String controlType = CustomerParamsUtil.getSaleControlType((Object)ownerId);
        this.getPageCache().put(CAN_SALE, controlType);
    }

    private void initDefaultVal() {
        DynamicObjectCollection doc;
        Set owners = UserUtil.getAuthorizedOwnerIDs();
        if (owners.size() == 0) {
            return;
        }
        if (owners.size() == 1) {
            this.setUnEnable(new String[]{"customer"});
        }
        Long userid = (Long)UserUtil.getUserID();
        QFilter filter = new QFilter("sysuser", "=", (Object)userid).and("enable", "=", (Object)"1");
        String orders = "isdefault desc";
        Set allCustomerIds = CustomerAdminUtil.getAllCustomersByAdmin((Object)userid);
        if (allCustomerIds != null && !allCustomerIds.isEmpty()) {
            filter.and("owner", "in", (Object)allCustomerIds);
        }
        if ((doc = QueryServiceHelper.query((String)"dbd_drp_user", (String)"owner", (QFilter[])new QFilter[]{filter}, (String)orders)).size() > 0) {
            this.setOwnerF7Value(((DynamicObject)doc.get(0)).get("owner"));
        }
        this.reSetControl();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getAuthorizedCommonUserOwnersFilter());
                return;
            }
            case "customer": {
                CheckResult result = this.checkOwnerBeforeSelect();
                if (!result.isSuccess()) {
                    this.getView().showMessage(result.getMsg());
                    e.setCancel(true);
                    return;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
                return;
            }
        }
        int index = e.getRow();
        CheckResult result = this.checkOwnerBeforeSelect();
        if (result.isSuccess()) {
            e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            switch (key) {
                case "customergroup": {
                    DynamicObject dobj = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"mdr_cust_standard_apply");
                    DynamicObject standardObj = dobj.getDynamicObject("classstandardid");
                    if (standardObj == null) break;
                    Long groupStandardPK = Long.valueOf(standardObj.get("id").toString());
                    formShowParameter.setCustomParam("groupStandard", (Object)groupStandardPK);
                    QFilter standardFilter = new QFilter("classstandard", "=", (Object)groupStandardPK);
                    formShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                    break;
                }
                case "region": {
                    this.setNoTreeF7(e);
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getRegionFitler(index));
                    break;
                }
                case "item": {
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFitler(index));
                    break;
                }
                case "itemclass": {
                    DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)6L, (String)"mdr_classstandardapply");
                    long standardId = itemClassStandard.getLong("classstandardid_id");
                    if (standardId <= 0L) break;
                    formShowParameter.setCustomParam("groupStandard", (Object)standardId);
                    QFilter itemStandardFilter = new QFilter("standard", "=", (Object)standardId);
                    formShowParameter.getListFilterParameter().getQFilters().add(itemStandardFilter);
                    break;
                }
            }
        } else {
            this.getView().showMessage(result.getMsg());
            e.setCancel(true);
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        switch (key = evt.getActionId()) {
            case "customergroup": 
            case "region": 
            case "item": 
            case "itemclass": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
                if (rows == null || rows.size() == 0) break;
                List<Object> ids = this.getIds(rows);
                int rowIndex = this.getCurrentRowIndex(TB_RULE);
                this.setValue(key, ids.get(0), rowIndex);
                if (ids.size() <= 1) break;
                this.handleOtherRows(rowIndex, ids, key);
                break;
            }
        }
    }

    private List<Object> getIds(ListSelectedRowCollection rows) {
        ArrayList<Object> ids = new ArrayList<Object>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        return ids;
    }

    private void handleOtherRows(int currentRowIndex, List<Object> rowValues, String key) {
        Map<String, Object> exsistValues = this.getCopyRowVals(this.getRowInfo(TB_RULE, currentRowIndex));
        int[] indexs = this.getModel().appendEntryRow(TB_RULE, currentRowIndex + 1, rowValues.size() - 1);
        int len = rowValues.size() - 1;
        for (int i = 0; i < len; ++i) {
            for (Map.Entry<String, Object> col : exsistValues.entrySet()) {
                this.setValue(col.getKey(), col.getValue(), indexs[i]);
            }
            this.setValue(key, rowValues.get(i + 1), indexs[i]);
        }
    }

    private Map<String, Object> getCopyRowVals(DynamicObject row) {
        HashMap<String, Object> vals = new HashMap<String, Object>(COPY_ROW_VALS.length);
        int len = COPY_ROW_VALS.length;
        for (int i = 0; i < len; ++i) {
            vals.put(COPY_ROW_VALS[i], row.get(COPY_ROW_VALS[i]));
        }
        return vals;
    }

    private QFilter getOwnerFilter() {
        return this.getCommonOwnerFitler();
    }

    private QFilter getCustomerFitler() {
        QFilter fs = new QFilter("authowner.id", "=", this.getOwnerF7PKValue());
        fs.and("marketability", "=", (Object)"1");
        Set ids = QueryUtil.querySingleCol((String)"mdr_customer_authorize", (String)"customer.id", (QFilter[])fs.toArray());
        fs = new QFilter("id", "in", (Object)ids);
        return fs;
    }

    private List<QFilter> getItemClassFitler(int index) {
        ArrayList<QFilter> fList = new ArrayList<QFilter>();
        Set<Object> existIds = this.getExistIds("itemclass", index);
        if (!existIds.isEmpty()) {
            fList.add(new QFilter("id", "not in", existIds));
        }
        return fList;
    }

    private List<QFilter> getItemFitler(int index) {
        IPageCache pageCache = this.getPageCache();
        ArrayList<QFilter> allList = new ArrayList<QFilter>();
        QFilter ruleFilter = ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOwnerF7PKValue(), (IPageCache)pageCache);
        if (ruleFilter != null) {
            allList.add(ruleFilter);
        }
        Set<Object> existIds = this.getExistIds("item", index);
        QFilter fs = new QFilter("id", "not in", existIds);
        allList.add(fs);
        return allList;
    }

    private QFilter getRegionFitler(int index) {
        QFilter fs = new QFilter("owner", "=", this.getOwnerF7PKValue());
        Set<Object> existIds = this.getExistIds("region", index);
        if (!existIds.isEmpty()) {
            fs.and("id", "not in", existIds);
        }
        return fs;
    }

    private CheckResult checkOwnerBeforeSelect() {
        if (this.getOwnerF7Value() == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053\uff01", (String)"SaleControlRuleAddPlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
        }
        return CheckResult.returnTrue();
    }

    private Set<Object> getExistIDsInPage(String f7Key, int index) {
        HashSet<Object> ids = new HashSet<Object>();
        DynamicObject currentRowInfo = this.getRowInfo(TB_RULE, index);
        KV keFilter = this.getRowKVFilter(currentRowInfo, f7Key);
        if (keFilter == null) {
            return ids;
        }
        DynamicObject rowInfo = null;
        int count = this.getModel().getEntryRowCount(TB_RULE);
        KV kv = null;
        for (int i = 0; i < count; ++i) {
            KV f7KV;
            if (i == index || !keFilter.equals((Object)(kv = this.getRowKVFilter(rowInfo = this.getRowInfo(TB_RULE, i), f7Key))) || (f7KV = this.getRowKV(rowInfo, f7Key)) == null) continue;
            ids.add(f7KV.getVal());
        }
        return ids;
    }

    private KV getRowKV(DynamicObject rowInfo, String f7Key) {
        DynamicObject info = rowInfo.getDynamicObject(f7Key);
        if (info == null) {
            return null;
        }
        return new KV(f7Key, info.get("id"));
    }

    private KV getRowKVFilter(DynamicObject rowInfo, String f7Key) {
        switch (f7Key) {
            case "item": 
            case "itemclass": {
                return this.getCustomerInfoKV(rowInfo);
            }
            case "customer": 
            case "customergroup": 
            case "region": {
                return this.getItemInfoKV(rowInfo);
            }
        }
        return null;
    }

    private KV getCustomerInfoKV(DynamicObject rowInfo) {
        DynamicObject groupinfo;
        KV kv = null;
        DynamicObject info = this.getF7Value("customer");
        if (info != null) {
            kv = new KV("customer", info.get("id"));
        }
        if (kv == null && (groupinfo = this.getF7Value("customergroup")) != null) {
            kv = new KV("customer", groupinfo.get("id"));
        }
        if (kv == null) {
            kv = this.getRowKV(rowInfo, "region");
        }
        return kv;
    }

    private QFilter getExistIdsQFilterByCustomerInfo(int index) {
        DynamicObject groupInfo;
        QFilter fs = null;
        DynamicObject info = this.getF7Value("customer");
        if (info != null) {
            fs = new QFilter("customer", "=", info.get("id"));
        }
        if (fs == null && (groupInfo = this.getF7Value("customergroup")) != null) {
            fs = new QFilter("customergroup", "=", groupInfo.get("id"));
        }
        if (fs == null) {
            DynamicObject rowInfo = this.getRowInfo(TB_RULE, index);
            fs = this.getInfoFilter(rowInfo, "region");
        }
        return fs;
    }

    private QFilter getExistIdsQFilterByItemInfo(int index) {
        DynamicObject rowInfo = this.getRowInfo(TB_RULE, index);
        QFilter fs = this.getInfoFilter(rowInfo, "item");
        if (fs == null) {
            fs = this.getInfoFilter(rowInfo, "itemclass");
        }
        return fs;
    }

    private KV getItemInfoKV(DynamicObject rowInfo) {
        KV kv = this.getRowKV(rowInfo, "item");
        if (kv == null) {
            kv = this.getRowKV(rowInfo, "itemclass");
        }
        return kv;
    }

    private QFilter getInfoFilter(DynamicObject rowInfo, String colKey) {
        DynamicObject info = rowInfo.getDynamicObject(colKey);
        if (info != null) {
            return new QFilter(colKey, "=", info.get("id"));
        }
        return null;
    }

    private Set<Object> getExistIds(String f7Key, int index) {
        HashSet<Object> ids = new HashSet<Object>();
        QFilter fs = null;
        switch (f7Key) {
            case "item": 
            case "itemclass": {
                fs = this.getExistIdsQFilterByCustomerInfo(index);
                break;
            }
            case "customer": 
            case "customergroup": 
            case "region": {
                fs = this.getExistIdsQFilterByItemInfo(index);
            }
        }
        if (fs != null) {
            fs.and("owner", "=", this.getOwnerF7PKValue());
            ids.addAll(QueryUtil.querySingleCol((String)"mdr_salecontrol", (String)f7Key, (QFilter[])fs.toArray()));
        }
        ids.addAll(this.getExistIDsInPage(f7Key, index));
        return ids;
    }
}

