/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.spu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.drp.dbd.business.handle.SpuHandler;
import kd.drp.mdr.common.enums.Enable;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.formplugin.MdrBillPlugin;
import org.apache.commons.lang.StringUtils;

public class SpuEdit
extends MdrBillPlugin
implements BeforeF7SelectListener {
    public static final String OP_NEWENTRY_SPEC = "newentry_spec";
    public static final String OP_DELETEENTRY_SPEC = "deleteentry_spec";
    public static final String OP_NEWENTRY_SPECVALUE = "newentry_specvalue";
    public static final String OP_DELETEENTRY_SPECVALUE = "deleteentry_specvalue";
    public static final String OP_DELETEENTRY_MAP = "deleteentry_map";
    public static final String OP_MAPINIT = "mapinit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"specid", "specvalueid", "itemid"});
    }

    public void afterBindData(EventObject e) {
        Object createOrgId;
        super.afterBindData(e);
        if (this.isEdit()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity_specmap");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject itemDy = entry.getDynamicObject("itemid");
                if (itemDy == null) continue;
                DynamicObject materialDy = entry.getDynamicObject("materielid");
                Object auxptyId = 0L;
                if (materialDy != null && materialDy.getBoolean("isuseauxpty")) {
                    DynamicObject auxptyDy = entry.getDynamicObject("auxptyid");
                    auxptyId = auxptyDy != null ? auxptyDy.getPkValue() : Long.valueOf(0L);
                }
                boolean exist = SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"entryentity_specmap", (Object)itemDy.getPkValue(), (Object)auxptyId);
                this.getView().setEnable(Boolean.valueOf(!exist), i, new String[]{"itemid", "auxptyid", "spumapname", "spumapnumber", "spumapids"});
            }
        }
        if (!kd.drp.mdr.common.StringUtils.isEmpty((Object)(createOrgId = this.getView().getFormShowParameter().getCustomParam("createorgid")))) {
            this.setValue("createorgid", createOrgId, false);
        }
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        this.getView().setEnable(Boolean.valueOf(!fromDatabase), new String[]{"createorgid"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name;
        switch (name = arg0.getProperty().getName()) {
            case "specid": {
                QFilter excludeExistF7Id = this.excludeExistF7Id("entryentity_spec", "specid", "id");
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)excludeExistF7Id);
                break;
            }
            case "specvalueid": {
                boolean refrenced;
                Object entryF7PKValue = this.getEntryF7PKValue("subentryentity_spec", "specvalueid", arg0.getRow());
                if (entryF7PKValue != null && (refrenced = SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"specvalueid", (Object)entryF7PKValue, null))) {
                    arg0.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5spu\u89c4\u683c\u503c\u5bf9\u5e94\u7684\u5546\u54c1\u5df2\u7ecf\u53d1\u5e03,\u4e0d\u80fd\u4fee\u6539\u5176\u89c4\u683c\u503c", (String)"SpuEdit_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter excludeExistSpecvalueid = this.excludeExistF7Id("subentryentity_spec", "specvalueid", "id");
                DynamicObject entrySpecDy = this.getEntryF7Value("entryentity_spec", "specid", this.getCurrentRowIndex("entryentity_spec"));
                if (entrySpecDy == null) {
                    arg0.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9spu\u89c4\u683c", (String)"SpuEdit_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                QFilter filter = new QFilter("group", "=", entrySpecDy.getPkValue());
                excludeExistSpecvalueid.and(filter);
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)excludeExistSpecvalueid);
                break;
            }
            case "itemid": {
                Object itemid = this.getEntryF7PKValue("entryentity_specmap", "itemid", arg0.getRow());
                Object auxptyid = this.getEntryF7PKValue("entryentity_specmap", "auxptyid", arg0.getRow());
                if (itemid != null) {
                    Object object = auxptyid = auxptyid == null ? Long.valueOf(0L) : auxptyid;
                    if (SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"entryentity_specmap", (Object)itemid, (Object)auxptyid)) {
                        arg0.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5spu\u89c4\u683c\u7ec4\u5408\u503c\u5bf9\u5e94\u7684\u5546\u54c1\u5df2\u7ecf\u53d1\u5e03,\u4e0d\u80fd\u4fee\u6539", (String)"SpuEdit_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)arg0, (QFilter)this.addItemFilter());
                break;
            }
        }
    }

    private QFilter addItemFilter() {
        QFilter filter = new QFilter("hasattr", "=", (Object)Enable.DISABLE);
        return filter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "itemid": {
                this.updateF7Field2F7(e.getChangeSet(), "itemid", "material", "materielid", false);
                break;
            }
            case "createorgid": {
                this.getModel().deleteEntryData("entryentity_specmap");
                break;
            }
            case "specid": {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue == oldValue) break;
                this.getModel().deleteEntryData("subentryentity_spec");
                this.getModel().deleteEntryData("entryentity_specmap");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "newentry_spec": 
            case "deleteentry_spec": {
                boolean refrenced = SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"specid", null, null);
                if (refrenced) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5spu\u5df2\u7ecf\u53d1\u5e03,\u4e0d\u80fd\u4fee\u6539\u5176\u89c4\u683c", (String)"SpuEdit_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().deleteEntryData("entryentity_specmap");
                break;
            }
            case "deleteentry_specvalue": {
                EntryGrid specValueEntry = (EntryGrid)this.getControl("subentryentity_spec");
                int[] selectRows = specValueEntry.getSelectRows();
                ArrayList<Integer> delRow = new ArrayList<Integer>();
                for (int i : selectRows) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("subentryentity_spec", i);
                    Object specValueId = DynamicObjectUtils.getPkId((DynamicObject)entryRowEntity, (String)"specvalueid");
                    if (specValueId == null) continue;
                    boolean refrenced2 = SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"specvalueid", (Object)specValueId, null);
                    if (refrenced2) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5spu\u89c4\u683c\u503c\u5bf9\u5e94\u7684\u5546\u54c1\u5df2\u7ecf\u53d1\u5e03,\u4e0d\u80fd\u5220\u9664\u5176\u89c4\u683c\u503c", (String)"SpuEdit_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    delRow.clear();
                    DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("entryentity_specmap");
                    for (DynamicObject dynamicObject : mapEntry) {
                        String mapJson = dynamicObject.getString("spumapids");
                        if (!mapJson.contains(specValueId.toString())) continue;
                        delRow.add(dynamicObject.getInt("seq"));
                    }
                    int[] delRow2 = new int[delRow.size()];
                    int j = 0;
                    for (Integer Row2 : delRow) {
                        delRow2[j] = Row2 - 1;
                        ++j;
                    }
                    this.getModel().deleteEntryRows("entryentity_specmap", delRow2);
                }
                break;
            }
            case "deleteentry_map": {
                int[] selectmapRows;
                EntryGrid mapEntry = (EntryGrid)this.getControl("entryentity_specmap");
                for (int i : selectmapRows = mapEntry.getSelectRows()) {
                    Object itemid = this.getEntryF7PKValue("entryentity_specmap", "itemid", i);
                    Object auxptyid = this.getEntryF7PKValue("entryentity_specmap", "auxptyid", i);
                    Object object = auxptyid = auxptyid == null ? Long.valueOf(0L) : auxptyid;
                    if (itemid == null || !SpuHandler.isRefrenced((IDataModel)this.getModel(), (String)"entryentity_specmap", (Object)itemid, (Object)auxptyid)) continue;
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5spu\u89c4\u683c\u7ec4\u5408\u503c\u5bf9\u5e94\u7684\u5546\u54c1\u5df2\u7ecf\u53d1\u5e03,\u4e0d\u80fd\u5220\u9664", (String)"SpuEdit_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                break;
            }
            case "mapinit": {
                boolean isCheck = this.mapCheck();
                if (!isCheck) break;
                this.mapinit();
                break;
            }
            case "save": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity_specmap");
                List filterentrys = entryEntity.stream().filter(m -> m.get("itemid") == null).collect(Collectors.toList());
                int[] rows = new int[filterentrys.size()];
                for (int i = 0; i < filterentrys.size(); ++i) {
                    rows[i] = ((DynamicObject)filterentrys.get(i)).getInt("seq") - 1;
                }
                this.getModel().deleteEntryRows("entryentity_specmap", rows);
            }
        }
    }

    private boolean mapCheck() {
        DynamicObjectCollection specs = this.getModel().getEntryEntity("entryentity_spec");
        if (specs == null || specs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u89c4\u683c", (String)"SpuEdit_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject specDy = null;
        DynamicObject specvalueDy = null;
        for (int i = 0; i < specs.size(); ++i) {
            specDy = ((DynamicObject)specs.get(i)).getDynamicObject("specid");
            if (specDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c", (String)"SpuEdit_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u89c4\u683c\u4e3a\u7a7a\u3002", (String)"SpuEdit_8", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection subRowObjs = ((DynamicObject)specs.get(i)).getDynamicObjectCollection("subentryentity_spec");
            if (subRowObjs == null || subRowObjs.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)String.format("%s\u8bf7\u5148\u6dfb\u89c4\u683c\u503c", specDy.getLocaleString("name")), (String)"SpuEdit_9", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (int j = 0; j < subRowObjs.size(); ++j) {
                specvalueDy = ((DynamicObject)subRowObjs.get(j)).getDynamicObject("specvalueid");
                if (specvalueDy != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c", (String)"SpuEdit_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u89c4\u683c\u503c\u4e3a\u7a7a\u3002", (String)"SpuEdit_10", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void mapinit() {
        Object specList;
        Object allSpecList = new ArrayList(16);
        ArrayList<Object> specValueList = new ArrayList<Object>(16);
        DynamicObjectCollection specEntrys = this.getModel().getEntryEntity("entryentity_spec");
        List sortspecEntrys = specEntrys.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1.getDynamicObject("specid").getInt("sort") - o2.getDynamicObject("specid").getInt("sort") != 0) {
                    return o1.getDynamicObject("specid").getInt("sort") - o2.getDynamicObject("specid").getInt("sort");
                }
                return (int)(o2.getDynamicObject("specid").getDate("createtime").getTime() - o1.getDynamicObject("specid").getDate("createtime").getTime());
            }
        }).collect(Collectors.toList());
        for (DynamicObject dynamicObject : sortspecEntrys) {
            DynamicObjectCollection subSpecValueEntrys = dynamicObject.getDynamicObjectCollection("subentryentity_spec");
            ArrayList list = new ArrayList(subSpecValueEntrys.size());
            for (DynamicObject subentry : subSpecValueEntrys) {
                list.add(subentry);
            }
            specValueList.add(list);
        }
        for (List list : specValueList) {
            int size = allSpecList.size();
            if (size == 0) {
                for (DynamicObject specDy : list) {
                    ArrayList specDyList = new ArrayList();
                    specDyList.add(specDy);
                    allSpecList.add(specDyList);
                }
                continue;
            }
            ArrayList newAllspecList = new ArrayList();
            for (int i = 0; i < size; ++i) {
                for (DynamicObject specDy : list) {
                    specList = new ArrayList<DynamicObject>((Collection)allSpecList.get(i));
                    specList.add(specDy);
                    newAllspecList.add(specList);
                }
            }
            allSpecList = newAllspecList;
        }
        int size = allSpecList.size();
        if (size == 0) {
            this.getModel().deleteEntryData("entryentity_specmap");
            return;
        }
        ArrayList<List> arrayList = new ArrayList<List>();
        DynamicObjectCollection map = this.getModel().getEntryEntity("entryentity_specmap");
        for (DynamicObject entry : map) {
            DynamicObjectCollection subEntry = entry.getDynamicObjectCollection("subentryentity_specmap");
            List collect = subEntry.stream().map(m -> m.getDynamicObject("mapspecvalueid").getPkValue()).collect(Collectors.toList());
            specList = allSpecList.iterator();
            while (specList.hasNext()) {
                List collect2;
                List list = (List)specList.next();
                if (CollectionUtils.isEmpty((Collection)list) || !StringUtils.join(collect2 = list.stream().map(m -> m.getDynamicObject("specvalueid").getPkValue()).collect(Collectors.toList()), (char)',').equals(StringUtils.join(collect, (char)','))) continue;
                arrayList.add(list);
            }
        }
        allSpecList.removeAll(arrayList);
        size = allSpecList.size();
        if (size > 0) {
            int[] prentRowIds = this.getModel().batchCreateNewEntryRow("entryentity_specmap", size);
            String[] batchNumber = this.batchMapNumber(size);
            if (batchNumber == null || batchNumber.length == 0) {
                int len = this.getModel().getEntryRowCount("entryentity_specmap");
                int[] delRows = new int[len];
                for (int i = 0; i < len; ++i) {
                    delRows[i] = i;
                }
                this.getModel().deleteEntryRows("entryentity_specmap", delRows);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230SPU\u89c4\u683c\u7ec4\u5408\u7684\u201c\u7f16\u7801\u89c4\u5219\u201d", (String)"SpuEdit_11", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder mapName = new StringBuilder();
            StringBuilder mapNum = new StringBuilder();
            StringBuilder mapids = new StringBuilder();
            for (int i = 0; i < prentRowIds.length; ++i) {
                List specList2 = (List)allSpecList.get(i);
                mapName.setLength(0);
                mapNum.setLength(0);
                mapids.setLength(0);
                mapids.append("[");
                this.getModel().setEntryCurrentRowIndex("entryentity_specmap", prentRowIds[i]);
                this.getModel().deleteEntryData("subentryentity_specmap");
                int[] subrowIds = this.getModel().batchCreateNewEntryRow("subentryentity_specmap", specList2.size());
                for (int j = 0; j < subrowIds.length; ++j) {
                    Object specValueId = null;
                    DynamicObject specValueRow = (DynamicObject)specList2.get(j);
                    if (specValueRow != null) {
                        specValueId = specValueRow.getDynamicObject("specvalueid").getPkValue();
                        mapName.append(specValueRow.getDynamicObject("specvalueid").getString("name")).append('+');
                        mapNum = mapNum.append(batchNumber[i]);
                        Object mapspecId = specValueRow.getDynamicObject("specvalueid").getDynamicObject("group").getPkValue();
                        this.getModel().setValue("mapspecid", mapspecId, subrowIds[j]);
                        mapids.append("{\"key\":").append(mapspecId).append(",").append("\"value\":").append(specValueId).append("}").append(",");
                    }
                    this.getModel().setValue("mapspecvalueid", specValueId, subrowIds[j]);
                }
                mapName.setLength(mapName.lastIndexOf("+"));
                mapids.setLength(mapids.lastIndexOf(","));
                mapids.append("]");
                this.getModel().setValue("spumapname", (Object)mapName.toString(), prentRowIds[i]);
                this.getModel().setValue("spumapnumber", (Object)batchNumber[i], prentRowIds[i]);
                this.getModel().setValue("spumapids", (Object)mapids.toString(), prentRowIds[i]);
            }
        }
    }

    private String[] batchMapNumber(int size) {
        DynamicObject spuMap = BusinessDataServiceHelper.newDynamicObject((String)"dbd_spu_map");
        spuMap.set("spuid", (Object)this.getModel().getDataEntity());
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"dbd_spu_map", (DynamicObject)spuMap, null, (int)size);
        return batchNumber;
    }
}

