/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.tempkey;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.cache.CustomerTreeCache;
import kd.drp.mdr.common.cache.ItemClassTreeCache;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.pagemodel.CreateJavaFile;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class TempKeySearchPlugin
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private static final String BAR_GETREDISKEY = "getrediskey";
    private static final String BAR_GETREDIS_ALL_KEY = "getredisallkey";
    private static final String TBL_SEARCH = "tblsearch";
    private static final String TBL_CLEAR = "tblclear";
    private static final String SEARCH_KEY = "searchkey";
    private static final String BAR_CUSTOMER_TREE = "reflashcustomertree";
    private static final String BAR_ITEMCLASS_TREE = "reflashitemclasstree";
    private static final String BAR_TO_SELECT = "toselect";
    private static final String BAR_CREATE_BY_INPUT = "createbyinput";
    private static final String BAR_CREATE_BY_SELECT = "createbyselect";
    private static final String BAR_TO_SELECT_SQL = "toselectsql";
    private static final String REFLASH_META = "reflashmeta";
    private static final String REFLASH_TB = "reflashtb";
    private static final String LOAD_FROM_CACHE = "loadfromcache";
    private static final DBRoute MDR_ROUTE = new DBRoute("mdr");

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "tbtable"});
        this.addClickListeners(new String[]{BAR_CUSTOMER_TREE, BAR_ITEMCLASS_TREE, BAR_TO_SELECT, BAR_TO_SELECT_SQL, BAR_GETREDISKEY, BAR_GETREDIS_ALL_KEY, REFLASH_META, REFLASH_TB, BAR_CREATE_BY_INPUT, BAR_CREATE_BY_SELECT, LOAD_FROM_CACHE});
        this.addF7Listener(this, new String[]{"entityobject"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "reflashmeta": {
                this.reflashMeta();
                break;
            }
            case "reflashtb": {
                this.reflashTB();
                break;
            }
            case "reflashcustomertree": {
                CustomerTreeCache.refreshCache();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e20\u9053\u6811\u5237\u65b0\u6210\u529f\uff01", (String)"TempKeySearchPlugin_0", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "reflashitemclasstree": {
                ItemClassTreeCache.refreshCache();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u6811\u5237\u65b0\u6210\u529f\uff01", (String)"TempKeySearchPlugin_1", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "toselect": {
                this.toSelect();
                break;
            }
            case "toselectsql": {
                this.toSelectSQL();
                break;
            }
            case "createbyinput": {
                this.createFromInput();
                break;
            }
            case "createbyselect": {
                this.createFromSelect();
                break;
            }
            case "getrediskey": {
                this.getRedisKeyValue();
                break;
            }
            case "getredisallkey": {
                this.getRedisAllKeys();
                break;
            }
            case "loadfromcache": {
                this.loadFromCache();
                break;
            }
        }
    }

    private void loadFromCache() {
        String json = this.getStringValue("jsonparams");
        JSONObject param = JSON.parseObject((String)json);
        String loadName = param.getString("loadname");
        String cols = param.getString("loadcols");
        JSONArray fsArr = param.getJSONArray("loadfs");
        QFilter[] fs = new QFilter[fsArr.size()];
        JSONObject f = null;
        ArrayList<QFilter> fsList = new ArrayList<QFilter>(fs.length);
        for (int i = 0; i < fsArr.size(); ++i) {
            f = fsArr.getJSONObject(i);
            fs[i] = new QFilter(f.getString("col"), f.getString("qcp"), f.get((Object)"value"));
            fsList.add(fs[i]);
        }
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)loadName, (String)cols, (QFilter[])fs);
        this.setValue("loadresult", String.format("fs\uff1a%s -------  result\uff1a%s", fsList, loadFromCache.keySet()));
    }

    private void getRedisAllKeys() {
        String regionKey;
        String pageId = this.getStringValue("redispageid");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{pageId})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"redis-pageid\u5fc5\u5f55", (String)"TempKeySearchPlugin_2", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache");
        List keys = cache.getKeys(regionKey = CacheKeyUtil.getAcctId() + ".pagecache" + pageId + ".sessionId." + RequestContext.get().getGlobalSessionId());
        if (keys != null) {
            this.setValue("redisvalue", keys.toString());
        }
    }

    private void getRedisKeyValue() {
        String key = this.getStringValue("rediskey");
        String pageId = this.getStringValue("redispageid");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{key, pageId})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"redis-key,redis-pageid\u5fc5\u5f55", (String)"TempKeySearchPlugin_3", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        PageCache cache = new PageCache(pageId);
        String value = cache.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = ResManager.loadKDString((String)"\u6ca1\u67e5\u5230\u503c", (String)"TempKeySearchPlugin_4", (String)"drp-dbd-formplugin", (Object[])new Object[0]);
        }
        this.setValue("redisvalue", value);
    }

    private void createFromInput() {
        List<String> models = this.getModelsFromInput();
        new CreateJavaFile(models).create();
    }

    private void createFromSelect() {
        List<String> models = this.getModelsFromSelect();
        new CreateJavaFile(models).create();
    }

    private List<String> getModelsFromSelect() {
        DynamicObjectCollection models = this.getModel().getDataEntity().getDynamicObjectCollection("selectpagemodels");
        ArrayList<String> modelNumbers = new ArrayList<String>(models.size());
        for (DynamicObject model : models) {
            modelNumbers.add(model.getString("fbasedataid_id"));
        }
        return modelNumbers;
    }

    private List<String> getModelsFromInput() {
        List<String> models = new ArrayList<String>();
        String pages = this.getTextFieldValue("inputpagemodels");
        if (StringUtils.isNotEmpty((CharSequence)pages.trim())) {
            models = Arrays.asList(pages.split(","));
        }
        return models;
    }

    private Object[] getIds() {
        Object[] ids = null;
        String idStr = this.getModel().getDataEntity().getString("objectids").trim();
        if (!StringUtils.isEmpty((CharSequence)idStr)) {
            String[] idArr = idStr.split("-");
            ids = new Object[idArr.length];
            for (int i = 0; i < idArr.length; ++i) {
                ids[i] = Long.valueOf(idArr[i]);
            }
        }
        return ids;
    }

    private void reflashTB() {
        String tbName = this.getModel().getDataEntity().getString("tbname");
        if (StringUtils.isEmpty((CharSequence)tbName)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8868\u540d\uff0c\u5982\uff1at_mdr_customer", (String)"TempKeySearchPlugin_5", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] ids = this.getIds();
        DataEntityCacheManager manger = new DataEntityCacheManager(tbName);
        if (ids == null) {
            manger.removeByDt();
        } else {
            manger.removeByPrimaryKey(ids);
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\uff01", (String)"TempKeySearchPlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
    }

    private void reflashMeta() {
        DynamicObject entity = this.getF7Value("entityobject");
        String number = entity.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u7f16\u7801number=\u3010%s\u3011\u4e0d\u5b58\u5728\uff01", (String)"TempKeySearchPlugin_7", (String)"drp-dbd-formplugin", (Object[])new Object[0]), number));
            return;
        }
        Object[] ids = this.getIds();
        DataEntityCacheManager manger = new DataEntityCacheManager(BusinessDataServiceHelper.newDynamicObject((String)number).getDataEntityType());
        if (ids == null) {
            manger.removeByDt();
        } else {
            manger.removeByPrimaryKey(ids);
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\uff01", (String)"TempKeySearchPlugin_6", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
    }

    private void toSelectSQL() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().getDataEntity().getString("selectcol");
        this.getModel().getDataEntity().getString("selecttb");
        String sql = dataEntity.getString("selectsql");
        if (!this.checkSQL(sql)) {
            this.getView().showMessage(ResManager.loadKDString((String)"SQL \u8bed\u53e5\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u884c\u6267\u884c\u67e5\u8be2\u8bed\u53e5", (String)"TempKeySearchPlugin_8", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        List<StringBuffer> queryReSult = this.queryReSult(sql);
        this.getModel().setValue("resultinfo", (Object)queryReSult.toString());
    }

    private List<StringBuffer> queryReSult(String sql) {
        String route = this.getModel().getDataEntity().getString("route");
        DBRoute dbRoute = MDR_ROUTE;
        switch (route) {
            case "A": {
                dbRoute = DBRoute.basedata;
                break;
            }
            case "B": {
                dbRoute = MDR_ROUTE;
                break;
            }
        }
        return (List)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<StringBuffer>>(){

            public List<StringBuffer> handle(ResultSet resultSet) throws Exception {
                ArrayList<StringBuffer> res = new ArrayList<StringBuffer>(16);
                ResultSetMetaData metaData = resultSet.getMetaData();
                int count = metaData.getColumnCount();
                StringBuffer reStr = null;
                while (resultSet.next()) {
                    reStr = new StringBuffer();
                    reStr.append("{");
                    for (int i = 1; i <= count; ++i) {
                        if (i != 1) {
                            reStr.append(",");
                        }
                        reStr.append(metaData.getColumnName(i));
                        reStr.append(":");
                        reStr.append(resultSet.getObject(i));
                    }
                    reStr.append("}");
                    res.add(reStr);
                }
                return res;
            }
        });
    }

    private boolean checkSQL(String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return false;
        }
        String lowerStr = sql.toLowerCase();
        if (!StringUtils.startsWith((CharSequence)(lowerStr = lowerStr.trim()), (CharSequence)"select")) {
            return false;
        }
        return !StringUtils.containsAny((CharSequence)lowerStr, (CharSequence[])new CharSequence[]{"update", "drop", "delete", "alter", "create", "grant", "deny", "revoke", "commit", "rollback", "set", "declare", "explan", "open", "fetch", "close", "execute", "describe", "prepare", ";"});
    }

    private void toSelect() {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblsearch": {
                this.searchTempKey();
                break;
            }
            case "tblclear": {
                this.getModel().deleteEntryData("tempkeyentry");
                CacheUtil.clearTempKey();
            }
        }
    }

    private void searchTempKey() {
        IDataModel model = this.getModel();
        model.deleteEntryData("tempkeyentry");
        List keys = CacheUtil.searchTempKeys();
        int len = keys.size();
        if (len == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7f13\u5b58\u4fe1\u606f\uff01", (String)"TempKeySearchPlugin_9", (String)"drp-dbd-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] indexs = model.batchCreateNewEntryRow("tempkeyentry", len);
        for (int i = 0; i < len; ++i) {
            model.setValue("tempkey", keys.get(i), indexs[i]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "searchkey": {
                this.searchOne();
                break;
            }
        }
    }

    private void searchOne() {
        int index = this.getCurrentRowIndex("tempkeyentry");
        DynamicObject rowInfo = this.getRowInfo("tempkeyentry", index);
        String value = CacheUtil.showCacheValue((String)rowInfo.getString("tempkey"));
        this.getModel().setValue("tempvalue", (Object)value, index);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "entityobject": {
                this.setNoTreeF7(e);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntityFitler());
                break;
            }
        }
    }

    private QFilter getEntityFitler() {
        return null;
    }
}

