/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.ticketissue;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.helper.SetBranchRangeHelper;
import kd.drp.dbd.enums.ControlMethodEnum;
import kd.drp.dbd.utils.DynamicObjectUtil;
import kd.drp.dbd.utils.OwnerUtil;

public class TicketIssueFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_TICKETISSUE = "ticket_send";
    private static final String KEY_CALLBACK = "callback";
    private static final String KEY_ID = "fid";
    private static final String KEY_REFRESH = "refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.initDefaultBranchID();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TICKETISSUE});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("branchid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        QFilter qFilter;
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"branchid") && (qFilter = this.buildFilter()) != null) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private QFilter buildFilter() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("bizorgid");
        if (doBizOrg != null) {
            long bizOrgId = Long.parseLong(String.valueOf(doBizOrg.getPkValue()));
            return OwnerUtil.getOwnerIdsFilter((long)bizOrgId);
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)KEY_TICKETISSUE, (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            DynamicObject ticketType = this.getModel().getDataEntity().getDynamicObject("tickettypeid");
            String ticketCodeStatus = this.getTicketCodeRuleStatus(ticketType);
            if ("0".equals(ticketCodeStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5238\u53f7\u89c4\u5219\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5238\u53f7,\u8bf7\u9009\u62e9\u5176\u4ed6\u793c\u5238\u7c7b\u578b", (String)"TicketIssueFormPlugin_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            } else {
                this.openTicketIssueview((Long)this.getModel().getDataEntity().getPkValue());
            }
        }
    }

    private void openTicketIssueview(Long fid) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("gcm_ticketissue_view");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u793c\u5238\u6d3e\u53d1", (String)"TicketIssueFormPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCustomParam(KEY_ID, (Object)fid);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CALLBACK));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (KEY_CALLBACK.equals(closedCallBackEvent.getActionId())) {
            String size = (String)closedCallBackEvent.getReturnData();
            this.updateQty(Integer.parseInt(size));
            this.updateMaketicketstatus();
            this.getView().updateView();
            this.getView().invokeOperation(KEY_REFRESH);
        }
    }

    public void updateMaketicketstatus() {
        DynamicObject tickettype = (DynamicObject)this.getModel().getValue("tickettypeid");
        tickettype.set("maketicketstatus", (Object)"1");
        SaveServiceHelper.update((DynamicObject)tickettype);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        IDataModel dataModel = this.getView().getModel();
        if (e.getChangeSet().length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "validperiodtype": {
                this.controlTypeReact();
                break;
            }
            case "schemecategory": {
                this.schemeTypeReact();
                break;
            }
            case "orgrange": {
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)dataModel.getValue("channelgroup");
                if (customerGroup != null && customerGroup.size() > 0) {
                    dataModel.beginInit();
                    dataModel.setValue("channelgroup", null);
                    this.getView().updateView("channelgroup");
                    dataModel.endInit();
                }
                DynamicObjectCollection range = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)range, (boolean)true, (String)"treeentryentity", (String)"applyorg", (String)"branch", null);
                this.expand();
                break;
            }
            case "channelgroup": {
                DynamicObjectCollection orgRange = (DynamicObjectCollection)dataModel.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                DynamicObjectCollection group = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)group, (boolean)false, (String)"treeentryentity", (String)"applyorg", (String)"branch", null);
                this.expand();
                break;
            }
            case "controlmethod": {
                String controlMethod = String.valueOf(e.getChangeSet()[0].getNewValue());
                if (ControlMethodEnum.ISAPPLYBRANCH.getControlMethod().equals(controlMethod)) break;
                dataModel.deleteEntryData("treeentryentity");
                break;
            }
            case "tickettypeid": {
                this.checkTicketCodeRule();
                break;
            }
        }
    }

    private void checkTicketCodeRule() {
        DynamicObject tickettype = (DynamicObject)this.getModel().getValue("tickettypeid");
        if (tickettype != null && "0".equals(this.getTicketCodeRuleStatus(tickettype))) {
            this.getModel().setValue("tickettypeid", (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5238\u53f7\u89c4\u5219\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5238\u53f7,\u8bf7\u9009\u62e9\u5176\u4ed6\u793c\u5238\u7c7b\u578b", (String)"TicketIssueFormPlugin_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getTicketCodeRuleStatus(DynamicObject tickettype) {
        long ticketcoderuleid = tickettype.getDynamicObject("ticketcoderule").getLong("id");
        DynamicObject coderuleEntity = this.getTicketCodeRuleEntity(ticketcoderuleid);
        return coderuleEntity.getString("enable");
    }

    private DynamicObject getTicketCodeRuleEntity(long ticketcoderuleid) {
        QFilter filter = new QFilter("id", "=", (Object)ticketcoderuleid);
        return BusinessDataServiceHelper.loadSingle((String)"gcm_ticketscoderule", (String)"enable", (QFilter[])filter.toArray());
    }

    private void updateQty(int vosize) {
        int initQty = (Integer)this.getModel().getValue("adtotalqty");
        this.getModel().setValue("adtotalqty", (Object)(initQty + vosize));
        BigDecimal amount = this.getModel().getDataEntity().getBigDecimal("totalticketamt");
        DynamicObject tickettype = (DynamicObject)this.getModel().getValue("tickettypeid");
        BigDecimal ticketvalue = (BigDecimal)tickettype.get("ticketvalue");
        this.getModel().setValue("totalticketamt", (Object)amount.add(ticketvalue.multiply(new BigDecimal(vosize))));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
    }

    private void expand() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlTypeReact();
        this.schemeTypeReact();
    }

    private void controlTypeReact() {
        String validperiodtype = (String)this.getModel().getValue("validperiodtype");
        FieldEdit relativedaycontrol = (FieldEdit)this.getView().getControl("relativedays");
        FieldEdit startdatecontrol = (FieldEdit)this.getView().getControl("startdate");
        FieldEdit enddatecontrol = (FieldEdit)this.getView().getControl("enddate");
        if ("A".equals(validperiodtype)) {
            relativedaycontrol.setMustInput(true);
            startdatecontrol.setMustInput(false);
            enddatecontrol.setMustInput(false);
        } else if ("B".equals(validperiodtype)) {
            relativedaycontrol.setMustInput(false);
            startdatecontrol.setMustInput(true);
            enddatecontrol.setMustInput(true);
        } else {
            relativedaycontrol.setMustInput(false);
            startdatecontrol.setMustInput(false);
            enddatecontrol.setMustInput(false);
        }
    }

    private void schemeTypeReact() {
        String schemeType = (String)this.getModel().getValue("schemecategory");
        FieldEdit totalqty = (FieldEdit)this.getView().getControl("totalqty");
        FieldEdit vipgetmaxqty = (FieldEdit)this.getView().getControl("vipgetmaxqty");
        if ("3".equals(schemeType) || "4".equals(schemeType)) {
            totalqty.setMustInput(true);
            vipgetmaxqty.setMustInput(true);
        } else {
            totalqty.setMustInput(false);
            vipgetmaxqty.setMustInput(false);
        }
    }

    private void initDefaultBranchID() {
        DynamicObject doBizOrg = (DynamicObject)this.getView().getModel().getValue("bizorgid");
        if (doBizOrg != null) {
            List lstOwner = OwnerUtil.getOwnerIds((long)DynamicObjectUtil.getPkValue((DynamicObject)doBizOrg), (boolean)true);
            Object ownerId = OwnerUtil.getDefaultOwnerId((List)lstOwner);
            this.getView().getModel().setValue("branchid", ownerId);
        }
    }
}

