/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.ticketissue;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.OperationException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.drp.dbd.business.helper.TicketActionFlowHelper;
import kd.drp.dbd.business.helper.TicketsInfoHelper;
import kd.drp.dbd.enums.TicketFlowOperTypeEnum;
import kd.drp.dbd.formplugin.ticketissue.MyTask;
import kd.drp.dbd.pojo.TicketFlowParamVO;
import kd.drp.dbd.pojo.TicketsInfoVO;

public class TicketIssueProcessFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_BTNSTART = "btnstart";
    private static final String KEY_BTNCLOSE = "btnclose";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String KEY_SIZE = "size";
    public static final String KEY_TEXT = "tips";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"TicketIssueProcessFormPlugin", (int)1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_BTNSTART, KEY_BTNCLOSE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_BTNSTART, (CharSequence)source.getKey())) {
            if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3e\u53d1\u8fc7\u7a0b\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"TicketIssueProcessFormPlugin_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            } else {
                this.start();
            }
        } else if (StringUtils.equals((CharSequence)KEY_BTNCLOSE, (CharSequence)source.getKey())) {
            int progress = 0;
            if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
                progress = Integer.parseInt(this.getPageCache().get(CACHEKEY_PROGRESS));
                if (progress < 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3e\u53d1\u8fc7\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed", (String)"TicketIssueProcessFormPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().returnDataToParent((Object)this.getPageCache().get(KEY_SIZE));
                    this.getView().close();
                }
            } else {
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        int progress = 0;
        if (this.getPageCache().get(CACHEKEY_PROGRESS) != null) {
            progress = Integer.parseInt(this.getPageCache().get(CACHEKEY_PROGRESS));
            if (progress == 100) {
                this.getView().returnDataToParent((Object)this.getPageCache().get(KEY_SIZE));
            } else {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3e\u53d1\u8fc7\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed", (String)"TicketIssueProcessFormPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void onProgress(ProgressEvent arg0) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            arg0.setProgress(0);
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (StringUtils.isNotBlank((CharSequence)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100) {
            this.afterProgress();
        }
        arg0.setProgress(progress);
    }

    private void afterProgress() {
        int size = Integer.parseInt(this.getPageCache().get(KEY_SIZE));
        if (size > 0) {
            this.getModel().setValue(KEY_TEXT, (Object)(ResManager.loadKDString((String)"\u672c\u6b21\u6d3e\u53d1\u5b8c\u6210,\u603b\u5171\u6d3e\u53d1\u793c\u5238\u3010", (String)"TicketIssueProcessFormPlugin_2", (String)"drp-gcm-formplugin", (Object[])new Object[0]) + size + ResManager.loadKDString((String)"\u3011\u5f20", (String)"TicketIssueProcessFormPlugin_3", (String)"drp-gcm-formplugin", (Object[])new Object[0])));
            this.getView().updateView(KEY_TEXT);
        } else {
            this.getModel().setValue(KEY_TEXT, (Object)(ResManager.loadKDString((String)"\u672c\u6b21\u6d3e\u53d1\u5931\u8d25,\u603b\u5171\u5236\u5238\u3010", (String)"TicketIssueProcessFormPlugin_4", (String)"drp-gcm-formplugin", (Object[])new Object[0]) + size + ResManager.loadKDString((String)"\u3011\u5f20", (String)"TicketIssueProcessFormPlugin_3", (String)"drp-gcm-formplugin", (Object[])new Object[0])));
            this.getView().updateView(KEY_TEXT);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTNSTART});
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"TicketIssueProcessFormPlugin_5", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(KEY_TEXT, (Object)ResManager.loadKDString((String)"\u5f00\u59cb\u6d3e\u53d1.......", (String)"TicketIssueProcessFormPlugin_6", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        this.getView().updateView(KEY_TEXT);
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "true");
        this.getPageCache().put(CACHEKEY_PROGRESS, "0");
        this.startDispatching();
        MyTask myTask = new MyTask(RequestContext.get(), this.getView().getPageId());
        threadPool.execute((Runnable)myTask);
    }

    private void startDispatching() {
        int ticketsize;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long id = (Long)formShowParameter.getCustomParam("fid");
        try (TXHandle h1 = TX.required((String)"gcm_ticketmake_view");){
            try {
                ArrayList<Long> billIdList = new ArrayList<Long>(1);
                billIdList.add(id);
                List ticketsInfoVOS = TicketsInfoHelper.saveTicketsInfo(billIdList, (String)"gcm_issuescheme", (String)"");
                ticketsize = ticketsInfoVOS.size();
                if (ticketsize == 0) {
                    h1.markRollback();
                }
                ArrayList<Long> ticketids = new ArrayList<Long>(ticketsize);
                for (TicketsInfoVO ticketsInfoVO : ticketsInfoVOS) {
                    ticketids.add(ticketsInfoVO.getId());
                }
                TicketFlowParamVO ticketFlowParamVO = new TicketFlowParamVO();
                ticketFlowParamVO.setBillIdList(ticketids);
                ticketFlowParamVO.setOperType(TicketFlowOperTypeEnum.TICKET_DISTRIBUTE);
                ticketFlowParamVO.setBillFormId("gcm_issuescheme");
                TicketActionFlowHelper.saveTicketActionFLow((TicketFlowParamVO)ticketFlowParamVO);
            }
            catch (OperationException e) {
                h1.markRollback();
                throw e;
            }
        }
        this.getPageCache().put(KEY_SIZE, String.valueOf(ticketsize));
    }
}

