/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.ticketscoderule;

import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.drp.dbd.business.helper.TicketRuleCodeHelper;

public class CodeRuleEditPlugin
extends AbstractBasePlugIn
implements ItemClickListener {
    private static int cnt = 0;
    private static String typeSeqCode = "";
    private static String endRandom = "";
    private static final int codeSplitCount = 4;
    private static String[] properties = new String[]{"attributetype", "fixval", "initial", "length", "format", "step", "step", "splitsign"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar mbar = (Toolbar)this.getView().getControl("tbmain");
        mbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"baritemap", (CharSequence)evt.getItemKey())) {
            // empty if block
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.EDIT || showParameter.getStatus() == OperationStatus.VIEW) {
            this.getView().getModel().beginInit();
            this.setEntry();
            int rowCount = this.getView().getModel().getEntryRowCount("coderuleentry");
            this.setDefaultRuleEntry(4 - rowCount);
            this.getView().getModel().endInit();
        } else if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.setEntry(2);
            this.formatEntry(1, 1);
            this.formatEntry(2, 2);
            this.setDefaultRuleEntry(4);
            this.setCodeRuleEntry(2);
        }
    }

    public void propertyChanged(PropertyChangedArgs arg) {
        String fixVal;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String proName = arg.getProperty().getName();
        if ("splitcount".equals(proName)) {
            String splitCount = String.valueOf(model.getValue("splitcount"));
            if (!StringUtils.isBlank((CharSequence)splitCount)) {
                int count = Integer.parseInt(splitCount);
                for (int i = count + 1; i <= 4; ++i) {
                    this.getView().getModel().setValue("attributetype" + i, (Object)"");
                }
                this.setEntry(count);
                this.setCodeRuleEntry(count);
            }
        } else if (proName.startsWith("attributetype")) {
            int entryNo = Integer.parseInt(proName.replace("attributetype", ""));
            if (StringUtils.isBlank((CharSequence)String.valueOf(arg.getChangeSet()[0].getNewValue()))) {
                return;
            }
            int attributeType = Integer.parseInt(String.valueOf(arg.getChangeSet()[0].getNewValue()));
            if (attributeType == 2) {
                int count = model.getDataEntity().getInt("splitcount");
                for (int i = 1; i <= count; ++i) {
                    int otherAttributeType;
                    Object oAttributeType;
                    if (i == entryNo || (oAttributeType = this.getModel().getValue("attributetype" + i)) == null || StringUtils.isBlank((CharSequence)String.valueOf(oAttributeType)) || 2 != (otherAttributeType = Integer.parseInt(String.valueOf(this.getModel().getValue("attributetype" + i))))) continue;
                    view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c\u6d41\u6c34\u53f7\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5", (String)"CodeRuleEditPlugin_0", (String)"drp-gcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    String attrTypeVal = String.valueOf(arg.getChangeSet()[0].getOldValue());
                    model.setValue(proName, (Object)attrTypeVal);
                    this.setCodeRuleEntry(entryNo, "attributetype");
                    return;
                }
            }
            if (attributeType == 1) {
                this.getModel().setValue("fixval" + entryNo, null);
            }
            this.recoverEntry(entryNo);
            this.formatEntry(entryNo, attributeType);
        } else if (proName.startsWith("fixval") && (fixVal = (String)this.getModel().getValue(proName)).contains("!")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e2d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\"!\"", (String)"CodeRuleEditPlugin_1", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
        }
        if ("splitsign".equals(proName) || "endrandom".equals(proName) || "splitcount".equals(proName) || "skip".equals(proName) || "isupgrade".equals(proName) || proName.startsWith("fixval") || proName.startsWith("initial") || proName.startsWith("length") || proName.startsWith("format") || proName.startsWith("step") || proName.startsWith("splitsign") || proName.startsWith("attributetype")) {
            this.genExampleCode();
        }
        if (proName.startsWith("fixval") || proName.startsWith("initial") || proName.startsWith("length") || proName.startsWith("format") || proName.startsWith("step") || proName.startsWith("splitsign") || proName.startsWith("attributetype")) {
            int entryNo = Integer.parseInt(proName.substring(proName.length() - 1));
            this.setCodeRuleEntry(entryNo, proName);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            StringBuilder msg = new StringBuilder();
            boolean isCheckData = this.checkData(msg);
            if (!isCheckData) {
                this.getView().showErrorNotification(msg.toString());
                args.setCancel(true);
                return;
            }
            String skip = String.valueOf(this.getView().getModel().getValue("skip"));
            String[] skips = skip.split(",");
            if (skips.length - 1 > 5) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8df3\u8fc7\u6570\u5b57\u4e0d\u80fd\u8bbe\u7f6e\u8d85\u8fc75\u4f4d\u6570\u5b57!", (String)"CodeRuleEditPlugin_2", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection docEntry = this.getView().getModel().getEntryEntity("coderuleentry");
            if (docEntry != null) {
                for (int i = docEntry.getRowCount() - 1; i >= 0; --i) {
                    if (((DynamicObject)docEntry.get(i)).get("attributetype") != null) continue;
                    this.getView().getModel().deleteEntryRow("coderuleentry", i);
                }
            }
        }
    }

    private void genExampleCode() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int splitCount = Integer.parseInt((String)model.getValue("splitcount"));
        StringBuilder exampleCode = new StringBuilder();
        block4: for (int i = 0; i < splitCount; ++i) {
            Object splitSign;
            int entryNum = i + 1;
            Object sAttributeType = model.getValue("attributetype" + entryNum);
            if (sAttributeType == null || StringUtil.isEmpty((CharSequence)String.valueOf(sAttributeType))) continue;
            int attributeType = Integer.parseInt(String.valueOf(sAttributeType));
            if (i != 0 && (splitSign = model.getValue("splitsign" + i)) != null) {
                exampleCode.append(splitSign.toString().trim());
            }
            switch (attributeType) {
                case 1: {
                    String fixVal = String.valueOf(model.getValue("fixval" + entryNum));
                    String formatVal = String.valueOf(model.getValue("format" + entryNum));
                    fixVal = TicketRuleCodeHelper.getStrFormat((String)fixVal, (String)formatVal);
                    exampleCode.append(fixVal);
                    continue block4;
                }
                case 2: {
                    int length = Integer.parseInt(String.valueOf(model.getValue("length" + entryNum)));
                    if (length > 100) {
                        return;
                    }
                    int step = Integer.parseInt(String.valueOf(model.getValue("step" + entryNum)));
                    String initial = String.valueOf(model.getValue("initial" + entryNum));
                    if (initial.length() > length) {
                        initial = "1";
                    }
                    cnt = 0;
                    boolean isUpGrade = Boolean.parseBoolean(String.valueOf(model.getValue("isupgrade")));
                    this.getSkipCode(initial, step, length, isUpGrade);
                    if (isUpGrade) {
                        length += typeSeqCode.length() - initial.length();
                    }
                    if (length <= 0) continue block4;
                    String seqNo = String.format("%0" + length + "d", Integer.parseInt(typeSeqCode));
                    exampleCode.append(seqNo);
                    continue block4;
                }
            }
        }
        String endRandomVal = String.valueOf(model.getValue("endrandom"));
        int randomLen = !StringUtils.isBlank((CharSequence)endRandomVal) ? Integer.parseInt(endRandomVal) : 0;
        cnt = 0;
        this.getSkipRandom(randomLen);
        if (!StringUtils.isBlank((CharSequence)endRandom)) {
            exampleCode.append(endRandom);
        }
        model.setValue("example", (Object)exampleCode.toString());
        model.setValue("examplelength", (Object)exampleCode.length());
        view.updateView("example");
        view.updateView("examplelength");
    }

    private void getSkipCode(String initial, int step, int len, boolean isUpGrade) {
        typeSeqCode = initial;
        if (step == 0) {
            ++step;
        }
        boolean isSkip = false;
        String skip = String.valueOf(this.getView().getModel().getValue("skip"));
        String[] skips = skip.split(",");
        if (skips.length > 1) {
            for (int i = 1; i < skips.length; ++i) {
                if (!initial.contains(String.valueOf(skips[i]))) continue;
                typeSeqCode = String.valueOf(Integer.parseInt(initial) + step);
                if (typeSeqCode.length() > len && !isUpGrade) {
                    cnt = 0;
                    typeSeqCode = "";
                    break;
                }
                isSkip = true;
                ++cnt;
                break;
            }
            if (isSkip && cnt <= 5) {
                this.getSkipCode(typeSeqCode, step, len, isUpGrade);
            }
        }
    }

    private void getSkipRandom(int len) {
        boolean isSkip = false;
        endRandom = TicketRuleCodeHelper.getRandom((int)len);
        String skip = String.valueOf(this.getView().getModel().getValue("skip"));
        String[] skips = skip.split(",");
        if (skips.length > 1) {
            for (int i = 1; i < skips.length; ++i) {
                if (!endRandom.contains(String.valueOf(skips[i]))) continue;
                endRandom = TicketRuleCodeHelper.getRandom((int)len);
                isSkip = true;
                ++cnt;
                break;
            }
            if (isSkip && cnt <= 5) {
                this.getSkipRandom(len);
            }
        }
    }

    private void setEntry(int count) {
        this.getModel().setValue("splitcount", (Object)count);
        this.reSetAllEntry();
        int displayCount = count - 1;
        for (int i = 0; i < displayCount; ++i) {
            String attributeTypeStr = (String)this.getModel().getValue("attributetype" + (2 + i));
            if (StringUtils.isBlank((CharSequence)attributeTypeStr)) {
                this.formatEntry(2 + i, 1);
                this.getView().getModel().setValue("attributetype" + (2 + i), (Object)"1");
                this.getView().getModel().setValue("format" + (2 + i), (Object)"0");
            } else {
                int attributeType = Integer.parseInt(attributeTypeStr);
                this.formatEntry(2 + i, attributeType);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"coderuleentry" + (2 + i)});
        }
    }

    private void setEntry() {
        DynamicObjectCollection docEntry = this.getView().getModel().getEntryEntity("coderuleentry");
        if (docEntry != null) {
            IDataModel model = this.getView().getModel();
            for (int i = 0; i < docEntry.getRowCount(); ++i) {
                int entryNum = i + 1;
                DynamicObject doEntry = (DynamicObject)docEntry.get(i);
                for (String property : properties) {
                    if (!"step".equals(property)) {
                        model.setValue(property + entryNum, doEntry.get(property));
                    } else if (doEntry.getInt(property) == 0) {
                        model.setValue(property + entryNum, (Object)1);
                    } else {
                        model.setValue(property + entryNum, doEntry.get(property));
                    }
                    this.getView().updateView(property + entryNum);
                }
            }
            int rowCount = 4;
            if (rowCount - docEntry.getRowCount() > 0) {
                for (int i = 1; i <= rowCount - docEntry.getRowCount(); ++i) {
                    model.setValue("step" + (docEntry.getRowCount() + i), (Object)1);
                    this.getView().updateView("step" + (docEntry.getRowCount() + i));
                }
            }
            this.setEntry(docEntry.getRowCount());
            for (int i = 0; i < docEntry.getRowCount(); ++i) {
                this.formatEntry(i + 1, ((DynamicObject)docEntry.get(i)).getInt("attributetype"));
            }
        }
    }

    private void setCodeRuleEntry(int count) {
        DynamicObject doEntry;
        int i;
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection ruleEntry = model.getEntryEntity("coderuleentry");
        for (i = 0; i < count; ++i) {
            int entryNum = i + 1;
            doEntry = (DynamicObject)ruleEntry.get(i);
            doEntry.set("attributetype", model.getValue("attributetype" + entryNum));
            doEntry.set("fixval", model.getValue("fixval" + entryNum));
            doEntry.set("initial", model.getValue("initial" + entryNum));
            doEntry.set("length", model.getValue("length" + entryNum));
            doEntry.set("format", model.getValue("format" + entryNum));
            doEntry.set("step", model.getValue("step" + entryNum));
            doEntry.set("splitsign", model.getValue("splitsign" + entryNum));
            doEntry.set("isenabled", (Object)Boolean.TRUE);
        }
        for (i = count; i < ruleEntry.getRowCount(); ++i) {
            doEntry = (DynamicObject)ruleEntry.get(i);
            doEntry.set("attributetype", null);
            doEntry.set("fixval", null);
            doEntry.set("initial", null);
            doEntry.set("length", null);
            doEntry.set("format", null);
            doEntry.set("step", null);
            doEntry.set("splitsign", null);
            doEntry.set("isenabled", (Object)Boolean.FALSE);
        }
        this.getView().updateView("coderuleentry");
    }

    private void setDefaultRuleEntry(int defaultEntryRow) {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection ruleEntry = model.getEntryEntity("coderuleentry");
        for (int i = 0; i < defaultEntryRow; ++i) {
            ruleEntry.addNew();
        }
    }

    private void setCodeRuleEntry(int entryNum, String propertyName) {
        DynamicObject doEntry;
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection ruleEntry = model.getDataEntity(true).getDynamicObjectCollection("coderuleentry");
        DynamicObjectType dotEntry = ruleEntry.getDynamicObjectType();
        if (ruleEntry.getRowCount() < entryNum) {
            doEntry = (DynamicObject)dotEntry.createInstance();
            model.createNewEntryRow("coderuleentry", doEntry);
            ruleEntry = model.getEntryEntity("coderuleentry");
        }
        if (ruleEntry.size() <= entryNum - 1) {
            ruleEntry.addNew();
        }
        if ((doEntry = (DynamicObject)ruleEntry.get(entryNum - 1)) != null && doEntry.getDataEntityType().getProperties().containsKey((Object)propertyName.substring(0, propertyName.length() - 1))) {
            doEntry.set(propertyName.substring(0, propertyName.length() - 1), model.getValue(propertyName));
        }
        this.getView().updateView("coderuleentry");
    }

    private void reSetAllEntry() {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"coderuleentry2", "coderuleentry3", "coderuleentry4"});
    }

    private void formatEntry(int entryNo, int attributeType) {
        IFormView formView = this.getView();
        switch (attributeType) {
            case 1: {
                formView.setVisible(Boolean.FALSE, new String[]{"initial" + entryNo});
                formView.setVisible(Boolean.FALSE, new String[]{"length" + entryNo});
                formView.setVisible(Boolean.FALSE, new String[]{"skip" + entryNo});
                formView.setVisible(Boolean.FALSE, new String[]{"step" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"fixval" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"format" + entryNo});
                break;
            }
            case 2: {
                formView.setVisible(Boolean.FALSE, new String[]{"fixval" + entryNo});
                formView.setVisible(Boolean.FALSE, new String[]{"format" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"initial" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"length" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"skip" + entryNo});
                formView.setVisible(Boolean.TRUE, new String[]{"step" + entryNo});
                break;
            }
        }
    }

    private void recoverEntry(int entryNo) {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.TRUE, new String[]{"fixval" + entryNo});
        formView.setVisible(Boolean.TRUE, new String[]{"format" + entryNo});
        formView.setVisible(Boolean.TRUE, new String[]{"length" + entryNo});
        formView.setVisible(Boolean.TRUE, new String[]{"step" + entryNo});
        formView.setVisible(Boolean.TRUE, new String[]{"initial" + entryNo});
        IDataModel model = this.getModel();
        model.setValue("fixval" + entryNo, (Object)"");
        model.setValue("format" + entryNo, (Object)"");
        model.setValue("length" + entryNo, (Object)8);
        model.setValue("step" + entryNo, (Object)1);
        model.setValue("initial" + entryNo, (Object)1);
    }

    private boolean checkData(StringBuilder msg) {
        IDataModel model = this.getModel();
        int splitCount = Integer.parseInt((String)model.getValue("splitcount"));
        boolean isExistSeq = false;
        boolean isNumber = true;
        int numLen = 0;
        String splitCountStr = "";
        block10: for (int i = 0; i < splitCount; ++i) {
            int entryNum = i + 1;
            switch (entryNum) {
                case 1: {
                    splitCountStr = ResManager.loadKDString((String)"\u4e00", (String)"CodeRuleEditPlugin_3", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    splitCountStr = ResManager.loadKDString((String)"\u4e8c", (String)"CodeRuleEditPlugin_4", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    splitCountStr = ResManager.loadKDString((String)"\u4e09", (String)"CodeRuleEditPlugin_5", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 4: {
                    splitCountStr = ResManager.loadKDString((String)"\u56db", (String)"CodeRuleEditPlugin_6", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            if (this.checkIllegalString(msg)) {
                return false;
            }
            int attributeType = 0;
            Object oAttributeType = model.getValue("attributetype" + entryNum);
            if (oAttributeType == null || StringUtils.isEmpty((CharSequence)String.valueOf(oAttributeType))) {
                msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u7f16\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"CodeRuleEditPlugin_8", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                return false;
            }
            attributeType = Integer.parseInt(String.valueOf(oAttributeType));
            switch (attributeType) {
                case 1: {
                    if (StringUtils.isBlank((Object)model.getValue("fixval" + entryNum))) {
                        msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u8bbe\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CodeRuleEditPlugin_9", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (isNumber) {
                        isNumber = this.validationNum(model.getValue("fixval" + entryNum).toString());
                    }
                    if (numLen < 0) continue block10;
                    numLen += model.getValue("fixval" + entryNum).toString().length();
                    continue block10;
                }
                case 2: {
                    if (Integer.parseInt(model.getValue("step" + entryNum).toString()) == 0) {
                        msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u6b65\u957f\u4e0d\u80fd\u4e3a\u7a7a", (String)"CodeRuleEditPlugin_10", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (Integer.parseInt(model.getValue("initial" + entryNum).toString()) == 0) {
                        msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u8d77\u59cb\u503c\u4e0d\u80fd\u4e3a0", (String)"CodeRuleEditPlugin_11", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (Integer.parseInt(model.getValue("length" + entryNum).toString()) == 0) {
                        msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CodeRuleEditPlugin_12", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (model.getValue("initial" + entryNum).toString().length() > Integer.parseInt(model.getValue("length" + entryNum).toString())) {
                        msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(splitCountStr).append(ResManager.loadKDString((String)"\u6bb5\u8d77\u59cb\u503c\u4f4d\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e\u957f\u5ea6", (String)"CodeRuleEditPlugin_13", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    isExistSeq = true;
                    if (numLen < 0) continue block10;
                    numLen += Integer.parseInt(model.getValue("length" + entryNum).toString());
                    continue block10;
                }
            }
        }
        if (!isExistSeq) {
            msg.append(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6d41\u6c34\u53f7", (String)"CodeRuleEditPlugin_14", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkIllegalString(StringBuilder msg) {
        boolean flag = false;
        int splitCount = Integer.parseInt((String)this.getModel().getValue("splitcount"));
        for (int i = 0; i < splitCount; ++i) {
            int entryNum = i + 1;
            String numStr = null;
            switch (entryNum) {
                case 1: {
                    numStr = ResManager.loadKDString((String)"\u4e00", (String)"CodeRuleEditPlugin_3", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    numStr = ResManager.loadKDString((String)"\u4e8c", (String)"CodeRuleEditPlugin_4", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    numStr = ResManager.loadKDString((String)"\u4e09", (String)"CodeRuleEditPlugin_5", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 4: {
                    numStr = ResManager.loadKDString((String)"\u56db", (String)"CodeRuleEditPlugin_6", (String)"drp-gcm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            String fixVal = (String)this.getModel().getValue("fixval" + entryNum);
            if (!StringUtils.isNotBlank((CharSequence)fixVal) || !fixVal.contains("!")) continue;
            msg.append(ResManager.loadKDString((String)"\u7f16\u7801", (String)"CodeRuleEditPlugin_7", (String)"drp-gcm-formplugin", (Object[])new Object[0])).append(numStr).append(ResManager.loadKDString((String)"\u6bb5\u4e2d\u8bbe\u7f6e\u503c\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\"!\"\u3001", (String)"CodeRuleEditPlugin_15", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            flag = true;
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            msg.insert(0, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"CodeRuleEditPlugin_16", (String)"drp-gcm-formplugin", (Object[])new Object[0]));
            msg.deleteCharAt(msg.length() - 1);
            this.getView().showErrorNotification(msg.toString());
        }
        return flag;
    }

    private boolean validationNum(String substring) {
        String str = "^[0-9]*$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(substring);
        return m.matches();
    }
}

