/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dbd.formplugin.ticketstype;

import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.dbd.business.helper.CurrencyHelper;
import kd.drp.dbd.business.helper.SetBranchRangeHelper;
import kd.drp.dbd.enums.ControlMethodEnum;
import kd.drp.dbd.utils.DynamicObjectUtil;

public class TicketsTypeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLocalCurrency();
        DynamicObject doTicketType = this.getView().getModel().getDataEntity();
        if (doTicketType == null) {
            return;
        }
        String status = String.valueOf(this.getView().getModel().getValue("status"));
        if (BaseDataRefrenceHelper.isRefrenced((String)"gcm_ticketstype", (Object)doTicketType.getPkValue()) && "A".equals(status)) {
            this.setControlEnable(doTicketType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            long orgId = RequestContext.get().getOrgId();
            this.getView().getModel().setItemValueByID("bizorg", (Object)orgId, 0);
            this.getView().getModel().setItemValueByID("settleorg", (Object)orgId, 0);
            this.getView().updateView("bizorg");
            this.getView().updateView("settleorg");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel dataModel = this.getView().getModel();
        String fieldKey = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        QFilter branchFilter = this.getApplyBranchQFilter(dataModel);
        switch (fieldKey) {
            case "bizorg": {
                this.setLocalCurrency();
                break;
            }
            case "orgrange": {
                Object newValue;
                DynamicObjectCollection customerGroup = (DynamicObjectCollection)dataModel.getValue("channelgroup");
                if (customerGroup != null && customerGroup.size() > 0) {
                    dataModel.beginInit();
                    dataModel.setValue("channelgroup", null);
                    this.getView().updateView("channelgroup");
                    dataModel.endInit();
                }
                if (!((newValue = e.getChangeSet()[0].getNewValue()) instanceof DynamicObjectCollection)) break;
                DynamicObjectCollection range = (DynamicObjectCollection)newValue;
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)range, (boolean)true, (String)"treeentryentity", (String)"applyorg", (String)"branch", (QFilter)branchFilter);
                this.expand();
                break;
            }
            case "channelgroup": {
                Object newValue;
                DynamicObjectCollection orgRange = (DynamicObjectCollection)dataModel.getValue("orgrange");
                if (orgRange != null && orgRange.size() > 0) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("orgrange", null);
                    this.getView().updateView("orgrange");
                    this.getView().getModel().endInit();
                }
                if (!((newValue = e.getChangeSet()[0].getNewValue()) instanceof DynamicObjectCollection)) break;
                DynamicObjectCollection group = (DynamicObjectCollection)newValue;
                SetBranchRangeHelper.setBranchRange((IDataModel)dataModel, (DynamicObjectCollection)group, (boolean)false, (String)"treeentryentity", (String)"applyorg", (String)"branch", (QFilter)branchFilter);
                this.expand();
                break;
            }
            case "controlmethod": {
                String controlMethod = String.valueOf(e.getChangeSet()[0].getNewValue());
                if (ControlMethodEnum.ISAPPLYBRANCH.getControlMethod().equals(controlMethod)) break;
                dataModel.deleteEntryData("treeentryentity");
                break;
            }
            case "isallgoods": {
                boolean isAllGoods = Boolean.parseBoolean(String.valueOf(e.getChangeSet()[0].getNewValue()));
                if (!isAllGoods) break;
                dataModel.deleteEntryData("tictgoodsentry");
                break;
            }
            case "checkno": {
                DynamicObject doTicketType;
                String checkNo = String.valueOf(e.getChangeSet()[0].getNewValue());
                if (!this.isExistChinese(checkNo) || (doTicketType = this.getView().getModel().getDataEntity()) == null) break;
                doTicketType.set("checkno", (Object)"");
                this.getView().updateView("checkno");
                break;
            }
            case "isonlineshop": {
                this.clearApplyBranch(dataModel);
                break;
            }
            case "isonlinestore": {
                this.clearApplyBranch(dataModel);
                break;
            }
            case "isoutlinestore": {
                this.clearApplyBranch(dataModel);
                break;
            }
            case "usagemode": {
                FieldEdit discountrate = (FieldEdit)this.getView().getControl("discountrate");
                if ("1".equals(dataModel.getValue("usagemode"))) {
                    discountrate.setMustInput(Boolean.TRUE.booleanValue());
                    break;
                }
                discountrate.setMustInput(Boolean.FALSE.booleanValue());
                break;
            }
        }
    }

    private void clearApplyBranch(IDataModel dataModel) {
        dataModel.beginInit();
        dataModel.setValue("controlmethod", null);
        this.getView().updateView("controlmethod");
        dataModel.setValue("orgrange", null);
        this.getView().updateView("orgrange");
        dataModel.setValue("channelgroup", null);
        this.getView().updateView("channelgroup");
        dataModel.deleteEntryData("treeentryentity");
        this.getView().updateView("treeentryentity");
        dataModel.endInit();
    }

    private QFilter getApplyBranchQFilter(IDataModel dataModel) {
        boolean isOnLineStore = (Boolean)dataModel.getValue("isonlinestore");
        boolean isOutLineStore = (Boolean)dataModel.getValue("isoutlinestore");
        boolean isOnLineShop = (Boolean)dataModel.getValue("isonlineshop");
        QFilter qFilter = new QFilter("1", "=", (Object)"1");
        if (isOnLineStore || isOutLineStore || isOnLineShop) {
            if (isOnLineStore) {
                qFilter.and("isonlinestore", "=", (Object)"1");
            }
            if (isOutLineStore && isOnLineStore || isOutLineStore && isOnLineShop) {
                qFilter.or("isstore", "=", (Object)"1");
            } else if (isOutLineStore) {
                qFilter.and("isstore", "=", (Object)"1");
            }
            if (isOnLineStore && isOnLineShop || isOutLineStore && isOnLineShop) {
                qFilter.or("customertype.typeid", "=", (Object)"H");
            } else if (isOnLineShop) {
                qFilter.and("customertype.typeid", "=", (Object)"H");
            }
        }
        return qFilter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getView().getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject doBizOrg;
        QFilter qFilter;
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods") && (qFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"mdr_item_info", (Long)DynamicObjectUtil.getPkValue((DynamicObject)(doBizOrg = (DynamicObject)this.getView().getModel().getValue("bizorg"))), (String)"id")) != null) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void setControlEnable(DynamicObject dataEntity) {
        IDataEntityType dType = dataEntity.getDataEntityType();
        for (IDataEntityProperty property : dType.getProperties()) {
            if (property.getName().equals("validitydays") || property.getName().equals("name") || property.getName().equals("comment")) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{property.getName()});
        }
    }

    private void expand() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        grid.setCollapse(false);
        grid.selectRows(-1);
    }

    private void setLocalCurrency() {
        DynamicObject doUseOrg = (DynamicObject)this.getView().getModel().getValue("bizorg");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)doUseOrg);
        if (orgId <= 0L) {
            return;
        }
        DynamicObject doCurrency = CurrencyHelper.getCurrency((Long)orgId);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)doCurrency);
        if (currencyId > 0L) {
            this.getView().getModel().setItemValueByID("localcurrency", (Object)currencyId, 0);
        } else {
            this.getView().getModel().setValue("localcurrency", null);
        }
        this.getView().updateView("localcurrency");
    }

    private boolean isExistChinese(String str) {
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }
}

